/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.topograph2D;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.geotools.geometry.iso.topograph2D.Coordinate;

public class CoordinateList
extends ArrayList {
    private static final Coordinate[] coordArrayType = new Coordinate[0];

    public CoordinateList() {
    }

    public CoordinateList(Coordinate[] coord) {
        this.add(coord, true);
    }

    public CoordinateList(Coordinate[] coord, boolean allowRepeated) {
        this.add(coord, allowRepeated);
    }

    public Coordinate getCoordinate(int i) {
        return (Coordinate)this.get(i);
    }

    public boolean add(Coordinate[] coord, boolean allowRepeated, boolean direction) {
        if (direction) {
            int i = 0;
            while (i < coord.length) {
                this.add(coord[i], allowRepeated);
                ++i;
            }
        } else {
            int i = coord.length - 1;
            while (i >= 0) {
                this.add(coord[i], allowRepeated);
                --i;
            }
        }
        return true;
    }

    public boolean add(Coordinate[] coord, boolean allowRepeated) {
        this.add(coord, allowRepeated, true);
        return true;
    }

    public boolean add(Object obj, boolean allowRepeated) {
        this.add((Coordinate)obj, allowRepeated);
        return true;
    }

    public void add(Coordinate coord, boolean allowRepeated) {
        Coordinate last;
        if (!allowRepeated && this.size() >= 1 && (last = (Coordinate)this.get(this.size() - 1)).equals2D(coord)) {
            return;
        }
        super.add(coord);
    }

    public boolean addAll(Collection coll, boolean allowRepeated) {
        boolean isChanged = false;
        Iterator i = coll.iterator();
        while (i.hasNext()) {
            this.add((Coordinate)i.next(), allowRepeated);
            isChanged = true;
        }
        return isChanged;
    }

    public void closeRing() {
        if (this.size() > 0) {
            this.add(this.get(0), false);
        }
    }

    public Coordinate[] toCoordinateArray() {
        return this.toArray(coordArrayType);
    }

    public Object clone() {
        CoordinateList clone = (CoordinateList)super.clone();
        int i = 0;
        while (i < this.size()) {
            clone.add(i, ((Coordinate)this.get(i)).clone());
            ++i;
        }
        return clone;
    }
}

