/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.topograph2D;

import java.io.PrintStream;
import org.geotools.geometry.iso.topograph2D.Coordinate;
import org.geotools.geometry.iso.topograph2D.Depth;
import org.geotools.geometry.iso.topograph2D.EdgeIntersection;
import org.geotools.geometry.iso.topograph2D.EdgeIntersectionList;
import org.geotools.geometry.iso.topograph2D.Envelope;
import org.geotools.geometry.iso.topograph2D.GraphComponent;
import org.geotools.geometry.iso.topograph2D.IntersectionMatrix;
import org.geotools.geometry.iso.topograph2D.Label;
import org.geotools.geometry.iso.topograph2D.index.MonotoneChainEdge;
import org.geotools.geometry.iso.util.algorithm2D.LineIntersector;

public class Edge
extends GraphComponent {
    Coordinate[] pts;
    private Envelope env;
    EdgeIntersectionList eiList = new EdgeIntersectionList(this);
    private String name;
    private MonotoneChainEdge mce;
    private boolean isIsolated = true;
    private Depth depth = new Depth();
    private int depthDelta = 0;

    public static void updateIM(Label label, IntersectionMatrix im) {
        im.setAtLeastIfValid(label.getLocation(0, 0), label.getLocation(1, 0), 1);
        if (label.isArea()) {
            im.setAtLeastIfValid(label.getLocation(0, 1), label.getLocation(1, 1), 2);
            im.setAtLeastIfValid(label.getLocation(0, 2), label.getLocation(1, 2), 2);
        }
    }

    public Edge(Coordinate[] pts, Label label) {
        this.pts = pts;
        this.label = label;
    }

    public Edge(Coordinate[] pts) {
        this(pts, null);
    }

    public int getNumPoints() {
        return this.pts.length;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Coordinate[] getCoordinates() {
        return this.pts;
    }

    public Coordinate getCoordinate(int i) {
        return this.pts[i];
    }

    public Coordinate getCoordinate() {
        if (this.pts.length > 0) {
            return this.pts[0];
        }
        return null;
    }

    public Envelope getEnvelope() {
        if (this.env == null) {
            this.env = new Envelope();
            int i = 0;
            while (i < this.pts.length) {
                this.env.expandToInclude(this.pts[i]);
                ++i;
            }
        }
        return this.env;
    }

    public Depth getDepth() {
        return this.depth;
    }

    public int getDepthDelta() {
        return this.depthDelta;
    }

    public void setDepthDelta(int depthDelta) {
        this.depthDelta = depthDelta;
    }

    public int getMaximumSegmentIndex() {
        return this.pts.length - 1;
    }

    public EdgeIntersectionList getEdgeIntersectionList() {
        return this.eiList;
    }

    public MonotoneChainEdge getMonotoneChainEdge() {
        if (this.mce == null) {
            this.mce = new MonotoneChainEdge(this);
        }
        return this.mce;
    }

    public boolean isClosed() {
        return this.pts[0].equals(this.pts[this.pts.length - 1]);
    }

    public boolean isCollapsed() {
        if (!this.label.isArea()) {
            return false;
        }
        if (this.pts.length != 3) {
            return false;
        }
        return this.pts[0].equals(this.pts[2]);
    }

    public Edge getCollapsedEdge() {
        Coordinate[] newPts = new Coordinate[]{this.pts[0], this.pts[1]};
        Edge newe = new Edge(newPts, Label.toLineLabel(this.label));
        return newe;
    }

    public void setIsolated(boolean isIsolated) {
        this.isIsolated = isIsolated;
    }

    public boolean isIsolated() {
        return this.isIsolated;
    }

    public void addIntersections(LineIntersector li, int segmentIndex, int geomIndex) {
        int i = 0;
        while (i < li.getIntersectionNum()) {
            this.addIntersection(li, segmentIndex, geomIndex, i);
            ++i;
        }
    }

    public void addIntersection(LineIntersector li, int segmentIndex, int geomIndex, int intIndex) {
        Coordinate nextPt;
        Coordinate intPt = new Coordinate(li.getIntersection(intIndex));
        int normalizedSegmentIndex = segmentIndex;
        double dist = li.getEdgeDistance(geomIndex, intIndex);
        int nextSegIndex = normalizedSegmentIndex + 1;
        if (nextSegIndex < this.pts.length && intPt.equals2D(nextPt = this.pts[nextSegIndex])) {
            normalizedSegmentIndex = nextSegIndex;
            dist = 0.0;
        }
        EdgeIntersection ei = this.eiList.add(intPt, normalizedSegmentIndex, dist);
    }

    public void computeIM(IntersectionMatrix im) {
        Edge.updateIM(this.label, im);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Edge)) {
            return false;
        }
        Edge e = (Edge)o;
        if (this.pts.length != e.pts.length) {
            return false;
        }
        boolean isEqualForward = true;
        boolean isEqualReverse = true;
        int iRev = this.pts.length;
        int i = 0;
        while (i < this.pts.length) {
            if (!this.pts[i].equals2D(e.pts[i])) {
                isEqualForward = false;
            }
            if (!this.pts[i].equals2D(e.pts[--iRev])) {
                isEqualReverse = false;
            }
            if (!isEqualForward && !isEqualReverse) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isPointwiseEqual(Edge e) {
        if (this.pts.length != e.pts.length) {
            return false;
        }
        int i = 0;
        while (i < this.pts.length) {
            if (!this.pts[i].equals2D(e.pts[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void print(PrintStream out) {
        out.print("edge " + this.name + ": ");
        out.print("LINESTRING (");
        int i = 0;
        while (i < this.pts.length) {
            if (i > 0) {
                out.print(",");
            }
            out.print(String.valueOf(this.pts[i].x) + " " + this.pts[i].y);
            ++i;
        }
        out.print(")  " + this.label + " " + this.depthDelta);
    }

    public void printReverse(PrintStream out) {
        out.print("edge " + this.name + ": ");
        int i = this.pts.length - 1;
        while (i >= 0) {
            out.print(this.pts[i] + " ");
            --i;
        }
        out.println("");
    }
}

