/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.topograph2D.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.geotools.geometry.iso.coordinate.DirectPositionImpl;
import org.geotools.geometry.iso.coordinate.PositionImpl;
import org.geotools.geometry.iso.topograph2D.Coordinate;
import org.geotools.geometry.iso.topograph2D.CoordinateList;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.coordinate.Position;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoordinateArrays {
    private static final Coordinate[] coordArrayType = new Coordinate[0];

    public static Coordinate ptNotInList(Coordinate[] testPts, Coordinate[] pts) {
        int i = 0;
        while (i < testPts.length) {
            Coordinate testPt = testPts[i];
            if (CoordinateArrays.indexOf(testPt, pts) < 0) {
                return testPt;
            }
            ++i;
        }
        return null;
    }

    public static int compare(Coordinate[] pts1, Coordinate[] pts2) {
        int i = 0;
        while (i < pts1.length && i < pts2.length) {
            int compare = pts1[i].compareTo(pts2[i]);
            if (compare != 0) {
                return compare;
            }
            ++i;
        }
        if (i < pts2.length) {
            return -1;
        }
        if (i < pts1.length) {
            return 1;
        }
        return 0;
    }

    public static int increasingDirection(Coordinate[] pts) {
        int i = 0;
        while (i < pts.length / 2) {
            int j = pts.length - 1 - i;
            int comp = pts[i].compareTo(pts[j]);
            if (comp != 0) {
                return comp;
            }
            ++i;
        }
        return 1;
    }

    private static boolean isEqualReversed(Coordinate[] pts1, Coordinate[] pts2) {
        int i = 0;
        while (i < pts1.length) {
            Coordinate p1 = pts1[i];
            Coordinate p2 = pts2[pts1.length - i - 1];
            if (p1.compareTo(p2) != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static Coordinate[] copyDeep(Coordinate[] coordinates) {
        Coordinate[] copy = new Coordinate[coordinates.length];
        int i = 0;
        while (i < coordinates.length) {
            copy[i] = new Coordinate(coordinates[i]);
            ++i;
        }
        return copy;
    }

    public static Coordinate[] toCoordinateArray(Collection coordList) {
        return coordList.toArray(coordArrayType);
    }

    public static boolean hasRepeatedPoints(Coordinate[] coord) {
        int i = 1;
        while (i < coord.length) {
            if (coord[i - 1].equals(coord[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Coordinate[] atLeastNCoordinatesOrNothing(int n, Coordinate[] c) {
        return c.length >= n ? c : new Coordinate[]{};
    }

    public static Coordinate[] removeRepeatedPoints(Coordinate[] coord) {
        if (!CoordinateArrays.hasRepeatedPoints(coord)) {
            return coord;
        }
        CoordinateList coordList = new CoordinateList(coord, false);
        return coordList.toCoordinateArray();
    }

    public static void reverse(Coordinate[] coord) {
        int last = coord.length - 1;
        int mid = last / 2;
        int i = 0;
        while (i <= mid) {
            Coordinate tmp = coord[i];
            coord[i] = coord[last - i];
            coord[last - i] = tmp;
            ++i;
        }
    }

    public static boolean equals(Coordinate[] coord1, Coordinate[] coord2) {
        if (coord1 == coord2) {
            return true;
        }
        if (coord1 == null || coord2 == null) {
            return false;
        }
        if (coord1.length != coord2.length) {
            return false;
        }
        int i = 0;
        while (i < coord1.length) {
            if (!coord1[i].equals(coord2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equals(Coordinate[] coord1, Coordinate[] coord2, Comparator coordinateComparator) {
        if (coord1 == coord2) {
            return true;
        }
        if (coord1 == null || coord2 == null) {
            return false;
        }
        if (coord1.length != coord2.length) {
            return false;
        }
        int i = 0;
        while (i < coord1.length) {
            if (coordinateComparator.compare(coord1[i], coord2[i]) != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static Coordinate minCoordinate(Coordinate[] coordinates) {
        Coordinate minCoord = null;
        int i = 0;
        while (i < coordinates.length) {
            if (minCoord == null || minCoord.compareTo(coordinates[i]) > 0) {
                minCoord = coordinates[i];
            }
            ++i;
        }
        return minCoord;
    }

    public static void scroll(Coordinate[] coordinates, Coordinate firstCoordinate) {
        int i = CoordinateArrays.indexOf(firstCoordinate, coordinates);
        if (i < 0) {
            return;
        }
        Coordinate[] newCoordinates = new Coordinate[coordinates.length];
        System.arraycopy(coordinates, i, newCoordinates, 0, coordinates.length - i);
        System.arraycopy(coordinates, 0, newCoordinates, coordinates.length - i, i);
        System.arraycopy(newCoordinates, 0, coordinates, 0, coordinates.length);
    }

    public static int indexOf(Coordinate coordinate, Coordinate[] coordinates) {
        int i = 0;
        while (i < coordinates.length) {
            if (coordinate.equals(coordinates[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static Coordinate[] extract(Coordinate[] pts, int start, int end) {
        int len = end - start + 1;
        Coordinate[] extractPts = new Coordinate[len];
        int iPts = 0;
        int i = start;
        while (i <= end) {
            extractPts[iPts++] = pts[i];
            ++i;
        }
        return extractPts;
    }

    public static Coordinate[] toCoordinateArray(List<DirectPosition> aPositions) {
        Coordinate[] rCoords = new Coordinate[aPositions.size()];
        int i = 0;
        while (i < aPositions.size()) {
            rCoords[i] = new Coordinate(aPositions.get(i).getCoordinates());
            ++i;
        }
        return rCoords;
    }

    public static List<Position> toPositionList(CoordinateReferenceSystem crs, Coordinate[] coordArray) {
        ArrayList<Position> rList = new ArrayList<Position>();
        int i = 0;
        while (i < coordArray.length) {
            DirectPositionImpl position = new DirectPositionImpl(crs, coordArray[i].getCoordinates());
            rList.add(new PositionImpl(position.clone()));
            ++i;
        }
        return rList;
    }

    public static List<DirectPositionImpl> toDirectPositionList(CoordinateReferenceSystem crs, Coordinate[] coordArray) {
        ArrayList<DirectPositionImpl> rList = new ArrayList<DirectPositionImpl>();
        int i = 0;
        while (i < coordArray.length) {
            rList.add(new DirectPositionImpl(crs, coordArray[i].getCoordinates()));
            ++i;
        }
        return rList;
    }

    public static class BidirectionalComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Coordinate[] pts1 = (Coordinate[])o1;
            Coordinate[] pts2 = (Coordinate[])o2;
            if (pts1.length < pts2.length) {
                return -1;
            }
            if (pts1.length > pts2.length) {
                return 1;
            }
            if (pts1.length == 0) {
                return 0;
            }
            int forwardComp = CoordinateArrays.compare(pts1, pts2);
            boolean isEqualRev = CoordinateArrays.isEqualReversed(pts1, pts2);
            if (isEqualRev) {
                return 0;
            }
            return forwardComp;
        }

        public int OLDcompare(Object o1, Object o2) {
            Coordinate[] pts1 = (Coordinate[])o1;
            Coordinate[] pts2 = (Coordinate[])o2;
            if (pts1.length < pts2.length) {
                return -1;
            }
            if (pts1.length > pts2.length) {
                return 1;
            }
            if (pts1.length == 0) {
                return 0;
            }
            int dir1 = CoordinateArrays.increasingDirection(pts1);
            int dir2 = CoordinateArrays.increasingDirection(pts2);
            int i1 = dir1 > 0 ? 0 : pts1.length - 1;
            int i2 = dir2 > 0 ? 0 : pts1.length - 1;
            int i = 0;
            while (i < pts1.length) {
                int comparePt = pts1[i1].compareTo(pts2[i2]);
                if (comparePt != 0) {
                    return comparePt;
                }
                i1 += dir1;
                i2 += dir2;
                ++i;
            }
            return 0;
        }
    }

    public static class ForwardComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Coordinate[] pts1 = (Coordinate[])o1;
            Coordinate[] pts2 = (Coordinate[])o2;
            return CoordinateArrays.compare(pts1, pts2);
        }
    }
}

