/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.util.algorithm2D;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import org.geotools.geometry.iso.util.algorithm2D.AlgoLine2D;
import org.geotools.geometry.iso.util.algorithm2D.AlgoPoint2D;

public class LineLineIntersection2D {
    private double[] itsc;
    Line2D line0;
    Line2D line1;

    public LineLineIntersection2D() {
        this.itsc = null;
        this.line0 = null;
        this.line1 = null;
    }

    public LineLineIntersection2D(Line2D line0, Line2D line1) {
        this.setValues(line0, line1);
    }

    public void setValues(Line2D line0, Line2D line1) {
        Point2D p0 = line0.getP1();
        Point2D p1 = line0.getP2();
        Point2D q0 = line1.getP1();
        Point2D q1 = line1.getP2();
        this.line0 = line0;
        this.line1 = line1;
        this.itsc = LineLineIntersection2D.intersection(p0, p1, q0, q1);
        if (this.itsc == null) {
            return;
        }
        int n = this.itsc.length;
        if (n == 4) {
            int count = 0;
            if (this.isNaN(this.itsc[0])) {
                ++count;
            }
            if (this.isNaN(this.itsc[1])) {
                ++count;
            }
            if (this.isNaN(this.itsc[2])) {
                ++count;
            }
            if (this.isNaN(this.itsc[3])) {
                ++count;
            }
            if (count == 3) {
                throw new IllegalArgumentException("Error on LineLineIntersection: wrong overlaping itscs. Count=" + count);
            }
            if (count == 0 && (this.itsc[0] != 0.0 && this.itsc[0] != 1.0 || this.itsc[1] != 0.0 && this.itsc[1] != 1.0 || this.itsc[2] != 0.0 && this.itsc[2] != 1.0 || this.itsc[3] != 0.0 && this.itsc[3] != 1.0)) {
                throw new IllegalArgumentException("Error on LineLineIntersection: wrong coincident itscs");
            }
        }
    }

    private boolean isNaN(double d) {
        return Double.isNaN(d);
    }

    public boolean isCoincident() {
        return this.itsc != null && this.itsc.length == 4 && !this.isNaN(this.itsc[0]) && !this.isNaN(this.itsc[1]) && !this.isNaN(this.itsc[2]) && !this.isNaN(this.itsc[3]);
    }

    public boolean overlapsInterior() {
        return this.itsc != null && this.itsc.length == 4 && (!this.isNaN(this.itsc[0]) && this.itsc[0] > 0.0 && this.itsc[0] < 1.0 || !this.isNaN(this.itsc[1]) && this.itsc[1] > 0.0 && this.itsc[1] < 1.0 || !this.isNaN(this.itsc[1]) && this.itsc[2] > 0.0 && this.itsc[2] < 1.0 || !this.isNaN(this.itsc[1]) && this.itsc[3] > 0.0 && this.itsc[3] < 1.0);
    }

    public boolean intersectInteriorInteriorPoint() {
        if (this.itsc == null || this.itsc.length != 2) {
            return false;
        }
        return !this.isNaN(this.itsc[0]) && this.itsc[0] != 0.0 && this.itsc[0] != 1.0 && !this.isNaN(this.itsc[1]) && this.itsc[1] != 0.0 && this.itsc[1] != 1.0;
    }

    public boolean isII() {
        return this.intersectInteriorInteriorPoint() || this.overlapsInterior();
    }

    public boolean isIB() {
        return this.itsc != null && this.itsc.length == 2 && !this.isNaN(this.itsc[0]) && !this.isNaN(this.itsc[1]) && this.itsc[0] > 0.0 && this.itsc[0] < 1.0 && (this.itsc[1] == 0.0 || this.itsc[1] == 1.0);
    }

    public boolean isBI() {
        return this.itsc != null && this.itsc.length == 2 && !this.isNaN(this.itsc[0]) && !this.isNaN(this.itsc[1]) && (this.itsc[0] == 0.0 || this.itsc[0] == 1.0) && this.itsc[1] > 0.0 && this.itsc[1] < 1.0;
    }

    public boolean isBB() {
        if (this.itsc == null) {
            return false;
        }
        if (this.itsc.length == 2) {
            return !(this.itsc[0] != 0.0 && this.itsc[0] != 1.0 || this.itsc[1] != 0.0 && this.itsc[1] != 1.0);
        }
        if (this.itsc.length == 4) {
            return this.isCoincident();
        }
        throw new IllegalArgumentException("Error on LineLineIntersection::IsBB()");
    }

    public Point2D[] intersectionPoint() {
        Point2D[] result = null;
        if (this.itsc == null) {
            return null;
        }
        if (this.itsc.length == 2) {
            result = !this.isNaN(this.itsc[0]) ? new Point2D[]{AlgoLine2D.evaluate(this.line0, this.itsc[0])} : (!this.isNaN(this.itsc[1]) ? new Point2D[]{AlgoLine2D.evaluate(this.line0, this.itsc[1])} : (Point2D[])null);
        } else if (this.itsc.length == 4) {
            int count = 0;
            int[] index = new int[4];
            if (!this.isNaN(this.itsc[0])) {
                index[count++] = 0;
            }
            if (!this.isNaN(this.itsc[1])) {
                index[count++] = 1;
            }
            if (!this.isNaN(this.itsc[2])) {
                index[count++] = 2;
            }
            if (!this.isNaN(this.itsc[3])) {
                index[count++] = 3;
            }
            Line2D l0 = index[0] < 2 ? this.line0 : this.line1;
            Line2D l1 = index[1] < 2 ? this.line0 : this.line1;
            result = new Point2D[2];
            if (count == 0) {
                result = null;
            } else if (count == 2) {
                result = !(this.itsc[index[0]] != 0.0 && this.itsc[index[0]] != 1.0 || this.itsc[index[1]] != 0.0 && this.itsc[index[1]] != 1.0) ? new Point2D[]{AlgoLine2D.evaluate(l0, this.itsc[index[0]])} : new Point2D[]{AlgoLine2D.evaluate(l0, this.itsc[index[0]]), AlgoLine2D.evaluate(l1, this.itsc[index[1]])};
            } else if (count == 3) {
                if (index[0] < 2 && index[1] < 2) {
                    result[0] = AlgoLine2D.evaluate(l0, this.itsc[index[0]]);
                    result[1] = AlgoLine2D.evaluate(l0, this.itsc[index[1]]);
                } else {
                    result[0] = AlgoLine2D.evaluate(l1, this.itsc[index[0]]);
                    result[1] = AlgoLine2D.evaluate(l1, this.itsc[index[1]]);
                }
            } else if (count == 4) {
                result[0] = AlgoLine2D.evaluate(l0, this.itsc[index[0]]);
                result[1] = AlgoLine2D.evaluate(l0, this.itsc[index[1]]);
            }
        }
        return result;
    }

    public static double[] intersection(Point2D p0, Point2D p1, Point2D q0, Point2D q1) {
        if (AlgoLine2D.isParallel(p0, p1, q0, q1)) {
            double[] result = new double[]{Double.NaN, Double.NaN, Double.NaN, Double.NaN};
            result[0] = AlgoLine2D.constrParamForPoint(p0, p1, q0);
            result[1] = AlgoLine2D.constrParamForPoint(p0, p1, q1);
            result[2] = AlgoLine2D.constrParamForPoint(q0, q1, p0);
            result[3] = AlgoLine2D.constrParamForPoint(q0, q1, p1);
            int i = 0;
            while (i <= 3) {
                if (result[i] < 0.0 || result[i] > 1.0) {
                    result[i] = Double.NaN;
                }
                ++i;
            }
            return result;
        }
        double[] result = new double[]{Double.NaN, Double.NaN};
        Point2D ep = AlgoPoint2D.subtract(p1, p0);
        Point2D eq = AlgoPoint2D.subtract(q1, q0);
        Point2D pq = AlgoPoint2D.subtract(q0, p0);
        double det = AlgoPoint2D.cross(ep, eq);
        double rp = AlgoPoint2D.cross(pq, eq) / det;
        double rq = AlgoPoint2D.cross(pq, ep) / det;
        double eps = 0.001;
        if (Math.abs(rp) < eps) {
            rp = 0.0;
        }
        if (Math.abs(rp - 1.0) < eps) {
            rp = 1.0;
        }
        if (Math.abs(rq) < eps) {
            rq = 0.0;
        }
        if (Math.abs(rq - 1.0) < eps) {
            rq = 1.0;
        }
        if (rp < 0.0 || rp > 1.0) {
            rp = Double.NaN;
        }
        if (rq < 0.0 || rq > 1.0) {
            rq = Double.NaN;
        }
        result[0] = rp;
        result[1] = rq;
        return result;
    }
}

