/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.util.elem2D;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Vector;
import org.geotools.geometry.iso.util.elem2D.Edge2D;
import org.geotools.geometry.iso.util.elem2D.Node2D;
import org.geotools.geometry.iso.util.elem2D.Simplex2D;
import org.geotools.geometry.iso.util.elem2D.Triangle2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Geo2DFactory {
    public static Edge2D getEdge(Node2D n0, Node2D n1) {
        if (n0 == null || n1 == null) {
            return null;
        }
        return n0.getEdge(n1);
    }

    public static Edge2D createEdgeAndNodes(double x0, double y0, double x1, double y1) {
        Node2D n0 = new Node2D(x0, y0);
        Node2D n1 = new Node2D(x1, y1);
        Edge2D edge = new Edge2D(n0, n1);
        n0.linkEdge(edge);
        n1.linkEdge(edge);
        return edge;
    }

    public static Edge2D createEdgeAndNode(Node2D n0, double x1, double y1) {
        Node2D n1 = new Node2D(x1, y1);
        Edge2D edge = new Edge2D(n0, n1);
        n0.linkEdge(edge);
        n1.linkEdge(edge);
        return edge;
    }

    public static Edge2D createEdgeAndNode(double x0, double y0, Node2D n1) {
        Node2D n0 = new Node2D(x0, y0);
        Edge2D edge = new Edge2D(n0, n1);
        n0.linkEdge(edge);
        n1.linkEdge(edge);
        return edge;
    }

    public static Edge2D createEdgeFromNodes(Node2D n0, Node2D n1) {
        if (n0 == null || n1 == null) {
            return null;
        }
        Edge2D edge = new Edge2D(n0, n1);
        n0.linkEdge(edge);
        n1.linkEdge(edge);
        return edge;
    }

    public static Edge2D createEdge(Node2D nodeFrom, Node2D nodeTo, Simplex2D rightSimplex, Simplex2D leftSimplex) {
        int side;
        if (nodeFrom == null || nodeTo == null) {
            return null;
        }
        assert (nodeFrom.getEdge(nodeTo) == null);
        assert (nodeTo.getEdge(nodeFrom) == null);
        Edge2D edge = new Edge2D(nodeFrom, nodeTo);
        nodeFrom.linkEdge(edge);
        nodeTo.linkEdge(edge);
        if (rightSimplex != null) {
            side = rightSimplex.getSide(nodeFrom, nodeTo);
            if (side == -1) {
                return null;
            }
            rightSimplex.linkEdge(side, edge);
            edge.setSimplex(rightSimplex, Edge2D.RIGHTSIDE);
        }
        if (leftSimplex != null) {
            side = leftSimplex.getSide(nodeFrom, nodeTo);
            if (side == -1) {
                return null;
            }
            leftSimplex.linkEdge(side, edge);
            edge.setSimplex(leftSimplex, Edge2D.LEFTSIDE);
        }
        return edge;
    }

    public static boolean connectEdgeSimplex(Edge2D edge, Simplex2D simplex, int edgeSide) {
        if (edge == null || simplex == null || edgeSide != Edge2D.RIGHTSIDE && edgeSide != Edge2D.LEFTSIDE) {
            return false;
        }
        int simplexSide = simplex.getSide(edge.getNode1(), edge.getNode2());
        if (simplexSide == -1) {
            return false;
        }
        simplex.linkEdge(simplexSide, edge);
        edge.setSimplex(simplex, edgeSide);
        return true;
    }

    public static boolean connectSimplexSimplex(Simplex2D simplex0, Simplex2D simplex1) {
        if (simplex0 == null || simplex1 == null) {
            return false;
        }
        return simplex0.linkSimplex(simplex1);
    }

    public static Object[] splitEdge(Edge2D edge, Point2D p) {
        if (edge.getLeftSimplex() != null || edge.getRightSimplex() != null) {
            System.out.println("error connectSimplexSimplex(Simplex2D simplex0, Simplex2D simplex1)");
            return null;
        }
        Node2D n1 = edge.getNode1();
        Node2D n2 = edge.getNode2();
        n1.unlinkEdge(edge);
        n2.unlinkEdge(edge);
        Node2D newNode = new Node2D(p);
        edge.setNodes(n1, newNode);
        Edge2D newEdge = new Edge2D(newNode, n2);
        n1.linkEdge(edge);
        n2.linkEdge(newEdge);
        newNode.linkEdge(edge);
        newNode.linkEdge(newEdge);
        newEdge.object = edge.object;
        return new Object[]{newEdge, newNode};
    }

    private static void connect(Edge2D edge, Node2D n0, Node2D n1) {
        if (edge.hasPoint(n0) && edge.hasPoint(n1)) {
            System.out.println("error connect(Edge2D edge, Node2D n0, Node2D n1)");
        }
        edge.setNodes(n0, n1);
        n0.linkEdge(edge);
        n1.linkEdge(edge);
    }

    public static void removeEdge(Edge2D edge) {
        Node2D n1 = edge.getNode1();
        Node2D n2 = edge.getNode2();
        n1.unlinkEdge(edge);
        n2.unlinkEdge(edge);
    }

    public static void setEdgeNodes(Edge2D e, Node2D n1, Node2D n2) {
        assert (e.getLeftSimplex() == null && e.getRightSimplex() == null);
        assert (Geo2DFactory.getEdge(n1, n2) == null);
        Node2D nn1 = e.getNode1();
        Node2D nn2 = e.getNode2();
        if (n1 != nn1) {
            n1.appendEdges(nn1.getEdges());
        }
        if (n2 != nn2) {
            n2.appendEdges(nn2.getEdges());
        }
        e.setNodes(n1, n2);
    }

    public static void setTriangleNodes(Triangle2D tri, Node2D n0, Node2D n1, Node2D n2) {
        tri.point[0] = n0;
        tri.point[1] = n1;
        tri.point[2] = n2;
    }

    public static void setTopology(ArrayList<Triangle2D> triangles, ArrayList<Edge2D> edges) {
        int i;
        Node2D[] n;
        if (edges == null) {
            edges = new ArrayList();
        }
        if (triangles == null) {
            triangles = new ArrayList();
        }
        for (Triangle2D tri : triangles) {
            tri.linkSimplex(0, null);
            tri.linkSimplex(1, null);
            tri.linkSimplex(2, null);
            n = tri.getPoints();
            i = 0;
            while (i < 3) {
                n[i].linkSimplex(tri);
                if (!(n[i].object instanceof TN)) {
                    n[i].object = new TN(n[i].object);
                }
                ((TN)n[i].object).tri.add(tri);
                ++i;
            }
        }
        for (Triangle2D tri : triangles) {
            n = tri.getPoints();
            i = 0;
            while (i < 3) {
                if (!tri.hasNeighbour(i)) {
                    TN tn = (TN)n[i].object;
                    for (Triangle2D t : tn.tri) {
                        int side;
                        if (t == tri || (side = t.getSide(n[i], n[(i + 1) % 3])) == -1) continue;
                        tri.linkSimplex(i, t);
                        t.linkSimplex(side, tri);
                        break;
                    }
                }
                ++i;
            }
        }
        for (Edge2D e : edges) {
            int i2;
            Node2D n0 = e.getNode1();
            Node2D n1 = e.getNode2();
            TN tn0 = (TN)n0.object;
            TN tn1 = (TN)n1.object;
            int side0 = -1;
            int side1 = -1;
            Simplex2D tri0 = null;
            Simplex2D tri1 = null;
            for (Triangle2D t0 : tn0.tri) {
                Node2D[] p0 = t0.getPoints();
                i2 = 0;
                while (i2 < 3) {
                    if (p0[i2] == n0 && p0[(i2 + 1) % 3] == n1) {
                        side0 = i2;
                        tri0 = t0;
                        break;
                    }
                    ++i2;
                }
                if (tri0 != null) break;
            }
            for (Triangle2D t1 : tn1.tri) {
                Node2D[] p1 = t1.getPoints();
                i2 = 0;
                while (i2 < 3) {
                    if (p1[i2] == n1 && p1[(i2 + 1) % 3] == n0) {
                        side1 = i2;
                        tri1 = t1;
                        break;
                    }
                    ++i2;
                }
                if (tri1 != null) break;
            }
            assert (side0 != -1 && side1 != -1);
            if (side0 != -1) {
                e.surfaceLeft = tri0;
                tri0.linkEdge(side0, e);
            }
            if (side1 == -1) continue;
            e.surfaceRight = tri1;
            tri1.linkEdge(side1, e);
        }
        for (Edge2D e : edges) {
            e.surfaceRight = null;
            e.surfaceLeft = null;
            Node2D n1 = e.getNode1();
            Node2D n2 = e.getNode2();
            n1.linkEdge(e);
            n2.linkEdge(e);
        }
        for (Triangle2D tri : triangles) {
            n = tri.getPoints();
            int i3 = 0;
            while (i3 < 3) {
                if (n[i3].object instanceof TN) {
                    n[i3].object = ((TN)n[i3].object).nodeObject;
                }
                ++i3;
            }
        }
    }

    public static void mergeNodes(Node2D n0, Node2D n1) {
        Edge2D[] edges = n1.getEdges();
        int i = 0;
        while (i < edges.length) {
            Edge2D e = edges[i];
            n1.unlinkEdge(e);
            if (!n0.hasEdge(e)) {
                n0.linkEdge(e);
            }
            ++i;
        }
    }

    public static Node2D createNode(Point2D p) {
        return new Node2D(p);
    }

    public static Triangle2D createTriangleAndNodes(double x0, double y0, double x1, double y1, double x2, double y2) {
        Node2D n0 = new Node2D(x0, y0);
        Node2D n1 = new Node2D(x1, y1);
        Node2D n2 = new Node2D(x2, y2);
        return new Triangle2D(n0, n1, n2);
    }

    private static class TN {
        Node2D nodeObject;
        Vector<Triangle2D> tri = new Vector(6, 2);

        public TN(Object o) {
            this.nodeObject = (Node2D)o;
        }

        public static int[] getTriangles(Node2D n0, Node2D n1) {
            int i;
            TN tn0 = (TN)n0.object;
            TN tn1 = (TN)n1.object;
            int[] side = new int[]{-1, -1};
            for (Triangle2D t0 : tn0.tri) {
                Node2D[] p0 = t0.getPoints();
                i = 0;
                while (i < 3) {
                    if (p0[i] == n0 && p0[(i + 1) % 3] == n1) {
                        side[0] = i;
                    }
                    ++i;
                }
            }
            for (Triangle2D t1 : tn0.tri) {
                Node2D[] p1 = t1.getPoints();
                i = 0;
                while (i < 3) {
                    if (p1[i] == n1 && p1[(i + 1) % 3] == n0) {
                        side[i] = i;
                    }
                    ++i;
                }
            }
            return side;
        }
    }
}

