/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.util.interpolation;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.geotools.geometry.iso.util.algorithm2D.AlgoPoint2D;
import org.geotools.geometry.iso.util.interpolation.ITP_Interpolation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointNeighboursGradients {
    ITP_Interpolation.Point3d mP;
    ITP_Interpolation.Point3d[] mNbrs;
    public Point2D mGradXY;

    public PointNeighboursGradients(ITP_Interpolation.Point3d p) {
        this.mP = p;
    }

    public PointNeighboursGradients(ITP_Interpolation.Point3d p, ITP_Interpolation.Point3d[] nbrs) {
        this.mP = p;
        System.arraycopy(nbrs, 0, this.mNbrs, 0, nbrs.length);
        this.mGradXY = null;
    }

    public void setAkimaGradient() {
        int nnbr = this.mNbrs.length;
        double a = 0.0;
        double b = 0.0;
        double c = 0.0;
        int i = 0;
        while (i < nnbr) {
            Point2D.Double dp0 = new Point2D.Double(this.mNbrs[i].x - this.mP.x, this.mNbrs[i].y - this.mP.y);
            double dz0 = this.mNbrs[i].z - this.mP.z;
            int j = i + 1;
            while (j <= this.mNbrs.length - 1) {
                Point2D.Double dp1 = new Point2D.Double(this.mNbrs[j].x - this.mP.x, this.mNbrs[j].y - this.mP.y);
                double delta_c = AlgoPoint2D.cross(dp0, dp1);
                if (delta_c != 0.0) {
                    double dz1 = this.mNbrs[j].z - this.mP.z;
                    double delta_a = ((Point2D)dp0).getY() * dz1 - ((Point2D)dp1).getY() * dz0;
                    double delta_b = ((Point2D)dp1).getX() * dz0 - ((Point2D)dp0).getX() * dz1;
                    if (delta_c < 0.0) {
                        delta_a = -delta_a;
                        delta_b = -delta_b;
                        delta_c = -delta_c;
                    }
                    a += delta_a;
                    b += delta_b;
                    c += delta_c;
                }
                ++j;
            }
            ++i;
        }
        this.mGradXY = new Point2D.Double(-a / c, -b / c);
    }

    public void setClosestPoints(ArrayList<ITP_Interpolation.Point3d> pIn, int nnbr) {
        ArrayList<ITP_Interpolation.Point3d> nbrs = new ArrayList<ITP_Interpolation.Point3d>();
        double[] nbrDist = new double[nnbr];
        int i = 0;
        while (i < nnbr) {
            nbrDist[i] = Double.MAX_VALUE;
            ++i;
        }
        i = 0;
        int j = 0;
        while (i < pIn.size()) {
            ITP_Interpolation.Point3d p1 = pIn.get(i);
            if (this.mP != p1) {
                double dist = (this.mP.x - p1.x) * (this.mP.x - p1.x) + (this.mP.y - p1.y) * (this.mP.y - p1.y);
                if (j < nnbr) {
                    nbrDist[j] = dist;
                    nbrs.add(p1);
                } else {
                    int k = 0;
                    while (k < nnbr) {
                        if (dist < nbrDist[k]) {
                            nbrDist[k] = dist;
                            nbrs.add(p1);
                            break;
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        this.mNbrs = new ITP_Interpolation.Point3d[nbrs.size()];
        i = 0;
        while (i < nbrs.size()) {
            this.mNbrs[i] = (ITP_Interpolation.Point3d)nbrs.get(i);
            ++i;
        }
    }
}

