/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.geotiff;

import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageReaderSpi;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.imageio.GeoToolsWriteParams;
import org.geotools.coverage.grid.io.imageio.geotiff.GeoTiffIIOMetadataDecoder;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.factory.Hints;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.gce.geotiff.GeoTiffWriteParams;
import org.geotools.gce.geotiff.GeoTiffWriter;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.ParameterGroup;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverageWriter;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.operation.MathTransform;

public class GeoTiffFormat
extends AbstractGridFormat
implements Format {
    private static final TIFFImageReaderSpi spi = new TIFFImageReaderSpi();
    private static final Logger LOGGER = Logging.getLogger(GeoTiffFormat.class);
    public static final DefaultParameterDescriptor<Boolean> WRITE_TFW = new DefaultParameterDescriptor("WRITE_TFW", Boolean.class, (Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE}, (Object)Boolean.FALSE);

    public GeoTiffFormat() {
        this.writeParameters = null;
        this.mInfo = new HashMap();
        this.mInfo.put("name", "GeoTIFF");
        this.mInfo.put("description", "Tagged Image File Format with Geographic information");
        this.mInfo.put("vendor", "Geotools");
        this.mInfo.put("version", "1.1");
        this.mInfo.put("docURL", "http://www.remotesensing.org/geotiff/spec/geotiffhome.html");
        this.readParameters = new ParameterGroup((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(this.mInfo, new GeneralParameterDescriptor[]{READ_GRIDGEOMETRY2D}));
        this.writeParameters = new ParameterGroup((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(this.mInfo, new GeneralParameterDescriptor[]{AbstractGridFormat.GEOTOOLS_WRITE_PARAMS}));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean accepts(Object o, Hints hints) {
        boolean closeMe;
        ImageInputStream inputStream;
        ImageReader reader;
        block54: {
            block52: {
                block53: {
                    block50: {
                        block51: {
                            IIOMetadata metadata;
                            block48: {
                                block49: {
                                    block57: {
                                        block56: {
                                            block55: {
                                                if (o == null) {
                                                    return false;
                                                }
                                                reader = null;
                                                inputStream = null;
                                                closeMe = false;
                                                if (o instanceof URL) {
                                                    URL url = (URL)o;
                                                    o = DataUtilities.urlToFile((URL)url);
                                                } else if (o instanceof ImageInputStream) {
                                                    closeMe = false;
                                                }
                                                inputStream = (ImageInputStream)(o instanceof ImageInputStream ? o : ImageIO.createImageInputStream(o));
                                                if (inputStream != null) break block55;
                                                if (LOGGER.isLoggable(Level.FINE)) {
                                                    LOGGER.fine("Unable to get an ImageInputStream");
                                                }
                                                break block56;
                                            }
                                            if (spi.canDecodeInput((Object)inputStream)) break block57;
                                        }
                                        if (reader != null) {
                                            try {
                                                reader.dispose();
                                            }
                                            catch (Exception exception) {
                                                // empty catch block
                                            }
                                        }
                                        if (!closeMe) return false;
                                        if (inputStream == null) return false;
                                        try {
                                            inputStream.close();
                                            return false;
                                        }
                                        catch (Throwable throwable) {
                                            // empty catch block
                                        }
                                        return false;
                                    }
                                    reader = spi.createReaderInstance();
                                    inputStream.mark();
                                    reader.setInput(inputStream);
                                    metadata = reader.getImageMetadata(0);
                                    if (metadata != null) break block48;
                                    if (reader == null) break block49;
                                    try {
                                        reader.dispose();
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                if (!closeMe) return false;
                                if (inputStream == null) return false;
                                try {
                                    inputStream.close();
                                    return false;
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                return false;
                            }
                            GeoTiffIIOMetadataDecoder metadataAdapter = new GeoTiffIIOMetadataDecoder(metadata);
                            if (!metadataAdapter.hasGeoKey() && LOGGER.isLoggable(Level.FINE)) {
                                LOGGER.fine("Unable to find geokey directory for this tif file");
                            }
                            if (!metadataAdapter.hasModelTrasformation() && (!metadataAdapter.hasPixelScales() || !metadataAdapter.hasTiePoints())) break block50;
                            if (reader == null) break block51;
                            try {
                                reader.dispose();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (!closeMe) return true;
                        if (inputStream == null) return true;
                        try {
                            inputStream.close();
                            return true;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        return true;
                    }
                    MathTransform raster2Model = GeoTiffReader.parseWorldFile(o);
                    if (raster2Model == null) break block52;
                    if (reader == null) break block53;
                    try {
                        reader.dispose();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!closeMe) return true;
                if (inputStream == null) return true;
                try {
                    inputStream.close();
                    return true;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return true;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Unable to find georeferencing for this tif file");
            }
            if (reader == null) break block54;
            try {
                reader.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!closeMe) return false;
        if (inputStream == null) return false;
        try {
            inputStream.close();
            return false;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
        catch (Throwable e) {
            try {
                if (!LOGGER.isLoggable(Level.FINE)) return false;
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                return false;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (reader != null) {
                    try {
                        reader.dispose();
                    }
                    catch (Exception exception) {}
                }
                if (closeMe && inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }

    public GeoTiffReader getReader(Object source) {
        return this.getReader(source, null);
    }

    public GeoTiffReader getReader(Object source, Hints hints) {
        if (source instanceof URL) {
            URL url = (URL)source;
            try {
                File file = DataUtilities.urlToFile((URL)url);
                return new GeoTiffReader(file, hints);
            }
            catch (DataSourceException e) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                }
                return null;
            }
        }
        try {
            return new GeoTiffReader(source, hints);
        }
        catch (DataSourceException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            return null;
        }
    }

    public GridCoverageWriter getWriter(Object destination, Hints hints) {
        try {
            return new GeoTiffWriter(destination, hints);
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            return null;
        }
    }

    public GridCoverageWriter getWriter(Object destination) {
        try {
            return new GeoTiffWriter(destination);
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            return null;
        }
    }

    public GeoToolsWriteParams getDefaultImageIOWriteParameters() {
        return new GeoTiffWriteParams();
    }
}

