/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.grassraster.core.color;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.geotools.gce.grassraster.JGrassMapEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JGrassColorTable {
    private static final int[][] rainbow;
    private int alpha;
    private List<String> rules;

    static {
        int[][] nArrayArray = new int[6][];
        int[] nArray = new int[3];
        nArray[0] = 255;
        nArray[1] = 255;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[1] = 255;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[1] = 255;
        nArray3[2] = 255;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[3];
        nArray4[2] = 255;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[3];
        nArray5[0] = 255;
        nArray5[2] = 255;
        nArrayArray[4] = nArray5;
        int[] nArray6 = new int[3];
        nArray6[0] = 255;
        nArrayArray[5] = nArray6;
        rainbow = nArrayArray;
    }

    /*
     * Unable to fully structure code
     */
    public JGrassColorTable(JGrassMapEnvironment readerGrassEnv, double[] dataRange) throws IOException {
        block10: {
            super();
            this.alpha = 255;
            this.rules = new ArrayList<String>();
            colrFile = readerGrassEnv.getCOLR();
            if (!colrFile.exists()) {
                if (dataRange != null) {
                    this.rules = JGrassColorTable.createDefaultColorTable(dataRange, this.alpha);
                }
                return;
            }
            rdr = new BufferedReader(new InputStreamReader(new FileInputStream(colrFile)));
            line = rdr.readLine();
            if (line == null) {
                rdr.close();
                if (colrFile.delete()) {
                    System.out.println("removed empty color file");
                }
                this.rules = JGrassColorTable.createDefaultColorTable(dataRange, this.alpha);
                return;
            }
            if ((line = line.trim()).charAt(0) != '%') ** GOTO lbl34
            stringValues = line.split("\\s+");
            if (stringValues.length == 4) {
                try {
                    this.alpha = Integer.parseInt(stringValues[3]);
                }
                catch (NumberFormatException e) {
                    this.alpha = 255;
                }
            } else {
                this.alpha = 255;
            }
            while ((line = rdr.readLine()) != null) {
                this.rules.add(String.valueOf(line) + " " + this.alpha);
            }
            break block10;
lbl-1000:
            // 1 sources

            {
                this.rules.add(String.valueOf(line) + " " + this.alpha);
lbl34:
                // 2 sources

                ** while ((line = rdr.readLine()) != null)
            }
        }
        rdr.close();
    }

    public static List<String> createDefaultColorTable(double[] dataRange, int alpha) {
        ArrayList<String> rules = new ArrayList<String>();
        float rinc = (float)(dataRange[1] - dataRange[0]) / 5.0f;
        int i = 0;
        while (i < 5) {
            StringBuffer rule = new StringBuffer();
            rule.append(String.valueOf(dataRange[0] + (double)((float)i * rinc)) + ":");
            rule.append(String.valueOf(rainbow[i][0]) + ":" + rainbow[i][1] + ":" + rainbow[i][2] + " ");
            rule.append(String.valueOf(dataRange[0] + (double)((float)(i + 1) * rinc)) + ":");
            rule.append(String.valueOf(rainbow[i + 1][0]) + ":" + rainbow[i + 1][1] + ":" + rainbow[i + 1][2] + " " + alpha);
            rules.add(rule.toString());
            ++i;
        }
        return rules;
    }

    public List<String> getColorRules() {
        return this.rules;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public static void parseColorRule(String rule, double[] values, Color[] colors) {
        String[] ruleSplit;
        if (colors == null) {
            colors = new Color[2];
        }
        if ((ruleSplit = rule.split("\\s+")).length >= 2) {
            String part1 = ruleSplit[0];
            String part2 = ruleSplit[1];
            int alpha = 255;
            if (ruleSplit.length == 3) {
                alpha = Integer.parseInt(ruleSplit[2]);
            }
            String[] part1Split = part1.split(":");
            String[] part2Split = part2.split(":");
            if (part1Split.length == 2) {
                values[0] = Double.parseDouble(part1Split[0]);
                colors[0] = new Color(Integer.parseInt(part1Split[1]), Integer.parseInt(part1Split[1]), Integer.parseInt(part1Split[1]), alpha);
            } else if (part1Split.length == 4) {
                values[0] = Double.parseDouble(part1Split[0]);
                colors[0] = new Color(Integer.parseInt(part1Split[1]), Integer.parseInt(part1Split[2]), Integer.parseInt(part1Split[3]), alpha);
            } else {
                values[0] = Double.NaN;
                colors[0] = new Color(0, 0, 0);
            }
            if (part2Split.length == 2) {
                values[1] = Double.parseDouble(part2Split[0]);
                colors[1] = new Color(Integer.parseInt(part2Split[1]), Integer.parseInt(part2Split[1]), Integer.parseInt(part2Split[1]), alpha);
            } else if (part2Split.length == 4) {
                values[1] = Double.parseDouble(part2Split[0]);
                colors[1] = new Color(Integer.parseInt(part2Split[1]), Integer.parseInt(part2Split[2]), Integer.parseInt(part2Split[3]), alpha);
            } else {
                values[1] = Double.NaN;
                colors[1] = new Color(255, 255, 255);
            }
        } else if (ruleSplit.length >= 1) {
            String[] partSplit;
            String part = ruleSplit[0];
            int alpha = 255;
            if (ruleSplit.length == 2) {
                alpha = Integer.parseInt(ruleSplit[1]);
            }
            if ((partSplit = part.split(":")).length == 2) {
                values[0] = Double.parseDouble(partSplit[0]);
                colors[0] = new Color(Integer.parseInt(partSplit[1]), Integer.parseInt(partSplit[1]), Integer.parseInt(partSplit[1]), alpha);
            } else if (partSplit.length == 4) {
                values[0] = Double.parseDouble(partSplit[0]);
                colors[0] = new Color(Integer.parseInt(partSplit[1]), Integer.parseInt(partSplit[2]), Integer.parseInt(partSplit[3]), alpha);
            } else {
                values[0] = Double.NaN;
                colors[0] = new Color(0, 0, 0);
            }
            values[1] = values[0];
            colors[1] = colors[0];
        } else {
            values[0] = -1000.0;
            colors[0] = new Color(0, 0, 0);
            values[1] = 1000.0;
            colors[1] = new Color(255, 255, 255);
        }
    }
}

