/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.grassraster.core.color;

import java.util.Enumeration;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeTable {
    private Vector<CellAttribute> atts = new Vector();

    public int size() {
        return this.atts.size();
    }

    public Enumeration<CellAttribute> getCategories() {
        return this.atts.elements();
    }

    public void addAttribute(float cat, String value) {
        if (this.get(cat) == null) {
            this.insertAttribute(cat, value);
        }
    }

    public void addAttribute(float cat0, float cat1, String value) {
    }

    private String get(float cat) {
        int low = 0;
        int high = this.atts.size() - 1;
        while (low <= high) {
            int i = (low + high) / 2;
            CellAttribute catt = this.atts.elementAt(i);
            int c = catt.compare(cat);
            if (c == 0) {
                return catt.getText();
            }
            if (c < 0) {
                high = i - 1;
                continue;
            }
            low = i++ + 1;
        }
        return null;
    }

    private void insertAttribute(float cat, String value) {
        int i = 0;
        int low = 0;
        int high = this.atts.size() - 1;
        while (low <= high) {
            i = (low + high) / 2;
            CellAttribute catt = this.atts.elementAt(i);
            int c = catt.compare(cat);
            if (c == 0) {
                low = high + 1;
                continue;
            }
            if (c < 0) {
                high = i - 1;
                continue;
            }
            low = i++ + 1;
        }
        this.atts.insertElementAt(new CellAttribute(cat, value), i);
    }

    public class CellAttribute {
        private float low = 0.0f;
        private float range = 0.0f;
        private String catText = null;

        public CellAttribute(float cat, String text) {
            this.low = cat;
            this.range = 0.0f;
            this.catText = text;
        }

        public CellAttribute(float cat0, float cat1, String text) {
            if (cat1 > cat0) {
                this.low = cat0;
                this.range = cat1 - cat0;
            } else {
                this.low = cat1;
                this.range = cat0 - cat1;
            }
            this.catText = text;
        }

        public int compare(float cat) {
            float diff = cat - this.low;
            if (diff < 0.0f) {
                return -1;
            }
            if (diff > this.range) {
                return 1;
            }
            return 0;
        }

        public String getText() {
            return this.catText;
        }

        public float getLowcategoryValue() {
            return this.low;
        }

        public float getCategoryRange() {
            return this.range;
        }

        public String toString() {
            if (this.range == 0.0f) {
                return String.valueOf(this.low) + ":" + this.catText;
            }
            return String.valueOf(this.low) + "-" + String.valueOf(this.low + this.range) + ":" + this.catText;
        }
    }
}

