/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.grassraster.core.color;

import java.util.ArrayList;

public class Format {
    private int width = 0;
    private int precision = -1;
    private String pre = "";
    private String post = "";
    private boolean leadingZeroes = false;
    private boolean showPlus = false;
    private boolean alternate = false;
    private boolean showSpace = false;
    private boolean leftAlign = false;
    private char fmt = (char)32;
    private boolean countSignInLen = true;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Format(String s) {
        int length = s.length();
        int parseState = 0;
        int i = 0;
        while (parseState == 0) {
            if (i >= length) {
                parseState = 5;
            } else if (s.charAt(i) == '%') {
                if (i >= length - 1) throw new IllegalArgumentException();
                if (s.charAt(i + 1) == '%') {
                    this.pre = this.pre + '%';
                    ++i;
                } else {
                    parseState = 1;
                }
            } else {
                this.pre = this.pre + s.charAt(i);
            }
            ++i;
        }
        while (parseState == 1) {
            if (i >= length) {
                parseState = 5;
            } else if (s.charAt(i) == ' ') {
                this.showSpace = true;
            } else if (s.charAt(i) == '-') {
                this.leftAlign = true;
            } else if (s.charAt(i) == '+') {
                this.showPlus = true;
            } else if (s.charAt(i) == '0') {
                this.leadingZeroes = true;
            } else if (s.charAt(i) == '#') {
                this.alternate = true;
            } else if (s.charAt(i) == '~') {
                this.countSignInLen = false;
            } else {
                parseState = 2;
                --i;
            }
            ++i;
        }
        while (parseState == 2) {
            if (i >= length) {
                parseState = 5;
                continue;
            }
            if ('0' <= s.charAt(i) && s.charAt(i) <= '9') {
                this.width = this.width * 10 + s.charAt(i) - 48;
                ++i;
                continue;
            }
            if (s.charAt(i) == '.') {
                parseState = 3;
                this.precision = 0;
                ++i;
                continue;
            }
            parseState = 4;
        }
        while (parseState == 3) {
            if (i >= length) {
                parseState = 5;
                continue;
            }
            if ('0' <= s.charAt(i) && s.charAt(i) <= '9') {
                this.precision = this.precision * 10 + s.charAt(i) - 48;
                ++i;
                continue;
            }
            parseState = 4;
        }
        if (parseState == 4) {
            if (i >= length) {
                parseState = 5;
            } else {
                this.fmt = s.charAt(i);
            }
            ++i;
        }
        if (i >= length) return;
        this.post = s.substring(i, length);
    }

    private String expFormat(double d) {
        String f = "";
        int e = 0;
        double factor = 1.0;
        if (d != 0.0) {
            double dd;
            for (dd = d; dd > 10.0; dd /= 10.0) {
                ++e;
                factor /= 10.0;
            }
            while (dd < 1.0) {
                --e;
                factor *= 10.0;
                dd *= 10.0;
            }
        }
        if ((this.fmt == 'g' || this.fmt == 'G') && e >= -4 && e < this.precision) {
            return this.fixedFormat(d);
        }
        f = f + this.fixedFormat(d *= factor);
        f = this.fmt == 'e' || this.fmt == 'g' ? f + "e" : f + "E";
        String p = "000";
        if (e >= 0) {
            f = f + "+";
            p = p + e;
        } else {
            f = f + "-";
            p = p + -e;
        }
        return f + p.substring(p.length() - 3, p.length());
    }

    private String fixedFormat(double d) {
        boolean removeTrailing;
        boolean bl = removeTrailing = (this.fmt == 'G' || this.fmt == 'g') && !this.alternate;
        if (d > 9.223372036854776E18) {
            return this.expFormat(d);
        }
        if (this.precision == 0) {
            return (long)d + (removeTrailing ? "" : ".");
        }
        long whole = (long)d;
        double fr = d - (double)whole;
        if (fr >= 1.0 || fr < 0.0) {
            return this.expFormat(d);
        }
        double factor = 1.0;
        StringBuffer buf = new StringBuffer();
        for (int i = 1; i <= this.precision && factor <= 9.223372036854776E18; factor *= 10.0, ++i) {
            buf.append("0");
        }
        String leadingZeroes = buf.toString();
        long l = (long)(factor * fr);
        if ((double)l >= factor) {
            l = 0L;
            ++whole;
        }
        String z = leadingZeroes + l;
        z = "." + z.substring(z.length() - this.precision, z.length());
        if (removeTrailing) {
            int t;
            for (t = z.length() - 1; t >= 0 && z.charAt(t) == '0'; --t) {
            }
            if (t >= 0 && z.charAt(t) == '.') {
                --t;
            }
            z = z.substring(0, t + 1);
        }
        return whole + z;
    }

    private String pad(String r) {
        String p = Format.repeat(' ', this.width - r.length());
        if (this.leftAlign) {
            return this.pre + r + p + this.post;
        }
        return this.pre + p + r + this.post;
    }

    private static long parseLong(String s, int base) {
        int i;
        int sign = 1;
        long r = 0L;
        for (i = 0; i < s.length() && Character.isWhitespace(s.charAt(i)); ++i) {
        }
        if (i < s.length() && s.charAt(i) == '-') {
            sign = -1;
            ++i;
        } else if (i < s.length() && s.charAt(i) == '+') {
            ++i;
        }
        while (i < s.length()) {
            char ch = s.charAt(i);
            if ('0' <= ch && ch < 48 + base) {
                r = r * (long)base + (long)ch - 48L;
            } else if ('A' <= ch && ch < 65 + base - 10) {
                r = r * (long)base + (long)ch - 65L + 10L;
            } else if ('a' <= ch && ch < 97 + base - 10) {
                r = r * (long)base + (long)ch - 97L + 10L;
            } else {
                return r * (long)sign;
            }
            ++i;
        }
        return r * (long)sign;
    }

    private static String repeat(char c, int n) {
        if (n <= 0) {
            return "";
        }
        StringBuffer s = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            s.append(c);
        }
        return s.toString();
    }

    private String sign(int s, String r) {
        String p = "";
        if (s < 0) {
            p = "-";
        } else if (s > 0) {
            if (this.showPlus) {
                p = "+";
            } else if (this.showSpace) {
                p = " ";
            }
        } else if (this.fmt == 'o' && this.alternate && r.length() > 0 && r.charAt(0) != '0') {
            p = "0";
        } else if (this.fmt == 'x' && this.alternate) {
            p = "0x";
        } else if (this.fmt == 'X' && this.alternate) {
            p = "0X";
        }
        int w = 0;
        if (this.leadingZeroes) {
            w = this.width;
        } else if ((this.fmt == 'u' || this.fmt == 'd' || this.fmt == 'i' || this.fmt == 'x' || this.fmt == 'X' || this.fmt == 'o') && this.precision > 0) {
            w = this.precision;
        }
        if (this.countSignInLen) {
            return p + Format.repeat('0', w - p.length() - r.length()) + r;
        }
        return p + Format.repeat('0', w - r.length()) + r;
    }

    public String form(char c) {
        if (this.fmt != 'c') {
            throw new IllegalArgumentException();
        }
        String r = "" + c;
        return this.pad(r);
    }

    public String form(Character c) {
        return this.form(c.charValue());
    }

    public String form(double x) {
        String r;
        if (this.precision < 0) {
            this.precision = 6;
        }
        int s = 1;
        if (x < 0.0) {
            x = -x;
            s = -1;
        }
        if (this.fmt == 'f') {
            r = this.fixedFormat(x);
        } else if (this.fmt == 'e' || this.fmt == 'E' || this.fmt == 'g' || this.fmt == 'G') {
            r = this.expFormat(x);
        } else {
            throw new IllegalArgumentException();
        }
        return this.pad(this.sign(s, r));
    }

    public String form(Double x) {
        return this.form((double)x);
    }

    public String form(Float x) {
        return this.form(x.doubleValue());
    }

    public String form(long x) {
        String r;
        int s = 0;
        if (this.fmt == 'd') {
            if (x < 0L) {
                r = ("" + x).substring(1);
                s = -1;
            } else {
                r = "" + x;
                s = 1;
            }
        } else if (this.fmt == 'i') {
            int xx = (int)x;
            if (xx < 0) {
                r = ("" + xx).substring(1);
                s = -1;
            } else {
                r = "" + xx;
                s = 1;
            }
        } else if (this.fmt == 'u') {
            long xl = x & 0xFFFFFFFFL;
            r = "" + xl;
            s = 1;
        } else if (this.fmt == 'o') {
            r = Format.convert(x, 3, "01234567");
        } else if (this.fmt == 'x') {
            r = Format.convert(x, 4, "0123456789abcdef");
        } else if (this.fmt == 'X') {
            r = Format.convert(x, 4, "0123456789ABCDEF");
        } else {
            throw new IllegalArgumentException();
        }
        return this.pad(this.sign(s, r));
    }

    public String form(Long x) {
        return this.form((long)x);
    }

    public String form(int x) {
        String r;
        int s = 0;
        if (this.fmt == 'd' || this.fmt == 'i') {
            if (x < 0) {
                r = ("" + x).substring(1);
                s = -1;
            } else {
                r = "" + x;
                s = 1;
            }
        } else {
            long xl = (long)x & 0xFFFFFFFFL;
            if (this.fmt == 'u') {
                r = "" + xl;
                s = 1;
            } else if (this.fmt == 'o') {
                r = Format.convert(xl, 3, "01234567");
            } else if (this.fmt == 'x') {
                r = Format.convert(xl, 4, "0123456789abcdef");
            } else if (this.fmt == 'X') {
                r = Format.convert(xl, 4, "0123456789ABCDEF");
            } else {
                throw new IllegalArgumentException();
            }
        }
        return this.pad(this.sign(s, r));
    }

    public String form(Integer x) {
        return this.form((int)x);
    }

    public String form(String s) {
        if (this.fmt != 's') {
            throw new IllegalArgumentException();
        }
        if (this.precision >= 0 && this.precision < s.length()) {
            s = s.substring(0, this.precision);
        }
        return this.pad(s);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double atof(String s) {
        int i;
        int sign = 1;
        double r = 0.0;
        double p = 1.0;
        boolean state = false;
        for (i = 0; i < s.length() && Character.isWhitespace(s.charAt(i)); ++i) {
        }
        if (i < s.length() && s.charAt(i) == '-') {
            sign = -1;
            ++i;
        } else if (i < s.length() && s.charAt(i) == '+') {
            ++i;
        }
        while (i < s.length()) {
            char ch = s.charAt(i);
            if ('0' <= ch && ch <= '9') {
                if (!state) {
                    r = r * 10.0 + (double)ch - 48.0;
                } else if (state) {
                    r += (p /= 10.0) * (double)(ch - 48);
                }
            } else if (ch == '.') {
                if (state) return (double)sign * r;
                state = true;
            } else {
                if (ch != 'e' && ch != 'E') return (double)sign * r;
                long e = (int)Format.parseLong(s.substring(i + 1), 10);
                return (double)sign * r * Math.pow(10.0, e);
            }
            ++i;
        }
        return (double)sign * r;
    }

    public static int atoi(String s) {
        return (int)Format.atol(s);
    }

    public static long atol(String s) {
        int i;
        for (i = 0; i < s.length() && Character.isWhitespace(s.charAt(i)); ++i) {
        }
        if (i < s.length() && s.charAt(i) == '0') {
            if (i + 1 < s.length() && (s.charAt(i + 1) == 'x' || s.charAt(i + 1) == 'X')) {
                return Format.parseLong(s.substring(i + 2), 16);
            }
            return Format.parseLong(s, 8);
        }
        return Format.parseLong(s, 10);
    }

    public static String convert(long x, int n, String d) {
        if (x == 0L) {
            return "0";
        }
        String r = "";
        int m = 1 << n;
        --m;
        while (x != 0L) {
            r = d.charAt((int)(x & (long)m)) + r;
            x >>>= n;
        }
        return r;
    }

    public static String sprintf(String fmt, char x) {
        return new Format(fmt).form(x);
    }

    public static String sprintf(String fmt, Character x) {
        return new Format(fmt).form(x);
    }

    public static String sprintf(String fmt, double x) {
        return new Format(fmt).form(x);
    }

    public static String sprintf(String fmt, Double x) {
        return new Format(fmt).form(x);
    }

    public static String sprintf(String fmt, Float x) {
        return new Format(fmt).form(x);
    }

    public static String sprintf(String fmt, long x) {
        return new Format(fmt).form(x);
    }

    public static String sprintf(String fmt, Long x) {
        return new Format(fmt).form(x);
    }

    public static String sprintf(String fmt, int x) {
        return new Format(fmt).form(x);
    }

    public static String sprintf(String fmt, Integer x) {
        return new Format(fmt).form(x);
    }

    public static String sprintf(String fmt, String x) {
        return new Format(fmt).form(x);
    }

    private static String[] split(String s) {
        ArrayList<String> list = new ArrayList<String>();
        int lasti = 0;
        int i = s.indexOf("%");
        if (i == -1) {
            return new String[]{s};
        }
        if (i > 0) {
            list.add("+" + s.substring(0, i));
            lasti = i++;
            i = s.indexOf("%", i);
        } else if (i == 0) {
            i = s.indexOf("%", i + 1);
        }
        while (i != -1) {
            String ss = s.substring(lasti, i);
            if (ss.equals("%")) {
                lasti = i++;
                ss = (i = s.indexOf("%", i)) != -1 ? s.substring(lasti, i) : s.substring(lasti);
                list.add("+" + ss);
            } else {
                list.add(" " + ss);
            }
            if (i == -1) {
                lasti = i;
                break;
            }
            lasti = i++;
            i = s.indexOf("%", i);
        }
        if (lasti != -1) {
            list.add(" " + s.substring(lasti));
        }
        String[] ret = new String[list.size()];
        for (i = 0; i < list.size(); ++i) {
            ret[i] = (String)list.get(i);
        }
        return ret;
    }

    public static String sprintf(String s, Object[] params) {
        if (s == null || params == null) {
            return s;
        }
        StringBuffer result = new StringBuffer("");
        String[] ss = Format.split(s);
        int p = 0;
        for (int i = 0; i < ss.length; ++i) {
            char c = ss[i].charAt(0);
            String t = ss[i].substring(1);
            if (c == '+') {
                result.append(t);
                continue;
            }
            Object param = params[p];
            if (param instanceof Integer) {
                result.append(new Format(t).form((Integer)param));
            } else if (param instanceof Long) {
                result.append(new Format(t).form((Long)param));
            } else if (param instanceof Character) {
                result.append(new Format(t).form((Character)param));
            } else if (param instanceof Double) {
                result.append(new Format(t).form((Double)param));
            } else if (param instanceof Float) {
                result.append(new Format(t).form((Float)param));
            } else {
                result.append(new Format(t).form(param.toString()));
            }
            ++p;
        }
        return result.toString();
    }

    public static String sprintf(String s, String[] params) {
        return Format.sprintf(s, (Object[])params);
    }

    public static String sprintf(String s, Integer[] params) {
        return Format.sprintf(s, (Object[])params);
    }

    public static String sprintf(String s, Long[] params) {
        return Format.sprintf(s, (Object[])params);
    }

    public static String sprintf(String s, Double[] params) {
        return Format.sprintf(s, (Object[])params);
    }

    public static String sprintf(String s, Float[] params) {
        return Format.sprintf(s, (Object[])params);
    }

    public static String sprintf(String s, Character[] params) {
        return Format.sprintf(s, (Object[])params);
    }

    public static String sprintf(String s, int[] params) {
        if (s == null || params == null) {
            return s;
        }
        StringBuffer result = new StringBuffer("");
        String[] ss = Format.split(s);
        int p = 0;
        for (int i = 0; i < ss.length; ++i) {
            char c = ss[i].charAt(0);
            String t = ss[i].substring(1);
            if (c == '+') {
                result.append(t);
                continue;
            }
            int param = params[p];
            result.append(new Format(t).form(param));
            ++p;
        }
        return result.toString();
    }
}

