/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.grid;

import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.grid.DefaultFeatureBuilder;
import org.geotools.grid.GridFeatureBuilder;
import org.geotools.grid.Orientation;
import org.geotools.grid.hexagon.Hexagons;
import org.geotools.grid.oblong.Oblongs;

public class Grids {
    public static SimpleFeatureSource createSquareGrid(ReferencedEnvelope bounds, double sideLen) {
        if (bounds == null) {
            throw new IllegalArgumentException("bounds should not be null");
        }
        return Oblongs.createGrid(bounds, sideLen, sideLen, new DefaultFeatureBuilder(bounds.getCoordinateReferenceSystem()));
    }

    public static SimpleFeatureSource createSquareGrid(ReferencedEnvelope bounds, double sideLen, double vertexSpacing) {
        if (bounds == null) {
            throw new IllegalArgumentException("bounds should not be null");
        }
        return Oblongs.createGrid(bounds, sideLen, sideLen, vertexSpacing, new DefaultFeatureBuilder(bounds.getCoordinateReferenceSystem()));
    }

    public static SimpleFeatureSource createSquareGrid(ReferencedEnvelope bounds, double sideLen, double vertexSpacing, GridFeatureBuilder builder) {
        return Oblongs.createGrid(bounds, sideLen, sideLen, vertexSpacing, builder);
    }

    public static SimpleFeatureSource createHexagonalGrid(ReferencedEnvelope bounds, double sideLen) {
        if (bounds == null) {
            throw new IllegalArgumentException("bounds should not be null");
        }
        return Hexagons.createGrid(bounds, sideLen, Orientation.FLAT, new DefaultFeatureBuilder(bounds.getCoordinateReferenceSystem()));
    }

    public static SimpleFeatureSource createHexagonalGrid(ReferencedEnvelope bounds, double sideLen, double vertexSpacing) {
        if (bounds == null) {
            throw new IllegalArgumentException("bounds should not be null");
        }
        return Hexagons.createGrid(bounds, sideLen, vertexSpacing, Orientation.FLAT, new DefaultFeatureBuilder(bounds.getCoordinateReferenceSystem()));
    }

    public static SimpleFeatureSource createHexagonalGrid(ReferencedEnvelope bounds, double sideLen, double vertexSpacing, GridFeatureBuilder builder) {
        if (bounds == null) {
            throw new IllegalArgumentException("bounds should not be null");
        }
        return Hexagons.createGrid(bounds, sideLen, vertexSpacing, Orientation.FLAT, builder);
    }
}

