/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.jdbc;

import com.sun.media.jai.codec.ByteArraySeekableStream;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.SeekableStream;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.media.jai.PlanarImage;
import org.geotools.gce.imagemosaic.jdbc.AbstractThread;
import org.geotools.gce.imagemosaic.jdbc.Config;
import org.geotools.gce.imagemosaic.jdbc.ImageLevelInfo;
import org.geotools.gce.imagemosaic.jdbc.TileQueueElement;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.util.logging.Logging;
import org.opengis.geometry.Envelope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageDecoderThread
extends AbstractThread {
    protected static final Logger LOGGER = Logging.getLogger((String)ImageDecoderThread.class.getPackage().getName());
    private byte[] imageBytes;
    private String location;
    private GeneralEnvelope tileEnvelope;

    public ImageDecoderThread(byte[] bytes, String location, GeneralEnvelope tileEnvelope, Rectangle pixelDimension, GeneralEnvelope requestEnvelope, ImageLevelInfo levelInfo, LinkedBlockingQueue<TileQueueElement> tileQueue, Config config) {
        super(pixelDimension, requestEnvelope, levelInfo, tileQueue, config);
        this.imageBytes = bytes;
        this.location = location;
        this.tileEnvelope = tileEnvelope;
    }

    @Override
    public void run() {
        if (this.imageBytes == null || this.imageBytes.length == 0) {
            return;
        }
        try {
            BufferedImage bufferedImage = null;
            boolean triedFromStream = false;
            if (this.levelInfo.getCanImageIOReadFromInputStream()) {
                bufferedImage = ImageIO.read(new ByteArrayInputStream(this.imageBytes));
                triedFromStream = true;
            }
            if (bufferedImage == null) {
                if (triedFromStream) {
                    LOGGER.warning("Could not read " + this.location + " from stream, switch to JAI");
                }
                bufferedImage = this.readImage2(this.imageBytes);
            }
            if (!this.requestEnvelope.contains((Envelope)this.tileEnvelope, true)) {
                GeneralEnvelope savedTileEnvelope = new GeneralEnvelope((Envelope)this.tileEnvelope);
                this.tileEnvelope.intersect((Envelope)this.requestEnvelope);
                double scaleX = savedTileEnvelope.getSpan(0) / (double)bufferedImage.getWidth();
                double scaleY = savedTileEnvelope.getSpan(1) / (double)bufferedImage.getHeight();
                int x = (int)Math.round((this.tileEnvelope.getMinimum(0) - savedTileEnvelope.getMinimum(0)) / scaleX);
                int y = (int)Math.round((savedTileEnvelope.getMaximum(1) - this.tileEnvelope.getMaximum(1)) / scaleY);
                int width = (int)Math.round((double)bufferedImage.getWidth() / savedTileEnvelope.getSpan(0) * this.tileEnvelope.getSpan(0));
                int height = (int)Math.round((double)bufferedImage.getHeight() / savedTileEnvelope.getSpan(1) * this.tileEnvelope.getSpan(1));
                if (width > 0 && height > 0) {
                    BufferedImage clippedImage = bufferedImage.getSubimage(x, y, width, height);
                    this.tileQueue.add(new TileQueueElement(this.location, clippedImage, this.tileEnvelope));
                }
            } else {
                this.tileQueue.add(new TileQueueElement(this.location, bufferedImage, this.tileEnvelope));
            }
        }
        catch (IOException ex) {
            LOGGER.severe("Decorde error for tile " + this.location);
            LOGGER.log(Level.SEVERE, ex.getLocalizedMessage(), ex);
        }
    }

    private BufferedImage readImage2(byte[] imageBytes) throws IOException {
        ByteArraySeekableStream stream = new ByteArraySeekableStream(imageBytes);
        String decoderName = null;
        int i$ = 0;
        String[] arr$ = ImageCodec.getDecoderNames((SeekableStream)stream);
        int len$ = arr$.length;
        if (i$ < len$) {
            String dn;
            decoderName = dn = arr$[i$];
        }
        ImageDecoder decoder = ImageCodec.createImageDecoder(decoderName, (SeekableStream)stream, null);
        PlanarImage img = PlanarImage.wrapRenderedImage((RenderedImage)decoder.decodeAsRenderedImage());
        return img.getAsBufferedImage();
    }
}

