/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.jdbc;

import org.geotools.gce.imagemosaic.jdbc.Config;
import org.geotools.gce.imagemosaic.jdbc.DBDialect;

public class PostgisDialect
extends DBDialect {
    public PostgisDialect(Config config) {
        super(config);
    }

    protected String getRegisterSpatialStatement(String tn, String srs) {
        return "select AddGeometryColumn('" + tn + "','" + this.config.getGeomAttributeNameInSpatialTable() + "'," + srs + ",'" + this.getMultiPolygonSQLType() + "',2)";
    }

    protected String getUnregisterSpatialStatement(String tn) {
        return "select DropGeometryColumn('" + tn + "','" + this.getConfig().getGeomAttributeNameInSpatialTable() + "')";
    }

    protected String getCreateSpatialTableStatement(String tableName) throws Exception {
        String statement = " CREATE TABLE " + tableName;
        statement = statement + " (" + this.getConfig().getKeyAttributeNameInSpatialTable() + " CHAR(64) NOT NULL ";
        statement = statement + ",CONSTRAINT " + tableName + "_PK PRIMARY KEY(" + this.getConfig().getKeyAttributeNameInSpatialTable();
        statement = statement + "))";
        return statement;
    }

    protected String getCreateSpatialTableStatementJoined(String tableName) throws Exception {
        String statement = " CREATE TABLE " + tableName;
        statement = statement + " (" + this.getConfig().getKeyAttributeNameInSpatialTable() + " CHAR(64) NOT NULL ";
        statement = statement + "," + this.getConfig().getBlobAttributeNameInTileTable() + " " + this.getBLOBSQLType();
        statement = statement + ",CONSTRAINT " + tableName + "_PK PRIMARY KEY(" + this.getConfig().getKeyAttributeNameInSpatialTable();
        statement = statement + "))";
        return statement;
    }

    protected String getBLOBSQLType() {
        return "BYTEA";
    }

    protected String getMultiPolygonSQLType() {
        return "MULTIPOLYGON";
    }

    protected String getDoubleSQLType() {
        return "FLOAT8";
    }

    protected String getCreateIndexStatement(String tn) throws Exception {
        return "CREATE INDEX IX_" + tn + " ON " + tn + " USING gist(" + this.getConfig().getGeomAttributeNameInSpatialTable() + ") ";
    }
}

