/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.jdbc;

import org.geotools.gce.imagemosaic.jdbc.Config;
import org.geotools.gce.imagemosaic.jdbc.DBDialect;

public class UniversalDialect
extends DBDialect {
    public UniversalDialect(Config config) {
        super(config);
    }

    protected String getBLOBSQLType() {
        return "BLOB";
    }

    protected String getMultiPolygonSQLType() {
        return null;
    }

    protected String getCreateSpatialTableStatement(String tableName) throws Exception {
        String statement = " CREATE TABLE " + tableName;
        statement = statement + " ( " + this.getConfig().getKeyAttributeNameInSpatialTable() + " CHAR(64) NOT NULL,";
        statement = statement + this.getConfig().getTileMinXAttribute() + " DOUBLE NOT NULL,";
        statement = statement + this.getConfig().getTileMinYAttribute() + " DOUBLE NOT NULL,";
        statement = statement + this.getConfig().getTileMaxXAttribute() + " DOUBLE NOT NULL,";
        statement = statement + this.getConfig().getTileMaxYAttribute() + " DOUBLE NOT NULL,";
        statement = statement + "CONSTRAINT " + tableName + "_PK PRIMARY KEY(" + this.getConfig().getKeyAttributeNameInSpatialTable();
        statement = statement + "))";
        return statement;
    }

    protected String getCreateSpatialTableStatementJoined(String tableName) throws Exception {
        String statement = " CREATE TABLE " + tableName;
        statement = statement + " ( " + this.getConfig().getKeyAttributeNameInSpatialTable() + " CHAR(64) NOT NULL,";
        statement = statement + this.getConfig().getTileMinXAttribute() + " DOUBLE NOT NULL,";
        statement = statement + this.getConfig().getTileMinYAttribute() + " DOUBLE NOT NULL,";
        statement = statement + this.getConfig().getTileMaxXAttribute() + " DOUBLE NOT NULL,";
        statement = statement + this.getConfig().getTileMaxYAttribute() + " DOUBLE NOT NULL,";
        statement = statement + this.getConfig().getBlobAttributeNameInTileTable() + " " + this.getBLOBSQLType() + ",";
        statement = statement + "CONSTRAINT " + tableName + "_PK PRIMARY KEY(" + this.getConfig().getKeyAttributeNameInSpatialTable();
        statement = statement + "))";
        return statement;
    }

    protected String getCreateIndexStatement(String tn) throws Exception {
        return "CREATE  INDEX IX_" + tn + " ON " + tn + "(" + this.getConfig().getTileMinXAttribute() + "," + this.getConfig().getTileMinYAttribute() + ")";
    }
}

