/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import com.sun.media.jai.util.Rational;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import it.geosolutions.imageio.utilities.Utilities;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.ROIShape;
import javax.media.jai.operator.AffineDescriptor;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.gce.imagemosaic.ImageMosaicUtils;
import org.geotools.gce.imagemosaic.RasterLayerRequest;
import org.geotools.gce.imagemosaic.RasterLayerResponse;
import org.geotools.gce.imagemosaic.ReadType;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.LiteShape2;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.metadata.iso.spatial.PixelTranslation;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.resources.geometry.XRectangle2D;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

class Granule {
    private static final String DIRECT_KAKADU_PLUGIN = "it.geosolutions.imageio.plugins.jp2k.JP2KKakaduImageReader";
    private static final Logger LOGGER = Logging.getLogger(Granule.class);
    private static float rationalTolerance = 1.0E-6f;
    ReferencedEnvelope granuleBBOX;
    URL granuleUrl;
    ROIShape granuleROIShape;
    Geometry inclusionGeometry;
    final Map<Integer, Level> granuleLevels = Collections.synchronizedMap(new HashMap());
    AffineTransform baseGridToWorld;
    ImageReaderSpi cachedSPI;

    private static Rectangle2D layoutHelper(RenderedImage source, float scaleX, float scaleY, float transX, float transY, Interpolation interp) {
        Rational scaleXRational = Rational.approximate((float)scaleX, (float)rationalTolerance);
        Rational scaleYRational = Rational.approximate((float)scaleY, (float)rationalTolerance);
        long scaleXRationalNum = scaleXRational.num;
        long scaleXRationalDenom = scaleXRational.denom;
        long scaleYRationalNum = scaleYRational.num;
        long scaleYRationalDenom = scaleYRational.denom;
        Rational transXRational = Rational.approximate((float)transX, (float)rationalTolerance);
        Rational transYRational = Rational.approximate((float)transY, (float)rationalTolerance);
        long transXRationalNum = transXRational.num;
        long transXRationalDenom = transXRational.denom;
        long transYRationalNum = transYRational.num;
        long transYRationalDenom = transYRational.denom;
        int x0 = source.getMinX();
        int y0 = source.getMinY();
        int w = source.getWidth();
        int h = source.getHeight();
        long dx0Num = x0;
        long dx0Denom = 1L;
        long dy0Num = y0;
        long dy0Denom = 1L;
        long dx1Num = x0 + w;
        long dx1Denom = 1L;
        long dy1Num = y0 + h;
        long dy1Denom = 1L;
        dx0Num *= scaleXRationalNum;
        dx0Denom *= scaleXRationalDenom;
        dy0Num *= scaleYRationalNum;
        dy0Denom *= scaleYRationalDenom;
        dx1Num *= scaleXRationalNum;
        dx1Denom *= scaleXRationalDenom;
        dy1Num *= scaleYRationalNum;
        dy1Denom *= scaleYRationalDenom;
        dx0Num = 2L * dx0Num - dx0Denom;
        dx0Denom *= 2L;
        dy0Num = 2L * dy0Num - dy0Denom;
        dy0Denom *= 2L;
        dx1Num = 2L * dx1Num - 3L * dx1Denom;
        dx1Denom *= 2L;
        dy1Num = 2L * dy1Num - 3L * dy1Denom;
        dy1Denom *= 2L;
        dx0Num = dx0Num * transXRationalDenom + transXRationalNum * dx0Denom;
        dy0Num = dy0Num * transYRationalDenom + transYRationalNum * dy0Denom;
        dx1Num = dx1Num * transXRationalDenom + transXRationalNum * dx1Denom;
        dy1Num = dy1Num * transYRationalDenom + transYRationalNum * dy1Denom;
        int l_x0 = Rational.ceil((long)dx0Num, (long)(dx0Denom *= transXRationalDenom));
        int l_y0 = Rational.ceil((long)dy0Num, (long)(dy0Denom *= transYRationalDenom));
        int l_x1 = Rational.ceil((long)dx1Num, (long)(dx1Denom *= transXRationalDenom));
        int l_y1 = Rational.ceil((long)dy1Num, (long)(dy1Denom *= transYRationalDenom));
        Rectangle2D.Double retValue = new Rectangle2D.Double();
        retValue.setFrame(l_x0, l_y0, l_x1 - l_x0 + 1, l_y1 - l_y0 + 1);
        return retValue;
    }

    public Granule(BoundingBox granuleBBOX, URL granuleUrl) {
        this(granuleBBOX, granuleUrl, null);
    }

    public Granule(BoundingBox granuleBBOX, URL granuleUrl, ImageReaderSpi suggestedSPI) {
        this(granuleBBOX, granuleUrl, suggestedSPI, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Granule(BoundingBox granuleBBOX, URL granuleUrl, ImageReaderSpi suggestedSPI, Geometry inclusionGeometry) {
        this.granuleBBOX = ReferencedEnvelope.reference((BoundingBox)granuleBBOX);
        this.granuleUrl = granuleUrl;
        this.inclusionGeometry = inclusionGeometry;
        ImageInputStream inStream = null;
        ImageReader reader = null;
        try {
            try {
                inStream = ImageMosaicUtils.getInputStream(granuleUrl);
                if (inStream == null) {
                    throw new IllegalArgumentException("Unable to get an input stream for the provided file " + granuleUrl.toString());
                }
                if (this.cachedSPI == null) {
                    inStream.mark();
                    if (suggestedSPI != null && suggestedSPI.canDecodeInput(inStream)) {
                        this.cachedSPI = suggestedSPI;
                        inStream.reset();
                    } else {
                        inStream.mark();
                        reader = ImageMosaicUtils.getReader(inStream);
                        if (reader != null) {
                            this.cachedSPI = reader.getOriginatingProvider();
                        }
                        inStream.reset();
                    }
                }
                if ((reader = this.cachedSPI.createReaderInstance()) == null) {
                    throw new IllegalArgumentException("Unable to get an ImageReader for the provided file " + granuleUrl.toString());
                }
                Rectangle originalDimension = ImageMosaicUtils.getDimension(0, inStream, reader);
                GridToEnvelopeMapper geMapper = new GridToEnvelopeMapper((GridEnvelope)new GridEnvelope2D(originalDimension), (org.opengis.geometry.Envelope)granuleBBOX);
                geMapper.setPixelAnchor(PixelInCell.CELL_CENTER);
                this.baseGridToWorld = geMapper.createAffineTransform();
                try {
                    if (inclusionGeometry != null) {
                        LiteShape2 shape = null;
                        geMapper.setPixelAnchor(PixelInCell.CELL_CORNER);
                        shape = new LiteShape2(inclusionGeometry, geMapper.createTransform().inverse(), null, false);
                        this.granuleROIShape = new ROIShape((Shape)shape);
                    }
                }
                catch (TransformException e1) {
                    throw new IllegalArgumentException(e1);
                }
                catch (FactoryException e1) {
                    throw new IllegalArgumentException(e1);
                }
                this.granuleLevels.put(0, new Level(1.0, 1.0, originalDimension.width, originalDimension.height));
            }
            catch (IllegalStateException e) {
                throw new IllegalArgumentException(e);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
            Object var11_14 = null;
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            try {
                try {
                    if (inStream != null) {
                        inStream.close();
                    }
                }
                catch (Throwable e) {
                    throw new IllegalArgumentException(e);
                }
                Object var14_18 = null;
                if (reader == null) throw throwable;
                reader.dispose();
                throw throwable;
            }
            catch (Throwable throwable2) {
                Object var14_19 = null;
                if (reader == null) throw throwable2;
                reader.dispose();
                throw throwable2;
            }
        }
        try {}
        catch (Throwable throwable) {
            Object var14_17 = null;
            if (reader == null) throw throwable;
            reader.dispose();
            throw throwable;
        }
        try {}
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
        if (inStream != null) {
            inStream.close();
        }
        Object var14_16 = null;
        if (reader == null) return;
        reader.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public RasterLayerResponse.GranuleLoadingResult loadRaster(ImageReadParam readParameters, int imageIndex, ReferencedEnvelope cropBBox, MathTransform2D mosaicWorldToGrid, RasterLayerRequest request, Dimension tileDimension) throws IOException {
        ReferencedEnvelope bbox;
        ReferencedEnvelope intersection;
        if (LOGGER.isLoggable(java.util.logging.Level.FINE)) {
            LOGGER.fine("Loading raster data for granule " + this.toString());
        }
        if ((intersection = new ReferencedEnvelope((bbox = this.inclusionGeometry != null ? new ReferencedEnvelope(this.granuleBBOX.intersection(this.inclusionGeometry.getEnvelopeInternal()), this.granuleBBOX.getCoordinateReferenceSystem()) : this.granuleBBOX).intersection((Envelope)cropBBox), cropBBox.getCoordinateReferenceSystem())).isEmpty()) {
            if (!LOGGER.isLoggable(java.util.logging.Level.FINE)) return null;
            LOGGER.fine("Got empty intersection for granule " + this.toString() + " with request " + request.toString());
            return null;
        }
        ImageInputStream inStream = null;
        ImageReader reader = null;
        try {
            Object tx2;
            RenderedImage raster;
            int ssy;
            int ssx;
            inStream = ImageMosaicUtils.getInputStream(this.granuleUrl);
            if (inStream == null) {
                RasterLayerResponse.GranuleLoadingResult granuleLoadingResult = null;
                Object var37_17 = null;
                try {
                    if (inStream != null) {
                        inStream.close();
                    }
                    Object var39_28 = null;
                    if (reader == null) return granuleLoadingResult;
                    reader.dispose();
                    return granuleLoadingResult;
                }
                catch (Throwable throwable) {
                    Object var39_29 = null;
                    if (reader == null) throw throwable;
                    reader.dispose();
                    throw throwable;
                }
            }
            if (this.cachedSPI == null) {
                reader = ImageMosaicUtils.getReader(inStream);
                if (reader != null) {
                    this.cachedSPI = reader.getOriginatingProvider();
                }
            } else {
                reader = this.cachedSPI.createReaderInstance();
            }
            if (reader == null) {
                if (LOGGER.isLoggable(java.util.logging.Level.WARNING)) {
                    LOGGER.warning("Unable to get reader for granule " + this.toString() + " with request " + request.toString());
                }
                RasterLayerResponse.GranuleLoadingResult granuleLoadingResult = null;
                Object var37_18 = null;
                try {}
                catch (Throwable throwable) {
                    Object var39_31 = null;
                    if (reader == null) throw throwable;
                    reader.dispose();
                    throw throwable;
                }
                if (inStream != null) {
                    inStream.close();
                }
                Object var39_30 = null;
                if (reader == null) return granuleLoadingResult;
                reader.dispose();
                return granuleLoadingResult;
            }
            Level selectedlevel = this.getLevel(imageIndex);
            MathTransform2D cropWorldToGrid = (MathTransform2D)PixelTranslation.translate((MathTransform)ProjectiveTransform.create((AffineTransform)selectedlevel.gridToWorldTransform), (PixelInCell)PixelInCell.CELL_CENTER, (PixelInCell)PixelInCell.CELL_CORNER).inverse();
            Rectangle sourceArea = CRS.transform((MathTransform)cropWorldToGrid, (org.opengis.geometry.Envelope)new GeneralEnvelope((org.opengis.geometry.Envelope)intersection)).toRectangle2D().getBounds();
            XRectangle2D.intersect((Rectangle2D)sourceArea, (Rectangle2D)selectedlevel.rasterDimensions, (Rectangle2D)sourceArea);
            if (sourceArea.isEmpty()) {
                if (LOGGER.isLoggable(java.util.logging.Level.FINE)) {
                    LOGGER.fine("Got empty area for granule " + this.toString() + " with request " + request.toString());
                }
                RasterLayerResponse.GranuleLoadingResult granuleLoadingResult = null;
                Object var37_19 = null;
                try {}
                catch (Throwable throwable) {
                    Object var39_33 = null;
                    if (reader == null) throw throwable;
                    reader.dispose();
                    throw throwable;
                }
                if (inStream != null) {
                    inStream.close();
                }
                Object var39_32 = null;
                if (reader == null) return granuleLoadingResult;
                reader.dispose();
                return granuleLoadingResult;
            }
            if (LOGGER.isLoggable(java.util.logging.Level.FINE)) {
                LOGGER.fine(new StringBuffer("Loading level ").append(imageIndex).append(" with source region ").append(sourceArea).toString());
            }
            int newSubSamplingFactor = 0;
            String pluginName = this.cachedSPI.getPluginClassName();
            if (pluginName != null && pluginName.equals(DIRECT_KAKADU_PLUGIN) && (newSubSamplingFactor = Utilities.getSubSamplingFactor2((int)(ssx = readParameters.getSourceXSubsampling()), (int)(ssy = readParameters.getSourceYSubsampling()))) != 0) {
                readParameters.setSourceSubsampling(newSubSamplingFactor, newSubSamplingFactor, 0, 0);
            }
            readParameters.setSourceRegion(sourceArea);
            try {
                raster = request.getReadType().read(readParameters, imageIndex, this.granuleUrl, selectedlevel.rasterDimensions, tileDimension, this.cachedSPI);
            }
            catch (Throwable e) {
                if (LOGGER.isLoggable(java.util.logging.Level.FINE)) {
                    LOGGER.log(java.util.logging.Level.FINE, "Unable to load raster for granule " + this.toString() + " with request " + request.toString(), e);
                }
                RasterLayerResponse.GranuleLoadingResult granuleLoadingResult = null;
                Object var37_20 = null;
                try {}
                catch (Throwable throwable) {
                    Object var39_35 = null;
                    if (reader == null) throw throwable;
                    reader.dispose();
                    throw throwable;
                }
                if (inStream != null) {
                    inStream.close();
                }
                Object var39_34 = null;
                if (reader == null) return granuleLoadingResult;
                reader.dispose();
                return granuleLoadingResult;
            }
            sourceArea.setRect(readParameters.getSourceRegion());
            double decimationScaleX = 1.0 * (double)sourceArea.width / (double)raster.getWidth();
            double decimationScaleY = 1.0 * (double)sourceArea.height / (double)raster.getHeight();
            AffineTransform decimationScaleTranform = XAffineTransform.getScaleInstance((double)decimationScaleX, (double)decimationScaleY);
            AffineTransform afterDecimationTranslateTranform = XAffineTransform.getTranslateInstance((double)sourceArea.x, (double)sourceArea.y);
            AffineTransform2D backToBaseLevelScaleTransform = selectedlevel.baseToLevelTransform;
            AffineTransform finalRaster2Model = new AffineTransform(this.baseGridToWorld);
            finalRaster2Model.concatenate(ImageMosaicUtils.CENTER_TO_CORNER);
            double x = finalRaster2Model.getTranslateX();
            double y = finalRaster2Model.getTranslateY();
            if (!XAffineTransform.isIdentity((AffineTransform)backToBaseLevelScaleTransform, (double)1.0E-5)) {
                finalRaster2Model.concatenate((AffineTransform)backToBaseLevelScaleTransform);
            }
            if (!XAffineTransform.isIdentity((AffineTransform)afterDecimationTranslateTranform, (double)1.0E-5)) {
                finalRaster2Model.concatenate(afterDecimationTranslateTranform);
            }
            if (!XAffineTransform.isIdentity((AffineTransform)decimationScaleTranform, (double)1.0E-5)) {
                finalRaster2Model.concatenate(decimationScaleTranform);
            }
            finalRaster2Model.preConcatenate((AffineTransform)mosaicWorldToGrid);
            InterpolationNearest nearest = new InterpolationNearest();
            Rectangle2D finalLayout = Granule.layoutHelper(raster, (float)finalRaster2Model.getScaleX(), (float)finalRaster2Model.getScaleY(), (float)finalRaster2Model.getTranslateX(), (float)finalRaster2Model.getTranslateY(), (Interpolation)nearest);
            if (finalLayout.isEmpty()) {
                if (LOGGER.isLoggable(java.util.logging.Level.FINE)) {
                    LOGGER.fine("Unable to create a granule " + this.toString() + " due to jai scale bug");
                }
                RasterLayerResponse.GranuleLoadingResult granuleLoadingResult = null;
                Object var37_21 = null;
                try {}
                catch (Throwable throwable) {
                    Object var39_37 = null;
                    if (reader == null) throw throwable;
                    reader.dispose();
                    throw throwable;
                }
                if (inStream != null) {
                    inStream.close();
                }
                Object var39_36 = null;
                if (reader == null) return granuleLoadingResult;
                reader.dispose();
                return granuleLoadingResult;
            }
            ROIShape granuleLoadingShape = null;
            if (this.granuleROIShape != null) {
                Point2D translate = mosaicWorldToGrid.transform((Point2D)new DirectPosition2D(x, y), (Point2D)null);
                tx2 = new AffineTransform();
                ((AffineTransform)tx2).preConcatenate(AffineTransform.getScaleInstance(((AffineTransform)mosaicWorldToGrid).getScaleX(), -((AffineTransform)mosaicWorldToGrid).getScaleY()));
                ((AffineTransform)tx2).preConcatenate(AffineTransform.getScaleInstance(this.baseGridToWorld.getScaleX(), -this.baseGridToWorld.getScaleY()));
                ((AffineTransform)tx2).preConcatenate(AffineTransform.getTranslateInstance(translate.getX(), translate.getY()));
                Shape sp = this.granuleROIShape.getAsShape();
                Area area = new Area(sp);
                area.transform((AffineTransform)tx2);
                granuleLoadingShape = new ROIShape(area);
            }
            RenderingHints localHints = new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE);
            if (XAffineTransform.isIdentity((AffineTransform)finalRaster2Model, (double)1.0E-5)) {
                tx2 = new RasterLayerResponse.GranuleLoadingResult(raster, granuleLoadingShape);
                Object var37_22 = null;
                try {}
                catch (Throwable throwable) {
                    Object var39_39 = null;
                    if (reader == null) throw throwable;
                    reader.dispose();
                    throw throwable;
                }
                if (inStream != null) {
                    inStream.close();
                }
                Object var39_38 = null;
                if (reader == null) return tx2;
                reader.dispose();
                return tx2;
            }
            Dimension tileDimensions = request.getTileDimensions();
            if (tileDimensions != null && request.getReadType().equals((Object)ReadType.DIRECT_READ)) {
                ImageLayout layout = new ImageLayout();
                layout.setTileHeight(tileDimensions.width).setTileWidth(tileDimensions.height);
                localHints.add(new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout));
            }
            RasterLayerResponse.GranuleLoadingResult granuleLoadingResult = new RasterLayerResponse.GranuleLoadingResult((RenderedImage)AffineDescriptor.create((RenderedImage)raster, (AffineTransform)finalRaster2Model, (Interpolation)nearest, (double[])request.getBackgroundValues(), (RenderingHints)localHints), granuleLoadingShape);
            Object var37_23 = null;
            try {}
            catch (Throwable throwable) {
                Object var39_41 = null;
                if (reader == null) throw throwable;
                reader.dispose();
                throw throwable;
            }
            if (inStream != null) {
                inStream.close();
            }
            Object var39_40 = null;
            if (reader == null) return granuleLoadingResult;
            reader.dispose();
            return granuleLoadingResult;
            catch (IllegalStateException e) {
                if (LOGGER.isLoggable(java.util.logging.Level.WARNING)) {
                    LOGGER.log(java.util.logging.Level.WARNING, "Unable to load raster for granule " + this.toString() + " with request " + request.toString(), e);
                }
                RasterLayerResponse.GranuleLoadingResult granuleLoadingResult2 = null;
                Object var37_24 = null;
                try {}
                catch (Throwable throwable) {
                    Object var39_43 = null;
                    if (reader == null) throw throwable;
                    reader.dispose();
                    throw throwable;
                }
                if (inStream != null) {
                    inStream.close();
                }
                Object var39_42 = null;
                if (reader == null) return granuleLoadingResult2;
                reader.dispose();
                return granuleLoadingResult2;
            }
            catch (NoninvertibleTransformException e) {
                if (LOGGER.isLoggable(java.util.logging.Level.WARNING)) {
                    LOGGER.log(java.util.logging.Level.WARNING, "Unable to load raster for granule " + this.toString() + " with request " + request.toString(), e);
                }
                RasterLayerResponse.GranuleLoadingResult granuleLoadingResult3 = null;
                Object var37_25 = null;
                try {}
                catch (Throwable throwable) {
                    Object var39_45 = null;
                    if (reader == null) throw throwable;
                    reader.dispose();
                    throw throwable;
                }
                if (inStream != null) {
                    inStream.close();
                }
                Object var39_44 = null;
                if (reader == null) return granuleLoadingResult3;
                reader.dispose();
                return granuleLoadingResult3;
            }
            catch (TransformException e) {
                if (LOGGER.isLoggable(java.util.logging.Level.WARNING)) {
                    LOGGER.log(java.util.logging.Level.WARNING, "Unable to load raster for granule " + this.toString() + " with request " + request.toString(), e);
                }
                RasterLayerResponse.GranuleLoadingResult granuleLoadingResult4 = null;
                Object var37_26 = null;
                try {}
                catch (Throwable throwable) {
                    Object var39_47 = null;
                    if (reader == null) throw throwable;
                    reader.dispose();
                    throw throwable;
                }
                if (inStream != null) {
                    inStream.close();
                }
                Object var39_46 = null;
                if (reader == null) return granuleLoadingResult4;
                reader.dispose();
                return granuleLoadingResult4;
            }
        }
        catch (Throwable throwable) {
            Object var37_27 = null;
            try {}
            catch (Throwable throwable2) {
                Object var39_49 = null;
                if (reader == null) throw throwable2;
                reader.dispose();
                throw throwable2;
            }
            if (inStream != null) {
                inStream.close();
            }
            Object var39_48 = null;
            if (reader == null) throw throwable;
            reader.dispose();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Level getLevel(int index) {
        Map<Integer, Level> map = this.granuleLevels;
        synchronized (map) {
            if (this.granuleLevels.containsKey(index)) {
                return this.granuleLevels.get(index);
            }
            ImageInputStream inStream = null;
            ImageReader reader = null;
            try {
                try {
                    inStream = ImageMosaicUtils.getInputStream(this.granuleUrl);
                    if (inStream == null) {
                        throw new IllegalArgumentException();
                    }
                    if (this.cachedSPI == null) {
                        reader = ImageMosaicUtils.getReader(inStream);
                        if (reader != null) {
                            this.cachedSPI = reader.getOriginatingProvider();
                        }
                    } else {
                        reader = this.cachedSPI.createReaderInstance();
                    }
                    if (reader == null) {
                        throw new IllegalArgumentException("Unable to get an ImageReader for the provided file " + this.granuleUrl.toString());
                    }
                    Rectangle levelDimension = ImageMosaicUtils.getDimension(index, inStream, reader);
                    Level baseLevel = this.granuleLevels.get(0);
                    double scaleX = (double)baseLevel.width / (1.0 * (double)levelDimension.width);
                    double scaleY = (double)baseLevel.height / (1.0 * (double)levelDimension.height);
                    Level newLevel = new Level(scaleX, scaleY, levelDimension.width, levelDimension.height);
                    this.granuleLevels.put(index, newLevel);
                    Level level = newLevel;
                    Object var14_13 = null;
                    try {
                        block20: {
                            try {
                                if (inStream == null) break block20;
                                inStream.close();
                            }
                            catch (Throwable e) {
                                throw new IllegalArgumentException(e);
                            }
                        }
                        Object var17_15 = null;
                        if (reader == null) return level;
                        reader.dispose();
                    }
                    catch (Throwable throwable) {
                        Object var17_16 = null;
                        if (reader == null) throw throwable;
                        reader.dispose();
                        throw throwable;
                    }
                    return level;
                }
                catch (IllegalStateException e) {
                    throw new IllegalArgumentException(e);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            catch (Throwable throwable) {
                Object var14_14 = null;
                try {}
                catch (Throwable throwable2) {
                    Object var17_18 = null;
                    if (reader == null) throw throwable2;
                    reader.dispose();
                    throw throwable2;
                }
                try {}
                catch (Throwable e) {
                    throw new IllegalArgumentException(e);
                }
                if (inStream != null) {
                    inStream.close();
                }
                Object var17_17 = null;
                if (reader == null) throw throwable;
                reader.dispose();
                throw throwable;
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Description of a granule ").append("\n");
        sb.append("BBOX:\t\t").append(this.granuleBBOX.toString());
        sb.append("file:\t\t").append(this.granuleUrl);
        sb.append("gridToWorld:\t\t").append(this.baseGridToWorld);
        int i = 1;
        for (Level level : this.granuleLevels.values()) {
            int n = ++i;
            ++i;
            sb.append("Description of level ").append(n).append("\n");
            sb.append(level.toString()).append("\n");
        }
        return sb.toString();
    }

    class Level {
        final double scaleX;
        final double scaleY;
        final int width;
        final int height;
        final AffineTransform2D baseToLevelTransform;
        final AffineTransform2D gridToWorldTransform;
        final Rectangle rasterDimensions;

        public AffineTransform getBaseToLevelTransform() {
            return this.baseToLevelTransform;
        }

        public double getScaleX() {
            return this.scaleX;
        }

        public double getScaleY() {
            return this.scaleY;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public Level(double scaleX, double scaleY, int width, int height) {
            this.scaleX = scaleX;
            this.scaleY = scaleY;
            this.baseToLevelTransform = new AffineTransform2D(XAffineTransform.getScaleInstance((double)scaleX, (double)scaleY, (double)0.0, (double)0.0));
            AffineTransform gridToWorldTransform_ = new AffineTransform((AffineTransform)this.baseToLevelTransform);
            gridToWorldTransform_.preConcatenate(ImageMosaicUtils.CENTER_TO_CORNER);
            gridToWorldTransform_.preConcatenate(Granule.this.baseGridToWorld);
            this.gridToWorldTransform = new AffineTransform2D(gridToWorldTransform_);
            this.width = width;
            this.height = height;
            this.rasterDimensions = new Rectangle(0, 0, width, height);
        }

        public Rectangle getBounds() {
            return (Rectangle)this.rasterDimensions.clone();
        }

        public AffineTransform2D getGridToWorldTransform() {
            return this.gridToWorldTransform;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Description of a granule level").append("\n");
            buffer.append("width:\t\t").append(this.width).append("\n");
            buffer.append("height:\t\t").append(this.height).append("\n");
            buffer.append("scaleX:\t\t").append(this.scaleX).append("\n");
            buffer.append("scaleY:\t\t").append(this.scaleY).append("\n");
            buffer.append("baseToLevelTransform:\t\t").append(this.baseToLevelTransform.toString()).append("\n");
            buffer.append("gridToWorldTransform:\t\t").append(this.gridToWorldTransform.toString()).append("\n");
            return super.toString();
        }
    }
}

