/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.imageio.GeoToolsWriteParams;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.DataUtilities;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.factory.Hints;
import org.geotools.gce.imagemosaic.ImageMosaicDescriptor;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.gce.imagemosaic.MosaicConfigurationBean;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalog;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.ParameterGroup;
import org.geotools.util.Converters;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverageWriter;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;

public final class ImageMosaicFormat
extends AbstractGridFormat
implements Format {
    static final double DEFAULT_ARTIFACTS_FILTER_PTILE_THRESHOLD = 0.1;
    private static final Logger LOGGER = Logging.getLogger((String)ImageMosaicFormat.class.toString());
    static final Interpolation DEFAULT_INTERPOLATION = new InterpolationNearest();
    public static final ParameterDescriptor<List> TIME = DefaultParameterDescriptor.create((String)"TIME", (CharSequence)"A list of time objects", List.class, null, (boolean)false);
    public static final ParameterDescriptor<Filter> FILTER = new DefaultParameterDescriptor("Filter", Filter.class, null, null);
    public static final ParameterDescriptor<Boolean> FADING = new DefaultParameterDescriptor("Fading", Boolean.class, (Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE}, (Object)Boolean.FALSE);
    public static final ParameterDescriptor<Color> OUTPUT_TRANSPARENT_COLOR = new DefaultParameterDescriptor("OutputTransparentColor", Color.class, null, null);
    public static final ParameterDescriptor<Integer> MAX_ALLOWED_TILES = new DefaultParameterDescriptor("MaxAllowedTiles", Integer.class, null, (Object)Integer.MAX_VALUE);
    public static final ParameterDescriptor<Integer> DEFAULT_ARTIFACTS_FILTER_THRESHOLD = new DefaultParameterDescriptor("DefaultArtifactsFilterThreshold", Integer.class, null, (Object)Integer.MIN_VALUE);
    public static final ParameterDescriptor<Double> ARTIFACTS_FILTER_PTILE_THRESHOLD = new DefaultParameterDescriptor("ArtifactsFilterPtileThreshold", Double.class, null, (Object)0.1);
    public static final ParameterDescriptor<Boolean> ALLOW_MULTITHREADING = new DefaultParameterDescriptor("AllowMultithreading", Boolean.class, (Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE}, (Object)Boolean.FALSE);
    public static final ParameterDescriptor<Boolean> HANDLE_FOOTPRINT = new DefaultParameterDescriptor("HandleFootprint", Boolean.class, (Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE}, (Object)Boolean.TRUE);
    public static final ParameterDescriptor<Boolean> SET_ROI_PROPERTY = new DefaultParameterDescriptor("SetRoiProperty", Boolean.class, (Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE}, (Object)Boolean.FALSE);
    public static final ParameterDescriptor<double[]> BACKGROUND_VALUES = new DefaultParameterDescriptor("BackgroundValues", double[].class, null, null);
    public static final ParameterDescriptor<Interpolation> INTERPOLATION = new DefaultParameterDescriptor("Interpolation", Interpolation.class, null, (Object)DEFAULT_INTERPOLATION);
    public static final ParameterDescriptor<List> ELEVATION = DefaultParameterDescriptor.create((String)"ELEVATION", (CharSequence)"An elevation value", List.class, null, (boolean)false);

    public ImageMosaicFormat() {
        this.setInfo();
    }

    private void setInfo() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("name", "ImageMosaic");
        info.put("description", "Image mosaicking plugin");
        info.put("vendor", "Geotools");
        info.put("docURL", "");
        info.put("version", "1.0");
        this.mInfo = info;
        this.readParameters = new ParameterGroup((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(this.mInfo, new GeneralParameterDescriptor[]{READ_GRIDGEOMETRY2D, INPUT_TRANSPARENT_COLOR, OUTPUT_TRANSPARENT_COLOR, USE_JAI_IMAGEREAD, BACKGROUND_VALUES, SUGGESTED_TILE_SIZE, ALLOW_MULTITHREADING, MAX_ALLOWED_TILES, TIME, ELEVATION, FILTER}));
        this.writeParameters = null;
    }

    public ImageMosaicReader getReader(Object source) {
        return this.getReader(source, null);
    }

    public GridCoverageWriter getWriter(Object destination) {
        throw new UnsupportedOperationException("This plugin does not support writing.");
    }

    public boolean accepts(Object source, Hints hints) {
        Utilities.ensureNonNull((String)"source", (Object)source);
        if (source instanceof ImageMosaicDescriptor) {
            return this.checkDescriptor((ImageMosaicDescriptor)source);
        }
        return this.checkForUrl(source, hints);
    }

    public boolean accepts(Object source) {
        return this.accepts(source, null);
    }

    private boolean checkDescriptor(ImageMosaicDescriptor source) {
        GranuleCatalog catalog = source.getCatalog();
        MosaicConfigurationBean configuration = source.getConfiguration();
        if (configuration == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Mosaic configuration is missing");
            }
            return false;
        }
        if (configuration.getLevels() == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("resolution leves is unavailable ");
            }
            return false;
        }
        if (catalog == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Granule Catalog is unavailable ");
            }
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkForUrl(Object source, Hints hints) {
        try {
            sourceURL = Utils.checkSource(source, hints);
            if (sourceURL == null) {
                return false;
            }
            if (source instanceof File && !(file = (File)source).exists()) {
                return false;
            }
            tileIndexStore = null;
            crs = null;
            shapefile = true;
            try {
                block60: {
                    block59: {
                        sourceF = DataUtilities.urlToFile((URL)sourceURL);
                        if (!FilenameUtils.getName((String)sourceF.getAbsolutePath()).equalsIgnoreCase("datastore.properties")) break block59;
                        shapefile = false;
                        properties = new Properties();
                        stream = new FileInputStream(sourceF);
                        try {
                            properties.load(stream);
                        }
                        finally {
                            IOUtils.closeQuietly((InputStream)stream);
                        }
                        SPIClass = properties.getProperty("SPI");
                        spi = (DataStoreFactorySpi)Class.forName(SPIClass).newInstance();
                        params = new HashMap<String, Serializable>();
                        var17_16 = paramsInfo = spi.getParametersInfo();
                        var16_18 = paramsInfo.length;
                        var15_19 = 0;
                        if (true) ** GOTO lbl48
                    }
                    testPropertiesUrl = DataUtilities.changeUrlExt((URL)sourceURL, (String)"properties");
                    testFile = DataUtilities.urlToFile((URL)testPropertiesUrl);
                    if (!testFile.exists()) {
                        return false;
                    }
                    tileIndexStore = new ShapefileDataStore(sourceURL);
                    break block60;
                    do {
                        p = var17_16[var15_19];
                        if (properties.containsKey(p.key)) {
                            params.put(p.key, (Serializable)Converters.convert((Object)properties.getProperty(p.key), (Class)p.type));
                        } else if (p.required && p.sample == null) {
                            if (ImageMosaicFormat.LOGGER.isLoggable(Level.FINE) == false) return false;
                            ImageMosaicFormat.LOGGER.fine("Required parameter missing: " + p.toString());
                            return false;
                        }
                        ++var15_19;
lbl48:
                        // 2 sources

                    } while (var15_19 < var16_18);
                    tileIndexStore = spi.createDataStore(params);
                    if (tileIndexStore == null) {
                        return false;
                    }
                }
                if ((typeNames = tileIndexStore.getTypeNames()).length <= 0) {
                    return false;
                }
                typeName = typeNames[0];
                if (typeName == null) {
                    return false;
                }
                featureSource = tileIndexStore.getFeatureSource(typeName);
                if (featureSource == null) {
                    return false;
                }
                schema = (SimpleFeatureType)featureSource.getSchema();
                if (schema == null) {
                    return false;
                }
                crs = ((SimpleFeatureType)featureSource.getSchema()).getGeometryDescriptor().getCoordinateReferenceSystem();
                if (crs == null) {
                    return false;
                }
                propsUrl = null;
                if (shapefile) {
                    propsUrl = DataUtilities.changeUrlExt((URL)sourceURL, (String)"properties");
                } else {
                    parent = DataUtilities.urlToFile((URL)sourceURL).getParentFile();
                    var18_33 = properties = parent.listFiles((FilenameFilter)FileFilterUtils.andFileFilter((IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.nameFileFilter((String)"indexer.properties")), (IOFileFilter)FileFilterUtils.andFileFilter((IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.nameFileFilter((String)"datastore.properties")), (IOFileFilter)FileFilterUtils.makeFileOnly((IOFileFilter)FileFilterUtils.suffixFileFilter((String)".properties")))));
                    var17_17 = properties.length;
                    var16_18 = 0;
                    while (var16_18 < var17_17) {
                        propFile = var18_33[var16_18];
                        if (Utils.checkFileReadable(propFile) && Utils.loadMosaicProperties(DataUtilities.fileToURL((File)propFile), "") != null) {
                            propsUrl = DataUtilities.fileToURL((File)propFile);
                            break;
                        }
                        ++var16_18;
                    }
                }
                props = Utils.loadMosaicProperties(propsUrl, "location");
                if (props == null) {
                    return false;
                }
                locationAttributeName = props.getLocationAttribute();
                if (schema.getDescriptor(locationAttributeName) != null) return true;
                return false;
            }
            finally {
                block58: {
                    try {
                        if (tileIndexStore != null) {
                            tileIndexStore.dispose();
                        }
                    }
                    catch (Throwable e) {
                        if (!ImageMosaicFormat.LOGGER.isLoggable(Level.FINE)) break block58;
                        ImageMosaicFormat.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                    }
                }
            }
        }
        catch (Throwable e) {
            if (ImageMosaicFormat.LOGGER.isLoggable(Level.FINE) == false) return false;
            ImageMosaicFormat.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            return false;
        }
    }

    public ImageMosaicReader getReader(Object source, Hints hints) {
        try {
            ImageMosaicReader reader = new ImageMosaicReader(source, hints);
            return reader;
        }
        catch (MalformedURLException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            return null;
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            return null;
        }
    }

    public GeoToolsWriteParams getDefaultImageIOWriteParameters() {
        throw new UnsupportedOperationException("Unsupported method.");
    }

    public GridCoverageWriter getWriter(Object destination, Hints hints) {
        throw new UnsupportedOperationException("This plugin does not support writing.");
    }
}

