/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.util.ArrayList;
import java.util.Collections;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.util.Utilities;

final class OverviewsController {
    final ArrayList<OverviewLevel> resolutionsLevels = new ArrayList();

    public OverviewsController(double[] highestRes, int numberOfOvervies, double[][] overviewsResolution) {
        this.resolutionsLevels.add(new OverviewLevel(1.0, highestRes[0], highestRes[1], 0));
        if (numberOfOvervies > 0) {
            int i = 0;
            while (i < overviewsResolution.length) {
                this.resolutionsLevels.add(new OverviewLevel(overviewsResolution[i][0] / highestRes[0], overviewsResolution[i][0], overviewsResolution[i][1], i + 1));
                ++i;
            }
            Collections.sort(this.resolutionsLevels);
        }
    }

    int pickOverviewLevel(OverviewPolicy policy, double[] requestedResolution) {
        double requestedScaleFactor;
        if (this.resolutionsLevels == null || this.resolutionsLevels.size() <= 0) {
            return 0;
        }
        OverviewLevel max = this.resolutionsLevels.get(0);
        if (requestedResolution == null) {
            return 0;
        }
        double reqx = requestedResolution[0];
        double reqy = requestedResolution[1];
        double requestedScaleFactorX = reqx / max.resolutionX;
        double requestedScaleFactorY = reqy / max.resolutionY;
        boolean leastReduceAxis = !(requestedScaleFactorX <= requestedScaleFactorY);
        double d = requestedScaleFactor = !leastReduceAxis ? requestedScaleFactorX : requestedScaleFactorY;
        if (requestedScaleFactor <= 1.0) {
            return max.imageChoice;
        }
        OverviewLevel min = this.resolutionsLevels.get(this.resolutionsLevels.size() - 1);
        if (requestedScaleFactor >= min.scaleFactor) {
            return min.imageChoice;
        }
        OverviewLevel prev = max;
        int size = this.resolutionsLevels.size();
        int i = 1;
        while (i < size) {
            OverviewLevel curr = this.resolutionsLevels.get(i);
            if (curr.scaleFactor == requestedScaleFactor) {
                return curr.imageChoice;
            }
            if (curr.scaleFactor > requestedScaleFactor || i == size - 1) {
                if (policy == OverviewPolicy.QUALITY) {
                    return prev.imageChoice;
                }
                if (policy == OverviewPolicy.SPEED) {
                    return curr.imageChoice;
                }
                if (requestedScaleFactor - prev.scaleFactor < curr.scaleFactor - requestedScaleFactor) {
                    return prev.imageChoice;
                }
                return curr.imageChoice;
            }
            prev = curr;
            ++i;
        }
        return max.imageChoice;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class OverviewLevel
    implements Comparable<OverviewLevel> {
        double scaleFactor;
        double resolutionX;
        double resolutionY;
        int imageChoice;

        public OverviewLevel(double scaleFactor, double resolutionX, double resolutionY, int imageChoice) {
            this.scaleFactor = scaleFactor;
            this.resolutionX = resolutionX;
            this.resolutionY = resolutionY;
            this.imageChoice = imageChoice;
        }

        @Override
        public int compareTo(OverviewLevel other) {
            if (this.scaleFactor > other.scaleFactor) {
                return 1;
            }
            if (this.scaleFactor < other.scaleFactor) {
                return -1;
            }
            return 0;
        }

        public String toString() {
            return "OverviewLevel[Choice=" + this.imageChoice + ",scaleFactor=" + this.scaleFactor + ",resX:" + this.resolutionX + ",resY:" + this.resolutionY + "]";
        }

        public int hashCode() {
            int hash = Utilities.hash((int)this.imageChoice, (int)31);
            hash = Utilities.hash((double)this.resolutionX, (int)hash);
            hash = Utilities.hash((double)this.resolutionY, (int)hash);
            hash = Utilities.hash((double)this.scaleFactor, (int)hash);
            return hash;
        }
    }
}

