/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataUtilities;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PathType {
    RELATIVE{

        URL resolvePath(String parentLocation, String location) {
            URL rasterURL;
            block5: {
                Utilities.ensureNonNull((String)"parentLocation", (Object)parentLocation);
                Utilities.ensureNonNull((String)"location", (Object)location);
                if (LOGGER.isLoggable(Level.FINE)) {
                    StringBuilder builder = new StringBuilder();
                    builder.append("Trying to resolve path:").append("\n");
                    builder.append("type:").append(this.toString()).append("\n");
                    builder.append("parentLocation:").append(parentLocation).append("\n");
                    builder.append("location:").append(location);
                    LOGGER.fine(builder.toString());
                }
                try {
                    rasterURL = DataUtilities.extendURL((URL)new URL(parentLocation), (String)location);
                    if (Utils.checkURLReadable(rasterURL)) break block5;
                    if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.info("Unable to read image for file " + rasterURL);
                    }
                    return null;
                }
                catch (MalformedURLException e) {
                    return null;
                }
            }
            return rasterURL;
        }
    }
    ,
    ABSOLUTE{

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        URL resolvePath(String parentLocation, String location) {
            URL rasterURL;
            block5: {
                Utilities.ensureNonNull((String)"location", (Object)location);
                if (LOGGER.isLoggable(Level.FINE)) {
                    StringBuilder builder = new StringBuilder();
                    builder.append("Trying to resolve path:").append("\n");
                    builder.append("type:").append(this.toString()).append("\n");
                    if (parentLocation != null) {
                        builder.append("parentLocation:").append(parentLocation).append("\n");
                    }
                    LOGGER.fine(builder.toString());
                }
                try {
                    File rasterFile = new File(location);
                    if (Utils.checkFileReadable(rasterFile)) return DataUtilities.fileToURL((File)rasterFile);
                    rasterURL = new URL(location);
                    if (Utils.checkURLReadable(rasterURL)) break block5;
                    if (!LOGGER.isLoggable(Level.INFO)) return null;
                    LOGGER.info("Unable to read image for file " + rasterURL);
                    return null;
                }
                catch (MalformedURLException e) {
                    return null;
                }
            }
            return rasterURL;
        }
    };

    private static final Logger LOGGER;

    static {
        LOGGER = Logging.getLogger(PathType.class);
    }

    private PathType() {
    }

    abstract URL resolvePath(String var1, String var2);

    /* synthetic */ PathType(String string, int n, PathType pathType) {
        this();
    }
}

