/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import jaitools.imageutils.ROIGeometry;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReadParam;
import javax.measure.unit.Unit;
import javax.media.jai.BorderExtender;
import javax.media.jai.Histogram;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.RenderedOp;
import javax.media.jai.TileCache;
import javax.media.jai.TileScheduler;
import javax.media.jai.operator.AffineDescriptor;
import javax.media.jai.operator.ConstantDescriptor;
import javax.media.jai.operator.CropDescriptor;
import javax.media.jai.operator.MosaicDescriptor;
import javax.media.jai.operator.MosaicType;
import javax.media.jai.util.ImagingException;
import org.apache.commons.io.FilenameUtils;
import org.geotools.coverage.Category;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.TypeMap;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.Query;
import org.geotools.factory.Hints;
import org.geotools.feature.visitor.MaxVisitor;
import org.geotools.filter.IllegalFilterException;
import org.geotools.gce.imagemosaic.GranuleDescriptor;
import org.geotools.gce.imagemosaic.GranuleLoader;
import org.geotools.gce.imagemosaic.OverviewsController;
import org.geotools.gce.imagemosaic.RasterLayerRequest;
import org.geotools.gce.imagemosaic.RasterManager;
import org.geotools.gce.imagemosaic.ReadParamsController;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalogVisitor;
import org.geotools.gce.imagemosaic.processing.ArtifactsFilterDescriptor;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.ImageWorker;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.resources.coverage.CoverageUtilities;
import org.geotools.resources.coverage.FeatureUtilities;
import org.geotools.resources.geometry.XRectangle2D;
import org.geotools.resources.i18n.Vocabulary;
import org.geotools.resources.image.ImageUtilities;
import org.geotools.util.DateRange;
import org.geotools.util.NumberRange;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.ColorInterpretation;
import org.opengis.coverage.SampleDimension;
import org.opengis.coverage.SampleDimensionType;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.BBOX;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.CodeList;
import org.opengis.util.InternationalString;

class RasterLayerResponse {
    private static final Logger LOGGER = Logging.getLogger(RasterLayerResponse.class);
    private GridCoverage2D gridCoverage;
    private RasterLayerRequest request;
    private GridCoverageFactory coverageFactory;
    private GeneralEnvelope coverageEnvelope;
    private boolean frozen = false;
    private RasterManager rasterManager;
    private Color finalTransparentColor;
    private ReferencedEnvelope mosaicBBox;
    private Rectangle rasterBounds;
    private MathTransform2D finalGridToWorldCorner;
    private MathTransform2D finalWorldToGridCorner;
    private int imageChoice = 0;
    private ImageReadParam baseReadParameters = new ImageReadParam();
    private boolean multithreadingAllowed = false;
    private boolean footprintManagement = Utils.IGNORE_FOOTPRINT == false;
    private int defaultArtifactsFilterThreshold = Integer.MIN_VALUE;
    private double artifactsFilterPTileThreshold = 0.1;
    private boolean setRoiProperty;
    private boolean alphaIn = false;
    private boolean oversampledRequest = false;
    private MathTransform baseGridToWorld;
    private Interpolation interpolation;
    private boolean needsReprojection;
    private double[] backgroundValues;
    private Hints hints;

    public RasterLayerResponse(RasterLayerRequest request, RasterManager rasterManager) {
        this.request = request;
        this.coverageEnvelope = rasterManager.spatialDomainManager.coverageEnvelope;
        this.coverageFactory = rasterManager.getCoverageFactory();
        this.rasterManager = rasterManager;
        this.hints = rasterManager.getHints();
        this.baseGridToWorld = rasterManager.spatialDomainManager.coverageGridToWorld2D;
        this.finalTransparentColor = request.getOutputTransparentColor();
        this.multithreadingAllowed = request.isMultithreadingAllowed();
        this.footprintManagement = request.isFootprintManagement();
        this.setRoiProperty = request.isSetRoiProperty();
        this.backgroundValues = request.getBackgroundValues();
        this.interpolation = request.getInterpolation();
        this.needsReprojection = request.isNeedsReprojection();
        this.defaultArtifactsFilterThreshold = request.getDefaultArtifactsFilterThreshold();
        this.artifactsFilterPTileThreshold = request.getArtifactsFilterPTileThreshold();
    }

    public GridCoverage2D createResponse() throws IOException {
        this.processRequest();
        return this.gridCoverage;
    }

    public RasterLayerRequest getOriginatingCoverageRequest() {
        return this.request;
    }

    private void processRequest() throws IOException {
        if (this.request.isEmpty()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Request is empty: " + this.request.toString());
            }
            this.gridCoverage = null;
            return;
        }
        if (this.frozen) {
            return;
        }
        RenderedImage mosaic = this.prepareResponse();
        RenderedImage finalRaster = this.postProcessRaster(mosaic);
        this.gridCoverage = this.prepareCoverage(finalRaster);
        this.frozen = true;
    }

    private RenderedImage postProcessRaster(RenderedImage mosaic) {
        block7: {
            if (this.finalTransparentColor != null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Support for alpha on final mosaic");
                }
                return ImageUtilities.maskColor((Color)this.finalTransparentColor, (RenderedImage)mosaic);
            }
            if (!this.needsReprojection) {
                try {
                    Object extender;
                    AffineTransform sourceGridToWorld = new AffineTransform((AffineTransform)this.finalGridToWorldCorner);
                    AffineTransform targetGridToWorld = new AffineTransform(this.request.getRequestedGridToWorld());
                    targetGridToWorld.concatenate(CoverageUtilities.CENTER_TO_CORNER);
                    AffineTransform targetWorldToGrid = targetGridToWorld.createInverse();
                    targetWorldToGrid.concatenate(sourceGridToWorld);
                    this.finalGridToWorldCorner = new AffineTransform2D(targetGridToWorld);
                    if (XAffineTransform.isIdentity((AffineTransform)targetWorldToGrid, (double)1.0E-6)) {
                        return mosaic;
                    }
                    Hints localHints = new Hints((RenderingHints)this.hints);
                    if (!(this.hints == null || this.hints.containsKey((Object)JAI.KEY_BORDER_EXTENDER) || (extender = this.hints.get((Object)JAI.KEY_BORDER_EXTENDER)) != null && extender instanceof BorderExtender)) {
                        localHints.add(ImageUtilities.EXTEND_BORDER_BY_COPYING);
                    }
                    mosaic = AffineDescriptor.create((RenderedImage)mosaic, (AffineTransform)targetWorldToGrid, (Interpolation)this.interpolation, (double[])this.backgroundValues, (RenderingHints)localHints);
                }
                catch (NoninvertibleTransformException e) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block7;
                    LOGGER.log(Level.SEVERE, "Unable to create the requested mosaic ", e);
                }
            }
        }
        return mosaic;
    }

    private RenderedImage prepareResponse() throws DataSourceException {
        try {
            BoundingBox cropBBOX;
            this.imageChoice = this.request.getRequestedBBox() != null && this.request.getRequestedRasterArea() != null && !this.request.isHeterogeneousGranules() ? ReadParamsController.setReadParams(this.request.getRequestedResolution(), this.request.getOverviewPolicy(), this.request.getDecimationPolicy(), this.baseReadParameters, this.request.rasterManager, this.request.rasterManager.overviewsController) : 0;
            assert (this.imageChoice >= 0);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(new StringBuffer("Loading level ").append(this.imageChoice).append(" with subsampling factors ").append(this.baseReadParameters.getSourceXSubsampling()).append(" ").append(this.baseReadParameters.getSourceYSubsampling()).toString());
            }
            this.mosaicBBox = (cropBBOX = this.request.getCropBBox()) != null ? ReferencedEnvelope.reference((BoundingBox)cropBBOX) : new ReferencedEnvelope((org.opengis.geometry.Envelope)this.coverageEnvelope);
            OverviewsController.OverviewLevel baseLevel = this.rasterManager.overviewsController.resolutionsLevels.get(0);
            OverviewsController.OverviewLevel selectedLevel = this.rasterManager.overviewsController.resolutionsLevels.get(this.imageChoice);
            double resX = baseLevel.resolutionX;
            double resY = baseLevel.resolutionY;
            double[] requestRes = this.request.getRequestedResolution();
            AffineTransform g2w = new AffineTransform((AffineTransform)this.baseGridToWorld);
            g2w.concatenate(CoverageUtilities.CENTER_TO_CORNER);
            if (requestRes[0] < resX || requestRes[1] < resY) {
                this.oversampledRequest = true;
            } else {
                g2w.concatenate(AffineTransform.getScaleInstance(selectedLevel.scaleFactor, selectedLevel.scaleFactor));
                g2w.concatenate(AffineTransform.getScaleInstance(this.baseReadParameters.getSourceXSubsampling(), this.baseReadParameters.getSourceYSubsampling()));
            }
            this.finalGridToWorldCorner = new AffineTransform2D(g2w);
            this.finalWorldToGridCorner = this.finalGridToWorldCorner.inverse();
            GeneralEnvelope tempRasterBounds = CRS.transform((MathTransform)this.finalWorldToGridCorner, (org.opengis.geometry.Envelope)this.mosaicBBox);
            this.rasterBounds = tempRasterBounds.toRectangle2D().getBounds();
            if (this.rasterBounds.width == 0) {
                ++this.rasterBounds.width;
            }
            if (this.rasterBounds.height == 0) {
                ++this.rasterBounds.height;
            }
            if (this.oversampledRequest) {
                this.rasterBounds.grow(2, 2);
            }
            GeneralEnvelope levelRasterArea_ = CRS.transform((MathTransform)this.finalWorldToGridCorner, (org.opengis.geometry.Envelope)this.rasterManager.spatialDomainManager.coverageBBox);
            GridEnvelope2D levelRasterArea = new GridEnvelope2D(new Envelope2D((org.opengis.geometry.Envelope)levelRasterArea_), PixelInCell.CELL_CORNER);
            XRectangle2D.intersect((Rectangle2D)levelRasterArea, (Rectangle2D)this.rasterBounds, (Rectangle2D)this.rasterBounds);
            MosaicBuilder visitor = new MosaicBuilder();
            visitor.request = this.request;
            List<?> times = this.request.getRequestedTimes();
            List<?> elevations = this.request.getElevation();
            Filter filter = this.request.getFilter();
            boolean hasTime = times != null && times.size() > 0;
            boolean hasElevation = elevations != null && elevations.size() > 0;
            boolean hasFilter = filter != null;
            SimpleFeatureType type = this.rasterManager.granuleCatalog.getType();
            Query query = null;
            if (type != null) {
                query = new Query(this.rasterManager.granuleCatalog.getType().getTypeName());
                BBOX bbox = FeatureUtilities.DEFAULT_FILTER_FACTORY.bbox((Expression)FeatureUtilities.DEFAULT_FILTER_FACTORY.property(this.rasterManager.granuleCatalog.getType().getGeometryDescriptor().getName()), (BoundingBox)this.mosaicBBox);
                query.setFilter((Filter)bbox);
            }
            if (hasTime || hasElevation || hasFilter) {
                NumberRange range;
                if (hasElevation) {
                    ArrayList<Object> elevationF = new ArrayList<Object>();
                    for (Object elevation : elevations) {
                        if (elevation == null) {
                            if (!LOGGER.isLoggable(Level.INFO)) continue;
                            LOGGER.info("Ignoring null elevation for the elevation filter");
                            continue;
                        }
                        if (elevation instanceof Number) {
                            elevationF.add(FeatureUtilities.DEFAULT_FILTER_FACTORY.equal((Expression)FeatureUtilities.DEFAULT_FILTER_FACTORY.property(this.rasterManager.elevationAttribute), (Expression)FeatureUtilities.DEFAULT_FILTER_FACTORY.literal(elevation), true));
                            continue;
                        }
                        range = (NumberRange)elevation;
                        elevationF.add(FeatureUtilities.DEFAULT_FILTER_FACTORY.and((Filter)FeatureUtilities.DEFAULT_FILTER_FACTORY.lessOrEqual((Expression)FeatureUtilities.DEFAULT_FILTER_FACTORY.property(this.rasterManager.elevationAttribute), (Expression)FeatureUtilities.DEFAULT_FILTER_FACTORY.literal(range.getMaximum())), (Filter)FeatureUtilities.DEFAULT_FILTER_FACTORY.greaterOrEqual((Expression)FeatureUtilities.DEFAULT_FILTER_FACTORY.property(this.rasterManager.elevationAttribute), (Expression)FeatureUtilities.DEFAULT_FILTER_FACTORY.literal(range.getMinimum()))));
                    }
                    int elevationSize = elevationF.size();
                    if (elevationSize > 1) {
                        query.setFilter((Filter)FeatureUtilities.DEFAULT_FILTER_FACTORY.and(query.getFilter(), (Filter)FeatureUtilities.DEFAULT_FILTER_FACTORY.or(elevationF)));
                    } else if (elevationSize == 1) {
                        query.setFilter((Filter)FeatureUtilities.DEFAULT_FILTER_FACTORY.and(query.getFilter(), (Filter)elevationF.get(0)));
                    }
                }
                if (hasFilter) {
                    query.setFilter((Filter)FeatureUtilities.DEFAULT_FILTER_FACTORY.and(query.getFilter(), filter));
                }
                if (hasTime) {
                    ArrayList<Object> timeFilter = new ArrayList<Object>();
                    for (Object datetime : times) {
                        if (datetime == null) {
                            if (!LOGGER.isLoggable(Level.INFO)) continue;
                            LOGGER.info("Ignoring null date for the time filter");
                            continue;
                        }
                        if (datetime instanceof Date) {
                            timeFilter.add(FeatureUtilities.DEFAULT_FILTER_FACTORY.equal((Expression)FeatureUtilities.DEFAULT_FILTER_FACTORY.property(this.rasterManager.timeAttribute), (Expression)FeatureUtilities.DEFAULT_FILTER_FACTORY.literal(datetime), true));
                            continue;
                        }
                        range = (DateRange)datetime;
                        timeFilter.add(FeatureUtilities.DEFAULT_FILTER_FACTORY.and((Filter)FeatureUtilities.DEFAULT_FILTER_FACTORY.lessOrEqual((Expression)FeatureUtilities.DEFAULT_FILTER_FACTORY.property(this.rasterManager.timeAttribute), (Expression)FeatureUtilities.DEFAULT_FILTER_FACTORY.literal((Object)range.getMaxValue())), (Filter)FeatureUtilities.DEFAULT_FILTER_FACTORY.greaterOrEqual((Expression)FeatureUtilities.DEFAULT_FILTER_FACTORY.property(this.rasterManager.timeAttribute), (Expression)FeatureUtilities.DEFAULT_FILTER_FACTORY.literal((Object)range.getMinValue()))));
                    }
                    int sizeTime = timeFilter.size();
                    if (sizeTime > 1) {
                        query.setFilter((Filter)FeatureUtilities.DEFAULT_FILTER_FACTORY.and(query.getFilter(), (Filter)FeatureUtilities.DEFAULT_FILTER_FACTORY.or(timeFilter)));
                    } else if (sizeTime == 1) {
                        query.setFilter((Filter)FeatureUtilities.DEFAULT_FILTER_FACTORY.and(query.getFilter(), (Filter)timeFilter.get(0)));
                    }
                }
                this.rasterManager.getGranules(query, (GranuleCatalogVisitor)visitor);
            } else {
                this.rasterManager.getGranules((BoundingBox)this.mosaicBBox, (GranuleCatalogVisitor)visitor);
            }
            visitor.produce();
            RenderedImage returnValue = null;
            if (visitor.granulesNumber >= 1 && (returnValue = this.buildMosaic(visitor)) != null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Loaded bbox " + this.mosaicBBox.toString() + " while crop bbox " + this.request.getCropBBox().toString());
                }
                return returnValue;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Creating constant image for area with no data");
            }
            Number[] values = Utils.getBackgroundValues(this.rasterManager.defaultSM, this.backgroundValues);
            return ConstantDescriptor.create((Float)Float.valueOf(this.rasterBounds.width), (Float)Float.valueOf(this.rasterBounds.height), (Number[])values, (RenderingHints)(this.rasterManager.defaultImageLayout != null ? new RenderingHints(JAI.KEY_IMAGE_LAYOUT, this.rasterManager.defaultImageLayout) : null));
        }
        catch (IOException e) {
            throw new DataSourceException("Unable to create this mosaic", (Throwable)e);
        }
        catch (TransformException e) {
            throw new DataSourceException("Unable to create this mosaic", (Throwable)e);
        }
    }

    private RenderedImage processGranuleRaster(RenderedImage granule, int granuleIndex, int[] alphaIndex, boolean alphaIn, PlanarImage[] alphaChannels, boolean doTransparentColor, Color transparentColor) {
        if (this.rasterManager.expandMe && granule.getColorModel() instanceof IndexColorModel) {
            granule = new ImageWorker(granule).forceComponentColorModel().getRenderedImage();
        }
        if (doTransparentColor) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Support for alpha on input image number " + granuleIndex);
            }
            granule = ImageUtilities.maskColor((Color)transparentColor, (RenderedImage)granule);
            alphaIndex[0] = granule.getColorModel().getNumComponents() - 1;
        }
        if (alphaIn || doTransparentColor) {
            ImageWorker w = new ImageWorker(granule);
            if (granule.getSampleModel() instanceof MultiPixelPackedSampleModel) {
                w.forceComponentColorModel();
            }
            alphaChannels[granuleIndex] = granule.getColorModel() instanceof IndexColorModel ? w.forceComponentColorModel().retainLastBand().getPlanarImage() : w.retainBands(alphaIndex).getPlanarImage();
        }
        return granule;
    }

    private RenderedImage buildMosaic(MosaicBuilder visitor) throws IOException {
        RenderedImage image;
        Rectangle imageBounds;
        ROI roi;
        Rectangle bounds;
        ImageLayout layout = new ImageLayout(this.rasterBounds.x, this.rasterBounds.y, this.rasterBounds.width, this.rasterBounds.height);
        Dimension tileDimensions = this.request.getTileDimensions();
        if (tileDimensions != null) {
            layout.setTileHeight(tileDimensions.width).setTileWidth(tileDimensions.height);
        }
        RenderingHints localHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
        if (this.hints != null && !this.hints.isEmpty()) {
            Object ts;
            Object extender;
            Object tc;
            if (this.hints.containsKey((Object)JAI.KEY_TILE_CACHE) && (tc = this.hints.get((Object)JAI.KEY_TILE_CACHE)) != null && tc instanceof TileCache) {
                localHints.add(new RenderingHints(JAI.KEY_TILE_CACHE, (TileCache)tc));
            }
            boolean addBorderExtender = true;
            if (this.hints != null && this.hints.containsKey((Object)JAI.KEY_BORDER_EXTENDER) && (extender = this.hints.get((Object)JAI.KEY_BORDER_EXTENDER)) != null && extender instanceof BorderExtender) {
                localHints.add(new RenderingHints(JAI.KEY_BORDER_EXTENDER, (BorderExtender)extender));
                addBorderExtender = false;
            }
            if (addBorderExtender) {
                localHints.add(ImageUtilities.BORDER_EXTENDER_HINTS);
            }
            if (this.hints.containsKey((Object)JAI.KEY_TILE_SCHEDULER) && (ts = this.hints.get((Object)JAI.KEY_TILE_SCHEDULER)) != null && ts instanceof TileScheduler) {
                localHints.add(new RenderingHints(JAI.KEY_TILE_SCHEDULER, (TileScheduler)ts));
            }
        }
        if (visitor.granulesNumber == 1 && Utils.OPTIMIZE_CROP && (bounds = this.toRectangle((roi = (ROI)visitor.rois.get(0)).getAsShape())) != null && (imageBounds = PlanarImage.wrapRenderedImage((RenderedImage)(image = visitor.getSourcesAsArray()[0])).getBounds()).equals(bounds)) {
            if (!imageBounds.equals(this.rasterBounds)) {
                XRectangle2D.intersect((Rectangle2D)imageBounds, (Rectangle2D)this.rasterBounds, (Rectangle2D)imageBounds);
                if (imageBounds.isEmpty()) {
                    return null;
                }
                return CropDescriptor.create((RenderedImage)image, (Float)new Float(imageBounds.x), (Float)new Float(imageBounds.y), (Float)new Float(imageBounds.width), (Float)new Float(imageBounds.height), (RenderingHints)localHints);
            }
            return image;
        }
        ROI[] sourceRoi = visitor.sourceRoi;
        RenderedOp mosaic = MosaicDescriptor.create((RenderedImage[])visitor.getSourcesAsArray(), (MosaicType)(this.request.isBlend() ? MosaicDescriptor.MOSAIC_TYPE_BLEND : MosaicDescriptor.MOSAIC_TYPE_OVERLAY), (PlanarImage[])(this.alphaIn || visitor.doInputTransparency ? visitor.alphaChannels : null), (ROI[])sourceRoi, (double[][])visitor.sourceThreshold, (double[])this.backgroundValues, (RenderingHints)localHints);
        if (this.setRoiProperty) {
            RenderedOp rop = mosaic;
            Object globalRoi = null;
            ROI[] rois = sourceRoi;
            int i = 0;
            while (i < rois.length) {
                globalRoi = globalRoi == null ? new ROIGeometry(((ROIGeometry)rois[i]).getAsGeometry()) : globalRoi.add(rois[i]);
                ++i;
            }
            rop.setProperty("ROI", globalRoi);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Mosaic created ");
        }
        return mosaic;
    }

    Rectangle toRectangle(Shape shape) {
        if (shape instanceof Rectangle) {
            return (Rectangle)shape;
        }
        if (shape == null) {
            return null;
        }
        PathIterator iter = shape.getPathIterator(new AffineTransform());
        double[] coords = new double[2];
        if (iter.isDone()) {
            return null;
        }
        iter.next();
        int action = iter.currentSegment(coords);
        if (action != 0 && action != 1) {
            return null;
        }
        double minx = coords[0];
        double miny = coords[1];
        double maxx = minx;
        double maxy = miny;
        double prevx = minx;
        double prevy = miny;
        int i = 0;
        while (i < 4 && !iter.isDone()) {
            iter.next();
            action = iter.currentSegment(coords);
            if (action == 4) break;
            if (action != 1) {
                return null;
            }
            double x = coords[0];
            double y = coords[1];
            if (!(prevx == x && prevy != y || prevx != x && prevy == y)) {
                return null;
            }
            if (x < minx) {
                minx = x;
            } else if (x > maxx) {
                maxx = x;
            }
            if (y < miny) {
                miny = y;
            } else if (y > maxy) {
                maxy = y;
            }
            prevx = x;
            prevy = y;
            ++i;
        }
        iter.next();
        if (!iter.isDone() || i != 3) {
            return null;
        }
        return new Rectangle2D.Double(minx, miny, maxx - minx, maxy - miny).getBounds();
    }

    private GridCoverage2D prepareCoverage(RenderedImage image) throws IOException {
        SampleModel sm = image.getSampleModel();
        ColorModel cm = image.getColorModel();
        int numBands = sm.getNumBands();
        GridSampleDimension[] bands = new GridSampleDimension[numBands];
        int i = 0;
        while (i < numBands) {
            double noData;
            ColorInterpretation colorInterpretation = TypeMap.getColorInterpretation((ColorModel)cm, (int)i);
            if (colorInterpretation == null) {
                throw new IOException("Unrecognized sample dimension type");
            }
            SampleDimensionType st = TypeMap.getSampleDimensionType((SampleModel)sm, (int)i);
            double min = -1.7976931348623157E308;
            double max = Double.MAX_VALUE;
            if (this.backgroundValues != null) {
                noData = this.backgroundValues[this.backgroundValues.length > i ? i : 0];
            } else if (st.compareTo((CodeList)SampleDimensionType.REAL_32BITS) == 0) {
                noData = Double.NaN;
            } else if (st.compareTo((CodeList)SampleDimensionType.REAL_64BITS) == 0) {
                noData = Double.NaN;
            } else if (st.compareTo((CodeList)SampleDimensionType.SIGNED_16BITS) == 0) {
                noData = -32768.0;
                min = -32768.0;
                max = 32767.0;
            } else if (st.compareTo((CodeList)SampleDimensionType.SIGNED_32BITS) == 0) {
                noData = -2.147483648E9;
                min = -2.147483648E9;
                max = 2.147483647E9;
            } else if (st.compareTo((CodeList)SampleDimensionType.SIGNED_8BITS) == 0) {
                noData = -128.0;
                min = -128.0;
                max = 127.0;
            } else {
                noData = 0.0;
                min = 0.0;
                if (st.compareTo((CodeList)SampleDimensionType.UNSIGNED_1BIT) == 0) {
                    max = 1.0;
                } else if (st.compareTo((CodeList)SampleDimensionType.UNSIGNED_2BITS) == 0) {
                    max = 3.0;
                } else if (st.compareTo((CodeList)SampleDimensionType.UNSIGNED_4BITS) == 0) {
                    max = 7.0;
                } else if (st.compareTo((CodeList)SampleDimensionType.UNSIGNED_8BITS) == 0) {
                    max = 255.0;
                } else if (st.compareTo((CodeList)SampleDimensionType.UNSIGNED_16BITS) == 0) {
                    max = 65535.0;
                } else if (st.compareTo((CodeList)SampleDimensionType.UNSIGNED_32BITS) == 0) {
                    max = Math.pow(2.0, 32.0) - 1.0;
                }
            }
            bands[i] = new SimplifiedGridSampleDimension(colorInterpretation.name(), st, colorInterpretation, noData, min, max, 1.0, 0.0, null).geophysics(true);
            ++i;
        }
        return this.coverageFactory.create((CharSequence)this.rasterManager.getCoverageIdentifier(), image, new GridGeometry2D((GridEnvelope)new GridEnvelope2D(PlanarImage.wrapRenderedImage((RenderedImage)image).getBounds()), PixelInCell.CELL_CORNER, (MathTransform)this.finalGridToWorldCorner, this.mosaicBBox.getCoordinateReferenceSystem(), this.hints), bands, null, null);
    }

    static class GranuleLoadingResult {
        RenderedImage loadedImage;
        ROI footprint;
        URL granuleUrl;
        boolean doFiltering;

        public ROI getFootprint() {
            return this.footprint;
        }

        public RenderedImage getRaster() {
            return this.loadedImage;
        }

        public URL getGranuleUrl() {
            return this.granuleUrl;
        }

        public boolean isDoFiltering() {
            return this.doFiltering;
        }

        GranuleLoadingResult(RenderedImage loadedImage, ROI footprint) {
            this(loadedImage, footprint, null);
        }

        GranuleLoadingResult(RenderedImage loadedImage, ROI footprint, URL granuleUrl) {
            this(loadedImage, footprint, granuleUrl, false);
        }

        GranuleLoadingResult(RenderedImage loadedImage, ROI footprint, URL granuleUrl, boolean doFiltering) {
            this.loadedImage = loadedImage;
            this.footprint = footprint;
            this.granuleUrl = granuleUrl;
            this.doFiltering = doFiltering;
        }
    }

    public static class MaxVisitor2
    extends MaxVisitor {
        private Comparable oldValue;
        private int oldNanCount;
        private int oldNullCount;
        private Feature targetFeature = null;

        public MaxVisitor2(Expression expr) throws IllegalFilterException {
            super(expr);
        }

        public MaxVisitor2(int attributeTypeIndex, SimpleFeatureType type) throws IllegalFilterException {
            super(attributeTypeIndex, type);
        }

        public Feature getTargetFeature() {
            return this.targetFeature;
        }

        public MaxVisitor2(String attrName, SimpleFeatureType type) throws IllegalFilterException {
            super(attrName, type);
        }

        public MaxVisitor2(String attributeTypeName) {
            super(attributeTypeName);
        }

        public void reset() {
            super.reset();
            this.oldValue = null;
            this.targetFeature = null;
        }

        public void setValue(Object result) {
            super.setValue(result);
            this.oldValue = null;
            this.targetFeature = null;
        }

        public void visit(Feature feature) {
            super.visit(feature);
            int nanCount = this.getNaNCount();
            if (this.oldNanCount != nanCount) {
                this.oldNanCount = nanCount;
                return;
            }
            int nullCount = this.getNullCount();
            if (this.oldNullCount != nullCount) {
                this.oldNullCount = nullCount;
                return;
            }
            Comparable max = this.getMax();
            if (this.oldValue == null || max.compareTo(this.oldValue) != 0) {
                this.targetFeature = feature;
                this.oldValue = max;
            }
        }
    }

    class MosaicBuilder
    implements GranuleCatalogVisitor {
        private final List<Future<GranuleLoadingResult>> tasks = new ArrayList<Future<GranuleLoadingResult>>();
        private int granulesNumber;
        private List<ROI> rois = new ArrayList<ROI>();
        private Color inputTransparentColor;
        private PlanarImage[] alphaChannels;
        private RasterLayerRequest request;
        private ROI[] sourceRoi;
        private double[][] sourceThreshold;
        private boolean doInputTransparency;
        private List<RenderedImage> sources = new ArrayList<RenderedImage>();

        public RenderedImage[] getSourcesAsArray() {
            RenderedImage[] imageSources = new RenderedImage[this.sources.size()];
            this.sources.toArray(imageSources);
            return imageSources;
        }

        public void visit(GranuleDescriptor granuleDescriptor, Object o) {
            Polygon bb = JTS.toGeometry((BoundingBox)RasterLayerResponse.this.mosaicBBox);
            Geometry inclusionGeometry = granuleDescriptor.inclusionGeometry;
            if (!RasterLayerResponse.this.footprintManagement || inclusionGeometry == null || RasterLayerResponse.this.footprintManagement && inclusionGeometry.intersects((Geometry)bb)) {
                GranuleLoader loader = new GranuleLoader(RasterLayerResponse.this.baseReadParameters, RasterLayerResponse.this.imageChoice, RasterLayerResponse.this.mosaicBBox, RasterLayerResponse.this.finalWorldToGridCorner, granuleDescriptor, this.request, RasterLayerResponse.this.hints);
                if (RasterLayerResponse.this.multithreadingAllowed && ((RasterLayerResponse)RasterLayerResponse.this).rasterManager.parent.multiThreadedLoader != null) {
                    this.tasks.add(((RasterLayerResponse)RasterLayerResponse.this).rasterManager.parent.multiThreadedLoader.submit(loader));
                } else {
                    this.tasks.add(new FutureTask<GranuleLoadingResult>(loader));
                }
                ++this.granulesNumber;
            }
            if (this.granulesNumber > this.request.getMaximumNumberOfGranules()) {
                throw new IllegalStateException("The maximum number of allowed granules (" + this.request.getMaximumNumberOfGranules() + ")has been exceeded.");
            }
        }

        public void produce() {
            this.alphaChannels = new PlanarImage[this.granulesNumber];
            int granuleIndex = 0;
            this.inputTransparentColor = this.request.getInputTransparentColor();
            this.doInputTransparency = this.inputTransparentColor != null && !RasterLayerResponse.this.footprintManagement;
            boolean firstGranule = true;
            int[] alphaIndex = null;
            for (Future<GranuleLoadingResult> future : this.tasks) {
                boolean doFiltering;
                RenderedImage loadedImage;
                GranuleLoadingResult result;
                block19: {
                    try {
                        if (!RasterLayerResponse.this.multithreadingAllowed || ((RasterLayerResponse)RasterLayerResponse.this).rasterManager.parent.multiThreadedLoader == null) {
                            FutureTask task = (FutureTask)future;
                            task.run();
                        }
                        if ((result = future.get()) == null) {
                            if (!LOGGER.isLoggable(Level.FINE)) continue;
                            LOGGER.log(Level.FINE, "Unable to load the raster for granule " + granuleIndex + " with request " + this.request.toString());
                            continue;
                        }
                        loadedImage = result.getRaster();
                        doFiltering = result.isDoFiltering();
                        if (loadedImage == null) {
                            if (!LOGGER.isLoggable(Level.FINE)) continue;
                            LOGGER.log(Level.FINE, "Unable to load the raster for granuleDescriptor " + granuleIndex + " with request " + this.request.toString());
                            continue;
                        }
                        if (!firstGranule) break block19;
                        ColorModel cm = loadedImage.getColorModel();
                        RasterLayerResponse.this.alphaIn = cm.hasAlpha();
                        if (RasterLayerResponse.this.alphaIn || this.doInputTransparency) {
                            alphaIndex = new int[]{cm.getNumComponents() - 1};
                        }
                        this.sourceThreshold = new double[][]{{CoverageUtilities.getMosaicThreshold((int)loadedImage.getSampleModel().getDataType())}};
                        firstGranule = false;
                    }
                    catch (InterruptedException e) {
                        if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                        LOGGER.log(Level.SEVERE, "Unable to load the raster for granuleDescriptor " + granuleIndex, e);
                        continue;
                    }
                    catch (ExecutionException e) {
                        if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                        LOGGER.log(Level.SEVERE, "Unable to load the raster for granuleDescriptor " + granuleIndex, e);
                        continue;
                    }
                    catch (com.sun.media.jai.codecimpl.util.ImagingException e) {
                        if (!LOGGER.isLoggable(Level.FINE)) continue;
                        LOGGER.fine("Adding to mosaic image number " + granuleIndex + " failed, original request was " + this.request);
                        continue;
                    }
                    catch (ImagingException e) {
                        if (!LOGGER.isLoggable(Level.FINE)) continue;
                        LOGGER.fine("Adding to mosaic image number " + granuleIndex + " failed, original request was " + this.request);
                        continue;
                    }
                }
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("Adding to mosaic image number " + granuleIndex);
                }
                RenderedImage raster = RasterLayerResponse.this.processGranuleRaster(loadedImage, granuleIndex, alphaIndex, RasterLayerResponse.this.alphaIn, this.alphaChannels, this.doInputTransparency, this.inputTransparentColor);
                Rectangle bounds = PlanarImage.wrapRenderedImage((RenderedImage)raster).getBounds();
                Polygon mask = JTS.toGeometry((Envelope)new Envelope(bounds.getMinX(), bounds.getMaxX(), bounds.getMinY(), bounds.getMaxY()));
                ROIGeometry imageBounds = new ROIGeometry((Geometry)mask);
                if (RasterLayerResponse.this.footprintManagement) {
                    ROI footprint = result.getFootprint();
                    if (footprint != null) {
                        imageBounds = imageBounds.contains(footprint.getBounds2D().getBounds()) ? footprint : imageBounds.intersect(footprint);
                    }
                    if (RasterLayerResponse.this.defaultArtifactsFilterThreshold != Integer.MIN_VALUE && doFiltering) {
                        URL url;
                        int artifactThreshold = RasterLayerResponse.this.defaultArtifactsFilterThreshold;
                        if (RasterLayerResponse.this.artifactsFilterPTileThreshold != -1.0 && (url = result.getGranuleUrl()) != null) {
                            File inputFile = DataUtilities.urlToFile((URL)url);
                            String inputFileName = inputFile.getPath();
                            String path = FilenameUtils.getFullPath((String)inputFileName);
                            String baseName = FilenameUtils.getBaseName((String)inputFileName);
                            String histogramPath = String.valueOf(path) + baseName + "." + "histogram";
                            Histogram histogram = Utils.getHistogram(histogramPath);
                            if (histogram != null) {
                                double[] p = histogram.getPTileThreshold(RasterLayerResponse.this.artifactsFilterPTileThreshold);
                                artifactThreshold = (int)p[0];
                            }
                        }
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, "Filtering granules artifacts");
                        }
                        raster = ArtifactsFilterDescriptor.create(raster, (ROI)imageBounds, new double[]{0.0}, artifactThreshold, 3, (RenderingHints)RasterLayerResponse.this.hints);
                    }
                }
                this.rois.add((ROI)imageBounds);
                this.sources.add(raster);
                ++granuleIndex;
            }
            this.granulesNumber = granuleIndex;
            if (this.granulesNumber == 0) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Unable to load any granuleDescriptor ");
                }
                return;
            }
            this.sourceRoi = this.rois.toArray(new ROI[this.rois.size()]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SimplifiedGridSampleDimension
    extends GridSampleDimension
    implements SampleDimension {
        private static final long serialVersionUID = 2227219522016820587L;
        private double nodata;
        private double minimum;
        private double maximum;
        private double scale;
        private double offset;
        private Unit<?> unit;
        private SampleDimensionType type;
        private ColorInterpretation color;
        private Category bkg;

        public SimplifiedGridSampleDimension(CharSequence description, SampleDimensionType type, ColorInterpretation color, double nodata, double minimum, double maximum, double scale, double offset, Unit<?> unit) {
            Category[] categoryArray;
            if (!Double.isNaN(nodata)) {
                Category[] categoryArray2 = new Category[1];
                categoryArray = categoryArray2;
                categoryArray2[0] = new Category((CharSequence)Vocabulary.formatInternational((int)147), new Color[]{new Color(0, 0, 0, 0)}, NumberRange.create((double)nodata, (double)nodata), NumberRange.create((double)nodata, (double)nodata));
            } else {
                categoryArray = null;
            }
            super(description, categoryArray, unit);
            this.nodata = nodata;
            this.minimum = minimum;
            this.maximum = maximum;
            this.scale = scale;
            this.offset = offset;
            this.unit = unit;
            this.type = type;
            this.color = color;
            this.bkg = new Category((CharSequence)"Background", Utils.TRANSPARENT, 0);
        }

        public double getMaximumValue() {
            return this.maximum;
        }

        public double getMinimumValue() {
            return this.minimum;
        }

        public double[] getNoDataValues() throws IllegalStateException {
            return new double[]{this.nodata};
        }

        public double getOffset() throws IllegalStateException {
            return this.offset;
        }

        public NumberRange<? extends Number> getRange() {
            return super.getRange();
        }

        public SampleDimensionType getSampleDimensionType() {
            return this.type;
        }

        public MathTransform1D getSampleToGeophysics() {
            return super.getSampleToGeophysics();
        }

        public Unit<?> getUnits() {
            return this.unit;
        }

        public double getScale() {
            return this.scale;
        }

        public ColorInterpretation getColorInterpretation() {
            return this.color;
        }

        public Category getBackground() {
            return this.bkg;
        }

        public InternationalString[] getCategoryNames() throws IllegalStateException {
            return new InternationalString[]{SimpleInternationalString.wrap((CharSequence)"Background")};
        }
    }
}

