/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.ImageLayout;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.io.DecimationPolicy;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.Query;
import org.geotools.factory.Hints;
import org.geotools.gce.imagemosaic.GranuleDescriptor;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.gce.imagemosaic.OverviewsController;
import org.geotools.gce.imagemosaic.PathType;
import org.geotools.gce.imagemosaic.RasterLayerRequest;
import org.geotools.gce.imagemosaic.RasterLayerResponse;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalog;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalogVisitor;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.geometry.BoundingBox;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RasterManager {
    private static final Logger LOGGER = Logging.getLogger(RasterManager.class);
    ColorModel defaultCM;
    SampleModel defaultSM;
    private GridCoverageFactory coverageFactory;
    private String coverageIdentifier;
    private Hints hints;
    OverviewsController overviewsController;
    OverviewPolicy overviewPolicy;
    DecimationPolicy decimationPolicy;
    ImageMosaicReader parent;
    private PathType pathType;
    boolean expandMe;
    boolean heterogeneousGranules;
    SpatialDomainManager spatialDomainManager;
    final GranuleCatalog granuleCatalog;
    String timeAttribute;
    String elevationAttribute;
    String runtimeAttribute;
    ImageLayout defaultImageLayout;

    public RasterManager(ImageMosaicReader reader) throws DataSourceException {
        Utilities.ensureNonNull((String)"ImageMosaicReader", (Object)((Object)reader));
        this.parent = reader;
        this.expandMe = this.parent.expandMe;
        this.heterogeneousGranules = this.parent.heterogeneousGranules;
        this.granuleCatalog = this.parent.catalog;
        this.parent.catalog = null;
        this.timeAttribute = this.parent.timeAttribute;
        this.elevationAttribute = this.parent.elevationAttribute;
        this.runtimeAttribute = this.parent.runtimeAttribute;
        this.coverageIdentifier = reader.getName();
        this.hints = reader.getHints();
        this.coverageIdentifier = reader.getName();
        this.coverageFactory = reader.getGridCoverageFactory();
        this.pathType = this.parent.pathType;
        this.overviewsController = new OverviewsController(reader.getHighestRes(), reader.getNumberOfOvervies(), reader.getOverviewsResolution());
        try {
            this.spatialDomainManager = new SpatialDomainManager(reader.getOriginalEnvelope(), (GridEnvelope2D)reader.getOriginalGridRange(), reader.getCrs(), reader.getOriginalGridToWorld(PixelInCell.CELL_CENTER), this.overviewsController);
        }
        catch (TransformException e) {
            throw new DataSourceException((Throwable)e);
        }
        catch (FactoryException e) {
            throw new DataSourceException((Throwable)e);
        }
        this.extractOverviewPolicy();
        this.extractDecimationPolicy();
        this.loadSampleImage();
    }

    private void loadSampleImage() {
        if (this.parent.sourceURL == null) {
            return;
        }
        URL baseURL = this.parent.sourceURL;
        File baseFile = DataUtilities.urlToFile((URL)baseURL);
        if (baseFile == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Unable to find sample image for path " + baseURL);
            }
            return;
        }
        File sampleImageFile = new File(String.valueOf(baseFile.getParent()) + "/sample_image");
        RenderedImage sampleImage = Utils.loadSampleImage(sampleImageFile);
        if (sampleImage != null) {
            this.defaultCM = sampleImage.getColorModel();
            this.defaultSM = sampleImage.getSampleModel();
            this.defaultImageLayout = new ImageLayout().setColorModel(this.defaultCM).setSampleModel(this.defaultSM);
        } else if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.warning("Unable to find sample image for path " + baseURL);
        }
    }

    private OverviewPolicy extractOverviewPolicy() {
        if (this.hints != null && this.hints.containsKey((Object)Hints.OVERVIEW_POLICY)) {
            this.overviewPolicy = (OverviewPolicy)this.hints.get((Object)Hints.OVERVIEW_POLICY);
        }
        if (this.overviewPolicy == null) {
            this.overviewPolicy = OverviewPolicy.getDefaultPolicy();
        }
        assert (this.overviewPolicy != null);
        return this.overviewPolicy;
    }

    private DecimationPolicy extractDecimationPolicy() {
        if (this.hints != null && this.hints.containsKey((Object)Hints.DECIMATION_POLICY)) {
            this.decimationPolicy = (DecimationPolicy)this.hints.get((Object)Hints.DECIMATION_POLICY);
        }
        if (this.decimationPolicy == null) {
            this.decimationPolicy = DecimationPolicy.getDefaultPolicy();
        }
        assert (this.decimationPolicy != null);
        return this.decimationPolicy;
    }

    public Collection<GridCoverage2D> read(GeneralParameterValue[] params) throws IOException {
        RasterLayerRequest request = new RasterLayerRequest(params, this);
        if (request.isEmpty()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Request is empty: " + request.toString());
            }
            return Collections.emptyList();
        }
        RasterLayerResponse response = new RasterLayerResponse(request, this);
        GridCoverage2D elem = response.createResponse();
        if (elem != null) {
            return Collections.singletonList(elem);
        }
        return Collections.emptyList();
    }

    public void dispose() {
        block3: {
            try {
                if (this.granuleCatalog != null) {
                    this.granuleCatalog.dispose();
                }
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.FINE)) break block3;
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
        }
    }

    Collection<GranuleDescriptor> getGranules(BoundingBox envelope) throws IOException {
        Collection<GranuleDescriptor> granules = this.granuleCatalog.getGranules(envelope);
        if (granules != null) {
            return granules;
        }
        return Collections.emptyList();
    }

    Collection<GranuleDescriptor> getGranules(Query q) throws IOException {
        Collection<GranuleDescriptor> granules = this.granuleCatalog.getGranules(q);
        if (granules != null) {
            return granules;
        }
        return Collections.emptyList();
    }

    void getGranules(Query q, GranuleCatalogVisitor visitor) throws IOException {
        this.granuleCatalog.getGranules(q, visitor);
    }

    void getGranules(BoundingBox envelope, GranuleCatalogVisitor visitor) throws IOException {
        this.granuleCatalog.getGranules(envelope, visitor);
    }

    public PathType getPathType() {
        return this.pathType;
    }

    public String getCoverageIdentifier() {
        return this.coverageIdentifier;
    }

    public Hints getHints() {
        return this.hints;
    }

    public GridCoverageFactory getCoverageFactory() {
        return this.coverageFactory;
    }

    static class SpatialDomainManager {
        ReferencedEnvelope coverageBBox;
        CoordinateReferenceSystem coverageCRS;
        CoordinateReferenceSystem coverageCRS2D;
        GeneralEnvelope coverageEnvelope = null;
        double[] coverageFullResolution;
        ReferencedEnvelope coverageGeographicBBox;
        CoordinateReferenceSystem coverageGeographicCRS2D;
        MathTransform2D coverageGridToWorld2D;
        Rectangle coverageRasterArea;

        public SpatialDomainManager(GeneralEnvelope envelope, GridEnvelope2D coverageGridrange, CoordinateReferenceSystem crs, MathTransform coverageGridToWorld2D, OverviewsController overviewsController) throws TransformException, FactoryException {
            this.coverageEnvelope = envelope.clone();
            this.coverageRasterArea = coverageGridrange.clone();
            this.coverageCRS = crs;
            this.coverageGridToWorld2D = (MathTransform2D)coverageGridToWorld2D;
            this.coverageFullResolution = new double[2];
            OverviewsController.OverviewLevel highestLevel = overviewsController.resolutionsLevels.get(0);
            this.coverageFullResolution[0] = highestLevel.resolutionX;
            this.coverageFullResolution[1] = highestLevel.resolutionY;
            this.prepareCoverageSpatialElements();
        }

        private void prepareCoverageSpatialElements() throws TransformException, FactoryException {
            this.coverageGeographicBBox = Utils.getWGS84ReferencedEnvelope(this.coverageEnvelope);
            this.coverageGeographicCRS2D = this.coverageGeographicBBox == null ? this.coverageGeographicBBox.getCoordinateReferenceSystem() : null;
            this.coverageCRS2D = CRS.getHorizontalCRS((CoordinateReferenceSystem)this.coverageCRS);
            assert (this.coverageCRS2D.getCoordinateSystem().getDimension() == 2);
            if (this.coverageCRS.getCoordinateSystem().getDimension() != 2) {
                MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)this.coverageCRS, (CoordinateReferenceSystem)this.coverageCRS2D);
                GeneralEnvelope bbox = CRS.transform((MathTransform)transform, (Envelope)this.coverageEnvelope);
                bbox.setCoordinateReferenceSystem(this.coverageCRS2D);
                this.coverageBBox = new ReferencedEnvelope((Envelope)bbox);
            } else {
                this.coverageBBox = new ReferencedEnvelope((Envelope)this.coverageEnvelope);
            }
        }
    }
}

