/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import com.sun.media.jai.operator.ImageReadDescriptor;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.RenderedOp;
import org.geotools.factory.Hints;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.resources.coverage.CoverageUtilities;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum ReadType {
    DIRECT_READ{

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        RenderedImage read(ImageReadParam readParameters, int imageIndex, URL granuleUrl, Rectangle rasterDimensions, ImageReader reader, Hints hints, boolean closeElements) {
            try {
                if (reader == null) {
                    if (!LOGGER.isLoggable(Level.WARNING)) return null;
                    LOGGER.warning("Unable to get reader for URL " + granuleUrl);
                    return null;
                }
                if (CoverageUtilities.checkEmptySourceRegion((ImageReadParam)readParameters, (Rectangle)rasterDimensions)) {
                    return null;
                }
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.log(Level.FINER, "reading file: " + granuleUrl);
                }
                BufferedImage bufferedImage = reader.read(imageIndex, readParameters);
                return bufferedImage;
            }
            catch (IOException e) {
                if (!LOGGER.isLoggable(Level.WARNING)) return null;
                LOGGER.log(Level.WARNING, "Unable to compute source area for URL " + granuleUrl, e);
                return null;
            }
            finally {
                try {
                    if (closeElements && reader != null) {
                        reader.dispose();
                    }
                }
                catch (Throwable throwable) {}
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        RenderedImage read(ImageReadParam readP, int imageIndex, URL rasterURL, Rectangle readDimension, ImageReaderSpi spi, Hints hints) throws IOException {
            ImageInputStream inStream = null;
            ImageReader reader = null;
            try {
                inStream = Utils.getInputStream(rasterURL);
                if (inStream == null) {
                    return null;
                }
                reader = spi.createReaderInstance();
                if (reader == null) {
                    if (!LOGGER.isLoggable(Level.WARNING)) return null;
                    LOGGER.warning("Unable to get reader for URL " + rasterURL);
                    return null;
                }
                inStream.reset();
                reader.setInput(inStream);
                if (CoverageUtilities.checkEmptySourceRegion((ImageReadParam)readP, (Rectangle)readDimension)) {
                    return null;
                }
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.log(Level.FINER, "reading file: " + rasterURL);
                }
                BufferedImage bufferedImage = reader.read(imageIndex, readP);
                return bufferedImage;
            }
            catch (IOException e) {
                if (!LOGGER.isLoggable(Level.WARNING)) return null;
                LOGGER.log(Level.WARNING, "Unable to compute source area for URL " + rasterURL, e);
                return null;
            }
            finally {
                try {
                    reader.dispose();
                }
                catch (Throwable throwable) {}
                try {
                    inStream.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }
    ,
    JAI_IMAGEREAD{

        RenderedImage read(ImageReadParam readP, int imageIndex, URL rasterUrl, Rectangle readDimension, ImageReaderSpi spi, Hints hints) throws IOException {
            if (CoverageUtilities.checkEmptySourceRegion((ImageReadParam)readP, (Rectangle)readDimension)) {
                return null;
            }
            RenderedOp raster = ImageReadDescriptor.create((ImageInputStream)Utils.getInputStream(rasterUrl), (Integer)imageIndex, (Boolean)false, (Boolean)false, (Boolean)false, null, null, (ImageReadParam)readP, (ImageReader)spi.createReaderInstance(), (RenderingHints)hints);
            if (raster != null) {
                raster.getWidth();
            }
            return raster;
        }

        RenderedImage read(ImageReadParam readParameters, int imageIndex, URL granuleUrl, Rectangle rasterDimensions, ImageReader reader, Hints hints, boolean closeElements) {
            block5: {
                try {
                    if (!CoverageUtilities.checkEmptySourceRegion((ImageReadParam)readParameters, (Rectangle)rasterDimensions)) break block5;
                    return null;
                }
                catch (IOException e) {
                    if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.log(Level.INFO, e.getLocalizedMessage(), e);
                    }
                    return null;
                }
            }
            RenderedOp raster = ImageReadDescriptor.create((ImageInputStream)Utils.getInputStream(granuleUrl), (Integer)imageIndex, (Boolean)false, (Boolean)false, (Boolean)false, null, null, (ImageReadParam)readParameters, (ImageReader)reader, (RenderingHints)hints);
            if (raster != null) {
                raster.getWidth();
            }
            return raster;
        }
    }
    ,
    UNSPECIFIED{

        RenderedImage read(ImageReadParam readParameters, int imageIndex, URL granuleUrl, Rectangle rasterDimensions, ImageReader reader, Hints hints, boolean closeElements) {
            throw new UnsupportedOperationException(Errors.format((int)205, (Object)"read"));
        }

        RenderedImage read(ImageReadParam readP, int imageIndex, URL rasterUrl, Rectangle readDimension, ImageReaderSpi spi, Hints hints) throws IOException {
            throw new UnsupportedOperationException(Errors.format((int)205, (Object)"read"));
        }
    };

    private static final Logger LOGGER;

    static {
        LOGGER = Logging.getLogger(ReadType.class);
    }

    private ReadType() {
    }

    static ReadType getDefault() {
        return JAI_IMAGEREAD;
    }

    abstract RenderedImage read(ImageReadParam var1, int var2, URL var3, Rectangle var4, ImageReaderSpi var5, Hints var6) throws IOException;

    abstract RenderedImage read(ImageReadParam var1, int var2, URL var3, Rectangle var4, ImageReader var5, Hints var6, boolean var7);

    /* synthetic */ ReadType(String string, int n, ReadType readType) {
        this();
    }
}

