/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalog;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.spi.ImageReaderSpi;
import org.apache.commons.io.FilenameUtils;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.Transaction;
import org.geotools.data.postgis.PostgisNGDataStoreFactory;
import org.geotools.data.postgis.PostgisNGJNDIDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.SchemaException;
import org.geotools.feature.visitor.FeatureCalc;
import org.geotools.filter.visitor.DefaultFilterVisitor;
import org.geotools.gce.imagemosaic.GranuleDescriptor;
import org.geotools.gce.imagemosaic.PathType;
import org.geotools.gce.imagemosaic.catalog.AbstractGranuleCatalog;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalogVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.BBOX;
import org.opengis.geometry.BoundingBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GTDataStoreGranuleCatalog
extends AbstractGranuleCatalog {
    static final Logger LOGGER = Logging.getLogger(GTDataStoreGranuleCatalog.class);
    static final TimeZone UTC_TZ = TimeZone.getTimeZone("UTC");
    static final FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
    private DataStore tileIndexStore;
    private String typeName;
    private String geometryPropertyName;
    private ReferencedEnvelope bounds;
    private DataStoreFactorySpi spi;
    private PathType pathType;
    private String locationAttribute;
    private ImageReaderSpi suggestedSPI;
    private String parentLocation;
    private boolean heterogeneous;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock(true);

    public GTDataStoreGranuleCatalog(Map<String, Serializable> params, boolean create, DataStoreFactorySpi spi) {
        Utilities.ensureNonNull((String)"params", params);
        Utilities.ensureNonNull((String)"spi", (Object)spi);
        this.spi = spi;
        try {
            this.pathType = (PathType)((Object)params.get("PathType"));
            this.locationAttribute = (String)((Object)params.get("LocationAttribute"));
            String temp = (String)((Object)params.get("SuggestedSPI"));
            this.suggestedSPI = temp != null ? (ImageReaderSpi)Class.forName(temp).newInstance() : null;
            this.parentLocation = (String)((Object)params.get("ParentLocation"));
            Serializable heterogen = params.get("Heterogeneous");
            if (heterogen != null) {
                this.heterogeneous = (Boolean)heterogen;
            }
            if (!create) {
                this.tileIndexStore = spi.createDataStore(params);
            } else {
                try {
                    this.tileIndexStore = spi.createNewDataStore(params);
                }
                catch (UnsupportedOperationException e) {
                    this.tileIndexStore = spi.createDataStore(params);
                }
            }
            if (create) {
                return;
            }
            if (spi instanceof PostgisNGJNDIDataStoreFactory || spi instanceof PostgisNGDataStoreFactory) {
                String typeName = FilenameUtils.getBaseName((String)FilenameUtils.getPathNoEndSeparator((String)this.parentLocation));
                this.extractBasicProperties(typeName);
            } else {
                this.extractBasicProperties(null);
            }
        }
        catch (Throwable e) {
            block17: {
                try {
                    try {
                        if (this.tileIndexStore != null) {
                            this.tileIndexStore.dispose();
                        }
                    }
                    catch (Throwable e1) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, e1.getLocalizedMessage(), e1);
                        }
                        this.tileIndexStore = null;
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    this.tileIndexStore = null;
                    throw throwable;
                }
                this.tileIndexStore = null;
            }
            throw new IllegalArgumentException(e);
        }
    }

    private void checkStore() throws IllegalStateException {
        if (this.tileIndexStore == null) {
            throw new IllegalStateException("The index store has been disposed already.");
        }
    }

    private void extractBasicProperties(String typeName) throws IOException {
        String[] typeNames = this.tileIndexStore.getTypeNames();
        if (typeNames == null || typeNames.length <= 0) {
            throw new IllegalArgumentException("BBOXFilterExtractor::extractBasicProperties(): Problems when opening the index, no typenames for the schema are defined");
        }
        if (typeName == null) {
            typeName = typeNames[0];
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("BBOXFilterExtractor::extractBasicProperties(): passed typename is null, using: " + typeName);
            }
        }
        String[] stringArray = typeNames;
        int n = typeNames.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("BBOXFilterExtractor::extractBasicProperties(): Looking for type '" + typeName + "' in DataStore:getTypeNames(). Testing: '" + type + "'.");
            }
            if (type.equalsIgnoreCase(typeName)) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("BBOXFilterExtractor::extractBasicProperties(): SUCCESS -> type '" + typeName + "' is equalsIgnoreCase() to '" + type + "'.");
                }
                this.typeName = type;
                break;
            }
            ++n2;
        }
        SimpleFeatureSource featureSource = this.tileIndexStore.getFeatureSource(this.typeName);
        if (featureSource == null) {
            throw new IOException("BBOXFilterExtractor::extractBasicProperties(): unable to get a featureSource for the qualified name" + this.typeName);
        }
        this.bounds = featureSource.getBounds();
        FeatureType schema = featureSource.getSchema();
        if (schema != null) {
            this.geometryPropertyName = schema.getGeometryDescriptor().getLocalName();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("BBOXFilterExtractor::extractBasicProperties(): geometryPropertyName is set to '" + this.geometryPropertyName + "'.");
            }
        } else {
            throw new IOException("BBOXFilterExtractor::extractBasicProperties(): unable to get a schema from the featureSource");
        }
    }

    public List<GranuleDescriptor> getGranules(BoundingBox envelope) throws IOException {
        Utilities.ensureNonNull((String)"envelope", (Object)envelope);
        Query q = new Query(this.typeName);
        BBOX filter = ff.bbox((Expression)ff.property(this.geometryPropertyName), (BoundingBox)ReferencedEnvelope.reference((BoundingBox)envelope));
        q.setFilter((Filter)filter);
        return this.getGranules(q);
    }

    @Override
    public void getGranules(BoundingBox envelope, GranuleCatalogVisitor visitor) throws IOException {
        Utilities.ensureNonNull((String)"envelope", (Object)envelope);
        Query q = new Query(this.typeName);
        BBOX filter = ff.bbox((Expression)ff.property(this.geometryPropertyName), (BoundingBox)ReferencedEnvelope.reference((BoundingBox)envelope));
        q.setFilter((Filter)filter);
        this.getGranules(q, visitor);
    }

    @Override
    public void dispose() {
        Lock l = this.rwLock.writeLock();
        try {
            l.lock();
            try {
                try {
                    if (this.tileIndexStore != null) {
                        this.tileIndexStore.dispose();
                    }
                }
                catch (Throwable e) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                    }
                    this.tileIndexStore = null;
                }
            }
            finally {
                this.tileIndexStore = null;
            }
        }
        finally {
            l.unlock();
        }
    }

    @Override
    public int removeGranules(Query query) {
        Utilities.ensureNonNull((String)"query", (Object)query);
        Lock lock = this.rwLock.writeLock();
        try {
            lock.lock();
            this.checkStore();
            SimpleFeatureStore fs = null;
            try {
                fs = (SimpleFeatureStore)this.tileIndexStore.getFeatureSource(this.typeName);
                int retVal = fs.getCount(query);
                fs.removeFeatures(query.getFilter());
                this.bounds = this.tileIndexStore.getFeatureSource(this.typeName).getBounds();
                int n = retVal;
                return n;
            }
            catch (Throwable e) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                }
                lock.unlock();
                return -1;
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void addGranule(SimpleFeature granule, Transaction transaction) throws IOException {
        this.addGranules(Collections.singleton(granule), transaction);
    }

    @Override
    public void addGranules(Collection<SimpleFeature> granules, Transaction transaction) throws IOException {
        Utilities.ensureNonNull((String)"granuleMetadata", granules);
        Lock lock = this.rwLock.writeLock();
        try {
            block17: {
                lock.lock();
                this.checkStore();
                FeatureWriter fw = null;
                try {
                    try {
                        fw = this.tileIndexStore.getFeatureWriterAppend(this.typeName, transaction);
                        for (SimpleFeature f : granules) {
                            SimpleFeature feature = (SimpleFeature)fw.next();
                            int i = f.getAttributeCount() - 1;
                            while (i >= 0) {
                                Object attribute = f.getAttribute(i);
                                if (this.spi instanceof PostgisNGJNDIDataStoreFactory || this.spi instanceof PostgisNGDataStoreFactory) {
                                    AttributeDescriptor descriptor = this.tileIndexStore.getSchema(this.typeName).getDescriptor(i);
                                    if (descriptor.getType().getBinding().equals(String.class)) {
                                        attribute = ((String)attribute).replace("\\", "\\\\");
                                    }
                                    if (descriptor.getType().getBinding().equals(Date.class)) {
                                        Calendar cal = Calendar.getInstance(UTC_TZ);
                                        cal.setTime((Date)attribute);
                                        attribute = cal.getTime();
                                    }
                                }
                                feature.setAttribute(i, attribute);
                                --i;
                            }
                            fw.write();
                        }
                    }
                    catch (Throwable e) {
                        if (LOGGER.isLoggable(Level.SEVERE)) {
                            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                        }
                        if (fw != null) {
                            fw.close();
                        }
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    if (fw != null) {
                        fw.close();
                    }
                    throw throwable;
                }
                if (fw != null) {
                    fw.close();
                }
            }
            this.bounds = this.tileIndexStore.getFeatureSource(this.typeName).getBounds(Query.ALL);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void getGranules(Query q, GranuleCatalogVisitor visitor) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<GranuleDescriptor> getGranules(Query q) throws IOException {
        Utilities.ensureNonNull((String)"q", (Object)q);
        SimpleFeatureIterator it = null;
        Lock lock = this.rwLock.readLock();
        try {
            lock.lock();
            this.checkStore();
            SimpleFeatureSource featureSource = this.tileIndexStore.getFeatureSource(this.typeName);
            if (featureSource == null) {
                throw new NullPointerException("The provided SimpleFeatureSource is null, it's impossible to create an index!");
            }
            SimpleFeatureCollection features = featureSource.getFeatures(q);
            if (features == null) {
                throw new NullPointerException("The provided SimpleFeatureCollection is null, it's impossible to create an index!");
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Index Loaded");
            }
            if (!(it = features.features()).hasNext()) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("The provided SimpleFeatureCollection  or empty, it's impossible to create an index!");
                }
                List<GranuleDescriptor> list = Collections.emptyList();
                return list;
            }
            ArrayList<GranuleDescriptor> retVal = new ArrayList<GranuleDescriptor>(features.size());
            while (it.hasNext()) {
                SimpleFeature sf = (SimpleFeature)it.next();
                GranuleDescriptor granule = new GranuleDescriptor(sf, this.suggestedSPI, this.pathType, this.locationAttribute, this.parentLocation, this.heterogeneous);
                retVal.add(granule);
            }
            ArrayList<GranuleDescriptor> arrayList = retVal;
            return arrayList;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            lock.unlock();
            if (it != null) {
                it.close();
            }
        }
    }

    @Override
    public Collection<GranuleDescriptor> getGranules() throws IOException {
        return this.getGranules(this.getBounds());
    }

    @Override
    public BoundingBox getBounds() {
        Lock lock = this.rwLock.readLock();
        try {
            lock.lock();
            this.checkStore();
            ReferencedEnvelope referencedEnvelope = this.bounds;
            return referencedEnvelope;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void createType(String namespace, String typeName, String typeSpec) throws IOException, SchemaException {
        Utilities.ensureNonNull((String)"typeName", (Object)typeName);
        Utilities.ensureNonNull((String)"typeSpec", (Object)typeSpec);
        Lock lock = this.rwLock.writeLock();
        try {
            lock.lock();
            this.checkStore();
            SimpleFeatureType featureType = DataUtilities.createType((String)namespace, (String)typeName, (String)typeSpec);
            this.tileIndexStore.createSchema((FeatureType)featureType);
            this.extractBasicProperties(featureType.getTypeName());
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void createType(SimpleFeatureType featureType) throws IOException {
        Utilities.ensureNonNull((String)"featureType", (Object)featureType);
        Lock lock = this.rwLock.writeLock();
        try {
            lock.lock();
            this.checkStore();
            this.tileIndexStore.createSchema((FeatureType)featureType);
            this.extractBasicProperties(featureType.getTypeName());
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void createType(String identification, String typeSpec) throws SchemaException, IOException {
        Utilities.ensureNonNull((String)"typeSpec", (Object)typeSpec);
        Utilities.ensureNonNull((String)"identification", (Object)identification);
        Lock lock = this.rwLock.writeLock();
        try {
            lock.lock();
            this.checkStore();
            SimpleFeatureType featureType = DataUtilities.createType((String)identification, (String)typeSpec);
            this.tileIndexStore.createSchema((FeatureType)featureType);
            this.extractBasicProperties(featureType.getTypeName());
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public SimpleFeatureType getType() throws IOException {
        Lock lock = this.rwLock.readLock();
        try {
            lock.lock();
            this.checkStore();
            SimpleFeatureType simpleFeatureType = this.tileIndexStore.getSchema(this.typeName);
            return simpleFeatureType;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void computeAggregateFunction(Query query, FeatureCalc function) throws IOException {
        Lock lock = this.rwLock.readLock();
        try {
            lock.lock();
            this.checkStore();
            SimpleFeatureSource fs = this.tileIndexStore.getFeatureSource(query.getTypeName());
            if (fs instanceof ContentFeatureSource) {
                ((ContentFeatureSource)fs).accepts(query, (FeatureVisitor)function, null);
            } else {
                SimpleFeatureCollection collection = fs.getFeatures(query);
                collection.accepts((FeatureVisitor)function, null);
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public QueryCapabilities getQueryCapabilities() {
        Lock lock = this.rwLock.readLock();
        try {
            lock.lock();
            this.checkStore();
            QueryCapabilities queryCapabilities = this.tileIndexStore.getFeatureSource(this.typeName).getQueryCapabilities();
            return queryCapabilities;
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "Unable to collect QueryCapabilities", e);
            }
            return null;
        }
        finally {
            lock.unlock();
        }
    }

    static class BBOXFilterExtractor
    extends DefaultFilterVisitor {
        private ReferencedEnvelope bbox;

        BBOXFilterExtractor() {
        }

        public ReferencedEnvelope getBBox() {
            return this.bbox;
        }

        public Object visit(BBOX filter, Object data) {
            ReferencedEnvelope bbox = new ReferencedEnvelope(filter.getMinX(), filter.getMinY(), filter.getMaxX(), filter.getMaxY(), null);
            this.bbox = this.bbox != null ? (ReferencedEnvelope)this.bbox.intersection((Envelope)bbox) : bbox;
            return super.visit(filter, data);
        }
    }
}

