/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.properties.time;

import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TimeParser {
    private static final String[] PATTERNS = new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", "yyyy-MM-dd'T'HHmmssSSS'Z'", "yyyyMMdd'T'HH:mm:ss.SSS'Z'", "yyyyMMdd'T'HHmmssSSS'Z'", "yyyy-MM-dd'T'HH:mm:ss.SSS", "yyyy-MM-dd'T'HHmmssSSS", "yyyyMMdd'T'HH:mm:ss.SSS", "yyyyMMdd'T'HHmmssSSS", "yyyy-MM-dd'T'HH:mm:ss'Z'", "yyyy-MM-dd'T'HHmmss'Z'", "yyyyMMdd'T'HH:mm:ss'Z'", "yyyyMMdd'T'HHmmss'Z'", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HHmmss", "yyyyMMdd'T'HH:mm:ss", "yyyyMMdd'T'HHmmss", "yyyy-MM-dd'T'HH:mm'Z'", "yyyy-MM-dd'T'HHmm'Z'", "yyyyMMdd'T'HH:mm'Z'", "yyyyMMdd'T'HHmm'Z'", "yyyy-MM-dd'T'HH:mm", "yyyy-MM-dd'T'HHmm", "yyyyMMdd'T'HH:mm", "yyyyMMdd'T'HHmm", "yyyy-MM-dd'T'HH'Z'", "yyyyMMdd'T'HH'Z'", "yyyy-MM-dd'T'HH", "yyyyMMdd'T'HH", "yyyy-MM-dd", "yyyyMMdd", "yyyy-MM", "yyyyMM", "yyyy"};
    static final TimeZone UTC_TZ = TimeZone.getTimeZone("UTC");
    static final long MILLIS_IN_DAY = 86400000L;

    public List<Date> parse(String value) throws ParseException {
        if (value == null) {
            return Collections.emptyList();
        }
        if ((value = value.trim()).length() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Date> dates = new ArrayList<Date>();
        if (value.indexOf(44) >= 0) {
            String[] listDates = value.split(",");
            int i = 0;
            while (i < listDates.length) {
                dates.add(TimeParser.getDate(listDates[i].trim()));
                ++i;
            }
            return dates;
        }
        String[] period = value.split("/");
        if (period.length == 1) {
            if (value.equals("current")) {
                dates.add(Calendar.getInstance(UTC_TZ).getTime());
            } else {
                dates.add(TimeParser.getDate(value));
            }
            return dates;
        }
        if (period.length == 3) {
            long time;
            Date begin = TimeParser.getDate(period[0]);
            Date end = TimeParser.getDate(period[1]);
            long millisIncrement = TimeParser.parsePeriod(period[2]);
            long startTime = begin.getTime();
            long endTime = end.getTime();
            int j = 0;
            while ((time = (long)j * millisIncrement + startTime) <= endTime) {
                Calendar calendar = Calendar.getInstance(UTC_TZ);
                calendar.setTimeInMillis(time);
                dates.add(calendar.getTime());
                ++j;
            }
            return dates;
        }
        throw new ParseException("Invalid time parameter: " + value, 0);
    }

    private static Date getDate(String value) throws ParseException {
        int i = 0;
        while (i < PATTERNS.length) {
            SimpleDateFormat format = new SimpleDateFormat(PATTERNS[i]);
            format.setTimeZone(UTC_TZ);
            ParsePosition pos = new ParsePosition(0);
            Date time = format.parse(value, pos);
            if (pos.getIndex() == value.length()) {
                return time;
            }
            ++i;
        }
        throw new ParseException("Invalid date: " + value, 0);
    }

    static long parsePeriod(String period) throws ParseException {
        int length = period.length();
        if (length != 0 && Character.toUpperCase(period.charAt(0)) != 'P') {
            throw new ParseException("Invalid period increment given: " + period, 0);
        }
        long millis = 0L;
        boolean time = false;
        int lower = 0;
        while (++lower < length) {
            double factor;
            double value;
            int upper;
            block17: {
                char letter;
                block16: {
                    letter = Character.toUpperCase(period.charAt(lower));
                    if (letter == 'T') {
                        time = true;
                        if (++lower >= length) break;
                    }
                    upper = lower;
                    letter = period.charAt(upper);
                    while (!Character.isLetter(letter) || letter == 'e' || letter == 'E') {
                        if (++upper >= length) {
                            throw new ParseException("Missing symbol in \"" + period + "\".", lower);
                        }
                        letter = period.charAt(upper);
                    }
                    letter = Character.toUpperCase(letter);
                    value = Double.parseDouble(period.substring(lower, upper));
                    if (!time) break block16;
                    switch (letter) {
                        case 'S': {
                            factor = 1000.0;
                            break block17;
                        }
                        case 'M': {
                            factor = 60000.0;
                            break block17;
                        }
                        case 'H': {
                            factor = 3600000.0;
                            break block17;
                        }
                        default: {
                            throw new ParseException("Unknown time symbol: " + letter, upper);
                        }
                    }
                }
                switch (letter) {
                    case 'D': {
                        factor = 8.64E7;
                        break;
                    }
                    case 'W': {
                        factor = 6.048E8;
                        break;
                    }
                    case 'M': {
                        factor = 2.592E9;
                        break;
                    }
                    case 'Y': {
                        factor = 3.15576E10;
                        break;
                    }
                    default: {
                        throw new ParseException("Unknown period symbol: " + letter, upper);
                    }
                }
            }
            millis += Math.round(value * factor);
            lower = upper;
        }
        return millis;
    }
}

