/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import com.sun.media.jai.util.Rational;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.Histogram;
import javax.media.jai.Interpolation;
import javax.media.jai.RasterFactory;
import javax.media.jai.RenderedOp;
import javax.media.jai.remote.SerializableRenderedImage;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.DataUtilities;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.factory.Hints;
import org.geotools.gce.imagemosaic.MosaicConfigurationBean;
import org.geotools.gce.imagemosaic.catalogbuilder.CatalogBuilder;
import org.geotools.gce.imagemosaic.catalogbuilder.CatalogBuilderConfiguration;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.Converters;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static final String INDEXER_PROPERTIES = "indexer.properties";
    private static Cache ehcache;
    public static final double[][] RGB_TO_GRAY_MATRIX;
    static final boolean OPTIMIZE_CROP;
    private static float rationalTolerance;
    private static final Logger LOGGER;
    public static final String DEFAULT_WILCARD = "*.*";
    public static final boolean DEFAULT_PATH_BEHAVIOR = false;
    private static final boolean DEFAULT_CACHING_BEHAVIOR = false;
    public static final int DEFAULT_PRIORITY = 5;
    public static final String DEFAULT_LOCATION_ATTRIBUTE = "location";
    public static final String DEFAULT_INDEX_NAME = "index";
    public static final DataStoreFactorySpi SHAPE_SPI;
    static final String DIRECT_KAKADU_PLUGIN = "it.geosolutions.imageio.plugins.jp2k.JP2KKakaduImageReader";
    public static final boolean DEFAULT_RECURSION_BEHAVIOR = true;
    static final Color TRANSPARENT;
    static final Boolean IGNORE_FOOTPRINT;
    public static final boolean DEFAULT_FOOTPRINT_MANAGEMENT = true;
    public static final boolean DEFAULT_CONFIGURATION_CACHING = false;
    static final double SAMEBBOX_THRESHOLD_FACTOR = 20.0;
    static final double AFFINE_IDENTITY_EPS = 1.0E-6;
    public static final boolean DEFAULT_COLOR_EXPANSION_BEHAVIOR = false;

    static Rectangle2D layoutHelper(RenderedImage source, float scaleX, float scaleY, float transX, float transY, Interpolation interp) {
        Rational scaleXRational = Rational.approximate((float)scaleX, (float)rationalTolerance);
        Rational scaleYRational = Rational.approximate((float)scaleY, (float)rationalTolerance);
        long scaleXRationalNum = scaleXRational.num;
        long scaleXRationalDenom = scaleXRational.denom;
        long scaleYRationalNum = scaleYRational.num;
        long scaleYRationalDenom = scaleYRational.denom;
        Rational transXRational = Rational.approximate((float)transX, (float)rationalTolerance);
        Rational transYRational = Rational.approximate((float)transY, (float)rationalTolerance);
        long transXRationalNum = transXRational.num;
        long transXRationalDenom = transXRational.denom;
        long transYRationalNum = transYRational.num;
        long transYRationalDenom = transYRational.denom;
        int x0 = source.getMinX();
        int y0 = source.getMinY();
        int w = source.getWidth();
        int h = source.getHeight();
        long dx0Num = x0;
        long dx0Denom = 1L;
        long dy0Num = y0;
        long dy0Denom = 1L;
        long dx1Num = x0 + w;
        long dx1Denom = 1L;
        long dy1Num = y0 + h;
        long dy1Denom = 1L;
        dx0Num *= scaleXRationalNum;
        dx0Denom *= scaleXRationalDenom;
        dy0Num *= scaleYRationalNum;
        dy0Denom *= scaleYRationalDenom;
        dx1Num *= scaleXRationalNum;
        dx1Denom *= scaleXRationalDenom;
        dy1Num *= scaleYRationalNum;
        dy1Denom *= scaleYRationalDenom;
        dx0Num = 2L * dx0Num - dx0Denom;
        dx0Denom *= 2L;
        dy0Num = 2L * dy0Num - dy0Denom;
        dy0Denom *= 2L;
        dx1Num = 2L * dx1Num - 3L * dx1Denom;
        dx1Denom *= 2L;
        dy1Num = 2L * dy1Num - 3L * dy1Denom;
        dy1Denom *= 2L;
        dx0Num = dx0Num * transXRationalDenom + transXRationalNum * dx0Denom;
        dy0Num = dy0Num * transYRationalDenom + transYRationalNum * dy0Denom;
        dx1Num = dx1Num * transXRationalDenom + transXRationalNum * dx1Denom;
        dy1Num = dy1Num * transYRationalDenom + transYRationalNum * dy1Denom;
        int l_x0 = Rational.ceil((long)dx0Num, (long)(dx0Denom *= transXRationalDenom));
        int l_y0 = Rational.ceil((long)dy0Num, (long)(dy0Denom *= transYRationalDenom));
        int l_x1 = Rational.ceil((long)dx1Num, (long)(dx1Denom *= transXRationalDenom));
        int l_y1 = Rational.ceil((long)dy1Num, (long)(dy1Denom *= transYRationalDenom));
        Rectangle2D.Double retValue = new Rectangle2D.Double();
        retValue.setFrame(l_x0, l_y0, l_x1 - l_x0 + 1, l_y1 - l_y0 + 1);
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean createMosaic(String location, String indexName, String wildcard, boolean absolutePath, Hints hints) {
        CatalogBuilderConfiguration configuration = new CatalogBuilderConfiguration();
        configuration.setAbsolute(absolutePath);
        configuration.setHints(hints);
        configuration.setRootMosaicDirectory(location);
        configuration.setIndexingDirectories(Arrays.asList(location));
        configuration.setIndexName(indexName);
        CatalogBuilder catalogBuilder = new CatalogBuilder(configuration);
        final LinkedList exceptions = new LinkedList();
        try {
            try {
                CatalogBuilder.ProcessingEventListener listener = new CatalogBuilder.ProcessingEventListener(){

                    public void exceptionOccurred(CatalogBuilder.ExceptionEvent event) {
                        Exception t = event.getException();
                        exceptions.add(t);
                        if (LOGGER.isLoggable(Level.SEVERE)) {
                            LOGGER.log(Level.SEVERE, t.getLocalizedMessage(), t);
                        }
                    }

                    public void getNotification(CatalogBuilder.ProcessingEvent event) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine(event.getMessage());
                        }
                    }
                };
                catalogBuilder.addProcessingEventListener(listener);
                catalogBuilder.run();
            }
            catch (Throwable e) {
                LOGGER.log(Level.SEVERE, "Unable to build mosaic", e);
                boolean bl = false;
                Object var11_11 = null;
                catalogBuilder.dispose();
                return bl;
            }
            Object var11_10 = null;
            catalogBuilder.dispose();
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            catalogBuilder.dispose();
            throw throwable;
        }
        return exceptions.size() <= 0;
    }

    public static String getMessageFromException(Exception exception) {
        if (exception.getLocalizedMessage() != null) {
            return exception.getLocalizedMessage();
        }
        return exception.getMessage();
    }

    static URL checkSource(Object source) throws MalformedURLException, DataSourceException {
        return Utils.checkSource(source, null);
    }

    static MosaicConfigurationBean loadMosaicProperties(URL sourceURL, String defaultLocationAttribute) {
        return Utils.loadMosaicProperties(sourceURL, defaultLocationAttribute, null);
    }

    static MosaicConfigurationBean loadMosaicProperties(URL sourceURL, String defaultLocationAttribute, Set<String> ignorePropertiesSet) {
        String[] pair;
        String[] pairs;
        Properties properties;
        boolean ignoreSome;
        MosaicConfigurationBean retValue;
        block31: {
            String bboxString;
            retValue = new MosaicConfigurationBean();
            ignoreSome = ignorePropertiesSet != null && !ignorePropertiesSet.isEmpty();
            URL propsURL = sourceURL;
            if (!sourceURL.toExternalForm().endsWith(".properties")) {
                propsURL = DataUtilities.changeUrlExt((URL)sourceURL, (String)"properties");
            }
            if ((properties = Utils.loadPropertiesFromURL(propsURL)) == null) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Unable to load mosaic properties file");
                }
                return null;
            }
            pairs = null;
            pair = null;
            if (!(ignoreSome && ignorePropertiesSet.contains("Envelope2D") || (bboxString = properties.getProperty("Envelope2D", null)) == null)) {
                bboxString = bboxString.trim();
                try {
                    ReferencedEnvelope bbox = Utils.parseEnvelope(bboxString);
                    if (bbox != null) {
                        retValue.setEnvelope(bbox);
                    } else if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.info("Cannot parse imposed bbox.");
                    }
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(Level.INFO)) break block31;
                    LOGGER.log(Level.INFO, "Cannot parse imposed bbox.", e);
                }
            }
        }
        if (!ignoreSome || !ignorePropertiesSet.contains("Levels")) {
            int levelsNumber = Integer.parseInt(properties.getProperty("LevelsNum", "1").trim());
            retValue.setLevelsNum(levelsNumber);
            if (!properties.containsKey("Levels")) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Required key Levels not found.");
                }
                return null;
            }
            String levels = properties.getProperty("Levels").trim();
            pairs = levels.split(" ");
            if (pairs == null || pairs.length != levelsNumber) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Levels number is different from the provided number of levels resoltion.");
                }
                return null;
            }
            double[][] resolutions = new double[levelsNumber][2];
            for (int i = 0; i < levelsNumber; ++i) {
                pair = pairs[i].split(",");
                if (pair == null || pair.length != 2) {
                    if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.info("OverviewLevel number is different from the provided number of levels resoltion.");
                    }
                    return null;
                }
                resolutions[i][0] = Double.parseDouble(pair[0]);
                resolutions[i][1] = Double.parseDouble(pair[1]);
            }
            retValue.setLevels(resolutions);
        }
        if (!(ignoreSome && ignorePropertiesSet.contains("SuggestedSPI") || !properties.containsKey("SuggestedSPI"))) {
            String suggestedSPI = properties.getProperty("SuggestedSPI").trim();
            retValue.setSuggestedSPI(suggestedSPI);
        }
        if (properties.containsKey("TimeAttribute")) {
            String timeAttribute = properties.getProperty("TimeAttribute").trim();
            retValue.setTimeAttribute(timeAttribute);
        }
        if (properties.containsKey("ElevationAttribute")) {
            String elevationAttribute = properties.getProperty("ElevationAttribute").trim();
            retValue.setElevationAttribute(elevationAttribute);
        }
        if (properties.containsKey("Caching")) {
            String caching = properties.getProperty("Caching").trim();
            try {
                retValue.setCaching(Boolean.valueOf(caching));
            }
            catch (Throwable e) {
                retValue.setCaching(false);
            }
        }
        if (!ignoreSome || !ignorePropertiesSet.contains("Name")) {
            if (!properties.containsKey("Name")) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.severe("Required key Name not found.");
                }
                return null;
            }
            String coverageName = properties.getProperty("Name").trim();
            retValue.setName(coverageName);
        }
        if (!ignoreSome || !ignorePropertiesSet.contains("ExpandToRGB")) {
            boolean expandMe = Boolean.valueOf(properties.getProperty("ExpandToRGB", "false").trim());
            retValue.setExpandToRGB(expandMe);
        }
        if (!ignoreSome || !ignorePropertiesSet.contains("Heterogeneous")) {
            boolean heterogeneous = Boolean.valueOf(properties.getProperty("Heterogeneous", "false").trim());
            retValue.setHeterogeneous(heterogeneous);
        }
        if (!ignoreSome || !ignorePropertiesSet.contains("AbsolutePath")) {
            boolean absolutePath = Boolean.valueOf(properties.getProperty("AbsolutePath", Boolean.toString(false)).trim());
            retValue.setAbsolutePath(absolutePath);
        }
        if (!ignoreSome || !ignorePropertiesSet.contains("FootprintManagement")) {
            boolean footprintManagement = Boolean.valueOf(properties.getProperty("FootprintManagement", "false").trim());
            retValue.setFootprintManagement(footprintManagement);
        }
        if (!ignoreSome || !ignorePropertiesSet.contains("LocationAttribute")) {
            retValue.setLocationAttribute(properties.getProperty("LocationAttribute", DEFAULT_LOCATION_ATTRIBUTE).trim());
        }
        return retValue;
    }

    public static ReferencedEnvelope parseEnvelope(String bboxString) {
        if (bboxString == null || bboxString.length() == 0) {
            return null;
        }
        String[] pairs = bboxString.split(" ");
        if (pairs != null && pairs.length == 2) {
            String[] pair1 = pairs[0].split(",");
            String[] pair2 = pairs[1].split(",");
            if (pair1 != null && pair1.length == 2 && pair2 != null && pair2.length == 2) {
                return new ReferencedEnvelope(Double.parseDouble(pair1[0]), Double.parseDouble(pair2[0]), Double.parseDouble(pair1[1]), Double.parseDouble(pair2[1]), null);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Properties loadPropertiesFromURL(URL propsURL) {
        InputStream openStream;
        Properties properties;
        block11: {
            properties = new Properties();
            BufferedInputStream stream = null;
            openStream = null;
            try {
                try {
                    openStream = propsURL.openStream();
                    stream = new BufferedInputStream(openStream);
                    properties.load(stream);
                }
                catch (FileNotFoundException e) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                    }
                    Properties properties2 = null;
                    Object var7_5 = null;
                    if (stream != null) {
                        IOUtils.closeQuietly((InputStream)stream);
                    }
                    if (openStream == null) return properties2;
                    IOUtils.closeQuietly((InputStream)openStream);
                    return properties2;
                }
                catch (IOException e) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                    }
                    Properties properties3 = null;
                    Object var7_6 = null;
                    if (stream != null) {
                        IOUtils.closeQuietly((InputStream)stream);
                    }
                    if (openStream == null) return properties3;
                    IOUtils.closeQuietly((InputStream)openStream);
                    return properties3;
                }
                Object var7_4 = null;
                if (stream == null) break block11;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (stream != null) {
                    IOUtils.closeQuietly((InputStream)stream);
                }
                if (openStream == null) throw throwable;
                IOUtils.closeQuietly((InputStream)openStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)stream);
        }
        if (openStream == null) return properties;
        IOUtils.closeQuietly((InputStream)openStream);
        return properties;
    }

    static ReferencedEnvelope getWGS84ReferencedEnvelope(GeneralEnvelope coverageEnvelope) {
        Utilities.ensureNonNull((String)"coverageEnvelope", (Object)coverageEnvelope);
        ReferencedEnvelope refEnv = new ReferencedEnvelope((org.opengis.geometry.Envelope)coverageEnvelope);
        try {
            return refEnv.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true);
        }
        catch (Exception e) {
            return null;
        }
    }

    static ImageReadParam cloneImageReadParam(ImageReadParam param) {
        ImageReadParam newParam = new ImageReadParam();
        if (param.hasController()) {
            newParam.setController(param.getController());
        }
        newParam.setDestination(param.getDestination());
        if (param.getDestinationType() != null) {
            newParam.setDestinationType(param.getDestinationType());
        }
        newParam.setDestinationBands(param.getDestinationBands());
        newParam.setDestinationOffset(param.getDestinationOffset());
        newParam.setSourceBands(param.getSourceBands());
        newParam.setSourceRegion(param.getSourceRegion());
        if (param.getSourceMaxProgressivePass() != Integer.MAX_VALUE) {
            newParam.setSourceProgressivePasses(param.getSourceMinProgressivePass(), param.getSourceNumProgressivePasses());
        }
        if (param.canSetSourceRenderSize()) {
            newParam.setSourceRenderSize(param.getSourceRenderSize());
        }
        newParam.setSourceSubsampling(param.getSourceXSubsampling(), param.getSourceYSubsampling(), param.getSubsamplingXOffset(), param.getSubsamplingYOffset());
        return newParam;
    }

    public static IOFileFilter excludeFilters(IOFileFilter inputFilter, IOFileFilter ... filters) {
        IOFileFilter retFilter = inputFilter;
        for (IOFileFilter filter : filters) {
            retFilter = FileFilterUtils.andFileFilter((IOFileFilter)retFilter, (IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)filter));
        }
        return retFilter;
    }

    static ImageReader getReader(ImageInputStream inStream) {
        Utilities.ensureNonNull((String)"inStream", (Object)inStream);
        inStream.mark();
        Iterator<ImageReader> readersIt = ImageIO.getImageReaders(inStream);
        if (!readersIt.hasNext()) {
            return null;
        }
        return readersIt.next();
    }

    static Rectangle getDimension(int imageIndex, ImageReader reader) throws IOException {
        Utilities.ensureNonNull((String)"reader", (Object)reader);
        if (imageIndex < 0) {
            throw new IllegalArgumentException(Errors.format((int)79, (Object)imageIndex));
        }
        return new Rectangle(0, 0, reader.getWidth(imageIndex), reader.getHeight(imageIndex));
    }

    public static boolean checkFileReadable(File file) {
        if (LOGGER.isLoggable(Level.FINE)) {
            String message = Utils.getFileInfo(file);
            LOGGER.fine(message);
        }
        return file.exists() && file.canRead() && file.isFile();
    }

    public static String getFileInfo(File file) {
        StringBuilder builder = new StringBuilder();
        builder.append("Checking file:").append(FilenameUtils.getFullPath((String)file.getAbsolutePath())).append("\n");
        builder.append("isHidden:").append(file.isHidden()).append("\n");
        builder.append("exists:").append(file.exists()).append("\n");
        builder.append("isFile").append(file.isFile()).append("\n");
        builder.append("canRead:").append(file.canRead()).append("\n");
        builder.append("canWrite").append(file.canWrite()).append("\n");
        builder.append("isAbsolute:").append(file.isAbsolute()).append("\n");
        builder.append("lastModified:").append(file.lastModified()).append("\n");
        builder.append("length:").append(file.length());
        String message = builder.toString();
        return message;
    }

    public static String checkDirectory(String testingDirectory, boolean writable) throws IllegalArgumentException {
        boolean failure;
        File inDir = new File(testingDirectory);
        boolean bl = failure = !inDir.exists() || !inDir.isDirectory() || inDir.isHidden() || !inDir.canRead();
        if (writable) {
            failure |= !inDir.canWrite();
        }
        if (failure) {
            String message = "Unable to create the mosaic\nlocation is:" + testingDirectory + "\n" + "location exists:" + inDir.exists() + "\n" + "location is a directory:" + inDir.isDirectory() + "\n" + "location is writable:" + inDir.canWrite() + "\n" + "location is readable:" + inDir.canRead() + "\n" + "location is hidden:" + inDir.isHidden() + "\n";
            LOGGER.severe(message);
            throw new IllegalArgumentException(message);
        }
        try {
            testingDirectory = inDir.getCanonicalPath();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        testingDirectory = FilenameUtils.normalize((String)testingDirectory);
        if (!testingDirectory.endsWith(File.separator)) {
            testingDirectory = testingDirectory + File.separator;
        }
        boolean bl2 = failure = !(inDir = new File(testingDirectory)).exists() || !inDir.isDirectory() || inDir.isHidden() || !inDir.canRead();
        if (writable) {
            failure |= !inDir.canWrite();
        }
        if (failure) {
            String message = "Unable to create the mosaic\nlocation is:" + testingDirectory + "\n" + "location exists:" + inDir.exists() + "\n" + "location is a directory:" + inDir.isDirectory() + "\n" + "location is writable:" + inDir.canWrite() + "\n" + "location is readable:" + inDir.canRead() + "\n" + "location is hidden:" + inDir.isHidden() + "\n";
            LOGGER.severe(message);
            throw new IllegalArgumentException(message);
        }
        return testingDirectory;
    }

    static boolean checkURLReadable(URL url) {
        try {
            url.openStream().close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static Map<String, Serializable> createDataStoreParamsFromPropertiesFile(URL datastoreProperties) throws IOException {
        Properties properties = Utils.loadPropertiesFromURL(datastoreProperties);
        if (properties == null) {
            return null;
        }
        String SPIClass = properties.getProperty("SPI");
        try {
            DataStoreFactorySpi spi = (DataStoreFactorySpi)Class.forName(SPIClass).newInstance();
            return Utils.createDataStoreParamsFromPropertiesFile(properties, spi);
        }
        catch (ClassNotFoundException e) {
            IOException ioe = new IOException();
            throw (IOException)ioe.initCause(e);
        }
        catch (InstantiationException e) {
            IOException ioe = new IOException();
            throw (IOException)ioe.initCause(e);
        }
        catch (IllegalAccessException e) {
            IOException ioe = new IOException();
            throw (IOException)ioe.initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeSampleImage(File sampleImageFile, SampleModel defaultSM, ColorModel defaultCM) throws IOException {
        SampleModel sm = defaultSM.createCompatibleSampleModel(1, 1);
        WritableRaster raster = RasterFactory.createWritableRaster((SampleModel)sm, null);
        BufferedImage sampleImage = new BufferedImage(defaultCM, raster, false, null);
        BufferedOutputStream outStream = null;
        ObjectOutputStream ooStream = null;
        SerializableRenderedImage sri = null;
        try {
            outStream = new BufferedOutputStream(new FileOutputStream(sampleImageFile));
            ooStream = new ObjectOutputStream(outStream);
            sri = new SerializableRenderedImage((RenderedImage)sampleImage, true);
            ooStream.writeObject(sri);
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            try {
                if (ooStream != null) {
                    ooStream.close();
                }
            }
            catch (Throwable e) {
                IOUtils.closeQuietly((OutputStream)ooStream);
            }
            try {
                if (outStream != null) {
                    ((OutputStream)outStream).close();
                }
            }
            catch (Throwable e) {
                IOUtils.closeQuietly((OutputStream)outStream);
            }
            try {
                if (sri != null) {
                    sri.dispose();
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (ooStream != null) {
                ooStream.close();
            }
        }
        catch (Throwable e) {
            IOUtils.closeQuietly((OutputStream)ooStream);
        }
        try {
            if (outStream != null) {
                ((OutputStream)outStream).close();
            }
        }
        catch (Throwable e) {
            IOUtils.closeQuietly((OutputStream)outStream);
        }
        try {
            if (sri != null) {
                sri.dispose();
            }
        }
        catch (Throwable e) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RenderedImage loadSampleImage(File sampleImageFile) {
        block39: {
            block33: {
                block38: {
                    block32: {
                        inStream = null;
                        oiStream = null;
                        try {
                            try {
                                if (Utils.checkFileReadable(sampleImageFile)) {
                                    inStream = new BufferedInputStream(new FileInputStream(sampleImageFile));
                                    oiStream = new ObjectInputStream(inStream);
                                    var3_3 = (RenderedImage)oiStream.readObject();
                                    var6_8 = null;
                                    break block32;
                                }
                                if (Utils.LOGGER.isLoggable(Level.WARNING)) {
                                    Utils.LOGGER.warning("Unable to find sample image for path " + sampleImageFile);
                                }
                                var3_4 = null;
                                break block33;
                            }
                            catch (FileNotFoundException e) {
                                block34: {
                                    if (Utils.LOGGER.isLoggable(Level.WARNING)) {
                                        Utils.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                                    }
                                    var4_20 = null;
                                    var6_10 = null;
                                    try {
                                        if (inStream != null) {
                                            inStream.close();
                                        }
                                    }
                                    catch (Throwable e) {
                                        if (!Utils.LOGGER.isLoggable(Level.FINE)) break block34;
                                        Utils.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                    }
                                }
                                try {
                                    if (oiStream == null) return var4_20;
                                    oiStream.close();
                                    return var4_20;
                                }
                                catch (Throwable e) {
                                    if (Utils.LOGGER.isLoggable(Level.FINE) == false) return var4_20;
                                    Utils.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                }
                                return var4_20;
                            }
                            catch (IOException e) {
                                block35: {
                                    if (Utils.LOGGER.isLoggable(Level.WARNING)) {
                                        Utils.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                                    }
                                    var4_21 = null;
                                    var6_11 = null;
                                    ** try [egrp 2[TRYBLOCK] [12 : 211->222)] { 
lbl46:
                                    // 1 sources

                                    if (inStream != null) {
                                        inStream.close();
                                    }
                                    break block35;
lbl49:
                                    // 1 sources

                                    catch (Throwable e) {
                                        if (!Utils.LOGGER.isLoggable(Level.FINE)) break block35;
                                        Utils.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                    }
                                }
                                ** try [egrp 3[TRYBLOCK] [13 : 252->263)] { 
lbl54:
                                // 1 sources

                                if (oiStream == null) return var4_21;
                                oiStream.close();
                                return var4_21;
lbl57:
                                // 1 sources

                                catch (Throwable e) {
                                    if (Utils.LOGGER.isLoggable(Level.FINE) == false) return var4_21;
                                    Utils.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                }
                                return var4_21;
                            }
                            catch (ClassNotFoundException e) {
                                block36: {
                                    if (Utils.LOGGER.isLoggable(Level.WARNING)) {
                                        Utils.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                                    }
                                    var4_22 = null;
                                    var6_12 = null;
                                    ** try [egrp 2[TRYBLOCK] [12 : 211->222)] { 
lbl68:
                                    // 1 sources

                                    if (inStream != null) {
                                        inStream.close();
                                    }
                                    break block36;
lbl71:
                                    // 1 sources

                                    catch (Throwable e) {
                                        if (!Utils.LOGGER.isLoggable(Level.FINE)) break block36;
                                        Utils.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                    }
                                }
                                ** try [egrp 3[TRYBLOCK] [13 : 252->263)] { 
lbl76:
                                // 1 sources

                                if (oiStream == null) return var4_22;
                                oiStream.close();
                                return var4_22;
lbl79:
                                // 1 sources

                                catch (Throwable e) {
                                    if (Utils.LOGGER.isLoggable(Level.FINE) == false) return var4_22;
                                    Utils.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                }
                                return var4_22;
                            }
                        }
                        catch (Throwable var5_23) {
                            block37: {
                                var6_13 = null;
                                ** try [egrp 2[TRYBLOCK] [12 : 211->222)] { 
lbl87:
                                // 1 sources

                                if (inStream != null) {
                                    inStream.close();
                                }
                                break block37;
lbl90:
                                // 1 sources

                                catch (Throwable e) {
                                    if (!Utils.LOGGER.isLoggable(Level.FINE)) break block37;
                                    Utils.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                }
                            }
                            try {}
                            catch (Throwable e) {
                                if (Utils.LOGGER.isLoggable(Level.FINE) == false) throw var5_23;
                                Utils.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                throw var5_23;
                            }
                            if (oiStream == null) throw var5_23;
                            oiStream.close();
                            throw var5_23;
                        }
                    }
                    ** try [egrp 2[TRYBLOCK] [12 : 211->222)] { 
lbl104:
                    // 1 sources

                    if (inStream != null) {
                        inStream.close();
                    }
                    break block38;
lbl107:
                    // 1 sources

                    catch (Throwable e) {
                        if (!Utils.LOGGER.isLoggable(Level.FINE)) break block38;
                        Utils.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                    }
                }
                ** try [egrp 3[TRYBLOCK] [13 : 252->263)] { 
lbl112:
                // 1 sources

                if (oiStream == null) return var3_3;
                oiStream.close();
                return var3_3;
lbl115:
                // 1 sources

                catch (Throwable e) {
                    if (Utils.LOGGER.isLoggable(Level.FINE) == false) return var3_3;
                    Utils.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                }
                return var3_3;
            }
            var6_9 = null;
            ** try [egrp 2[TRYBLOCK] [12 : 211->222)] { 
lbl122:
            // 1 sources

            if (inStream != null) {
                inStream.close();
            }
            break block39;
lbl125:
            // 1 sources

            catch (Throwable e) {
                if (!Utils.LOGGER.isLoggable(Level.FINE)) break block39;
                Utils.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
        }
        try {}
        catch (Throwable e) {
            if (Utils.LOGGER.isLoggable(Level.FINE) == false) return var3_4;
            Utils.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            return var3_4;
        }
        if (oiStream == null) return var3_4;
        oiStream.close();
        return var3_4;
    }

    static Number[] getBackgroundValues(SampleModel sampleModel, double[] backgroundValues) {
        Number[] values = null;
        int dataType = sampleModel != null ? sampleModel.getDataType() : 5;
        int numBands = sampleModel != null ? sampleModel.getNumBands() : 1;
        switch (dataType) {
            case 0: {
                values = new Byte[numBands];
                if (backgroundValues == null) {
                    Arrays.fill(values, (Object)0);
                    break;
                }
                for (int i = 0; i < values.length; ++i) {
                    values[i] = i >= backgroundValues.length ? Byte.valueOf((byte)backgroundValues[0]) : Byte.valueOf((byte)backgroundValues[i]);
                }
                break;
            }
            case 1: 
            case 2: {
                values = new Short[numBands];
                if (backgroundValues == null) {
                    Arrays.fill(values, (Object)0);
                    break;
                }
                for (int i = 0; i < values.length; ++i) {
                    values[i] = i >= backgroundValues.length ? Short.valueOf((short)backgroundValues[0]) : Short.valueOf((short)backgroundValues[i]);
                }
                break;
            }
            case 3: {
                values = new Integer[numBands];
                if (backgroundValues == null) {
                    Arrays.fill(values, (Object)0);
                    break;
                }
                for (int i = 0; i < values.length; ++i) {
                    values[i] = i >= backgroundValues.length ? Integer.valueOf((int)backgroundValues[0]) : Integer.valueOf((int)backgroundValues[i]);
                }
                break;
            }
            case 4: {
                values = new Float[numBands];
                if (backgroundValues == null) {
                    Arrays.fill(values, Float.valueOf(0.0f));
                    break;
                }
                for (int i = 0; i < values.length; ++i) {
                    values[i] = i >= backgroundValues.length ? Float.valueOf((float)backgroundValues[0]) : Float.valueOf((float)backgroundValues[i]);
                }
                break;
            }
            case 5: {
                values = new Double[numBands];
                if (backgroundValues == null) {
                    Arrays.fill(values, (Object)0.0);
                    break;
                }
                for (int i = 0; i < values.length; ++i) {
                    values[i] = i >= backgroundValues.length ? Double.valueOf(backgroundValues[0]) : Double.valueOf(backgroundValues[i]);
                }
                break;
            }
        }
        return values;
    }

    public static Map<String, Serializable> createDataStoreParamsFromPropertiesFile(Properties properties, DataStoreFactorySpi spi) throws IOException {
        DataAccessFactory.Param[] paramsInfo;
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        for (DataAccessFactory.Param p : paramsInfo = spi.getParametersInfo()) {
            if (properties.containsKey(p.key)) {
                params.put(p.key, (Serializable)Converters.convert((Object)properties.getProperty(p.key), (Class)p.type));
                continue;
            }
            if (!p.required || p.sample != null) continue;
            throw new IOException("Required parameter missing: " + p.toString());
        }
        return params;
    }

    static URL checkSource(Object source, Hints hints) {
        URL sourceURL = null;
        File sourceFile = null;
        if (source instanceof File) {
            sourceFile = (File)source;
            sourceURL = DataUtilities.fileToURL((File)sourceFile);
        } else if (source instanceof URL) {
            sourceURL = (URL)source;
            if (sourceURL.getProtocol().equals("file")) {
                sourceFile = DataUtilities.urlToFile((URL)sourceURL);
            }
        } else if (source instanceof String) {
            String tempSource = (String)source;
            File tempFile = new File(tempSource);
            if (!tempFile.exists()) {
                try {
                    sourceURL = new URL(tempSource);
                    source = DataUtilities.urlToFile((URL)sourceURL);
                }
                catch (MalformedURLException e) {
                    sourceURL = null;
                    source = null;
                }
            } else {
                sourceURL = DataUtilities.fileToURL((File)tempFile);
                sourceFile = tempFile;
            }
        }
        if (sourceFile != null) {
            if (!sourceFile.isDirectory()) {
                sourceURL = DataUtilities.fileToURL((File)sourceFile);
            } else {
                String locationPath = sourceFile.getAbsolutePath();
                String defaultIndexName = FilenameUtils.getName((String)locationPath);
                boolean datastoreFound = false;
                boolean buildMosaic = false;
                File dataStoreProperties = new File(locationPath, "datastore.properties");
                File[] properties = sourceFile.listFiles((FilenameFilter)FileFilterUtils.andFileFilter((IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.nameFileFilter((String)"datastore.properties")), (IOFileFilter)FileFilterUtils.makeFileOnly((IOFileFilter)FileFilterUtils.suffixFileFilter((String)".properties"))));
                if (Utils.checkFileReadable(dataStoreProperties)) {
                    datastoreFound = true;
                    boolean found = false;
                    for (File propFile : properties) {
                        if (!Utils.checkFileReadable(propFile) || null == Utils.loadMosaicProperties(DataUtilities.fileToURL((File)propFile), DEFAULT_LOCATION_ATTRIBUTE)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        buildMosaic = true;
                    }
                } else {
                    buildMosaic = true;
                    datastoreFound = false;
                }
                File shapeFile = null;
                if (!datastoreFound) {
                    for (File propFile : properties) {
                        if (null == Utils.loadMosaicProperties(DataUtilities.fileToURL((File)propFile), DEFAULT_LOCATION_ATTRIBUTE)) continue;
                        shapeFile = new File(locationPath, FilenameUtils.getBaseName((String)propFile.getName()) + ".shp");
                        if (!Utils.checkFileReadable(shapeFile) && Utils.checkFileReadable(propFile)) {
                            buildMosaic = true;
                            continue;
                        }
                        buildMosaic = false;
                        break;
                    }
                }
                if (buildMosaic) {
                    File mosaicDirectory = new File(locationPath);
                    if (!mosaicDirectory.exists() || mosaicDirectory.isFile() || !mosaicDirectory.canWrite()) {
                        if (LOGGER.isLoggable(Level.SEVERE)) {
                            LOGGER.log(Level.SEVERE, "Unable to create the mosaic, check the location:\nlocation is:" + locationPath + "\n" + "location exists:" + mosaicDirectory.exists() + "\n" + "location is a directory:" + mosaicDirectory.isDirectory() + "\n" + "location is writable:" + mosaicDirectory.canWrite() + "\n" + "location is readable:" + mosaicDirectory.canRead() + "\n" + "location is hidden:" + mosaicDirectory.isHidden() + "\n");
                        }
                        return null;
                    }
                    Utils.createMosaic(locationPath, defaultIndexName, DEFAULT_WILCARD, false, hints);
                    File propertiesFile = new File(locationPath, defaultIndexName + ".properties");
                    if (!Utils.checkFileReadable(propertiesFile)) {
                        sourceURL = null;
                        return sourceURL;
                    }
                    sourceURL = !datastoreFound ? (!Utils.checkFileReadable(shapeFile = new File(locationPath, defaultIndexName + ".shp")) ? null : DataUtilities.fileToURL((File)shapeFile)) : (!Utils.checkFileReadable(dataStoreProperties = new File(locationPath, "datastore.properties")) ? null : DataUtilities.fileToURL((File)dataStoreProperties));
                } else {
                    sourceURL = datastoreFound ? DataUtilities.fileToURL((File)dataStoreProperties) : DataUtilities.fileToURL(shapeFile);
                }
            }
        }
        return sourceURL;
    }

    public static ImageReader getReader(RenderedImage rOp) {
        if (rOp != null && rOp instanceof RenderedOp) {
            RenderedOp renderedOp = (RenderedOp)rOp;
            int nSources = renderedOp.getNumSources();
            if (nSources > 0) {
                for (int k = 0; k < nSources; ++k) {
                    Object source = null;
                    try {
                        source = renderedOp.getSourceObject(k);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        // empty catch block
                    }
                    if (source == null || !(source instanceof RenderedOp)) continue;
                    Utils.getReader((RenderedImage)((RenderedOp)source));
                }
            } else {
                Object imageReader = rOp.getProperty("JAI.ImageReader");
                if (imageReader != null && imageReader instanceof ImageReader) {
                    ImageReader reader = (ImageReader)imageReader;
                    return reader;
                }
            }
        }
        return null;
    }

    private Utils(Cache ehcache) {
        Utils.ehcache = ehcache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Histogram getHistogram(String file) {
        FileInputStream fileStream;
        Histogram histogram;
        block16: {
            Serializable value;
            Element element;
            Utilities.ensureNonNull((String)"file", (Object)file);
            histogram = null;
            if (ehcache != null && ehcache.isKeyInCache((Object)file) && ehcache.isElementInMemory((Serializable)((Object)file)) && (element = ehcache.get((Serializable)((Object)file))) != null && (value = element.getValue()) != null && value instanceof Histogram) {
                return (Histogram)value;
            }
            if (histogram != null) return histogram;
            fileStream = null;
            ObjectInputStream objectStream = null;
            try {
                try {
                    fileStream = new FileInputStream(file);
                    objectStream = new ObjectInputStream(fileStream);
                    histogram = (Histogram)objectStream.readObject();
                    if (ehcache != null) {
                        ehcache.put(new Element((Serializable)((Object)file), (Serializable)histogram));
                    }
                }
                catch (FileNotFoundException e) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Unable to parse Histogram:" + e.getLocalizedMessage());
                    }
                    Object var6_5 = null;
                    if (objectStream != null) {
                        IOUtils.closeQuietly((InputStream)objectStream);
                    }
                    if (fileStream == null) return histogram;
                    IOUtils.closeQuietly((InputStream)fileStream);
                    return histogram;
                }
                catch (IOException e) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Unable to parse Histogram:" + e.getLocalizedMessage());
                    }
                    Object var6_6 = null;
                    if (objectStream != null) {
                        IOUtils.closeQuietly((InputStream)objectStream);
                    }
                    if (fileStream == null) return histogram;
                    IOUtils.closeQuietly((InputStream)fileStream);
                    return histogram;
                }
                catch (ClassNotFoundException e) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Unable to parse Histogram:" + e.getLocalizedMessage());
                    }
                    Object var6_7 = null;
                    if (objectStream != null) {
                        IOUtils.closeQuietly((InputStream)objectStream);
                    }
                    if (fileStream == null) return histogram;
                    IOUtils.closeQuietly((InputStream)fileStream);
                    return histogram;
                }
                Object var6_4 = null;
                if (objectStream == null) break block16;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (objectStream != null) {
                    IOUtils.closeQuietly(objectStream);
                }
                if (fileStream == null) throw throwable;
                IOUtils.closeQuietly((InputStream)fileStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)objectStream);
        }
        if (fileStream == null) return histogram;
        IOUtils.closeQuietly((InputStream)fileStream);
        return histogram;
    }

    static boolean areaIsDifferent(Geometry granuleFootprint, AffineTransform baseGridToWorld, ReferencedEnvelope granuleBBOX) {
        double bboxArea;
        Envelope envelope = granuleFootprint.getEnvelope().getEnvelopeInternal();
        double deltaMinX = Math.abs(envelope.getMinX() - granuleBBOX.getMinX());
        double deltaMinY = Math.abs(envelope.getMinY() - granuleBBOX.getMinY());
        double deltaMaxX = Math.abs(envelope.getMaxX() - granuleBBOX.getMaxX());
        double deltaMaxY = Math.abs(envelope.getMaxY() - granuleBBOX.getMaxY());
        double resX = XAffineTransform.getScaleX0((AffineTransform)baseGridToWorld);
        double resY = XAffineTransform.getScaleY0((AffineTransform)baseGridToWorld);
        double toleranceX = resX / 20.0;
        double toleranceY = resY / 20.0;
        double cellArea = resX * resY;
        if (deltaMinX > toleranceX || deltaMaxX > toleranceX || deltaMinY > toleranceY || deltaMaxY > toleranceY) {
            return true;
        }
        double footprintArea = granuleFootprint.getArea();
        return Math.abs(footprintArea - (bboxArea = granuleBBOX.getHeight() * granuleBBOX.getWidth())) > cellArea;
    }

    static Rectangle toRectangle(Shape shape) {
        int i;
        if (shape instanceof Rectangle) {
            return (Rectangle)shape;
        }
        if (shape == null) {
            return null;
        }
        PathIterator iter = shape.getPathIterator(new AffineTransform());
        double[] coords = new double[2];
        if (iter.isDone()) {
            return null;
        }
        iter.next();
        int action = iter.currentSegment(coords);
        if (action != 0 && action != 1) {
            return null;
        }
        double minx = coords[0];
        double miny = coords[1];
        double maxx = minx;
        double maxy = miny;
        double prevx = minx;
        double prevy = miny;
        for (i = 0; i < 4 && !iter.isDone(); ++i) {
            iter.next();
            action = iter.currentSegment(coords);
            if (action == 4) break;
            if (action != 1) {
                return null;
            }
            double x = coords[0];
            double y = coords[1];
            if (!(prevx == x && prevy != y || prevx != x && prevy == y)) {
                return null;
            }
            if (x < minx) {
                minx = x;
            } else if (x > maxx) {
                maxx = x;
            }
            if (y < miny) {
                miny = y;
            } else if (y > maxy) {
                maxy = y;
            }
            prevx = x;
            prevy = y;
        }
        iter.next();
        if (!iter.isDone() || i != 3) {
            return null;
        }
        return new Rectangle2D.Double(minx, miny, maxx - minx, maxy - miny).getBounds();
    }

    static {
        RGB_TO_GRAY_MATRIX = new double[][]{{0.114, 0.587, 0.299, 0.0}};
        String prop = System.getProperty("org.geotools.imagemosaic.optimizecrop");
        OPTIMIZE_CROP = prop == null || !prop.equalsIgnoreCase("FALSE");
        rationalTolerance = 1.0E-6f;
        LOGGER = Logging.getLogger((String)Utils.class.toString());
        SHAPE_SPI = new ShapefileDataStoreFactory();
        TRANSPARENT = new Color(0, 0, 0, 0);
        IGNORE_FOOTPRINT = Boolean.getBoolean("org.geotools.footprint.ignore");
    }

    public static class Prop {
        public static final String LOCATION_ATTRIBUTE = "LocationAttribute";
        public static final String ENVELOPE2D = "Envelope2D";
        public static final String LEVELS_NUM = "LevelsNum";
        public static final String LEVELS = "Levels";
        public static final String SUGGESTED_SPI = "SuggestedSPI";
        public static final String EXP_RGB = "ExpandToRGB";
        public static final String ABSOLUTE_PATH = "AbsolutePath";
        public static final String NAME = "Name";
        public static final String FOOTPRINT_MANAGEMENT = "FootprintManagement";
        public static final String HETEROGENEOUS = "Heterogeneous";
        public static final String TIME_ATTRIBUTE = "TimeAttribute";
        public static final String ELEVATION_ATTRIBUTE = "ElevationAttribute";
        public static final String CACHING = "Caching";
        public static final String RECURSIVE = "Recursive";
        public static final String WILDCARD = "Wildcard";
        public static final String SCHEMA = "Schema";
        public static final String RESOLUTION_LEVELS = "ResolutionLevels";
        public static final String PROPERTY_COLLECTORS = "PropertyCollectors";
    }
}

