/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.properties.time;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.gce.imagemosaic.properties.PropertiesCollectorSPI;
import org.geotools.gce.imagemosaic.properties.RegExPropertiesCollector;
import org.geotools.gce.imagemosaic.properties.time.TimeParser;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TimestampFileNameExtractor
extends RegExPropertiesCollector {
    private static final Logger LOGGER = Logging.getLogger(TimestampFileNameExtractor.class);
    private static final TimeParser parser = new TimeParser();

    public TimestampFileNameExtractor(PropertiesCollectorSPI spi, List<String> propertyNames, String regex) {
        super(spi, propertyNames, regex);
    }

    @Override
    public void setProperties(SimpleFeature feature) {
        ArrayList<Date> dates = new ArrayList<Date>();
        for (String match : this.getMatches()) {
            try {
                dates.addAll(parser.parse(match));
            }
            catch (ParseException e) {
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
        }
        if (dates.size() <= 0 && LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("No matches found for this property extractor:");
        }
        int index = 0;
        for (String propertyName : this.getPropertyNames()) {
            feature.setAttribute(propertyName, dates.get(index++));
            if (index < dates.size()) continue;
            return;
        }
    }
}

