/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalog;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.index.ItemVisitor;
import com.vividsolutions.jts.index.strtree.STRtree;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.feature.visitor.FeatureCalc;
import org.geotools.gce.imagemosaic.GranuleDescriptor;
import org.geotools.gce.imagemosaic.catalog.AbstractGranuleCatalog;
import org.geotools.gce.imagemosaic.catalog.GTDataStoreGranuleCatalog;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalog;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalogVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.resources.coverage.FeatureUtilities;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.geometry.BoundingBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class STRTreeGranuleCatalog
extends AbstractGranuleCatalog {
    static final Logger LOGGER = Logging.getLogger(STRTreeGranuleCatalog.class);
    private GranuleCatalog wrappedCatalogue;
    private STRtree index;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock(true);

    public STRTreeGranuleCatalog(Map<String, Serializable> params, DataStoreFactorySpi spi) {
        this(new GTDataStoreGranuleCatalog(params, false, spi));
    }

    public STRTreeGranuleCatalog(GranuleCatalog catalogue) {
        Utilities.ensureNonNull((String)"catalogue", (Object)catalogue);
        this.wrappedCatalogue = catalogue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIndex(Lock readLock) throws IOException {
        Lock writeLock = this.rwLock.writeLock();
        try {
            readLock.unlock();
            writeLock.lock();
            if (this.index == null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("No index exits and we create a new one.");
                }
                this.createIndex();
            } else if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Index does not need to be created...");
            }
            Object var4_3 = null;
            readLock.lock();
            writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            readLock.lock();
            writeLock.unlock();
            throw throwable;
        }
    }

    private void createIndex() {
        Iterator<GranuleDescriptor> it = null;
        Collection<GranuleDescriptor> features = null;
        try {
            features = this.wrappedCatalogue.getGranules();
            if (features == null) {
                throw new NullPointerException("The provided SimpleFeatureCollection is null, it's impossible to create an index!");
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Index Loaded");
            }
            if (!(it = features.iterator()).hasNext()) {
                throw new IllegalArgumentException("The provided SimpleFeatureCollection  or empty, it's impossible to create an index!");
            }
            STRtree tree = new STRtree();
            long size = 0L;
            while (it.hasNext()) {
                GranuleDescriptor granule = it.next();
                ReferencedEnvelope env = ReferencedEnvelope.reference((BoundingBox)granule.getGranuleBBOX());
                Polygon g = FeatureUtilities.getPolygon((Rectangle2D)new Rectangle2D.Double(env.getMinX(), env.getMinY(), env.getWidth(), env.getHeight()), (int)0);
                tree.insert(g.getEnvelopeInternal(), (Object)granule);
            }
            tree.build();
            this.index = tree;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GranuleDescriptor> getGranules(BoundingBox envelope) throws IOException {
        Utilities.ensureNonNull((String)"envelope", (Object)envelope);
        Lock lock = this.rwLock.readLock();
        try {
            lock.lock();
            this.checkStore();
            this.checkIndex(lock);
            List list = this.index.query((Envelope)ReferencedEnvelope.reference((BoundingBox)envelope));
            Object var5_4 = null;
            lock.unlock();
            return list;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getGranules(BoundingBox envelope, GranuleCatalogVisitor visitor) throws IOException {
        Utilities.ensureNonNull((String)"envelope", (Object)envelope);
        Utilities.ensureNonNull((String)"visitor", (Object)visitor);
        Lock lock = this.rwLock.readLock();
        try {
            lock.lock();
            this.checkStore();
            this.checkIndex(lock);
            this.index.query((Envelope)ReferencedEnvelope.reference((BoundingBox)envelope), (ItemVisitor)new JTSIndexVisitorAdapter(visitor));
            Object var5_4 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Lock l = this.rwLock.writeLock();
        try {
            block5: {
                l.lock();
                if (this.wrappedCatalogue != null) {
                    try {
                        this.wrappedCatalogue.dispose();
                    }
                    catch (Exception e) {
                        if (!LOGGER.isLoggable(Level.FINE)) break block5;
                        LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                    }
                }
            }
            Object var4_3 = null;
            this.wrappedCatalogue = null;
            this.index = null;
            l.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.wrappedCatalogue = null;
            this.index = null;
            l.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GranuleDescriptor> getGranules(Query q) throws IOException {
        List features;
        Filter filter;
        Lock lock;
        block4: {
            Utilities.ensureNonNull((String)"q", (Object)q);
            lock = this.rwLock.readLock();
            lock.lock();
            this.checkStore();
            filter = q.getFilter();
            ReferencedEnvelope requestedBBox = this.extractAndCombineBBox(filter);
            this.checkIndex(lock);
            features = this.index.query((Envelope)requestedBBox);
            if (!q.equals((Object)Query.ALL)) break block4;
            List list = features;
            Object var13_8 = null;
            lock.unlock();
            return list;
        }
        try {
            ArrayList<GranuleDescriptor> retVal = new ArrayList<GranuleDescriptor>();
            int maxGranules = q.getMaxFeatures();
            int numGranules = 0;
            for (GranuleDescriptor g : features) {
                if (maxGranules > 0 && numGranules >= maxGranules) break;
                SimpleFeature originator = g.getOriginator();
                if (originator == null || !filter.evaluate((Object)originator)) continue;
                retVal.add(g);
            }
            ArrayList<GranuleDescriptor> arrayList = retVal;
            Object var13_9 = null;
            lock.unlock();
            return arrayList;
        }
        catch (Throwable throwable) {
            Object var13_10 = null;
            lock.unlock();
            throw throwable;
        }
    }

    private ReferencedEnvelope extractAndCombineBBox(Filter filter) {
        GTDataStoreGranuleCatalog.BBOXFilterExtractor bboxExtractor = new GTDataStoreGranuleCatalog.BBOXFilterExtractor();
        filter.accept((FilterVisitor)bboxExtractor, null);
        ReferencedEnvelope requestedBBox = bboxExtractor.getBBox();
        if (requestedBBox == null) {
            return ReferencedEnvelope.reference((BoundingBox)this.wrappedCatalogue.getBounds());
        }
        Envelope intersection = requestedBBox.intersection((Envelope)ReferencedEnvelope.reference((BoundingBox)this.wrappedCatalogue.getBounds()));
        ReferencedEnvelope referencedEnvelope = new ReferencedEnvelope(intersection, this.wrappedCatalogue.getBounds().getCoordinateReferenceSystem());
        return requestedBBox;
    }

    public List<GranuleDescriptor> getGranules() throws IOException {
        return this.getGranules(this.getBounds());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getGranules(Query q, GranuleCatalogVisitor visitor) throws IOException {
        Utilities.ensureNonNull((String)"q", (Object)q);
        Lock lock = this.rwLock.readLock();
        try {
            lock.lock();
            this.checkStore();
            Filter filter = q.getFilter();
            ReferencedEnvelope requestedBBox = this.extractAndCombineBBox(filter);
            this.checkIndex(lock);
            this.index.query((Envelope)requestedBBox, (ItemVisitor)new JTSIndexVisitorAdapter(visitor, q));
            Object var7_6 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BoundingBox getBounds() {
        Lock lock = this.rwLock.readLock();
        try {
            lock.lock();
            this.checkStore();
            BoundingBox boundingBox = this.wrappedCatalogue.getBounds();
            Object var4_3 = null;
            lock.unlock();
            return boundingBox;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    private void checkStore() throws IllegalStateException {
        if (this.wrappedCatalogue == null) {
            throw new IllegalStateException("The underlying store has already been disposed!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SimpleFeatureType getType() throws IOException {
        Lock lock = this.rwLock.readLock();
        try {
            lock.lock();
            this.checkStore();
            SimpleFeatureType simpleFeatureType = this.wrappedCatalogue.getType();
            Object var4_3 = null;
            lock.unlock();
            return simpleFeatureType;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void computeAggregateFunction(Query query, FeatureCalc function) throws IOException {
        Lock lock = this.rwLock.readLock();
        try {
            lock.lock();
            this.checkStore();
            this.wrappedCatalogue.computeAggregateFunction(query, function);
            Object var5_4 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryCapabilities getQueryCapabilities() {
        Lock lock = this.rwLock.readLock();
        try {
            lock.lock();
            this.checkStore();
            QueryCapabilities queryCapabilities = this.wrappedCatalogue.getQueryCapabilities();
            Object var4_3 = null;
            lock.unlock();
            return queryCapabilities;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    private static class JTSIndexVisitorAdapter
    implements ItemVisitor {
        private GranuleCatalogVisitor adaptee;
        private Filter filter;
        private int maxGranules = -1;
        private int granuleIndex = 0;

        public JTSIndexVisitorAdapter(GranuleCatalogVisitor adaptee) {
            this(adaptee, (Query)null);
        }

        public JTSIndexVisitorAdapter(GranuleCatalogVisitor adaptee, Query q) {
            this.adaptee = adaptee;
            this.filter = q == null ? Query.ALL.getFilter() : q.getFilter();
            this.maxGranules = q.getMaxFeatures();
        }

        public JTSIndexVisitorAdapter(GranuleCatalogVisitor adaptee, Filter filter) {
            this.adaptee = adaptee;
            this.filter = filter == null ? Query.ALL.getFilter() : filter;
        }

        public void visitItem(Object o) {
            if (this.maxGranules > 0 && this.granuleIndex > this.maxGranules) {
                return;
            }
            if (o instanceof GranuleDescriptor) {
                GranuleDescriptor g = (GranuleDescriptor)o;
                SimpleFeature originator = g.getOriginator();
                if (originator != null && this.filter.evaluate((Object)originator)) {
                    this.adaptee.visit(g, null);
                    ++this.granuleIndex;
                }
                return;
            }
            throw new IllegalArgumentException("Unable to visit provided item" + o);
        }
    }
}

