/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FootprintUtils {
    static final Set<String> IGNORE_PROPS = new HashSet<String>();
    static final String FOOTPRINT_EXT = ".fpt";
    static final String FOOTPRINT_PREFIX = "footprint";
    static final String FOOTPRINT = "footprint.shp";
    private static final Logger LOGGER;

    private FootprintUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static void initFootprintsGranuleIDGeometryMap(File footprintSummaryFile, Map<String, Geometry> footprintsIDGeometryMap) {
        block22: {
            String footprint;
            Utilities.ensureNonNull((String)"footprintSummaryFile", (Object)footprintSummaryFile);
            if (!footprintSummaryFile.exists() || !footprintSummaryFile.canRead()) {
                throw new IllegalArgumentException("Unable to access to the provided footprint file " + footprintSummaryFile.getAbsolutePath());
            }
            Utilities.ensureNonNull((String)"footprintsID_GeometryMap", footprintsIDGeometryMap);
            FileReader reader = null;
            reader = new FileReader(footprintSummaryFile);
            BufferedReader bReader = new BufferedReader(reader);
            WKTReader geometryReader = new WKTReader();
            while ((footprint = bReader.readLine()) != null) {
                String[] fpt = footprint.split("=");
                if (fpt.length != 2) continue;
                footprintsIDGeometryMap.put(fpt[0], geometryReader.read(fpt[1]));
            }
            bReader.close();
            Object var8_9 = null;
            try {
                if (reader != null) {
                    reader.close();
                }
                break block22;
            }
            catch (Throwable e2) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, e2.getLocalizedMessage(), e2);
                }
                IOUtils.closeQuietly((Reader)reader);
            }
            break block22;
            {
                catch (IOException e) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                    }
                    Object var8_10 = null;
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        break block22;
                    }
                    catch (Throwable e2) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, e2.getLocalizedMessage(), e2);
                        }
                        IOUtils.closeQuietly((Reader)reader);
                    }
                    break block22;
                }
                catch (ParseException e) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                    }
                    Object var8_11 = null;
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        break block22;
                    }
                    catch (Throwable e2) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, e2.getLocalizedMessage(), e2);
                        }
                        IOUtils.closeQuietly((Reader)reader);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (Throwable e2) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, e2.getLocalizedMessage(), e2);
                    }
                    IOUtils.closeQuietly((Reader)reader);
                }
                throw throwable;
            }
        }
    }

    static Geometry lookupFootprintGeometry(String featureID, Map<String, Geometry> footprintsMap) {
        Utilities.ensureNonNull((String)"featureID", (Object)featureID);
        Utilities.ensureNonNull((String)"footprintsMap", footprintsMap);
        if (footprintsMap != null && !footprintsMap.isEmpty()) {
            String id = featureID.substring(featureID.lastIndexOf(".") + 1, featureID.length());
            return footprintsMap.containsKey(id) ? footprintsMap.get(id) : null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initFootprintsLocationGeometryMap(ShapefileDataStore footprintStore, Map<String, Geometry> footprintsMap) throws IOException {
        Utilities.ensureNonNull((String)"footprintStore", (Object)footprintStore);
        Utilities.ensureNonNull((String)"footprintsMap", footprintsMap);
        String[] typeNames = footprintStore.getTypeNames();
        if (typeNames.length <= 0) {
            throw new IllegalArgumentException("Problems when opening the footprint, no typenames for the schema are defined");
        }
        String typeName = typeNames[0];
        SimpleFeatureSource featureSource = footprintStore.getFeatureSource(typeName);
        FeatureCollection features = featureSource.getFeatures();
        if (features == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("No features found in the footprint");
            }
            return;
        }
        FeatureIterator it = null;
        try {
            it = features.features();
            if (!it.hasNext()) {
                throw new IllegalArgumentException("The provided FeatureCollection<SimpleFeatureType, SimpleFeature>  or empty, it's impossible to create an index!");
            }
            while (it.hasNext()) {
                SimpleFeature feature = (SimpleFeature)it.next();
                Geometry g = (Geometry)feature.getDefaultGeometry();
                String location = (String)feature.getAttribute("location");
                footprintsMap.put(location, g);
            }
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            try {
                if (it != null) {
                    it.close();
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                it.close();
            }
            catch (Throwable e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (it != null) {
                it.close();
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            it.close();
        }
        catch (Throwable e) {}
    }

    private static String buildIDGeometryPair(Map<String, Geometry> footprintGeometryMap, String featureID, String locationKey, WKTWriter writer) {
        Geometry polygon;
        String idGeometryPair = "";
        Utilities.ensureNonNull((String)"featureID", (Object)featureID);
        Utilities.ensureNonNull((String)"writer", (Object)writer);
        Utilities.ensureNonNull((String)"locationKey", (Object)locationKey);
        Utilities.ensureNonNull((String)"footprintGeometryMap", footprintGeometryMap);
        if (!footprintGeometryMap.isEmpty() && footprintGeometryMap.containsKey(locationKey) && (polygon = footprintGeometryMap.get(locationKey)) != null) {
            String s = writer.write(polygon);
            String id = featureID;
            id = id.substring(id.lastIndexOf(".") + 1, id.length());
            idGeometryPair = id + "=" + s + "\n";
        }
        return idGeometryPair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void writeFootprintSummary(File footprintSummaryFile, File indexFile, Map<String, Geometry> footprintsLocationGeometryMap) throws MalformedURLException {
        Utilities.ensureNonNull((String)"footprintSummaryFile", (Object)footprintSummaryFile);
        Utilities.ensureNonNull((String)"indexFile", (Object)indexFile);
        Utilities.ensureNonNull((String)"footprintsLocationGeometryMap", footprintsLocationGeometryMap);
        if (footprintsLocationGeometryMap.isEmpty()) {
            return;
        }
        store = new ShapefileDataStore(indexFile.toURI().toURL());
        if (footprintsLocationGeometryMap.isEmpty()) {
            return;
        }
        typeNames = store.getTypeNames();
        if (typeNames.length <= 0) {
            throw new IllegalArgumentException("Problems when opening the shapefile, no typenames for the schema are defined");
        }
        typeName = typeNames[0];
        footprintWriter = null;
        it = null;
        try {
            block44: {
                featureSource = store.getFeatureSource(typeName);
                features = featureSource.getFeatures();
                if (features != null) break block44;
                if (FootprintUtils.LOGGER.isLoggable(Level.FINE)) {
                    FootprintUtils.LOGGER.fine("No features found in the shapefile");
                }
                var17_11 = null;
                ** GOTO lbl102
            }
            it = features.features();
            if (!it.hasNext()) {
                throw new IllegalArgumentException("The provided FeatureCollection<SimpleFeatureType, SimpleFeature>  or empty, it's impossible to create an index!");
            }
            footprintWriter = new FileWriter(footprintSummaryFile);
            writer = new BufferedWriter(footprintWriter);
            geometryWriter = new WKTWriter();
            while (it.hasNext()) {
                feature = (SimpleFeature)it.next();
                location = (String)feature.getAttribute("location");
                if (location == null || location.trim().length() <= 0 || !footprintsLocationGeometryMap.containsKey(locationKey = location)) continue;
                idGeometryPair = FootprintUtils.buildIDGeometryPair(footprintsLocationGeometryMap, feature.getID(), locationKey, geometryWriter);
                writer.write(idGeometryPair);
            }
            writer.flush();
            writer.close();
            ** GOTO lbl128
        }
        catch (Throwable e) {
            block39: {
                if (FootprintUtils.LOGGER.isLoggable(Level.FINEST)) {
                    FootprintUtils.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                }
                var17_13 = null;
                try {
                    if (it != null) {
                        it.close();
                    }
                }
                catch (Throwable e) {
                    if (!FootprintUtils.LOGGER.isLoggable(Level.FINEST)) break block39;
                    FootprintUtils.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                }
            }
            try {
                if (footprintWriter != null) {
                    footprintWriter.flush();
                    footprintWriter.close();
                }
            }
            catch (Throwable e) {
                if (FootprintUtils.LOGGER.isLoggable(Level.FINEST)) {
                    FootprintUtils.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                }
                IOUtils.closeQuietly((Writer)footprintWriter);
            }
            footprintWriter = null;
            try {
                store.dispose();
                return;
            }
            catch (Throwable e) {
                if (FootprintUtils.LOGGER.isLoggable(Level.FINEST) == false) return;
                FootprintUtils.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                return;
            }
        }
        {
            block47: {
                block43: {
                    block46: {
                        block42: {
                            catch (Throwable var16_25) {
                                block45: {
                                    block41: {
                                        var17_14 = null;
                                        ** try [egrp 2[TRYBLOCK] [6 : 348->363)] { 
lbl77:
                                        // 1 sources

                                        if (it != null) {
                                            it.close();
                                        }
                                        break block41;
lbl80:
                                        // 1 sources

                                        catch (Throwable e) {
                                            if (!FootprintUtils.LOGGER.isLoggable(Level.FINEST)) break block41;
                                            FootprintUtils.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                        }
                                    }
                                    ** try [egrp 3[TRYBLOCK] [7 : 393->411)] { 
lbl85:
                                    // 1 sources

                                    if (footprintWriter != null) {
                                        footprintWriter.flush();
                                        footprintWriter.close();
                                    }
                                    break block45;
lbl89:
                                    // 1 sources

                                    catch (Throwable e) {
                                        if (FootprintUtils.LOGGER.isLoggable(Level.FINEST)) {
                                            FootprintUtils.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                        }
                                        IOUtils.closeQuietly((Writer)footprintWriter);
                                    }
                                }
                                footprintWriter = null;
                                ** try [egrp 4[TRYBLOCK] [8 : 449->456)] { 
lbl96:
                                // 1 sources

                                store.dispose();
                                throw var16_25;
lbl98:
                                // 1 sources

                                catch (Throwable e) {
                                    if (FootprintUtils.LOGGER.isLoggable(Level.FINEST) == false) throw var16_25;
                                    FootprintUtils.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                }
                                throw var16_25;
                            }
lbl102:
                            // 1 sources

                            ** try [egrp 2[TRYBLOCK] [6 : 348->363)] { 
lbl103:
                            // 1 sources

                            if (it != null) {
                                it.close();
                            }
                            break block42;
lbl106:
                            // 1 sources

                            catch (Throwable e) {
                                if (!FootprintUtils.LOGGER.isLoggable(Level.FINEST)) break block42;
                                FootprintUtils.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                            }
                        }
                        ** try [egrp 3[TRYBLOCK] [7 : 393->411)] { 
lbl111:
                        // 1 sources

                        if (footprintWriter != null) {
                            footprintWriter.flush();
                            footprintWriter.close();
                        }
                        break block46;
lbl115:
                        // 1 sources

                        catch (Throwable e) {
                            if (FootprintUtils.LOGGER.isLoggable(Level.FINEST)) {
                                FootprintUtils.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                            }
                            IOUtils.closeQuietly((Writer)footprintWriter);
                        }
                    }
                    footprintWriter = null;
                    ** try [egrp 4[TRYBLOCK] [8 : 449->456)] { 
lbl122:
                    // 1 sources

                    store.dispose();
                    return;
lbl124:
                    // 1 sources

                    catch (Throwable e) {
                        if (FootprintUtils.LOGGER.isLoggable(Level.FINEST) == false) return;
                        FootprintUtils.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                    }
                    return;
lbl128:
                    // 1 sources

                    var17_12 = null;
                    ** try [egrp 2[TRYBLOCK] [6 : 348->363)] { 
lbl130:
                    // 1 sources

                    if (it != null) {
                        it.close();
                    }
                    break block43;
lbl133:
                    // 1 sources

                    catch (Throwable e) {
                        if (!FootprintUtils.LOGGER.isLoggable(Level.FINEST)) break block43;
                        FootprintUtils.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                    }
                }
                ** try [egrp 3[TRYBLOCK] [7 : 393->411)] { 
lbl138:
                // 1 sources

                if (footprintWriter != null) {
                    footprintWriter.flush();
                    footprintWriter.close();
                }
                break block47;
lbl142:
                // 1 sources

                catch (Throwable e) {
                    if (FootprintUtils.LOGGER.isLoggable(Level.FINEST)) {
                        FootprintUtils.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                    }
                    IOUtils.closeQuietly((Writer)footprintWriter);
                }
            }
            footprintWriter = null;
            try {}
            catch (Throwable e) {}
            if (FootprintUtils.LOGGER.isLoggable(Level.FINEST) == false) return;
            FootprintUtils.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
            return;
            store.dispose();
            return;
        }
    }

    static File searchFootprint(String indexingDirectory) {
        File file;
        File footprintFile = null;
        if (indexingDirectory != null && indexingDirectory.trim().length() > 0 && (file = new File(indexingDirectory, FOOTPRINT)) != null && file.exists()) {
            footprintFile = file;
        }
        return footprintFile;
    }

    static {
        IGNORE_PROPS.add("Envelope2D");
        IGNORE_PROPS.add("AbsolutePath");
        IGNORE_PROPS.add("SuggestedSPI");
        IGNORE_PROPS.add("ExpandToRGB");
        IGNORE_PROPS.add("Levels");
        IGNORE_PROPS.add("LocationAttribute");
        IGNORE_PROPS.add("Name");
        LOGGER = Logging.getLogger(FootprintUtils.class);
    }
}

