/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalogbuilder;

import com.sun.media.imageioimpl.common.BogusColorSpace;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.SampleModel;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.spi.ImageReaderSpi;
import javax.swing.SwingUtilities;
import org.apache.commons.io.DirectoryWalker;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.HiddenFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridFormatFinder;
import org.geotools.coverage.grid.io.UnknownFormat;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.gce.image.WorldImageFormat;
import org.geotools.gce.imagemosaic.MosaicConfigurationBean;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalog;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalogFactory;
import org.geotools.gce.imagemosaic.catalogbuilder.CatalogBuilderConfiguration;
import org.geotools.gce.imagemosaic.properties.PropertiesCollector;
import org.geotools.gce.imagemosaic.properties.PropertiesCollectorFinder;
import org.geotools.gce.imagemosaic.properties.PropertiesCollectorSPI;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.io.ImageIOExt;
import org.geotools.referencing.CRS;
import org.geotools.resources.coverage.CoverageUtilities;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;

public class CatalogBuilder
implements Runnable {
    private static final double RESOLUTION_TOLERANCE_FACTOR = 0.01;
    static final Logger LOGGER = Logging.getLogger(CatalogBuilder.class);
    private int numFiles;
    private List<ProcessingEventListener> notificationListeners = new CopyOnWriteArrayList<ProcessingEventListener>();
    private boolean sendDelayedMessages = false;
    private volatile boolean stop = false;
    private MosaicConfigurationBean mosaicConfiguration;
    private GeometryFactory geomFactory;
    private GranuleCatalog catalog;
    private int numberOfProcessedFiles;
    private boolean mustConvertToRGB = false;
    private int fileIndex = 0;
    private ColorModel defaultCM = null;
    private CoordinateReferenceSystem defaultCRS = null;
    private byte[][] defaultPalette = null;
    private CatalogBuilderConfiguration runConfiguration;
    private ImageReaderSpi cachedReaderSPI;
    private ImageInputStreamSpi cachedStreamSPI;
    private List<PropertiesCollector> propertiesCollectors;
    private SampleModel defaultSM;
    private ReferencedEnvelope imposedBBox;
    private SimpleFeatureType indexSchema;
    private AbstractGridFormat cachedFormat;

    public void run() {
        try {
            IOFileFilter finalFilter = this.createGranuleFilterRules();
            this.numFiles = 0;
            for (String indexingDirectory : this.runConfiguration.getIndexingDirectories()) {
                File directoryToScan = new File(indexingDirectory);
                Collection files = FileUtils.listFiles((File)directoryToScan, (IOFileFilter)finalFilter, (IOFileFilter)(this.runConfiguration.isRecursive() ? TrueFileFilter.INSTANCE : FalseFileFilter.INSTANCE));
                this.numFiles += files.size();
            }
            if (this.numFiles > 0) {
                List<String> indexingDirectories = this.runConfiguration.getIndexingDirectories();
                CatalogBuilderDirectoryWalker catalogBuilderDirectoryWalker = new CatalogBuilderDirectoryWalker(indexingDirectories, (FileFilter)finalFilter);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    private IOFileFilter createGranuleFilterRules() {
        WildcardFileFilter specialWildCardFileFilter = new WildcardFileFilter(this.runConfiguration.getWildcard(), IOCase.INSENSITIVE);
        IOFileFilter dirFilter = FileFilterUtils.andFileFilter((IOFileFilter)FileFilterUtils.directoryFileFilter(), (IOFileFilter)HiddenFileFilter.VISIBLE);
        IOFileFilter fileFilter = Utils.excludeFilters(FileFilterUtils.makeSVNAware((IOFileFilter)FileFilterUtils.makeFileOnly((IOFileFilter)FileFilterUtils.andFileFilter((IOFileFilter)specialWildCardFileFilter, (IOFileFilter)HiddenFileFilter.VISIBLE))), FileFilterUtils.suffixFileFilter((String)"shp"), FileFilterUtils.suffixFileFilter((String)"dbf"), FileFilterUtils.suffixFileFilter((String)"shx"), FileFilterUtils.suffixFileFilter((String)"qix"), FileFilterUtils.suffixFileFilter((String)"lyr"), FileFilterUtils.suffixFileFilter((String)"prj"), FileFilterUtils.nameFileFilter((String)"error.txt"), FileFilterUtils.nameFileFilter((String)"error.txt.lck"), FileFilterUtils.suffixFileFilter((String)"properties"), FileFilterUtils.suffixFileFilter((String)"svn-base"));
        Set extensions = WorldImageFormat.getWorldExtension((String)"png");
        for (String ext : extensions) {
            fileFilter = FileFilterUtils.andFileFilter((IOFileFilter)fileFilter, (IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)ext.substring(1))));
        }
        extensions = WorldImageFormat.getWorldExtension((String)"gif");
        for (String ext : extensions) {
            fileFilter = FileFilterUtils.andFileFilter((IOFileFilter)fileFilter, (IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)ext.substring(1))));
        }
        extensions = WorldImageFormat.getWorldExtension((String)"jpg");
        for (String ext : extensions) {
            fileFilter = FileFilterUtils.andFileFilter((IOFileFilter)fileFilter, (IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)ext.substring(1))));
        }
        extensions = WorldImageFormat.getWorldExtension((String)"tiff");
        for (String ext : extensions) {
            fileFilter = FileFilterUtils.andFileFilter((IOFileFilter)fileFilter, (IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)ext.substring(1))));
        }
        extensions = WorldImageFormat.getWorldExtension((String)"bmp");
        for (String ext : extensions) {
            fileFilter = FileFilterUtils.andFileFilter((IOFileFilter)fileFilter, (IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)ext.substring(1))));
        }
        fileFilter = FileFilterUtils.andFileFilter((IOFileFilter)fileFilter, (IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)"sdw")));
        fileFilter = FileFilterUtils.andFileFilter((IOFileFilter)fileFilter, (IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)"aux")));
        fileFilter = FileFilterUtils.andFileFilter((IOFileFilter)fileFilter, (IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)"wld")));
        fileFilter = FileFilterUtils.andFileFilter((IOFileFilter)fileFilter, (IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)"svn")));
        IOFileFilter finalFilter = FileFilterUtils.orFileFilter((IOFileFilter)dirFilter, (IOFileFilter)fileFilter);
        return finalFilter;
    }

    public CatalogBuilder(CatalogBuilderConfiguration configuration) {
        Utilities.ensureNonNull((String)"runConfiguration", (Object)configuration);
        Utilities.ensureNonNull((String)"root location", (Object)configuration.getRootMosaicDirectory());
        File parent = new File(configuration.getRootMosaicDirectory());
        File indexerProperties = new File(parent, "indexer.properties");
        if (Utils.checkFileReadable(indexerProperties)) {
            Properties props = Utils.loadPropertiesFromURL(DataUtilities.fileToURL((File)indexerProperties));
            if (props.containsKey("Name")) {
                configuration.setIndexName(props.getProperty("Name"));
            }
            if (props.containsKey("AbsolutePath")) {
                configuration.setAbsolute(Boolean.valueOf(props.getProperty("AbsolutePath")));
            }
            if (props.containsKey("Recursive")) {
                configuration.setRecursive(Boolean.valueOf(props.getProperty("Recursive")));
            }
            if (props.containsKey("Wildcard")) {
                configuration.setWildcard(props.getProperty("Wildcard"));
            }
            if (props.containsKey("Schema")) {
                configuration.setSchema(props.getProperty("Schema"));
            }
            if (props.containsKey("TimeAttribute")) {
                configuration.setTimeAttribute(props.getProperty("TimeAttribute"));
            }
            if (props.containsKey("ElevationAttribute")) {
                configuration.setElevationAttribute(props.getProperty("ElevationAttribute"));
            }
            if (props.containsKey("Envelope2D")) {
                configuration.setEnvelope2D(props.getProperty("Envelope2D"));
            }
            if (props.containsKey("ResolutionLevels")) {
                configuration.setResolutionLevels(props.getProperty("ResolutionLevels"));
            }
            if (props.containsKey("PropertyCollectors")) {
                configuration.setPropertyCollectors(props.getProperty("PropertyCollectors"));
            }
            if (props.containsKey("Caching")) {
                configuration.setCaching(Boolean.valueOf(props.getProperty("Caching")));
            }
        }
        configuration.check();
        this.runConfiguration = new CatalogBuilderConfiguration(configuration);
    }

    public final void addProcessingEventListener(ProcessingEventListener listener) {
        this.notificationListeners.add(listener);
    }

    public void reset() {
        this.removeAllProcessingEventListeners();
        this.stop = false;
        this.closeIndexObjects();
        this.defaultCM = null;
        this.defaultCRS = null;
        this.defaultPalette = null;
        this.fileIndex = 0;
        this.numberOfProcessedFiles = 0;
        this.runConfiguration = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(Level level, String inMessage, double percentage) {
        if (LOGGER.isLoggable(level)) {
            LOGGER.log(level, inMessage);
        }
        List<ProcessingEventListener> list = this.notificationListeners;
        synchronized (list) {
            String newLine = System.getProperty("line.separator");
            StringBuilder message = new StringBuilder("Thread Name ");
            message.append(Thread.currentThread().getName()).append(newLine);
            message.append(this.getClass().toString()).append(newLine).append(inMessage);
            ProcessingEvent evt = new ProcessingEvent(this, message.toString(), percentage);
            ProgressEventDispatchThreadEventLauncher eventLauncher = new ProgressEventDispatchThreadEventLauncher();
            eventLauncher.setEvent(evt, this.notificationListeners.toArray());
            this.sendEvent(eventLauncher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireException(Exception ex) {
        List<ProcessingEventListener> list = this.notificationListeners;
        synchronized (list) {
            this.fireException(Utils.getMessageFromException(ex), -1.0, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireException(String string, double percentage, Exception ex) {
        List<ProcessingEventListener> list = this.notificationListeners;
        synchronized (list) {
            String newLine = System.getProperty("line.separator");
            StringBuilder message = new StringBuilder("Thread Name ");
            message.append(Thread.currentThread().getName()).append(newLine);
            message.append(this.getClass().toString()).append(newLine).append(string);
            ExceptionEvent evt = new ExceptionEvent(this, string, percentage, ex);
            ProgressEventDispatchThreadEventLauncher eventLauncher = new ProgressEventDispatchThreadEventLauncher();
            eventLauncher.setEvent(evt, this.notificationListeners.toArray());
            this.sendEvent(eventLauncher);
        }
    }

    public boolean getStop() {
        return this.stop;
    }

    public boolean isSendDelayedMessages() {
        return this.sendDelayedMessages;
    }

    public void setSendDelayedMessages(boolean sendDelayedMessages) {
        this.sendDelayedMessages = sendDelayedMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllProcessingEventListeners() {
        List<ProcessingEventListener> list = this.notificationListeners;
        synchronized (list) {
            this.notificationListeners.clear();
        }
    }

    public void removeProcessingEventListener(ProcessingEventListener listener) {
        this.notificationListeners.remove(listener);
    }

    private void sendEvent(ProgressEventDispatchThreadEventLauncher eventLauncher) {
        if (this.sendDelayedMessages) {
            SwingUtilities.invokeLater(eventLauncher);
        } else {
            eventLauncher.run();
        }
    }

    public void stop() {
        this.stop = true;
    }

    private void indexingPreamble() throws IOException {
        block10: {
            PrecisionModel precMod = new PrecisionModel(PrecisionModel.FLOATING);
            this.geomFactory = new GeometryFactory(precMod);
            File parent = new File(this.runConfiguration.getRootMosaicDirectory());
            File datastoreProperties = new File(parent, "datastore.properties");
            if (Utils.checkFileReadable(datastoreProperties)) {
                Properties properties = Utils.loadPropertiesFromURL(DataUtilities.fileToURL((File)datastoreProperties));
                if (properties == null) {
                    throw new IOException();
                }
                String SPIClass = properties.getProperty("SPI");
                try {
                    DataStoreFactorySpi spi = (DataStoreFactorySpi)Class.forName(SPIClass).newInstance();
                    Map<String, Serializable> params = Utils.createDataStoreParamsFromPropertiesFile(properties, spi);
                    this.catalog = GranuleCatalogFactory.createGranuleCatalog(params, false, true, spi);
                }
                catch (ClassNotFoundException e) {
                    IOException ioe = new IOException();
                    throw (IOException)ioe.initCause(e);
                }
                catch (InstantiationException e) {
                    IOException ioe = new IOException();
                    throw (IOException)ioe.initCause(e);
                }
                catch (IllegalAccessException e) {
                    IOException ioe = new IOException();
                    throw (IOException)ioe.initCause(e);
                }
            } else {
                URL file = new File(parent, this.runConfiguration.getIndexName() + ".shp").toURI().toURL();
                HashMap<String, Serializable> params = new HashMap<String, Serializable>();
                params.put(ShapefileDataStoreFactory.URLP.key, file);
                if (file.getProtocol().equalsIgnoreCase("file")) {
                    params.put(ShapefileDataStoreFactory.CREATE_SPATIAL_INDEX.key, Boolean.TRUE);
                }
                params.put(ShapefileDataStoreFactory.MEMORY_MAPPED.key, Boolean.TRUE);
                params.put(ShapefileDataStoreFactory.DBFTIMEZONE.key, TimeZone.getTimeZone("UTC"));
                this.catalog = GranuleCatalogFactory.createGranuleCatalog(params, false, true, Utils.SHAPE_SPI);
            }
            this.mosaicConfiguration = new MosaicConfigurationBean();
            this.mosaicConfiguration.setName(this.runConfiguration.getIndexName());
            String bbox = this.runConfiguration.getEnvelope2D();
            try {
                this.imposedBBox = Utils.parseEnvelope(bbox);
            }
            catch (Exception e) {
                this.imposedBBox = null;
                if (!LOGGER.isLoggable(Level.WARNING)) break block10;
                LOGGER.log(Level.WARNING, "Unable to parse imposed bbox", e);
            }
        }
        this.mosaicConfiguration.setCaching(this.runConfiguration.isCaching());
        this.loadPropertyCollectors();
    }

    private void loadPropertyCollectors() {
        String pcConfig = this.runConfiguration.getPropertyCollectors();
        if (pcConfig != null && pcConfig.length() > 0) {
            String[] pcsDefs;
            Set<PropertiesCollectorSPI> pcSPIs = PropertiesCollectorFinder.getPropertiesCollectorSPI();
            ArrayList<PropertiesCollector> pcs = new ArrayList<PropertiesCollector>();
            for (String pcDef : pcsDefs = pcConfig.split(",")) {
                int squareLPos = pcDef.indexOf("[");
                int squareRPos = pcDef.indexOf("]");
                int squareRPosLast = pcDef.lastIndexOf("]");
                int roundLPos = pcDef.indexOf("(");
                int roundRPos = pcDef.indexOf(")");
                int roundRPosLast = pcDef.lastIndexOf(")");
                if (squareRPos != squareRPosLast || squareLPos == -1 || squareRPos == -1 || squareLPos == 0 || roundRPos != roundRPosLast || roundLPos == -1 || roundRPos == -1 || roundLPos == 0 || roundLPos != squareRPos + 1 || roundRPos != pcDef.length() - 1) continue;
                String name = pcDef.substring(0, squareLPos);
                PropertiesCollectorSPI selectedSPI = null;
                for (PropertiesCollectorSPI spi : pcSPIs) {
                    if (!spi.isAvailable() || !spi.getName().equalsIgnoreCase(name)) continue;
                    selectedSPI = spi;
                    break;
                }
                if (selectedSPI == null) continue;
                String config = squareLPos < squareRPos ? pcDef.substring(squareLPos + 1, squareRPos) : "";
                File configFile = new File(this.runConfiguration.getRootMosaicDirectory(), config + ".properties");
                if (!Utils.checkFileReadable(configFile)) continue;
                String[] propertyNames = pcDef.substring(roundLPos + 1, roundRPos).split(",");
                PropertiesCollector pc = selectedSPI.create(configFile, Arrays.asList(propertyNames));
                if (pc != null) {
                    pcs.add(pc);
                    continue;
                }
                if (!LOGGER.isLoggable(Level.INFO)) continue;
                LOGGER.info("Unable to create PropertyCollector from config file:" + configFile);
            }
            this.propertiesCollectors = pcs;
        }
    }

    private void indexingPostamble(boolean success) throws IOException {
        this.closeIndexObjects();
        if (success) {
            this.createSampleImage();
            if (this.numberOfProcessedFiles > 0) {
                String elevationAttribute;
                this.mosaicConfiguration.setName(this.runConfiguration.getIndexName());
                this.mosaicConfiguration.setExpandToRGB(this.mustConvertToRGB);
                this.mosaicConfiguration.setAbsolutePath(this.runConfiguration.isAbsolute());
                this.mosaicConfiguration.setLocationAttribute(this.runConfiguration.getLocationAttribute());
                this.mosaicConfiguration.setCaching(this.runConfiguration.isCaching());
                String timeAttribute = this.runConfiguration.getTimeAttribute();
                if (timeAttribute != null) {
                    this.mosaicConfiguration.setTimeAttribute(this.runConfiguration.getTimeAttribute());
                }
                if ((elevationAttribute = this.runConfiguration.getElevationAttribute()) != null) {
                    this.mosaicConfiguration.setElevationAttribute(this.runConfiguration.getElevationAttribute());
                }
                this.createPropertiesFiles();
                this.fireEvent(Level.FINE, "Done!!!", 100.0);
            } else {
                this.fireEvent(Level.FINE, "Nothing to process!!!", 100.0);
            }
        } else {
            this.fireEvent(Level.FINE, "Canceled!!!", 100.0);
        }
    }

    private void createSampleImage() {
        if (this.defaultCM != null && this.defaultSM != null) {
            File sampleImageFile = new File(this.runConfiguration.getRootMosaicDirectory() + "/sample_image");
            try {
                Utils.storeSampleImage(sampleImageFile, this.defaultSM, this.defaultCM);
            }
            catch (IOException e) {
                this.fireEvent(Level.SEVERE, e.getLocalizedMessage(), 0.0);
            }
        }
    }

    private void closeIndexObjects() {
        try {
            if (this.catalog != null) {
                this.catalog.dispose();
            }
        }
        catch (Throwable e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        this.catalog = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createPropertiesFiles() {
        String elevationAttribute;
        this.fireEvent(Level.INFO, "Creating final properties file ", 99.9);
        Properties properties = new Properties();
        properties.setProperty("AbsolutePath", Boolean.toString(this.mosaicConfiguration.isAbsolutePath()));
        properties.setProperty("LocationAttribute", this.mosaicConfiguration.getLocationAttribute());
        String timeAttribute = this.mosaicConfiguration.getTimeAttribute();
        if (timeAttribute != null) {
            properties.setProperty("TimeAttribute", this.mosaicConfiguration.getTimeAttribute());
        }
        if ((elevationAttribute = this.mosaicConfiguration.getElevationAttribute()) != null) {
            properties.setProperty("ElevationAttribute", this.mosaicConfiguration.getElevationAttribute());
        }
        int numberOfLevels = this.mosaicConfiguration.getLevelsNum();
        double[][] resolutionLevels = this.mosaicConfiguration.getLevels();
        properties.setProperty("LevelsNum", Integer.toString(numberOfLevels));
        StringBuilder levels = new StringBuilder();
        for (int k = 0; k < numberOfLevels; ++k) {
            levels.append(Double.toString(resolutionLevels[0][k])).append(",").append(Double.toString(resolutionLevels[1][k]));
            if (k >= numberOfLevels - 1) continue;
            levels.append(" ");
        }
        properties.setProperty("Levels", levels.toString());
        properties.setProperty("Name", this.runConfiguration.getIndexName());
        properties.setProperty("ExpandToRGB", Boolean.toString(this.mustConvertToRGB));
        properties.setProperty("Heterogeneous", Boolean.toString(this.mosaicConfiguration.isHeterogeneous()));
        if (this.cachedReaderSPI != null) {
            properties.setProperty("SuggestedSPI", this.cachedReaderSPI.getClass().getName());
        }
        if (this.imposedBBox != null) {
            properties.setProperty("Envelope2D", this.imposedBBox.getMinX() + "," + this.imposedBBox.getMinY() + " " + this.imposedBBox.getMaxX() + "," + this.imposedBBox.getMaxY());
        }
        properties.setProperty("Caching", Boolean.toString(this.mosaicConfiguration.isCaching()));
        BufferedOutputStream outStream = null;
        try {
            try {
                outStream = new BufferedOutputStream(new FileOutputStream(this.runConfiguration.getRootMosaicDirectory() + "/" + this.runConfiguration.getIndexName() + ".properties"));
                properties.store(outStream, "-Automagically created from GeoTools-");
            }
            catch (FileNotFoundException e) {
                this.fireEvent(Level.SEVERE, e.getLocalizedMessage(), 0.0);
                Object var10_10 = null;
                if (outStream == null) return;
                IOUtils.closeQuietly(outStream);
                return;
            }
            catch (IOException e) {
                this.fireEvent(Level.SEVERE, e.getLocalizedMessage(), 0.0);
                Object var10_11 = null;
                if (outStream == null) return;
                IOUtils.closeQuietly(outStream);
                return;
            }
            Object var10_9 = null;
            if (outStream == null) return;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (outStream == null) throw throwable;
            IOUtils.closeQuietly(outStream);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)outStream);
    }

    public void dispose() {
        this.reset();
    }

    private static boolean setupResolutions(double[][] resolutionLevels, int numberOfLevels, AbstractGridCoverage2DReader coverageReader, ImageReader imageioReader, double[][] compareLevels) throws IndexOutOfBoundsException, IOException {
        boolean checkLevels;
        double[] res = CoverageUtilities.getResolution((AffineTransform)((AffineTransform)coverageReader.getOriginalGridToWorld(PixelInCell.CELL_CORNER)));
        resolutionLevels[0][0] = res[0];
        resolutionLevels[1][0] = res[1];
        boolean bl = checkLevels = compareLevels != null;
        if (numberOfLevels >= 1) {
            for (int k = 0; k < numberOfLevels; ++k) {
                resolutionLevels[0][k] = resolutionLevels[0][0] * (double)coverageReader.getOriginalGridRange().getSpan(0) / (1.0 * (double)imageioReader.getWidth(k));
                resolutionLevels[1][k] = resolutionLevels[1][0] * (double)coverageReader.getOriginalGridRange().getSpan(1) / (1.0 * (double)imageioReader.getHeight(k));
                if (!checkLevels || !(Math.abs(resolutionLevels[0][k] - compareLevels[0][k]) > 0.01 * compareLevels[0][k]) && !(Math.abs(resolutionLevels[1][k] - compareLevels[1][k]) > 0.01 * compareLevels[1][k])) continue;
                return false;
            }
        }
        return true;
    }

    public MosaicConfigurationBean getMosaicConfiguration() {
        return new MosaicConfigurationBean(this.mosaicConfiguration);
    }

    static /* synthetic */ int access$008(CatalogBuilder x0) {
        return x0.fileIndex++;
    }

    static /* synthetic */ void access$100(CatalogBuilder x0, Exception x1) {
        x0.fireException(x1);
    }

    static /* synthetic */ ImageInputStreamSpi access$400(CatalogBuilder x0) {
        return x0.cachedStreamSPI;
    }

    static /* synthetic */ ImageInputStreamSpi access$402(CatalogBuilder x0, ImageInputStreamSpi x1) {
        x0.cachedStreamSPI = x1;
        return x0.cachedStreamSPI;
    }

    static /* synthetic */ ImageReaderSpi access$500(CatalogBuilder x0) {
        return x0.cachedReaderSPI;
    }

    static /* synthetic */ ImageReaderSpi access$502(CatalogBuilder x0, ImageReaderSpi x1) {
        x0.cachedReaderSPI = x1;
        return x0.cachedReaderSPI;
    }

    static /* synthetic */ AbstractGridFormat access$600(CatalogBuilder x0) {
        return x0.cachedFormat;
    }

    static /* synthetic */ AbstractGridFormat access$602(CatalogBuilder x0, AbstractGridFormat x1) {
        x0.cachedFormat = x1;
        return x0.cachedFormat;
    }

    static /* synthetic */ ColorModel access$902(CatalogBuilder x0, ColorModel x1) {
        x0.defaultCM = x1;
        return x0.defaultCM;
    }

    static /* synthetic */ SampleModel access$1002(CatalogBuilder x0, SampleModel x1) {
        x0.defaultSM = x1;
        return x0.defaultSM;
    }

    static /* synthetic */ ColorModel access$900(CatalogBuilder x0) {
        return x0.defaultCM;
    }

    static /* synthetic */ byte[][] access$1102(CatalogBuilder x0, byte[][] x1) {
        x0.defaultPalette = x1;
        return x1;
    }

    static /* synthetic */ byte[][] access$1100(CatalogBuilder x0) {
        return x0.defaultPalette;
    }

    static /* synthetic */ CoordinateReferenceSystem access$1202(CatalogBuilder x0, CoordinateReferenceSystem x1) {
        x0.defaultCRS = x1;
        return x0.defaultCRS;
    }

    static /* synthetic */ boolean access$1300(double[][] x0, int x1, AbstractGridCoverage2DReader x2, ImageReader x3, double[][] x4) throws IndexOutOfBoundsException, IOException {
        return CatalogBuilder.setupResolutions(x0, x1, x2, x3, x4);
    }

    static /* synthetic */ MosaicConfigurationBean access$1400(CatalogBuilder x0) {
        return x0.mosaicConfiguration;
    }

    static /* synthetic */ SimpleFeatureType access$1502(CatalogBuilder x0, SimpleFeatureType x1) {
        x0.indexSchema = x1;
        return x0.indexSchema;
    }

    static /* synthetic */ SimpleFeatureType access$1500(CatalogBuilder x0) {
        return x0.indexSchema;
    }

    static /* synthetic */ GranuleCatalog access$1600(CatalogBuilder x0) {
        return x0.catalog;
    }

    static /* synthetic */ CoordinateReferenceSystem access$1200(CatalogBuilder x0) {
        return x0.defaultCRS;
    }

    static /* synthetic */ GeometryFactory access$1700(CatalogBuilder x0) {
        return x0.geomFactory;
    }

    static /* synthetic */ List access$1800(CatalogBuilder x0) {
        return x0.propertiesCollectors;
    }

    static /* synthetic */ int access$808(CatalogBuilder x0) {
        return x0.numberOfProcessedFiles++;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class CatalogBuilderDirectoryWalker
    extends DirectoryWalker {
        private DefaultTransaction transaction;
        private volatile boolean canceled;

        protected void handleCancelled(File startDirectory, Collection results, DirectoryWalker.CancelException cancel) throws IOException {
            super.handleCancelled(startDirectory, results, cancel);
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Stop requested when walking directory " + startDirectory);
            }
            super.handleEnd(results);
        }

        protected boolean handleIsCancelled(File file, int depth, Collection results) throws IOException {
            if (!this.checkStop()) {
                this.canceled = true;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void handleFile(File fileBeingProcessed, int depth, Collection results) throws IOException {
            block110: {
                CatalogBuilder.access$008(CatalogBuilder.this);
                if (!this.checkFile(fileBeingProcessed)) {
                    return;
                }
                try {
                    validFileName = fileBeingProcessed.getCanonicalPath();
                    validFileName = FilenameUtils.normalize((String)validFileName);
                }
                catch (IOException e1) {
                    CatalogBuilder.access$100(CatalogBuilder.this, e1);
                    return;
                }
                validFileName = FilenameUtils.getName((String)validFileName);
                CatalogBuilder.access$300(CatalogBuilder.this, Level.INFO, "Now indexing file " + validFileName, (double)CatalogBuilder.access$000(CatalogBuilder.this) * 100.0 / (double)CatalogBuilder.access$200(CatalogBuilder.this));
                inStream = null;
                imageioReader = null;
                coverageReader = null;
                try {
                    block118: {
                        block119: {
                            block116: {
                                block117: {
                                    block115: {
                                        block114: {
                                            block113: {
                                                block112: {
                                                    block111: {
                                                        if (CatalogBuilder.access$400(CatalogBuilder.this) != null) {
                                                            inStream = CatalogBuilder.access$400(CatalogBuilder.this).createInputStreamInstance(fileBeingProcessed);
                                                        }
                                                        if (inStream == null) {
                                                            CatalogBuilder.access$402(CatalogBuilder.this, ImageIOExt.getImageInputStreamSPI((Object)fileBeingProcessed));
                                                            if (CatalogBuilder.access$400(CatalogBuilder.this) != null) {
                                                                inStream = CatalogBuilder.access$400(CatalogBuilder.this).createInputStreamInstance(fileBeingProcessed);
                                                            }
                                                        }
                                                        if (inStream != null) break block111;
                                                        CatalogBuilder.access$300(CatalogBuilder.this, Level.INFO, fileBeingProcessed + " has been skipped since we could not get a stream for it", (double)CatalogBuilder.access$000(CatalogBuilder.this) * 100.0 / (double)CatalogBuilder.access$200(CatalogBuilder.this));
                                                        var17_9 = null;
                                                        ** GOTO lbl261
                                                    }
                                                    inStream.mark();
                                                    if (CatalogBuilder.access$500(CatalogBuilder.this) != null) break block112;
                                                    it = ImageIO.getImageReaders(inStream);
                                                    if (it.hasNext()) {
                                                        imageioReader = it.next();
                                                        if (imageioReader != null) {
                                                            CatalogBuilder.access$502(CatalogBuilder.this, imageioReader.getOriginatingProvider());
                                                            imageioReader.setInput(inStream);
                                                        }
                                                        break block113;
                                                    } else {
                                                        imageioReader = null;
                                                    }
                                                    break block113;
                                                }
                                                if (!CatalogBuilder.access$500(CatalogBuilder.this).canDecodeInput(inStream)) {
                                                    CatalogBuilder.access$502(CatalogBuilder.this, null);
                                                } else {
                                                    imageioReader = CatalogBuilder.access$500(CatalogBuilder.this).createReaderInstance();
                                                    imageioReader.setInput(inStream);
                                                }
                                            }
                                            if (imageioReader != null) break block114;
                                            CatalogBuilder.access$300(CatalogBuilder.this, Level.INFO, "Skipped file " + fileBeingProcessed + ":No ImageIO reader\ts availaible.", (double)CatalogBuilder.access$000(CatalogBuilder.this) * 99.0 / (double)CatalogBuilder.access$200(CatalogBuilder.this));
                                            ** GOTO lbl285
                                        }
                                        format /* !! */  = CatalogBuilder.access$600(CatalogBuilder.this) == null ? GridFormatFinder.findFormat((Object)fileBeingProcessed) : (CatalogBuilder.access$600(CatalogBuilder.this).accepts((Object)fileBeingProcessed) != false ? CatalogBuilder.access$600(CatalogBuilder.this) : new UnknownFormat());
                                        if (!(format /* !! */  instanceof UnknownFormat) && format /* !! */  != null) break block115;
                                        CatalogBuilder.access$300(CatalogBuilder.this, Level.INFO, "Skipped file " + fileBeingProcessed + ": File format is not supported.", (double)CatalogBuilder.access$000(CatalogBuilder.this) * 99.0 / (double)CatalogBuilder.access$200(CatalogBuilder.this));
                                        ** GOTO lbl310
                                    }
                                    CatalogBuilder.access$602(CatalogBuilder.this, format /* !! */ );
                                    coverageReader = format /* !! */ .getReader((Object)fileBeingProcessed, CatalogBuilder.access$700(CatalogBuilder.this).getHints());
                                    envelope = coverageReader.getOriginalEnvelope();
                                    actualCRS = coverageReader.getCrs();
                                    its = imageioReader.getImageTypes(0).next();
                                    if (CatalogBuilder.access$800(CatalogBuilder.this) != 0) break block116;
                                    CatalogBuilder.access$902(CatalogBuilder.this, its.getColorModel());
                                    CatalogBuilder.access$1002(CatalogBuilder.this, its.getSampleModel());
                                    if (CatalogBuilder.access$900(CatalogBuilder.this) instanceof IndexColorModel) {
                                        icm = (IndexColorModel)CatalogBuilder.access$900(CatalogBuilder.this);
                                        numBands = CatalogBuilder.access$900(CatalogBuilder.this).getNumColorComponents();
                                        CatalogBuilder.access$1102(CatalogBuilder.this, new byte[3][icm.getMapSize()]);
                                        icm.getReds(CatalogBuilder.access$1100(CatalogBuilder.this)[0]);
                                        icm.getGreens(CatalogBuilder.access$1100(CatalogBuilder.this)[0]);
                                        icm.getBlues(CatalogBuilder.access$1100(CatalogBuilder.this)[0]);
                                        if (numBands == 4) {
                                            icm.getAlphas(CatalogBuilder.access$1100(CatalogBuilder.this)[0]);
                                        }
                                    }
                                    CatalogBuilder.access$1202(CatalogBuilder.this, actualCRS);
                                    imageioReader.reset();
                                    try {
                                        inStream.reset();
                                    }
                                    catch (IOException e) {
                                        block89: {
                                            try {
                                                inStream.close();
                                            }
                                            catch (Throwable e1) {
                                                if (!CatalogBuilder.LOGGER.isLoggable(Level.FINE)) break block89;
                                                CatalogBuilder.LOGGER.log(Level.FINE, e1.getLocalizedMessage(), e1);
                                            }
                                        }
                                        inStream = ImageIO.createImageInputStream(fileBeingProcessed);
                                    }
                                    if (inStream != null) break block117;
                                    CatalogBuilder.access$300(CatalogBuilder.this, Level.INFO, fileBeingProcessed + " has been skipped since we could not get a stream for it", (double)CatalogBuilder.access$000(CatalogBuilder.this) * 100.0 / (double)CatalogBuilder.access$200(CatalogBuilder.this));
                                    ** GOTO lbl335
                                }
                                imageioReader.setInput(inStream);
                                numberOfLevels = imageioReader.getNumImages(true);
                                resolutionLevels = new double[2][numberOfLevels];
                                CatalogBuilder.access$1300(resolutionLevels, numberOfLevels, coverageReader, imageioReader, null);
                                CatalogBuilder.access$1400(CatalogBuilder.this).setLevelsNum(numberOfLevels);
                                CatalogBuilder.access$1400(CatalogBuilder.this).setLevels(resolutionLevels);
                                schemaDef = CatalogBuilder.access$700(CatalogBuilder.this).getSchema();
                                if (schemaDef != null) {
                                    try {
                                        CatalogBuilder.access$1502(CatalogBuilder.this, DataUtilities.createType((String)CatalogBuilder.access$1400(CatalogBuilder.this).getName(), (String)CatalogBuilder.access$700(CatalogBuilder.this).getSchema()));
                                        CatalogBuilder.access$1502(CatalogBuilder.this, DataUtilities.createSubType((SimpleFeatureType)CatalogBuilder.access$1500(CatalogBuilder.this), (String[])DataUtilities.attributeNames((SimpleFeatureType)CatalogBuilder.access$1500(CatalogBuilder.this)), (CoordinateReferenceSystem)actualCRS));
                                    }
                                    catch (Throwable e) {
                                        if (CatalogBuilder.LOGGER.isLoggable(Level.FINE)) {
                                            CatalogBuilder.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                        }
                                        CatalogBuilder.access$1502(CatalogBuilder.this, null);
                                    }
                                }
                                if (CatalogBuilder.access$1500(CatalogBuilder.this) == null) {
                                    featureBuilder = new SimpleFeatureTypeBuilder();
                                    featureBuilder.setName(CatalogBuilder.access$700(CatalogBuilder.this).getIndexName());
                                    featureBuilder.setNamespaceURI("http://www.geo-solutions.it/");
                                    featureBuilder.add(CatalogBuilder.access$700(CatalogBuilder.this).getLocationAttribute(), String.class);
                                    featureBuilder.add("the_geom", Polygon.class, actualCRS);
                                    featureBuilder.setDefaultGeometry("the_geom");
                                    if (CatalogBuilder.access$700(CatalogBuilder.this).getTimeAttribute() != null) {
                                        featureBuilder.add(CatalogBuilder.access$700(CatalogBuilder.this).getTimeAttribute(), Date.class);
                                    }
                                    CatalogBuilder.access$1502(CatalogBuilder.this, featureBuilder.buildFeatureType());
                                }
                                CatalogBuilder.access$1600(CatalogBuilder.this).createType(CatalogBuilder.access$1500(CatalogBuilder.this));
                                break block118;
                            }
                            if (!CatalogBuilder.access$1400(CatalogBuilder.this).isHeterogeneous()) {
                                numberOfLevels = imageioReader.getNumImages(true);
                                if (numberOfLevels != CatalogBuilder.access$1400(CatalogBuilder.this).getLevelsNum()) {
                                    CatalogBuilder.access$1400(CatalogBuilder.this).setHeterogeneous(true);
                                    if (numberOfLevels > CatalogBuilder.access$1400(CatalogBuilder.this).getLevelsNum()) {
                                        resolutionLevels = new double[2][numberOfLevels];
                                        CatalogBuilder.access$1300(resolutionLevels, numberOfLevels, coverageReader, imageioReader, null);
                                        CatalogBuilder.access$1400(CatalogBuilder.this).setLevelsNum(numberOfLevels);
                                        CatalogBuilder.access$1400(CatalogBuilder.this).setLevels(resolutionLevels);
                                    }
                                } else {
                                    resolutionLevels = new double[2][numberOfLevels];
                                    mosaicLevels = CatalogBuilder.access$1400(CatalogBuilder.this).getLevels();
                                    homogeneousLevels = CatalogBuilder.access$1300(resolutionLevels, numberOfLevels, coverageReader, imageioReader, mosaicLevels);
                                    if (!homogeneousLevels) {
                                        CatalogBuilder.access$1400(CatalogBuilder.this).setHeterogeneous(true);
                                    }
                                }
                            }
                            actualCM = its.getColorModel();
                            if (CatalogBuilder.access$000(CatalogBuilder.this) <= 0 || CRS.equalsIgnoreMetadata((Object)CatalogBuilder.access$1200(CatalogBuilder.this), (Object)actualCRS)) break block119;
                            CatalogBuilder.access$300(CatalogBuilder.this, Level.INFO, "Skipping image " + fileBeingProcessed + " because CRSs do not match.", (double)(CatalogBuilder.access$000(CatalogBuilder.this) + 1) * 99.0 / (double)CatalogBuilder.access$200(CatalogBuilder.this));
                            ** GOTO lbl360
                        }
                        if (!this.checkColorModels(CatalogBuilder.access$900(CatalogBuilder.this), CatalogBuilder.access$1100(CatalogBuilder.this), actualCM)) break block118;
                        CatalogBuilder.access$300(CatalogBuilder.this, Level.INFO, "Skipping image " + fileBeingProcessed + " because color models do not match.", (double)(CatalogBuilder.access$000(CatalogBuilder.this) + 1) * 99.0 / (double)CatalogBuilder.access$200(CatalogBuilder.this));
                        ** GOTO lbl385
                    }
                    feature = DataUtilities.template((SimpleFeatureType)CatalogBuilder.access$1500(CatalogBuilder.this));
                    feature.setAttribute(CatalogBuilder.access$1500(CatalogBuilder.this).getGeometryDescriptor().getLocalName(), (Object)CatalogBuilder.access$1700(CatalogBuilder.this).toGeometry((Envelope)new ReferencedEnvelope((org.opengis.geometry.Envelope)envelope)));
                    feature.setAttribute(CatalogBuilder.access$700(CatalogBuilder.this).getLocationAttribute(), (Object)this.prepareLocation(fileBeingProcessed));
                    if (CatalogBuilder.access$1800(CatalogBuilder.this) != null && CatalogBuilder.access$1800(CatalogBuilder.this).size() > 0) {
                        for (PropertiesCollector pc : CatalogBuilder.access$1800(CatalogBuilder.this)) {
                            pc.collect(fileBeingProcessed).collect(coverageReader).collect(imageioReader).setProperties(feature);
                            pc.reset();
                        }
                    }
                    CatalogBuilder.access$1600(CatalogBuilder.this).addGranule(feature, (Transaction)this.transaction);
                    CatalogBuilder.access$300(CatalogBuilder.this, Level.FINE, "Done with file " + fileBeingProcessed, (double)(CatalogBuilder.access$000(CatalogBuilder.this) + 1) * 99.0 / (double)CatalogBuilder.access$200(CatalogBuilder.this));
                    CatalogBuilder.access$808(CatalogBuilder.this);
                    ** GOTO lbl410
                }
                catch (IOException e) {
                    block91: {
                        block90: {
                            CatalogBuilder.access$100(CatalogBuilder.this, e);
                            var17_16 = null;
                            try {
                                if (inStream != null) {
                                    inStream.close();
                                }
                            }
                            catch (Throwable e) {
                                if (!CatalogBuilder.LOGGER.isLoggable(Level.FINEST)) break block90;
                                CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                            }
                        }
                        try {
                            if (imageioReader != null) {
                                imageioReader.dispose();
                            }
                        }
                        catch (Throwable e) {
                            if (!CatalogBuilder.LOGGER.isLoggable(Level.FINEST)) break block91;
                            CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                        }
                    }
                    try {
                        if (coverageReader == null) return;
                        coverageReader.dispose();
                        return;
                    }
                    catch (Throwable e) {
                        if (CatalogBuilder.LOGGER.isLoggable(Level.FINEST) == false) return;
                        CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                    }
                    return;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    block93: {
                        block92: {
                            CatalogBuilder.access$100(CatalogBuilder.this, e);
                            var17_17 = null;
                            ** try [egrp 6[TRYBLOCK] [28 : 1843->1858)] { 
lbl211:
                            // 1 sources

                            if (inStream != null) {
                                inStream.close();
                            }
                            break block92;
lbl214:
                            // 1 sources

                            catch (Throwable e) {
                                if (!CatalogBuilder.LOGGER.isLoggable(Level.FINEST)) break block92;
                                CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                            }
                        }
                        ** try [egrp 7[TRYBLOCK] [29 : 1888->1901)] { 
lbl219:
                        // 1 sources

                        if (imageioReader != null) {
                            imageioReader.dispose();
                        }
                        break block93;
lbl222:
                        // 1 sources

                        catch (Throwable e) {
                            if (!CatalogBuilder.LOGGER.isLoggable(Level.FINEST)) break block93;
                            CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                        }
                    }
                    ** try [egrp 8[TRYBLOCK] [30 : 1931->1944)] { 
lbl227:
                    // 1 sources

                    if (coverageReader == null) return;
                    coverageReader.dispose();
                    return;
lbl230:
                    // 1 sources

                    catch (Throwable e) {
                        if (CatalogBuilder.LOGGER.isLoggable(Level.FINEST) == false) return;
                        CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                    }
                    return;
                }
                {
                    block109: {
                        block108: {
                            block107: {
                                block106: {
                                    block105: {
                                        block104: {
                                            block103: {
                                                block102: {
                                                    block101: {
                                                        block100: {
                                                            block99: {
                                                                block98: {
                                                                    block97: {
                                                                        block96: {
                                                                            catch (Throwable var16_48) {
                                                                                block95: {
                                                                                    block94: {
                                                                                        var17_18 = null;
                                                                                        ** try [egrp 6[TRYBLOCK] [28 : 1843->1858)] { 
lbl238:
                                                                                        // 1 sources

                                                                                        if (inStream != null) {
                                                                                            inStream.close();
                                                                                        }
                                                                                        break block94;
lbl241:
                                                                                        // 1 sources

                                                                                        catch (Throwable e) {
                                                                                            if (!CatalogBuilder.LOGGER.isLoggable(Level.FINEST)) break block94;
                                                                                            CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                                                                        }
                                                                                    }
                                                                                    ** try [egrp 7[TRYBLOCK] [29 : 1888->1901)] { 
lbl246:
                                                                                    // 1 sources

                                                                                    if (imageioReader != null) {
                                                                                        imageioReader.dispose();
                                                                                    }
                                                                                    break block95;
lbl249:
                                                                                    // 1 sources

                                                                                    catch (Throwable e) {
                                                                                        if (!CatalogBuilder.LOGGER.isLoggable(Level.FINEST)) break block95;
                                                                                        CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                                                                    }
                                                                                }
                                                                                ** try [egrp 8[TRYBLOCK] [30 : 1931->1944)] { 
lbl254:
                                                                                // 1 sources

                                                                                if (coverageReader == null) throw var16_48;
                                                                                coverageReader.dispose();
                                                                                throw var16_48;
lbl257:
                                                                                // 1 sources

                                                                                catch (Throwable e) {
                                                                                    if (CatalogBuilder.LOGGER.isLoggable(Level.FINEST) == false) throw var16_48;
                                                                                    CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                                                                }
                                                                                throw var16_48;
                                                                            }
lbl261:
                                                                            // 1 sources

                                                                            ** try [egrp 6[TRYBLOCK] [28 : 1843->1858)] { 
lbl262:
                                                                            // 1 sources

                                                                            if (inStream != null) {
                                                                                inStream.close();
                                                                            }
                                                                            break block96;
lbl265:
                                                                            // 1 sources

                                                                            catch (Throwable e) {
                                                                                if (!CatalogBuilder.LOGGER.isLoggable(Level.FINEST)) break block96;
                                                                                CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                                                            }
                                                                        }
                                                                        ** try [egrp 7[TRYBLOCK] [29 : 1888->1901)] { 
lbl270:
                                                                        // 1 sources

                                                                        if (imageioReader != null) {
                                                                            imageioReader.dispose();
                                                                        }
                                                                        break block97;
lbl273:
                                                                        // 1 sources

                                                                        catch (Throwable e) {
                                                                            if (!CatalogBuilder.LOGGER.isLoggable(Level.FINEST)) break block97;
                                                                            CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                                                        }
                                                                    }
                                                                    ** try [egrp 8[TRYBLOCK] [30 : 1931->1944)] { 
lbl278:
                                                                    // 1 sources

                                                                    if (coverageReader == null) return;
                                                                    coverageReader.dispose();
                                                                    return;
lbl281:
                                                                    // 1 sources

                                                                    catch (Throwable e) {
                                                                        if (CatalogBuilder.LOGGER.isLoggable(Level.FINEST) == false) return;
                                                                        CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                                                    }
                                                                    return;
lbl285:
                                                                    // 1 sources

                                                                    var17_10 = null;
                                                                    ** try [egrp 6[TRYBLOCK] [28 : 1843->1858)] { 
lbl287:
                                                                    // 1 sources

                                                                    if (inStream != null) {
                                                                        inStream.close();
                                                                    }
                                                                    break block98;
lbl290:
                                                                    // 1 sources

                                                                    catch (Throwable e) {
                                                                        if (!CatalogBuilder.LOGGER.isLoggable(Level.FINEST)) break block98;
                                                                        CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                                                    }
                                                                }
                                                                ** try [egrp 7[TRYBLOCK] [29 : 1888->1901)] { 
lbl295:
                                                                // 1 sources

                                                                if (imageioReader != null) {
                                                                    imageioReader.dispose();
                                                                }
                                                                break block99;
lbl298:
                                                                // 1 sources

                                                                catch (Throwable e) {
                                                                    if (!CatalogBuilder.LOGGER.isLoggable(Level.FINEST)) break block99;
                                                                    CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                                                }
                                                            }
                                                            ** try [egrp 8[TRYBLOCK] [30 : 1931->1944)] { 
lbl303:
                                                            // 1 sources

                                                            if (coverageReader == null) return;
                                                            coverageReader.dispose();
                                                            return;
lbl306:
                                                            // 1 sources

                                                            catch (Throwable e) {
                                                                if (CatalogBuilder.LOGGER.isLoggable(Level.FINEST) == false) return;
                                                                CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                                            }
                                                            return;
lbl310:
                                                            // 1 sources

                                                            var17_11 = null;
                                                            ** try [egrp 6[TRYBLOCK] [28 : 1843->1858)] { 
lbl312:
                                                            // 1 sources

                                                            if (inStream != null) {
                                                                inStream.close();
                                                            }
                                                            break block100;
lbl315:
                                                            // 1 sources

                                                            catch (Throwable e) {
                                                                if (!CatalogBuilder.LOGGER.isLoggable(Level.FINEST)) break block100;
                                                                CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                                            }
                                                        }
                                                        ** try [egrp 7[TRYBLOCK] [29 : 1888->1901)] { 
lbl320:
                                                        // 1 sources

                                                        if (imageioReader != null) {
                                                            imageioReader.dispose();
                                                        }
                                                        break block101;
lbl323:
                                                        // 1 sources

                                                        catch (Throwable e) {
                                                            if (!CatalogBuilder.LOGGER.isLoggable(Level.FINEST)) break block101;
                                                            CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                                        }
                                                    }
                                                    ** try [egrp 8[TRYBLOCK] [30 : 1931->1944)] { 
lbl328:
                                                    // 1 sources

                                                    if (coverageReader == null) return;
                                                    coverageReader.dispose();
                                                    return;
lbl331:
                                                    // 1 sources

                                                    catch (Throwable e) {
                                                        if (CatalogBuilder.LOGGER.isLoggable(Level.FINEST) == false) return;
                                                        CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                                    }
                                                    return;
lbl335:
                                                    // 1 sources

                                                    var17_12 = null;
                                                    ** try [egrp 6[TRYBLOCK] [28 : 1843->1858)] { 
lbl337:
                                                    // 1 sources

                                                    if (inStream != null) {
                                                        inStream.close();
                                                    }
                                                    break block102;
lbl340:
                                                    // 1 sources

                                                    catch (Throwable e) {
                                                        if (!CatalogBuilder.LOGGER.isLoggable(Level.FINEST)) break block102;
                                                        CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                                    }
                                                }
                                                ** try [egrp 7[TRYBLOCK] [29 : 1888->1901)] { 
lbl345:
                                                // 1 sources

                                                if (imageioReader != null) {
                                                    imageioReader.dispose();
                                                }
                                                break block103;
lbl348:
                                                // 1 sources

                                                catch (Throwable e) {
                                                    if (!CatalogBuilder.LOGGER.isLoggable(Level.FINEST)) break block103;
                                                    CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                                }
                                            }
                                            ** try [egrp 8[TRYBLOCK] [30 : 1931->1944)] { 
lbl353:
                                            // 1 sources

                                            if (coverageReader == null) return;
                                            coverageReader.dispose();
                                            return;
lbl356:
                                            // 1 sources

                                            catch (Throwable e) {
                                                if (CatalogBuilder.LOGGER.isLoggable(Level.FINEST) == false) return;
                                                CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                            }
                                            return;
lbl360:
                                            // 1 sources

                                            var17_13 = null;
                                            ** try [egrp 6[TRYBLOCK] [28 : 1843->1858)] { 
lbl362:
                                            // 1 sources

                                            if (inStream != null) {
                                                inStream.close();
                                            }
                                            break block104;
lbl365:
                                            // 1 sources

                                            catch (Throwable e) {
                                                if (!CatalogBuilder.LOGGER.isLoggable(Level.FINEST)) break block104;
                                                CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                            }
                                        }
                                        ** try [egrp 7[TRYBLOCK] [29 : 1888->1901)] { 
lbl370:
                                        // 1 sources

                                        if (imageioReader != null) {
                                            imageioReader.dispose();
                                        }
                                        break block105;
lbl373:
                                        // 1 sources

                                        catch (Throwable e) {
                                            if (!CatalogBuilder.LOGGER.isLoggable(Level.FINEST)) break block105;
                                            CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                        }
                                    }
                                    ** try [egrp 8[TRYBLOCK] [30 : 1931->1944)] { 
lbl378:
                                    // 1 sources

                                    if (coverageReader == null) return;
                                    coverageReader.dispose();
                                    return;
lbl381:
                                    // 1 sources

                                    catch (Throwable e) {
                                        if (CatalogBuilder.LOGGER.isLoggable(Level.FINEST) == false) return;
                                        CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                    }
                                    return;
lbl385:
                                    // 1 sources

                                    var17_14 = null;
                                    ** try [egrp 6[TRYBLOCK] [28 : 1843->1858)] { 
lbl387:
                                    // 1 sources

                                    if (inStream != null) {
                                        inStream.close();
                                    }
                                    break block106;
lbl390:
                                    // 1 sources

                                    catch (Throwable e) {
                                        if (!CatalogBuilder.LOGGER.isLoggable(Level.FINEST)) break block106;
                                        CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                    }
                                }
                                ** try [egrp 7[TRYBLOCK] [29 : 1888->1901)] { 
lbl395:
                                // 1 sources

                                if (imageioReader != null) {
                                    imageioReader.dispose();
                                }
                                break block107;
lbl398:
                                // 1 sources

                                catch (Throwable e) {
                                    if (!CatalogBuilder.LOGGER.isLoggable(Level.FINEST)) break block107;
                                    CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                }
                            }
                            ** try [egrp 8[TRYBLOCK] [30 : 1931->1944)] { 
lbl403:
                            // 1 sources

                            if (coverageReader == null) return;
                            coverageReader.dispose();
                            return;
lbl406:
                            // 1 sources

                            catch (Throwable e) {
                                if (CatalogBuilder.LOGGER.isLoggable(Level.FINEST) == false) return;
                                CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                            }
                            return;
lbl410:
                            // 1 sources

                            var17_15 = null;
                            ** try [egrp 6[TRYBLOCK] [28 : 1843->1858)] { 
lbl412:
                            // 1 sources

                            if (inStream != null) {
                                inStream.close();
                            }
                            break block108;
lbl415:
                            // 1 sources

                            catch (Throwable e) {
                                if (!CatalogBuilder.LOGGER.isLoggable(Level.FINEST)) break block108;
                                CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                            }
                        }
                        ** try [egrp 7[TRYBLOCK] [29 : 1888->1901)] { 
lbl420:
                        // 1 sources

                        if (imageioReader != null) {
                            imageioReader.dispose();
                        }
                        break block109;
lbl423:
                        // 1 sources

                        catch (Throwable e) {
                            if (!CatalogBuilder.LOGGER.isLoggable(Level.FINEST)) break block109;
                            CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                        }
                    }
                    ** try [egrp 8[TRYBLOCK] [30 : 1931->1944)] { 
lbl428:
                    // 1 sources

                    if (coverageReader != null) {
                        coverageReader.dispose();
                    }
lbl432:
                    // 1 sources

                    catch (Throwable e) {}
                    if (!CatalogBuilder.LOGGER.isLoggable(Level.FINEST)) break block110;
                    CatalogBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                }
            }
            super.handleFile(fileBeingProcessed, depth, results);
        }

        private String prepareLocation(File fileBeingProcessed) throws IOException {
            if (CatalogBuilder.this.runConfiguration.isAbsolute()) {
                return fileBeingProcessed.getAbsolutePath();
            }
            String path = fileBeingProcessed.getCanonicalPath();
            path = path.substring(CatalogBuilder.this.runConfiguration.getRootMosaicDirectory().length());
            return path;
        }

        private boolean checkStop() {
            if (CatalogBuilder.this.getStop()) {
                CatalogBuilder.this.fireEvent(Level.INFO, "Stopping requested at file  " + CatalogBuilder.this.fileIndex + " of " + CatalogBuilder.this.numFiles + " files", (double)CatalogBuilder.this.fileIndex * 100.0 / (double)CatalogBuilder.this.numFiles);
                return false;
            }
            return true;
        }

        private boolean checkFile(File fileBeingProcessed) {
            if (!(fileBeingProcessed.exists() && fileBeingProcessed.canRead() && fileBeingProcessed.isFile())) {
                CatalogBuilder.this.fireEvent(Level.INFO, "Skipped file " + fileBeingProcessed + " snce it seems invalid", (double)CatalogBuilder.this.fileIndex * 99.0 / (double)CatalogBuilder.this.numFiles);
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public CatalogBuilderDirectoryWalker(List<String> indexingDirectories, FileFilter filter) throws IOException {
            block11: {
                block10: {
                    super(filter, Integer.MAX_VALUE);
                    this.transaction = new DefaultTransaction("MosaicCreationTransaction" + System.nanoTime());
                    CatalogBuilder.this.indexingPreamble();
                    for (String indexingDirectory : indexingDirectories) {
                        this.walk(new File(indexingDirectory), null);
                        if (!this.canceled) continue;
                        break;
                    }
                    if (this.canceled) {
                        this.transaction.rollback();
                        break block10;
                    }
                    this.transaction.commit();
                }
                Object var7_7 = null;
                this.transaction.close();
                try {
                    CatalogBuilder.this.indexingPostamble(!this.canceled);
                }
                catch (Exception e2) {}
                break block11;
                {
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, "Failure occurred while collecting the granules", e);
                        this.transaction.rollback();
                        Object var7_8 = null;
                        this.transaction.close();
                        try {
                            CatalogBuilder.this.indexingPostamble(!this.canceled);
                        }
                        catch (Exception e2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    this.transaction.close();
                    try {
                        CatalogBuilder.this.indexingPostamble(!this.canceled);
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }

        public int getNumberOfProcessedFiles() {
            return CatalogBuilder.this.numberOfProcessedFiles;
        }

        private boolean checkColorModels(ColorModel defaultCM, byte[][] defaultPalette, ColorModel actualCM) {
            if (defaultCM instanceof ComponentColorModel && actualCM instanceof ComponentColorModel) {
                boolean colorSpaceIsOk;
                ComponentColorModel defCCM = (ComponentColorModel)defaultCM;
                ComponentColorModel actualCCM = (ComponentColorModel)actualCM;
                ColorSpace defCS = defCCM.getColorSpace();
                ColorSpace actualCS = actualCCM.getColorSpace();
                boolean isBogusDef = defCS instanceof BogusColorSpace;
                boolean isBogusActual = actualCS instanceof BogusColorSpace;
                if (isBogusDef && isBogusActual) {
                    BogusColorSpace def = (BogusColorSpace)defCS;
                    BogusColorSpace act = (BogusColorSpace)actualCS;
                    colorSpaceIsOk = def.getNumComponents() == act.getNumComponents() && def.isCS_sRGB() == act.isCS_sRGB() && def.getType() == act.getType();
                } else {
                    colorSpaceIsOk = defCS.equals(actualCS);
                }
                return defCCM.getNumColorComponents() != actualCCM.getNumColorComponents() || defCCM.hasAlpha() != actualCCM.hasAlpha() || !colorSpaceIsOk || defCCM.getTransparency() != actualCCM.getTransparency() || defCCM.getTransferType() != actualCCM.getTransferType();
            }
            if (defaultCM instanceof IndexColorModel && actualCM instanceof IndexColorModel) {
                IndexColorModel defICM = (IndexColorModel)defaultCM;
                IndexColorModel actualICM = (IndexColorModel)actualCM;
                if (defICM.getNumColorComponents() != actualICM.getNumColorComponents() || defICM.hasAlpha() != actualICM.hasAlpha() || !defICM.getColorSpace().equals(actualICM.getColorSpace()) || defICM.getTransferType() != actualICM.getTransferType()) {
                    return true;
                }
                if (defICM.getMapSize() != actualICM.getMapSize() || defICM.getTransparency() != actualICM.getTransparency() || defICM.getTransferType() != actualICM.getTransferType() || defICM.getTransparentPixel() != actualICM.getTransparentPixel()) {
                    CatalogBuilder.this.mustConvertToRGB = true;
                    return false;
                }
                int numBands = actualICM.getNumColorComponents();
                byte[][] actualPalette = new byte[3][actualICM.getMapSize()];
                actualICM.getReds(actualPalette[0]);
                actualICM.getGreens(actualPalette[0]);
                actualICM.getBlues(actualPalette[0]);
                if (numBands == 4) {
                    actualICM.getAlphas(defaultPalette[0]);
                }
                block0: for (int i = 0; i < defICM.getMapSize(); ++i) {
                    for (int j = 0; j < numBands; ++j) {
                        if (actualPalette[j][i] == defaultPalette[j][i]) continue;
                        CatalogBuilder.this.mustConvertToRGB = true;
                        continue block0;
                    }
                }
                return false;
            }
            return true;
        }
    }

    static final class ProgressEventDispatchThreadEventLauncher
    implements Runnable {
        private ProcessingEvent event;
        private Object[] listeners;

        ProgressEventDispatchThreadEventLauncher() {
        }

        synchronized void setEvent(ProcessingEvent evt, Object[] listeners) {
            if (listeners == null || evt == null) {
                throw new NullPointerException("Input argumentBuilder cannot be null");
            }
            this.listeners = listeners;
            this.event = evt;
        }

        public void run() {
            int numListeners = this.listeners.length;
            if (this.event instanceof ExceptionEvent) {
                for (int i = 0; i < numListeners; ++i) {
                    ((ProcessingEventListener)this.listeners[i]).exceptionOccurred((ExceptionEvent)this.event);
                }
            } else {
                for (int i = 0; i < numListeners; ++i) {
                    ((ProcessingEventListener)this.listeners[i]).getNotification(this.event);
                }
            }
        }
    }

    public static final class ExceptionEvent
    extends ProcessingEvent {
        private static final long serialVersionUID = 2272452028229922551L;
        private Exception exception;

        public ExceptionEvent(Object source, String message, double percentage, Exception exception) {
            super(source, message, percentage);
            this.exception = exception;
        }

        public ExceptionEvent(Object source, Exception exception) {
            super(source, Utils.getMessageFromException(exception), -1.0);
            this.exception = exception;
        }

        public Exception getException() {
            return this.exception;
        }
    }

    public static class ProcessingEvent
    extends EventObject {
        private static final long serialVersionUID = 6930580659705360225L;
        private String message = null;
        private double percentage = 0.0;

        public ProcessingEvent(Object source, String message, double percentage) {
            super(source);
            this.message = message;
            this.percentage = percentage;
        }

        public double getPercentage() {
            return this.percentage;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static abstract class ProcessingEventListener
    implements EventListener {
        public abstract void getNotification(ProcessingEvent var1);

        public abstract void exceptionOccurred(ExceptionEvent var1);
    }
}

