/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagepyramid;

import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.geotools.data.DataUtilities;
import org.geotools.factory.Hints;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.resources.coverage.CoverageUtilities;
import org.geotools.util.logging.Logging;
import org.opengis.referencing.datum.PixelInCell;

class Utils {
    static final Logger LOGGER = Logging.getLogger(Utils.class);

    Utils() {
    }

    static URL checkSource(Object source) {
        return Utils.checkSource(source, null);
    }

    static URL checkSource(Object source, Hints hints) {
        int n;
        URL sourceURL = null;
        File sourceFile = null;
        if (source instanceof File) {
            sourceFile = (File)source;
            sourceURL = DataUtilities.fileToURL((File)sourceFile);
        } else if (source instanceof URL) {
            sourceURL = (URL)source;
            if (sourceURL.getProtocol().equals("file")) {
                sourceFile = DataUtilities.urlToFile((URL)sourceURL);
            }
        } else if (source instanceof String) {
            String tempSource = (String)source;
            File tempFile = new File(tempSource);
            if (!tempFile.exists()) {
                try {
                    sourceURL = new URL(tempSource);
                    source = DataUtilities.urlToFile((URL)sourceURL);
                }
                catch (MalformedURLException e) {
                    sourceURL = null;
                    source = null;
                }
            } else {
                sourceURL = DataUtilities.fileToURL((File)tempFile);
                sourceFile = tempFile;
            }
        } else {
            return null;
        }
        if (sourceFile == null || !sourceFile.exists()) {
            return sourceURL;
        }
        if (!sourceFile.isDirectory()) {
            return sourceURL;
        }
        File directory = sourceFile;
        if ((sourceFile = new File(directory, String.valueOf(directory.getName()) + ".properties")).exists()) {
            return DataUtilities.fileToURL((File)sourceFile);
        }
        File zeroLevelDirectory = new File(directory, "0");
        IOFileFilter directoryFilter = FileFilterUtils.directoryFileFilter();
        File[] numericDirectories = directory.listFiles(new NumericDirectoryFilter());
        File[] directories = directory.listFiles((FileFilter)directoryFilter);
        if (directories.length == 0) {
            return null;
        }
        if (!zeroLevelDirectory.exists() && numericDirectories.length == directories.length) {
            LOGGER.log(Level.INFO, "Detected gdal_retile file structure, moving root files to the '0' subdirectory");
            if (zeroLevelDirectory.mkdir()) {
                IOFileFilter notDirFilter = FileFilterUtils.notFileFilter((IOFileFilter)directoryFilter);
                File[] fileArray = directory.listFiles((FileFilter)notDirFilter);
                n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    if (!f.renameTo(new File(zeroLevelDirectory, f.getName()))) {
                        LOGGER.log(Level.INFO, "Could not move " + f.getAbsolutePath() + " to " + zeroLevelDirectory);
                    }
                    ++n2;
                }
                directories = directory.listFiles((FileFilter)directoryFilter);
            }
        }
        ArrayList<MosaicInfo> mosaics = new ArrayList<MosaicInfo>();
        ImageMosaicFormat mosaicFactory = new ImageMosaicFormat();
        File[] fileArray = directories;
        int n3 = directories.length;
        n = 0;
        while (n < n3) {
            File subdir = fileArray[n];
            if (mosaicFactory.accepts((Object)subdir, hints)) {
                mosaics.add(new MosaicInfo(subdir, mosaicFactory.getReader((Object)subdir, hints)));
            }
            ++n;
        }
        if (mosaics.size() == 0) {
            return null;
        }
        Collections.sort(mosaics);
        int i = 1;
        while (i < mosaics.size()) {
            double[] res;
            double[] resprev = ((MosaicInfo)mosaics.get(i - 1)).getResolutions();
            if (resprev[1] > (res = ((MosaicInfo)mosaics.get(i)).getResolutions())[1]) {
                LOGGER.log(Level.INFO, "Invalid mosaic, y resolution in " + ((MosaicInfo)mosaics.get(i - 1)).getPath() + " is greater than the one in " + ((MosaicInfo)mosaics.get(i)).getPath() + " whilst x resolutions " + "have the opposite relationship");
                return null;
            }
            ++i;
        }
        Properties properties = new Properties();
        properties.put("Name", directory.getName());
        properties.put("LevelsNum", String.valueOf(mosaics.size()));
        StringBuilder sbDirNames = new StringBuilder();
        StringBuilder sbLevels = new StringBuilder();
        for (MosaicInfo mi : mosaics) {
            sbDirNames.append(mi.getName()).append(" ");
            double[] resolutions = mi.getResolutions();
            sbLevels.append(resolutions[0]).append(",").append(resolutions[1]).append(" ");
        }
        properties.put("LevelsDirs", sbDirNames.toString());
        properties.put("Levels", sbLevels.toString());
        GeneralEnvelope envelope = ((MosaicInfo)mosaics.get(0)).getEnvelope();
        properties.put("Envelope2D", String.valueOf(envelope.getMinimum(0)) + "," + envelope.getMinimum(1) + " " + envelope.getMaximum(0) + "," + envelope.getMaximum(1));
        FileOutputStream os = null;
        try {
            try {
                os = new FileOutputStream(sourceFile);
                properties.store(os, "Automatically generated");
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, "We could not generate the pyramid propert file " + sourceFile.getPath(), e);
                if (os != null) {
                    try {
                        ((OutputStream)os).close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return null;
            }
        }
        finally {
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException iOException) {}
            }
        }
        if (envelope.getCoordinateReferenceSystem() != null) {
            File prjFile = new File(directory, String.valueOf(directory.getName()) + ".prj");
            PrintWriter pw = null;
            try {
                try {
                    pw = new PrintWriter(new FileOutputStream(prjFile));
                    pw.print(envelope.getCoordinateReferenceSystem().toString());
                }
                catch (IOException e) {
                    LOGGER.log(Level.INFO, "We could not write out the projection file " + prjFile.getPath(), e);
                    pw.close();
                    return null;
                }
            }
            finally {
                pw.close();
            }
        }
        return DataUtilities.fileToURL((File)sourceFile);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MosaicInfo
    implements Comparable<MosaicInfo> {
        File directory;
        ImageMosaicReader reader;
        double[] resolutions;

        MosaicInfo(File directory, ImageMosaicReader reader) {
            this.directory = directory;
            this.reader = reader;
            this.resolutions = CoverageUtilities.getResolution((AffineTransform)((AffineTransform)reader.getOriginalGridToWorld(PixelInCell.CELL_CORNER)));
        }

        double[] getResolutions() {
            return this.resolutions;
        }

        String getPath() {
            return this.directory.getPath();
        }

        String getName() {
            return this.directory.getName();
        }

        GeneralEnvelope getEnvelope() {
            return this.reader.getOriginalEnvelope();
        }

        @Override
        public int compareTo(MosaicInfo other) {
            return this.resolutions[0] > other.resolutions[0] ? 1 : -1;
        }
    }

    static class NumericDirectoryFilter
    implements FileFilter {
        NumericDirectoryFilter() {
        }

        public boolean accept(File pathname) {
            if (!pathname.isDirectory()) {
                return false;
            }
            try {
                Integer.parseInt(pathname.getName());
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }
}

