/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagepyramid;

import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.geotools.data.DataUtilities;
import org.geotools.factory.Hints;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.resources.coverage.CoverageUtilities;
import org.geotools.util.logging.Logging;
import org.opengis.referencing.datum.PixelInCell;

class Utils {
    static final Logger LOGGER = Logging.getLogger(Utils.class);

    Utils() {
    }

    static URL checkSource(Object source) {
        return Utils.checkSource(source, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static URL checkSource(Object source, Hints hints) {
        URL sourceURL = null;
        File sourceFile = null;
        if (source instanceof File) {
            sourceFile = (File)source;
            sourceURL = DataUtilities.fileToURL((File)sourceFile);
        } else if (source instanceof URL) {
            sourceURL = (URL)source;
            if (sourceURL.getProtocol().equals("file")) {
                sourceFile = DataUtilities.urlToFile((URL)sourceURL);
            }
        } else if (source instanceof String) {
            String tempSource = (String)source;
            File tempFile = new File(tempSource);
            if (!tempFile.exists()) {
                try {
                    sourceURL = new URL(tempSource);
                    source = DataUtilities.urlToFile((URL)sourceURL);
                }
                catch (MalformedURLException e) {
                    sourceURL = null;
                    source = null;
                }
            } else {
                sourceURL = DataUtilities.fileToURL((File)tempFile);
                sourceFile = tempFile;
            }
        } else {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("we really don't know how to convert the thing:" + source != null ? source.toString() : "null");
            }
            return null;
        }
        if (LOGGER.isLoggable(Level.INFO) && sourceFile != null) {
            String message = Utils.fileStatus(sourceFile);
            LOGGER.info(message);
        }
        if (sourceFile == null || !sourceFile.exists()) {
            return sourceURL;
        }
        if (!sourceFile.isDirectory()) {
            return sourceURL;
        }
        File directory = sourceFile;
        sourceFile = new File(directory, directory.getName() + ".properties");
        if (LOGGER.isLoggable(Level.INFO) && sourceFile != null) {
            String message = Utils.fileStatus(sourceFile);
            LOGGER.info(message);
        }
        if (sourceFile.exists()) {
            return DataUtilities.fileToURL((File)sourceFile);
        }
        File zeroLevelDirectory = new File(directory, "0");
        IOFileFilter directoryFilter = FileFilterUtils.directoryFileFilter();
        File[] numericDirectories = directory.listFiles(new NumericDirectoryFilter());
        File[] directories = directory.listFiles((FileFilter)directoryFilter);
        if (directories.length == 0) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("I was unable to determine a structure similar to the GDAL Retile one!!");
            }
            return null;
        }
        if (!zeroLevelDirectory.exists() && numericDirectories.length == directories.length) {
            LOGGER.log(Level.INFO, "Detected gdal_retile file structure, moving root files to the '0' subdirectory");
            if (zeroLevelDirectory.mkdir()) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Created '0' subidr, now moving files");
                }
                IOFileFilter zeroLevelsFiles = FileFilterUtils.makeSVNAware((IOFileFilter)FileFilterUtils.makeCVSAware((IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)directoryFilter)));
                for (File f : directory.listFiles((FileFilter)zeroLevelsFiles)) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Moving file" + f.getAbsolutePath());
                    }
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest(Utils.fileStatus(f));
                    }
                    if (f.renameTo(new File(zeroLevelDirectory, f.getName()))) continue;
                    LOGGER.log(Level.WARNING, "Could not move " + f.getAbsolutePath() + " to " + zeroLevelDirectory + " check the permission inside the source directory " + f.getParent() + " and target directory " + zeroLevelDirectory);
                }
                directories = directory.listFiles((FileFilter)directoryFilter);
            } else {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("I was unable to create the 0 directory. check the file permission in the parent directory:" + sourceFile.getParent());
                }
                return null;
            }
        }
        ArrayList<MosaicInfo> mosaics = new ArrayList<MosaicInfo>();
        ImageMosaicFormat mosaicFactory = new ImageMosaicFormat();
        for (File subdir : directories) {
            if (mosaicFactory.accepts((Object)subdir, hints)) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Trying to build mosaic for the directory:" + subdir.getAbsolutePath());
                }
                mosaics.add(new MosaicInfo(subdir, mosaicFactory.getReader((Object)subdir, hints)));
                continue;
            }
            if (!LOGGER.isLoggable(Level.INFO)) continue;
            LOGGER.info("Unable to build mosaic for the directory:" + subdir.getAbsolutePath());
        }
        if (mosaics.size() == 0) {
            return null;
        }
        Collections.sort(mosaics);
        for (int i = 1; i < mosaics.size(); ++i) {
            double[] res;
            double[] resprev = ((MosaicInfo)mosaics.get(i - 1)).getResolutions();
            if (!(resprev[1] > (res = ((MosaicInfo)mosaics.get(i)).getResolutions())[1])) continue;
            LOGGER.log(Level.INFO, "Invalid mosaic, y resolution in " + ((MosaicInfo)mosaics.get(i - 1)).getPath() + " is greater than the one in " + ((MosaicInfo)mosaics.get(i)).getPath() + " whilst x resolutions " + "have the opposite relationship");
            return null;
        }
        Properties properties = new Properties();
        properties.put("Name", directory.getName());
        properties.put("LevelsNum", String.valueOf(mosaics.size()));
        StringBuilder sbDirNames = new StringBuilder();
        StringBuilder sbLevels = new StringBuilder();
        for (MosaicInfo mi : mosaics) {
            sbDirNames.append(mi.getName()).append(" ");
            double[] resolutions = mi.getResolutions();
            sbLevels.append(resolutions[0]).append(",").append(resolutions[1]).append(" ");
        }
        properties.put("LevelsDirs", sbDirNames.toString());
        properties.put("Levels", sbLevels.toString());
        GeneralEnvelope envelope = ((MosaicInfo)mosaics.get(0)).getEnvelope();
        properties.put("Envelope2D", envelope.getMinimum(0) + "," + envelope.getMinimum(1) + " " + envelope.getMaximum(0) + "," + envelope.getMaximum(1));
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(sourceFile);
            properties.store(os, "Automatically generated");
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "We could not generate the pyramid propert file " + sourceFile.getPath(), e);
            URL uRL = null;
            return uRL;
        }
        finally {
            if (os != null) {
                IOUtils.closeQuietly((OutputStream)os);
            }
        }
        if (envelope.getCoordinateReferenceSystem() != null) {
            File prjFile = new File(directory, directory.getName() + ".prj");
            PrintWriter pw = null;
            try {
                pw = new PrintWriter(new FileOutputStream(prjFile));
                pw.print(envelope.getCoordinateReferenceSystem().toString());
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, "We could not write out the projection file " + prjFile.getPath(), e);
                URL uRL = null;
                return uRL;
            }
            finally {
                pw.close();
            }
        }
        return DataUtilities.fileToURL((File)sourceFile);
    }

    private static String fileStatus(File sourceFile) {
        if (sourceFile == null) {
            throw new NullPointerException("Provided null input to fileStatus method");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Checking file:").append(FilenameUtils.getFullPath((String)sourceFile.getAbsolutePath())).append("\n");
        builder.append("exists").append(sourceFile.exists()).append("\n");
        builder.append("isFile").append(sourceFile.isFile()).append("\n");
        builder.append("canRead:").append(sourceFile.canRead()).append("\n");
        builder.append("canWrite").append(sourceFile.canWrite()).append("\n");
        builder.append("isHidden:").append(sourceFile.isHidden()).append("\n");
        builder.append("lastModified").append(sourceFile.lastModified()).append("\n");
        return builder.toString();
    }

    static class NumericDirectoryFilter
    implements FileFilter {
        NumericDirectoryFilter() {
        }

        public boolean accept(File pathname) {
            if (!pathname.isDirectory()) {
                return false;
            }
            try {
                Integer.parseInt(pathname.getName());
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MosaicInfo
    implements Comparable<MosaicInfo> {
        File directory;
        ImageMosaicReader reader;
        double[] resolutions;

        public String toString() {
            return "MosaicInfo [directory=" + this.directory + ", resolutions=" + Arrays.toString(this.resolutions) + "]";
        }

        MosaicInfo(File directory, ImageMosaicReader reader) {
            this.directory = directory;
            this.reader = reader;
            this.resolutions = CoverageUtilities.getResolution((AffineTransform)((AffineTransform)reader.getOriginalGridToWorld(PixelInCell.CELL_CORNER)));
        }

        double[] getResolutions() {
            return this.resolutions;
        }

        String getPath() {
            return this.directory.getPath();
        }

        String getName() {
            return this.directory.getName();
        }

        GeneralEnvelope getEnvelope() {
            return this.reader.getOriginalEnvelope();
        }

        @Override
        public int compareTo(MosaicInfo other) {
            return this.resolutions[0] > other.resolutions[0] ? 1 : -1;
        }
    }
}

