/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagepyramid;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.channels.Channels;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReadParam;
import org.apache.commons.io.IOUtils;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.PrjFileReader;
import org.geotools.factory.Hints;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.gce.imagepyramid.ImagePyramidFormat;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.util.SoftValueHashMap;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public final class ImagePyramidReader
extends AbstractGridCoverage2DReader
implements GridCoverageReader {
    private static final Logger LOGGER = Logging.getLogger((String)ImagePyramidReader.class.toString());
    private URL sourceURL;
    private String[] levelsDirs;
    private Map<Integer, ImageMosaicReader> readers;

    public ImagePyramidReader(Object source, Hints uHints) throws IOException {
        if (this.hints == null) {
            this.hints = new Hints();
        }
        if (uHints != null) {
            this.hints.add((RenderingHints)uHints);
        }
        this.coverageFactory = CoverageFactoryFinder.getGridCoverageFactory((Hints)this.hints);
        if (source == null) {
            IOException ex = new IOException("ImagePyramidReader:No source set to read this coverage.");
            throw new DataSourceException((Throwable)ex);
        }
        this.source = source;
        if (source instanceof File) {
            this.sourceURL = DataUtilities.fileToURL((File)((File)source));
        } else if (source instanceof URL) {
            this.sourceURL = (URL)source;
        } else if (source instanceof String) {
            File tempFile = new File((String)source);
            if (tempFile.exists()) {
                this.sourceURL = DataUtilities.fileToURL((File)tempFile);
            } else {
                try {
                    this.sourceURL = new URL((String)source);
                    this.sourceURL.openStream().close();
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("The given String can't be intereted as a File nor as an URL.", e);
                }
            }
        } else {
            throw new IllegalArgumentException("This plugin accepts only File, URL and String pointing to a file");
        }
        URL prjURL = DataUtilities.changeUrlExt((URL)this.sourceURL, (String)"prj");
        PrjFileReader crsReader = null;
        try {
            crsReader = new PrjFileReader(Channels.newChannel(prjURL.openStream()));
        }
        catch (FactoryException e) {
            throw new DataSourceException((Throwable)e);
        }
        finally {
            try {
                crsReader.close();
            }
            catch (Throwable e) {}
        }
        Object tempCRS = this.hints.get((Object)Hints.DEFAULT_COORDINATE_REFERENCE_SYSTEM);
        if (tempCRS != null) {
            this.crs = (CoordinateReferenceSystem)tempCRS;
            LOGGER.log(Level.WARNING, "Using forced coordinate reference system " + this.crs.toWKT());
        } else {
            CoordinateReferenceSystem tempcrs = crsReader.getCoordinateReferenceSystem();
            if (tempcrs == null) {
                this.crs = AbstractGridFormat.getDefaultCRS();
                LOGGER.log(Level.WARNING, "Unable to find a CRS for this coverage, using a default one: " + this.crs.toWKT());
            } else {
                this.crs = tempcrs;
            }
        }
        this.parseMainFile(this.sourceURL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseMainFile(URL sourceURL) throws IOException {
        InputStream openStream;
        block7: {
            BufferedInputStream propertyStream = null;
            openStream = null;
            try {
                String[] pair;
                openStream = sourceURL.openStream();
                propertyStream = new BufferedInputStream(openStream);
                Properties properties = new Properties();
                properties.load(propertyStream);
                String envelope = properties.getProperty("Envelope2D");
                String[] pairs = envelope.split(" ");
                double[][] cornersV = new double[2][2];
                for (int i = 0; i < 2; ++i) {
                    pair = pairs[i].split(",");
                    cornersV[i][0] = Double.parseDouble(pair[0]);
                    cornersV[i][1] = Double.parseDouble(pair[1]);
                }
                this.originalEnvelope = new GeneralEnvelope(cornersV[0], cornersV[1]);
                this.originalEnvelope.setCoordinateReferenceSystem(this.crs);
                this.numOverviews = Integer.parseInt(properties.getProperty("LevelsNum")) - 1;
                this.levelsDirs = properties.getProperty("LevelsDirs").split(" ");
                int readersCacheSize = (this.numOverviews + 1) / 3;
                this.readers = new SoftValueHashMap(readersCacheSize == 0 ? this.numOverviews + 1 : readersCacheSize);
                String levels = properties.getProperty("Levels");
                pairs = levels.split(" ");
                this.overViewResolutions = this.numOverviews >= 1 ? new double[this.numOverviews][2] : (double[][])null;
                pair = pairs[0].split(",");
                this.highestRes = new double[2];
                this.highestRes[0] = Double.parseDouble(pair[0].trim());
                this.highestRes[1] = Double.parseDouble(pair[1].trim());
                for (int i = 1; i < this.numOverviews + 1; ++i) {
                    pair = pairs[i].split(",");
                    this.overViewResolutions[i - 1][0] = Double.parseDouble(pair[0].trim());
                    this.overViewResolutions[i - 1][1] = Double.parseDouble(pair[1].trim());
                }
                this.coverageName = properties.getProperty("Name");
                this.originalGridRange = new GridEnvelope2D(new Rectangle((int)Math.round(this.originalEnvelope.getSpan(0) / this.highestRes[0]), (int)Math.round(this.originalEnvelope.getSpan(1) / this.highestRes[1])));
                GridToEnvelopeMapper geMapper = new GridToEnvelopeMapper(this.originalGridRange, (Envelope)this.originalEnvelope);
                geMapper.setPixelAnchor(PixelInCell.CELL_CORNER);
                this.raster2Model = geMapper.createTransform();
                if (propertyStream == null) break block7;
            }
            catch (Throwable throwable) {
                if (propertyStream != null) {
                    IOUtils.closeQuietly(propertyStream);
                }
                if (openStream != null) {
                    IOUtils.closeQuietly((InputStream)openStream);
                }
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)propertyStream);
        }
        if (openStream != null) {
            IOUtils.closeQuietly((InputStream)openStream);
        }
    }

    public ImagePyramidReader(Object source) throws IOException {
        this(source, null);
    }

    public Format getFormat() {
        return new ImagePyramidFormat();
    }

    public GridCoverage2D read(GeneralParameterValue[] params) throws IOException {
        GeneralEnvelope requestedEnvelope = null;
        Rectangle dim = null;
        OverviewPolicy overviewPolicy = null;
        if (params != null && params != null) {
            for (int i = 0; i < params.length; ++i) {
                ParameterValue param = (ParameterValue)params[i];
                String name = param.getDescriptor().getName().getCode();
                if (name.equals(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString())) {
                    GridGeometry2D gg = (GridGeometry2D)param.getValue();
                    requestedEnvelope = new GeneralEnvelope((Envelope)gg.getEnvelope2D());
                    dim = gg.getGridRange2D().getBounds();
                    continue;
                }
                if (!name.equals(AbstractGridFormat.OVERVIEW_POLICY.getName().toString())) continue;
                overviewPolicy = (OverviewPolicy)param.getValue();
            }
        }
        return this.loadTiles(requestedEnvelope, dim, params, overviewPolicy);
    }

    private GridCoverage2D loadTiles(GeneralEnvelope requestedEnvelope, Rectangle dim, GeneralParameterValue[] params, OverviewPolicy overviewPolicy) throws IOException {
        if (requestedEnvelope != null) {
            if (!CRS.equalsIgnoreMetadata((Object)requestedEnvelope.getCoordinateReferenceSystem(), (Object)this.crs)) {
                try {
                    MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)requestedEnvelope.getCoordinateReferenceSystem(), (CoordinateReferenceSystem)this.crs, (boolean)true);
                    if (!transform.isIdentity()) {
                        requestedEnvelope = CRS.transform((MathTransform)transform, (Envelope)requestedEnvelope);
                        requestedEnvelope.setCoordinateReferenceSystem(this.crs);
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Reprojected envelope " + requestedEnvelope.toString() + " crs " + this.crs.toWKT());
                        }
                    }
                }
                catch (TransformException e) {
                    throw new DataSourceException("Unable to create a coverage for this source", (Throwable)e);
                }
                catch (FactoryException e) {
                    throw new DataSourceException("Unable to create a coverage for this source", (Throwable)e);
                }
            }
            if (!requestedEnvelope.intersects((Envelope)this.originalEnvelope, true)) {
                return null;
            }
            requestedEnvelope.intersect((Envelope)this.originalEnvelope);
        } else {
            requestedEnvelope = new GeneralEnvelope((Envelope)this.originalEnvelope);
        }
        requestedEnvelope.setCoordinateReferenceSystem(this.crs);
        try {
            return this.loadRequestedTiles(requestedEnvelope, dim, params, overviewPolicy);
        }
        catch (TransformException e) {
            throw new DataSourceException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GridCoverage2D loadRequestedTiles(GeneralEnvelope requestedEnvelope, Rectangle dim, GeneralParameterValue[] params, OverviewPolicy overviewPolicy) throws TransformException, IOException {
        ImageReadParam readP = new ImageReadParam();
        Integer imageChoice = 0;
        if (dim != null) {
            imageChoice = this.setReadParams(overviewPolicy, readP, requestedEnvelope, dim);
        }
        ImageMosaicReader reader = null;
        Map<Integer, ImageMosaicReader> map = this.readers;
        synchronized (map) {
            ImageMosaicReader o = this.readers.get(imageChoice);
            if (o == null) {
                String extension;
                String levelDirName = this.levelsDirs[imageChoice];
                URL parentUrl = DataUtilities.getParentUrl((URL)this.sourceURL);
                URL shpFileUrl = DataUtilities.extendURL((URL)parentUrl, (String)(extension = levelDirName + "/" + this.coverageName + ".shp"));
                reader = shpFileUrl.getProtocol() != null && shpFileUrl.getProtocol().equalsIgnoreCase("file") && !DataUtilities.urlToFile((URL)shpFileUrl).exists() ? new ImageMosaicReader((Object)DataUtilities.extendURL((URL)parentUrl, (String)levelDirName), this.hints) : new ImageMosaicReader((Object)shpFileUrl, this.hints);
                this.readers.put(imageChoice, reader);
            } else {
                reader = o;
            }
        }
        return reader.read(params);
    }

    public synchronized void dispose() {
        super.dispose();
        this.readers.clear();
    }

    public int getGridCoverageCount() {
        return 1;
    }

    double[] getHighestRes() {
        return this.highestRes;
    }
}

