/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc;

import java.util.Collections;
import java.util.HashSet;
import junit.framework.TestCase;
import org.geotools.data.jdbc.DefaultSQLBuilder;
import org.geotools.data.jdbc.fidmapper.BasicFIDMapper;
import org.geotools.data.jdbc.fidmapper.FIDMapper;
import org.geotools.data.jdbc.fidmapper.TypedFIDMapper;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.SQLEncoder;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.identity.FeatureId;

public class DefaultSQLBuilderTest
extends TestCase {
    DefaultSQLBuilder builder;
    FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);

    protected void setUp() throws Exception {
        SQLEncoder encoder = new SQLEncoder();
        encoder.setSqlNameEscape("\"");
        this.builder = new DefaultSQLBuilder(encoder);
    }

    public void testExpression() throws Exception {
        Add a = this.ff.add((Expression)this.ff.property("col"), (Expression)this.ff.literal(5));
        StringBuffer sb = new StringBuffer();
        this.builder.encode(sb, (Expression)a);
        DefaultSQLBuilderTest.assertEquals((String)"\"col\" + 5", (String)sb.toString());
    }

    public void testFilter() throws Exception {
        PropertyIsEqualTo equal = this.ff.equal((Expression)this.ff.property("col"), (Expression)this.ff.literal(5), false);
        StringBuffer sb = new StringBuffer();
        this.builder.encode(sb, (Filter)equal);
        DefaultSQLBuilderTest.assertEquals((String)"\"col\" = 5", (String)sb.toString());
    }

    public void testGetPrePostQueryFilterWithFidValidation() throws Exception {
        String featureTypeName = "FT";
        TypedFIDMapper mapper = new TypedFIDMapper((FIDMapper)new BasicFIDMapper("id", 5), "FT");
        SQLEncoder encoder = new SQLEncoder();
        encoder.setSqlNameEscape("\"");
        encoder.setFIDMapper((FIDMapper)mapper);
        this.builder = new DefaultSQLBuilder(encoder);
        HashSet<Object> ids = new HashSet<Object>();
        ids.add(this.ff.featureId("discarded.1"));
        ids.add(this.ff.gmlObjectId("discarded.2"));
        FeatureId validFid = this.ff.featureId("FT.fid-something");
        ids.add(validFid);
        Id id = this.ff.id(ids);
        Filter preFilter = this.builder.getPreQueryFilter((Filter)id);
        Filter postFilter = this.builder.getPostQueryFilter((Filter)id);
        Id expected = this.ff.id(Collections.singleton(validFid));
        DefaultSQLBuilderTest.assertEquals((Object)expected, (Object)preFilter);
        DefaultSQLBuilderTest.assertEquals((Object)Filter.INCLUDE, (Object)postFilter);
    }
}

