/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.jdbc.JDBCGeometryTestSetup;
import org.geotools.jdbc.JDBCTestSupport;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class JDBCGeometryTest
extends JDBCTestSupport {
    protected abstract JDBCGeometryTestSetup createTestSetup();

    public void testPoint() throws Exception {
        JDBCGeometryTest.assertEquals(Point.class, (Object)this.checkGeometryType(Point.class));
    }

    public void testLineString() throws Exception {
        JDBCGeometryTest.assertEquals(LineString.class, (Object)this.checkGeometryType(LineString.class));
    }

    public void testLinearRing() throws Exception {
        JDBCGeometryTest.assertEquals(LinearRing.class, (Object)this.checkGeometryType(LinearRing.class));
    }

    public void testPolygon() throws Exception {
        JDBCGeometryTest.assertEquals(Polygon.class, (Object)this.checkGeometryType(Polygon.class));
    }

    public void testMultiPoint() throws Exception {
        JDBCGeometryTest.assertEquals(MultiPoint.class, (Object)this.checkGeometryType(MultiPoint.class));
    }

    public void testMultiLineString() throws Exception {
        JDBCGeometryTest.assertEquals(MultiLineString.class, (Object)this.checkGeometryType(MultiLineString.class));
    }

    public void testMultiPolygon() throws Exception {
        JDBCGeometryTest.assertEquals(MultiPolygon.class, (Object)this.checkGeometryType(MultiPolygon.class));
    }

    public void testGeometry() throws Exception {
        JDBCGeometryTest.assertEquals(Geometry.class, (Object)this.checkGeometryType(Geometry.class));
    }

    public void testGeometryCollection() throws Exception {
        JDBCGeometryTest.assertEquals(GeometryCollection.class, (Object)this.checkGeometryType(GeometryCollection.class));
    }

    protected Class checkGeometryType(Class geomClass) throws Exception {
        String featureTypeName = this.tname("t" + geomClass.getSimpleName());
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:4326");
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        ftb.setName(featureTypeName);
        ftb.add(this.aname("id"), Integer.class);
        ftb.add(this.aname("name"), String.class);
        ftb.add(this.aname("geom"), geomClass, crs);
        SimpleFeatureType newFT = ftb.buildFeatureType();
        this.dataStore.createSchema(newFT);
        SimpleFeatureType newSchema = this.dataStore.getSchema(featureTypeName);
        JDBCGeometryTest.assertNotNull((Object)newSchema);
        JDBCGeometryTest.assertEquals((int)3, (int)newSchema.getAttributeCount());
        return newSchema.getGeometryDescriptor().getType().getBinding();
    }
}

