/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import org.geotools.data.DataUtilities;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.JDBCSkipColumnTestSetup;
import org.geotools.jdbc.JDBCTestSupport;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public abstract class JDBCSkipColumnTest
extends JDBCTestSupport {
    protected static final String SKIPCOLUMN = "skipcolumn";
    protected static final String ID = "id";
    protected static final String NAME = "name";
    protected static final String GEOM = "geom";
    protected SimpleFeatureType schema;

    protected abstract JDBCSkipColumnTestSetup createTestSetup();

    protected void setUp() throws Exception {
        super.setUp();
        this.schema = DataUtilities.createType((String)(this.dataStore.getNamespaceURI() + "." + SKIPCOLUMN), (String)"id:0,geom:Point,name:String");
    }

    public void testSkippedColumn() throws Exception {
        SimpleFeatureType ft = this.dataStore.getSchema(this.tname(SKIPCOLUMN));
        this.assertFeatureTypesEqual(this.schema, ft);
    }

    public void testReadFeatures() throws Exception {
        ContentFeatureCollection fc = this.dataStore.getFeatureSource(this.tname(SKIPCOLUMN)).getFeatures();
        JDBCSkipColumnTest.assertEquals((int)1, (int)fc.size());
        FeatureIterator fr = fc.features();
        JDBCSkipColumnTest.assertTrue((boolean)fr.hasNext());
        SimpleFeature f = (SimpleFeature)fr.next();
        JDBCSkipColumnTest.assertFalse((boolean)fr.hasNext());
        fr.close();
    }

    public void testGetBounds() throws Exception {
        ReferencedEnvelope env = this.dataStore.getFeatureSource(this.tname(SKIPCOLUMN)).getBounds();
        JDBCSkipColumnTest.assertEquals((Object)0.0, (Object)env.getMinX());
        JDBCSkipColumnTest.assertEquals((Object)0.0, (Object)env.getMinY());
        JDBCSkipColumnTest.assertEquals((Object)0.0, (Object)env.getMaxX());
        JDBCSkipColumnTest.assertEquals((Object)0.0, (Object)env.getMaxY());
    }
}

