/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverageio.jp2k;

import com.sun.media.imageioimpl.plugins.tiff.TIFFImageReader;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageReaderSpi;
import it.geosolutions.imageio.plugins.jp2k.JP2KStreamMetadata;
import it.geosolutions.imageio.plugins.jp2k.box.UUIDBoxMetadataNode;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.imageio.geotiff.GeoTiffIIOMetadataDecoder;
import org.geotools.coverage.grid.io.imageio.geotiff.GeoTiffMetadata2CRSAdapter;
import org.geotools.coverageio.jp2k.JP2KFormat;
import org.geotools.coverageio.jp2k.RasterManager;
import org.geotools.coverageio.jp2k.Utils;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.PrjFileReader;
import org.geotools.data.WorldFileReader;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.metadata.iso.spatial.PixelTranslation;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.resources.coverage.CoverageUtilities;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public final class JP2KReader
extends AbstractGridCoverage2DReader
implements GridCoverageReader {
    private static final Logger LOGGER = Logging.getLogger(JP2KReader.class);
    private static final char SEPARATOR = File.separatorChar;
    private static final short[] GEOJP2_UUID = new short[]{177, 75, 248, 189, 8, 61, 75, 67, 165, 174, 140, 215, 213, 166, 206, 3};
    private static final short[] MSIG_WORLDFILEBOX_UUID = new short[]{150, 169, 241, 241, 220, 152, 64, 45, 167, 174, 214, 142, 52, 69, 24, 9};
    private static final int WORLD_FILE_INTERPRETATION_PIXEL_CORNER = 1;
    private GridEnvelope2D nativeGridRange = null;
    private GeneralEnvelope nativeEnvelope = null;
    ImageReaderSpi cachedSPI;
    URL sourceURL;
    boolean expandMe;
    private RasterManager rasterManager;
    private String parentPath;

    public JP2KReader(Object input) throws IOException {
        this(input, null);
    }

    protected void setCoverageProperties(ImageReader reader) throws IOException {
        IIOMetadata metadata = reader.getStreamMetadata();
        int hrWidth = reader.getWidth(0);
        int hrHeight = reader.getHeight(0);
        Rectangle actualDim = new Rectangle(0, 0, hrWidth, hrHeight);
        this.nativeGridRange = new GridEnvelope2D(actualDim);
        if (this.crs == null) {
            this.parsePRJFile();
        }
        if (this.nativeEnvelope == null) {
            this.parseWorldFile();
        }
        if (this.crs == null || this.nativeEnvelope == null) {
            this.checkUUIDBoxes(metadata);
        }
        if (this.nativeEnvelope == null) {
            throw new DataSourceException("Unavailable envelope for this coverage");
        }
        this.originalEnvelope = this.getCoverageEnvelope();
        this.originalEnvelope.setCoordinateReferenceSystem(this.crs);
        this.originalGridRange = this.getCoverageGridRange();
    }

    protected void setCoverageEnvelope(GeneralEnvelope coverageEnvelope) {
        this.nativeEnvelope = coverageEnvelope;
    }

    protected GeneralEnvelope getCoverageEnvelope() {
        return this.nativeEnvelope;
    }

    protected void setCoverageGridRange(GridEnvelope2D coverageGridRange) {
        this.nativeGridRange = coverageGridRange;
    }

    protected GridEnvelope2D getCoverageGridRange() {
        return this.nativeGridRange;
    }

    private boolean isGeoJP2(byte[] id) {
        return this.isSameUUID(id, GEOJP2_UUID);
    }

    private boolean isWorldBox(byte[] id) {
        return this.isSameUUID(id, MSIG_WORLDFILEBOX_UUID);
    }

    private boolean isSameUUID(byte[] id, short[] uuid) {
        for (int i = 0; i < uuid.length; ++i) {
            if ((id[i] & 0xFF) == uuid[i]) continue;
            return false;
        }
        return true;
    }

    private void checkUUIDBoxes(IIOMetadata metadata) throws IOException {
        if (!(metadata instanceof JP2KStreamMetadata)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Metadata should be an instance of the expected class: JP2KStreamMetadata.");
            }
            return;
        }
        List uuidBoxMetadataNodes = ((JP2KStreamMetadata)metadata).searchOccurrencesNode(1970628964);
        UUIDBoxMetadataNode geoJP2uuid = null;
        UUIDBoxMetadataNode worldBoxuuid = null;
        if (uuidBoxMetadataNodes != null && !uuidBoxMetadataNodes.isEmpty()) {
            for (IIOMetadataNode node : uuidBoxMetadataNodes) {
                if (!(node instanceof UUIDBoxMetadataNode)) continue;
                UUIDBoxMetadataNode uuid = (UUIDBoxMetadataNode)node;
                byte[] id = uuid.getUuid();
                if (this.isGeoJP2(id)) {
                    geoJP2uuid = uuid;
                    continue;
                }
                if (!this.isWorldBox(id)) continue;
                worldBoxuuid = uuid;
            }
        }
        if (geoJP2uuid != null) {
            this.getGeoJP2(geoJP2uuid);
        }
        if (worldBoxuuid != null && this.crs != null) {
            this.getWorldBox(worldBoxuuid);
        }
    }

    private void getWorldBox(UUIDBoxMetadataNode uuid) throws IOException {
        block8: {
            byte[] bb = uuid.getData();
            if (bb[0] != 77 || bb[1] != 83 || bb[2] != 73 || bb[3] != 71) {
                return;
            }
            byte worldFileInterpretation = bb[6];
            int ckIndex = 16;
            byte chunkIndex = bb[16];
            long chunkLength = Utils.bytes2long(bb, 18);
            if (chunkIndex != 0 && chunkLength != 48L) {
                return;
            }
            double xScale = Utils.bytes2double(bb, 22);
            double xRotation = Utils.bytes2double(bb, 30);
            double yRotation = Utils.bytes2double(bb, 38);
            double yScale = Utils.bytes2double(bb, 46);
            double xUpperLeft = Utils.bytes2double(bb, 54);
            double yUpperLeft = Utils.bytes2double(bb, 62);
            AffineTransform tempTransform = new AffineTransform(xScale, yRotation, xRotation, yScale, xUpperLeft, yUpperLeft);
            if (worldFileInterpretation == 1) {
                AffineTransform transform = (AffineTransform)ProjectiveTransform.create((AffineTransform)tempTransform);
                double tr = -PixelTranslation.getPixelTranslation((PixelInCell)PixelInCell.CELL_CORNER);
                transform.translate(tr, tr);
                this.raster2Model = ProjectiveTransform.create((AffineTransform)transform);
            } else {
                this.raster2Model = ProjectiveTransform.create((AffineTransform)tempTransform);
                tempTransform.translate(-0.5, -0.5);
            }
            try {
                GeneralEnvelope envelope = CRS.transform((MathTransform)ProjectiveTransform.create((AffineTransform)tempTransform), (Envelope)new GeneralEnvelope((Rectangle2D)this.nativeGridRange));
                envelope.setCoordinateReferenceSystem(this.crs);
                this.nativeEnvelope = envelope;
            }
            catch (TransformException e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Unable to parse CRS from underlying TIFF", e);
                }
            }
            catch (UnsupportedOperationException e) {
                if (!LOGGER.isLoggable(Level.FINE)) break block8;
                LOGGER.log(Level.FINE, "Unable to parse CRS from underlying TIFF due to an unsupported CRS", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getGeoJP2(UUIDBoxMetadataNode uuid) throws IOException {
        CoordinateReferenceSystem coordinateReferenceSystem = null;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(uuid.getData());
        TIFFImageReader tiffreader = (TIFFImageReader)new TIFFImageReaderSpi().createReaderInstance();
        tiffreader.setInput((Object)ImageIO.createImageInputStream(inputStream));
        IIOMetadata tiffmetadata = tiffreader.getImageMetadata(0);
        try {
            GeoTiffIIOMetadataDecoder metadataDecoder = new GeoTiffIIOMetadataDecoder(tiffmetadata);
            GeoTiffMetadata2CRSAdapter adapter = new GeoTiffMetadata2CRSAdapter(null);
            coordinateReferenceSystem = adapter.createCoordinateSystem(metadataDecoder);
            if (coordinateReferenceSystem != null && this.crs == null) {
                this.crs = coordinateReferenceSystem;
            }
            if (this.raster2Model == null) {
                this.raster2Model = adapter.getRasterToModel(metadataDecoder);
                AffineTransform tempTransform = new AffineTransform((AffineTransform)this.raster2Model);
                tempTransform.translate(-0.5, -0.5);
                GeneralEnvelope envelope = CRS.transform((MathTransform)ProjectiveTransform.create((AffineTransform)tempTransform), (Envelope)new GeneralEnvelope((Rectangle2D)this.nativeGridRange));
                envelope.setCoordinateReferenceSystem(this.crs);
                this.setCoverageEnvelope(envelope);
            }
        }
        catch (FactoryException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Unable to parse CRS from underlying TIFF", e);
            }
            coordinateReferenceSystem = null;
        }
        catch (TransformException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Unable to parse CRS from underlying TIFF", e);
            }
            coordinateReferenceSystem = null;
        }
        catch (UnsupportedOperationException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Unable to parse CRS from underlying TIFF", e);
            }
            coordinateReferenceSystem = null;
        }
        catch (IllegalArgumentException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Unable to parse CRS from underlying TIFF", e);
            }
            coordinateReferenceSystem = null;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    public int getGridCoverageCount() {
        return 1;
    }

    public synchronized void dispose() {
        super.dispose();
        this.rasterManager.dispose();
    }

    public JP2KReader(Object source, Hints uHints) throws IOException {
        if (this.hints == null) {
            this.hints = new Hints();
        }
        if (uHints != null) {
            this.hints.add((RenderingHints)uHints);
        }
        this.coverageFactory = CoverageFactoryFinder.getGridCoverageFactory((Hints)this.hints);
        if (source == null) {
            IOException ex = new IOException("JP2KReader:No source set to read this coverage.");
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, ex.getLocalizedMessage(), ex);
            }
            throw new DataSourceException((Throwable)ex);
        }
        this.source = source;
        this.sourceURL = Utils.checkSource(source);
        if (this.sourceURL == null) {
            throw new DataSourceException("This plugin accepts only File,  URL and String pointing to a file");
        }
        File inputFile = DataUtilities.urlToFile((URL)this.sourceURL);
        if (inputFile == null) {
            throw new DataSourceException("Unable to find a file for the provided source");
        }
        this.parentPath = inputFile.getParent();
        ImageReader reader = null;
        ImageInputStream stream = ImageIO.createImageInputStream(inputFile);
        if (this.cachedSPI == null && (reader = Utils.getReader(stream)) != null) {
            this.cachedSPI = reader.getOriginatingProvider();
        }
        if (reader == null) {
            throw new DataSourceException("No reader found for that source " + this.sourceURL);
        }
        reader.setInput(stream);
        this.coverageName = inputFile.getName();
        int dotIndex = this.coverageName.lastIndexOf(".");
        this.coverageName = dotIndex == -1 ? this.coverageName : this.coverageName.substring(0, dotIndex);
        Object tempCRS = this.hints.get((Object)Hints.DEFAULT_COORDINATE_REFERENCE_SYSTEM);
        if (tempCRS != null) {
            this.crs = (CoordinateReferenceSystem)tempCRS;
            LOGGER.log(Level.WARNING, new StringBuffer("Using forced coordinate reference system ").append(this.crs.toWKT()).toString());
        } else {
            this.setCoverageProperties(reader);
            if (this.crs == null) {
                this.crs = AbstractGridFormat.getDefaultCRS();
                LOGGER.log(Level.WARNING, "Unable to find a CRS for this coverage, using a default one: " + this.crs.toWKT());
            }
        }
        this.setResolutionInfo(reader);
        reader.dispose();
        this.rasterManager = new RasterManager(this);
    }

    public Format getFormat() {
        return new JP2KFormat();
    }

    public GridCoverage2D read(GeneralParameterValue[] params) throws IOException {
        Collection<GridCoverage2D> response;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Reading image from " + this.sourceURL.toString());
            LOGGER.fine(new StringBuffer("Highest res ").append(this.highestRes[0]).append(" ").append(this.highestRes[1]).toString());
        }
        if ((response = this.rasterManager.read(params)).isEmpty()) {
            return null;
        }
        return response.iterator().next();
    }

    Hints getHints() {
        return this.hints;
    }

    double[] getHighestRes() {
        return this.highestRes;
    }

    double[][] getOverviewsResolution() {
        return this.overViewResolutions;
    }

    int getNumberOfOverviews() {
        return this.numOverviews;
    }

    MathTransform getRaster2Model() {
        return this.raster2Model;
    }

    GridCoverageFactory getGridCoverageFactory() {
        return this.coverageFactory;
    }

    String getName() {
        return this.coverageName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parsePRJFile() throws UnsupportedEncodingException {
        String prjPath = this.parentPath + SEPARATOR + this.coverageName + ".prj";
        File prjFile = new File(prjPath);
        if (prjFile.exists()) {
            PrjFileReader projReader = null;
            FileInputStream instream = null;
            try {
                instream = new FileInputStream(prjFile);
                FileChannel channel = instream.getChannel();
                projReader = new PrjFileReader((ReadableByteChannel)channel);
                this.crs = projReader.getCoordinateReferenceSystem();
            }
            catch (FileNotFoundException e) {
                LOGGER.log(Level.INFO, e.getLocalizedMessage(), e);
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, e.getLocalizedMessage(), e);
            }
            catch (FactoryException e) {
                LOGGER.log(Level.INFO, e.getLocalizedMessage(), e);
            }
            finally {
                if (projReader != null) {
                    try {
                        projReader.close();
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                    }
                }
                if (instream != null) {
                    try {
                        instream.close();
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                    }
                }
            }
        }
    }

    protected void parseWorldFile() throws IOException {
        block6: {
            String worldFilePath = new StringBuffer(this.parentPath).append(SEPARATOR).append(this.coverageName).toString();
            File file2Parse = null;
            boolean worldFileExists = false;
            file2Parse = new File(worldFilePath + ".j2w");
            worldFileExists = file2Parse.exists();
            if (!worldFileExists) {
                file2Parse = new File(worldFilePath + ".wld");
                worldFileExists = file2Parse.exists();
            }
            if (worldFileExists) {
                WorldFileReader reader = new WorldFileReader(file2Parse);
                this.raster2Model = reader.getTransform();
                MathTransform tempTransform = PixelTranslation.translate((MathTransform)this.raster2Model, (PixelInCell)PixelInCell.CELL_CENTER, (PixelInCell)PixelInCell.CELL_CORNER);
                try {
                    GeneralEnvelope coverageEnvelope;
                    GeneralEnvelope gridRange = new GeneralEnvelope((Rectangle2D)this.nativeGridRange);
                    this.nativeEnvelope = coverageEnvelope = CRS.transform((MathTransform)tempTransform, (Envelope)gridRange);
                }
                catch (TransformException e) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                    }
                }
                catch (IllegalStateException e) {
                    if (!LOGGER.isLoggable(Level.WARNING)) break block6;
                    LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                }
            }
        }
    }

    private void setResolutionInfo(ImageReader reader) throws IOException {
        Rectangle originalDim = new Rectangle(0, 0, reader.getWidth(0), reader.getHeight(0));
        if (this.nativeGridRange == null) {
            this.setCoverageGridRange(new GridEnvelope2D(originalDim));
        }
        this.highestRes = CoverageUtilities.getResolution((AffineTransform)((AffineTransform)this.raster2Model));
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(new StringBuffer("Highest Resolution = [").append(this.highestRes[0]).append(",").append(this.highestRes[1]).toString());
        }
        this.numOverviews = 0;
        this.overViewResolutions = this.numOverviews >= 1 ? new double[this.numOverviews][2] : (double[][])null;
    }
}

