/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts.spatialschema.geometry.geometry;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LinearRing;
import java.util.List;
import org.geotools.geometry.jts.JTSGeometry;
import org.geotools.geometry.jts.JTSUtils;
import org.geotools.geometry.jts.spatialschema.geometry.primitive.SurfacePatchImpl;
import org.opengis.geometry.coordinate.Polygon;
import org.opengis.geometry.coordinate.PolyhedralSurface;
import org.opengis.geometry.primitive.Ring;
import org.opengis.geometry.primitive.SurfaceBoundary;
import org.opengis.geometry.primitive.SurfaceInterpolation;

public class PolygonImpl
extends SurfacePatchImpl
implements Polygon {
    private List spanningSurface;

    public PolygonImpl(SurfaceBoundary boundary) {
        this(boundary, null);
    }

    public PolygonImpl(SurfaceBoundary boundary, List spanningSurface) {
        super(SurfaceInterpolation.PLANAR, boundary);
        this.spanningSurface = spanningSurface;
    }

    public int getNumDerivativesOnBoundary() {
        return 0;
    }

    public Geometry calculateJTSPeer() {
        SurfaceBoundary boundary = this.getBoundary();
        Ring exterior = boundary.getExterior();
        List interiors = boundary.getInteriors();
        Geometry g = ((JTSGeometry)exterior).getJTSGeometry();
        int numHoles = interiors != null ? interiors.size() : 0;
        LinearRing jtsExterior = JTSUtils.GEOMETRY_FACTORY.createLinearRing(g.getCoordinates());
        LinearRing[] jtsInterior = new LinearRing[numHoles];
        for (int i = 0; i < numHoles; ++i) {
            Geometry g2 = ((JTSGeometry)interiors.get(i)).getJTSGeometry();
            jtsInterior[i] = JTSUtils.GEOMETRY_FACTORY.createLinearRing(g2.getCoordinates());
        }
        com.vividsolutions.jts.geom.Polygon result = JTSUtils.GEOMETRY_FACTORY.createPolygon(jtsExterior, jtsInterior);
        return result;
    }

    public PolyhedralSurface getSurface() {
        return (PolyhedralSurface)super.getSurface();
    }

    public List getSpanningSurface() {
        return this.spanningSurface;
    }

    public boolean isValid() {
        com.vividsolutions.jts.geom.Polygon poly = (com.vividsolutions.jts.geom.Polygon)this.getJTSGeometry();
        return poly.isValid();
    }
}

