/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.geotools.data.FeatureReader;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.collection.DelegateSimpleFeatureIterator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class CollectionFeatureReader
implements FeatureReader<SimpleFeatureType, SimpleFeature> {
    private SimpleFeatureIterator features;
    private SimpleFeatureType type;
    private boolean closed = false;

    public CollectionFeatureReader(Collection<SimpleFeature> featuresArg, SimpleFeatureType typeArg) {
        assert (!featuresArg.isEmpty());
        this.features = new DelegateSimpleFeatureIterator(featuresArg.iterator());
        this.type = typeArg;
    }

    public CollectionFeatureReader(SimpleFeatureCollection featuresArg, SimpleFeatureType typeArg) {
        assert (!featuresArg.isEmpty());
        this.features = featuresArg.features();
        this.type = typeArg;
    }

    public CollectionFeatureReader(SimpleFeature[] featuresArg) {
        assert (featuresArg.length > 0);
        Iterator<SimpleFeature> iterator = Arrays.asList(featuresArg).iterator();
        this.features = new DelegateSimpleFeatureIterator(iterator);
        this.type = featuresArg[0].getFeatureType();
    }

    public SimpleFeatureType getFeatureType() {
        return this.type;
    }

    public SimpleFeature next() throws IOException, IllegalAttributeException, NoSuchElementException {
        if (this.closed) {
            throw new NoSuchElementException("Reader has been closed");
        }
        return (SimpleFeature)this.features.next();
    }

    public boolean hasNext() throws IOException {
        return this.features != null && this.features.hasNext() && !this.closed;
    }

    public void close() throws IOException {
        this.closed = true;
        if (this.features != null) {
            this.features.close();
            this.features = null;
        }
    }
}

