/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.util.Arrays;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.geotools.data.DefaultQuery;
import org.opengis.filter.Filter;

public class DefaultQueryTest
extends TestCase {
    public DefaultQueryTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(DefaultQueryTest.class);
        return suite;
    }

    public void testFullConstructor() {
        DefaultQuery query = new DefaultQuery("mytype", (Filter)Filter.INCLUDE, 10, new String[]{"foo"}, "myquery");
        DefaultQueryTest.assertNotNull((Object)query);
    }

    public void testPropertyNames() {
        System.out.println("testPropertyNames");
        DefaultQuery query = new DefaultQuery();
        DefaultQueryTest.assertNull((Object)query.getPropertyNames());
        query.setPropertyNames(new String[]{"foo", "bar"});
        String[] names = query.getPropertyNames();
        DefaultQueryTest.assertNotNull((Object)names);
        DefaultQueryTest.assertEquals((String)"foo", (String)names[0]);
        List<String> list = Arrays.asList(names);
        query.setPropertyNames(list);
        names = query.getPropertyNames();
        DefaultQueryTest.assertEquals((String)"bar", (String)names[1]);
        query.setPropertyNames((List)null);
        DefaultQueryTest.assertNull((Object)query.getPropertyNames());
        query = new DefaultQuery("Test", (Filter)Filter.INCLUDE, new String[]{"foo", "wibble"});
        DefaultQueryTest.assertNotNull((Object)query.getPropertyNames());
    }

    public void testRetrieveAllProperties() {
        System.out.println("testRetrieveAllProperties");
        DefaultQuery query = new DefaultQuery();
        DefaultQueryTest.assertTrue((boolean)query.retrieveAllProperties());
        query.setPropertyNames(new String[]{"foo", "bar"});
        DefaultQueryTest.assertFalse((boolean)query.retrieveAllProperties());
        query.setPropertyNames((String[])null);
        DefaultQueryTest.assertTrue((boolean)query.retrieveAllProperties());
        query.setPropertyNames(new String[]{"foo", "bar"});
        query.setPropertyNames((List)null);
        DefaultQueryTest.assertTrue((boolean)query.retrieveAllProperties());
    }

    public void testMaxFeatures() {
        System.out.println("testMaxFeatures");
        DefaultQuery query = new DefaultQuery();
        DefaultQueryTest.assertEquals((int)Integer.MAX_VALUE, (int)query.getMaxFeatures());
        query.setMaxFeatures(5);
        DefaultQueryTest.assertEquals((int)5, (int)query.getMaxFeatures());
    }

    public void testFilter() {
        System.out.println("testGetFilter");
        DefaultQuery query = new DefaultQuery();
        query.setFilter((Filter)Filter.EXCLUDE);
        DefaultQueryTest.assertEquals((Object)Filter.EXCLUDE, (Object)query.getFilter());
        query = new DefaultQuery("test", (Filter)Filter.INCLUDE);
        DefaultQueryTest.assertEquals((Object)Filter.INCLUDE, (Object)query.getFilter());
    }

    public void testTypeName() {
        DefaultQuery query = new DefaultQuery();
        DefaultQueryTest.assertNull((Object)query.getTypeName());
        query.setTypeName("foobar");
        DefaultQueryTest.assertEquals((String)"foobar", (String)query.getTypeName());
        query = new DefaultQuery("mytype", (Filter)Filter.EXCLUDE);
        DefaultQueryTest.assertEquals((String)"mytype", (String)query.getTypeName());
    }

    public void testHandle() {
        System.out.println("testGetHandle");
        DefaultQuery query = new DefaultQuery();
        DefaultQueryTest.assertNull((Object)query.getHandle());
        query.setHandle("myquery");
        DefaultQueryTest.assertEquals((String)"myquery", (String)query.getHandle());
    }

    public void testVersion() {
        System.out.println("testGetVersion");
        DefaultQuery query = new DefaultQuery();
        DefaultQueryTest.assertNull((Object)query.getVersion());
    }

    public void testToString() {
        System.out.println("testToString");
        DefaultQuery query = new DefaultQuery();
        DefaultQueryTest.assertNotNull((Object)query.toString());
        query.setHandle("myquery");
        DefaultQueryTest.assertNotNull((Object)query.toString());
        query.setFilter((Filter)Filter.EXCLUDE);
        DefaultQueryTest.assertNotNull((Object)query.toString());
        query.setPropertyNames(new String[]{"foo", "bar"});
        DefaultQueryTest.assertNotNull((Object)query.toString());
    }
}

