/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.visitor.ExtractBoundsFilterVisitor;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Touches;

public class ExtractBoundsFilterVisitorTest {
    FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
    ExtractBoundsFilterVisitor visitor = new ExtractBoundsFilterVisitor();
    Envelope infinity = this.visitor.infinity();

    @Test
    public void testInclude() {
        Envelope env = (Envelope)Filter.INCLUDE.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)this.infinity, (Object)env);
    }

    @Test
    public void testExclude() {
        Envelope env = (Envelope)Filter.EXCLUDE.accept((FilterVisitor)this.visitor, null);
        Assert.assertTrue((boolean)env.isNull());
    }

    @Test
    public void testNonSpatial() {
        PropertyIsLessThan f = this.ff.less((Expression)this.ff.property("att"), (Expression)this.ff.literal(10));
        Envelope env = (Envelope)f.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)this.infinity, (Object)env);
    }

    @Test
    public void testBbox() {
        BBOX f = this.ff.bbox("geom", -10.0, -10.0, 10.0, 10.0, null);
        Envelope env = (Envelope)f.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)new Envelope(-10.0, 10.0, -10.0, 10.0), (Object)env);
    }

    @Test
    public void testAnd() {
        And f = this.ff.and((Filter)this.ff.bbox("geom", -10.0, -10.0, 10.0, 10.0, null), (Filter)this.ff.equals((Expression)this.ff.property("att"), (Expression)this.ff.literal((Object)"10")));
        Envelope env = (Envelope)f.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)new Envelope(-10.0, 10.0, -10.0, 10.0), (Object)env);
    }

    @Test
    public void testOr() {
        Or f = this.ff.or((Filter)this.ff.bbox("geom", -10.0, -10.0, 10.0, 10.0, null), (Filter)this.ff.equals((Expression)this.ff.property("att"), (Expression)this.ff.literal((Object)"10")));
        Envelope env = (Envelope)f.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)this.infinity, (Object)env);
    }

    @Test
    public void testTouches() {
        Coordinate[] coords = new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(10.0, 10.0)};
        LineString lineString = new GeometryFactory().createLineString(coords);
        Touches filter = this.ff.touches((Expression)this.ff.property("name"), (Expression)this.ff.literal((Object)lineString));
        Envelope env = (Envelope)filter.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)new Envelope(0.0, 10.0, 0.0, 10.0), (Object)env);
    }

    @Test
    public void testBeyond() {
        Coordinate[] coords = new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(10.0, 10.0)};
        LineString lineString = new GeometryFactory().createLineString(coords);
        Beyond filter = this.ff.beyond((Expression)this.ff.property("name"), (Expression)this.ff.literal((Object)lineString), 100.0, "m");
        Envelope env = (Envelope)filter.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)this.infinity, (Object)env);
    }

    @Test
    public void testNotBeyond() {
        Coordinate[] coords = new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(10.0, 10.0)};
        LineString lineString = new GeometryFactory().createLineString(coords);
        Beyond filter = this.ff.beyond((Expression)this.ff.property("name"), (Expression)this.ff.literal((Object)lineString), 100.0, "m");
        Envelope env = (Envelope)filter.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)this.infinity, (Object)env);
    }

    @Test
    public void testNull() {
        PropertyIsNull filter = this.ff.isNull((Expression)this.ff.property("name"));
        Envelope env = (Envelope)filter.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)this.infinity, (Object)env);
    }

    @Test
    public void testDWithin() {
        Point geom = new GeometryFactory().createPoint(new Coordinate(0.0, 0.0));
        DWithin filter = this.ff.dwithin((Expression)this.ff.property("name"), (Expression)this.ff.literal((Object)geom), 100.0, "metre");
        Envelope env = (Envelope)filter.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)new Envelope(-100.0, 100.0, -100.0, 100.0), (Object)env);
    }

    @Test
    public void testAndDWithin() {
        Point geom = new GeometryFactory().createPoint(new Coordinate(0.0, 0.0));
        DWithin filter = this.ff.dwithin((Expression)this.ff.property("geom"), (Expression)this.ff.literal((Object)geom), 100.0, "metre");
        filter = this.ff.and((Filter)filter, (Filter)this.ff.bbox((Expression)this.ff.property("geom"), 50.0, 50.0, 150.0, 150.0, null));
        Envelope env = (Envelope)filter.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)new Envelope(50.0, 100.0, 50.0, 100.0), (Object)env);
    }
}

