/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.FeatureTypeStyleImpl;
import org.geotools.styling.Font;
import org.geotools.styling.FontImpl;
import org.geotools.styling.GraphicImpl;
import org.geotools.styling.PointSymbolizerImpl;
import org.geotools.styling.Rule;
import org.geotools.styling.RuleImpl;
import org.geotools.styling.StyleImpl;
import org.geotools.styling.Symbol;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextMarkImpl;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.style.Graphic;

public class TextSymbolTest
extends TestCase {
    private static final FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory(null);
    String dataFolder = System.getProperty("dataFolder");

    public TextSymbolTest(String testName) {
        super(testName);
        if (this.dataFolder == null) {
            this.dataFolder = System.getProperty("basedir");
            this.dataFolder = this.dataFolder + "/tests/unit/testData";
        }
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TextSymbolTest.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(TextSymbolTest.class);
        return suite;
    }

    public void testRender() throws Exception {
        GeometryFactory geomFac = new GeometryFactory();
        MemoryDataStore data = new MemoryDataStore();
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        ftb.add("centre", Point.class);
        ftb.add("size", Double.class);
        ftb.add("rotation", Double.class);
        ftb.add("symbol", String.class);
        ftb.setName("test");
        SimpleFeatureType pointType = ftb.buildFeatureType();
        String[] symbol = new String[]{"\uf04a", "\uf04b", "\uf059", "\uf05a", "\uf06b", "\uf06c", "\uf06e"};
        double size = 16.0;
        double rotation = 0.0;
        int rows = 8;
        for (int j = 0; j < rows; ++j) {
            for (int i = 0; i < symbol.length; ++i) {
                Point point = this.makeSamplePoint(geomFac, (double)i * 5.0 + 5.0, 5.0 + (double)(j * 5));
                SimpleFeature pointFeature = SimpleFeatureBuilder.build((SimpleFeatureType)pointType, (Object[])new Object[]{point, new Double(size), new Double(rotation), symbol[i]}, null);
                data.addFeature(pointFeature);
            }
            size += 2.0;
            rotation += 45.0;
        }
        String typeName = data.getTypeNames()[0];
        FeatureCollection ft = data.getFeatureSource(typeName).getFeatures();
        FontImpl font = new FontImpl();
        font.setFontFamily((Expression)filterFactory.literal((Object)(this.dataFolder + "geog.ttf")));
        font.setFontSize((Expression)filterFactory.property("size"));
        PropertyName symbExpr = filterFactory.property("symbol");
        TextMarkImpl textMark = new TextMarkImpl((Font)font, (Expression)symbExpr);
        FontImpl font2 = new FontImpl();
        font2.setFontFamily((Expression)filterFactory.literal((Object)"MapInfo Cartographic"));
        font2.setFontSize((Expression)filterFactory.property("size"));
        textMark.addFont((Font)font2);
        FontImpl font3 = new FontImpl();
        font3.setFontFamily((Expression)filterFactory.literal((Object)"ESRI Cartography"));
        font3.setFontSize((Expression)filterFactory.property("size"));
        textMark.addFont((Font)font3);
        GraphicImpl graphic = new GraphicImpl();
        graphic.addSymbol((Symbol)textMark);
        PointSymbolizerImpl pointsym = new PointSymbolizerImpl();
        pointsym.setGeometryPropertyName("centre");
        pointsym.setGraphic((Graphic)graphic);
        RuleImpl rule = new RuleImpl();
        rule.setSymbolizers(new Symbolizer[]{pointsym});
        FeatureTypeStyleImpl fts = new FeatureTypeStyleImpl();
        fts.addRule((Rule)rule);
        fts.setFeatureTypeName("testPoint");
        StyleImpl style = new StyleImpl();
        style.addFeatureTypeStyle((FeatureTypeStyle)fts);
    }

    private Point makeSamplePoint(GeometryFactory geomFac, double x, double y) {
        Coordinate c = new Coordinate(x, y);
        Point point = geomFac.createPoint(c);
        return point;
    }
}

