/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.awt.Color;
import junit.framework.TestCase;
import org.geotools.util.ColorConverterFactory;
import org.geotools.util.Converter;
import org.geotools.util.Converters;

public class ColorConverterFactoryTest
extends TestCase {
    ColorConverterFactory factory;

    protected void setUp() throws Exception {
        this.factory = new ColorConverterFactory();
    }

    public void testFromString() throws Exception {
        ColorConverterFactoryTest.assertEquals((Object)Color.RED, (Object)this.convert("#FF0000"));
    }

    public void testFromInteger() throws Exception {
        ColorConverterFactoryTest.assertEquals((Object)Color.RED, (Object)this.convert(0xFF0000));
        ColorConverterFactoryTest.assertEquals((String)"no alpha", (Object)new Color(0, 0, 255, 255), (Object)this.convert(255));
        ColorConverterFactoryTest.assertEquals((String)"255 alpha", (Object)new Color(0, 0, 255, 255), (Object)this.convert(-16776961));
        ColorConverterFactoryTest.assertEquals((String)"1 alpha", (Object)new Color(0, 0, 255, 1), (Object)this.convert(0x10000FF));
    }

    Color convert(Object value) throws Exception {
        Converter converter = this.factory.createConverter(value.getClass(), Color.class, null);
        return (Color)converter.convert(value, Color.class);
    }

    public void testRegisteredWithConverters() {
        Color color = (Color)Converters.convert((Object)"#189E77", Color.class);
        Color expected = new Color(24, 158, 119);
        ColorConverterFactoryTest.assertNotNull((String)"converter not registered", (Object)color);
        ColorConverterFactoryTest.assertEquals((Object)expected, (Object)color);
    }
}

