/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import junit.framework.TestCase;
import org.geotools.util.GeometryConverterFactory;

public class GeometryConverterFactoryTest
extends TestCase {
    GeometryConverterFactory factory;

    protected void setUp() throws Exception {
        this.factory = new GeometryConverterFactory();
    }

    public void testEnvelopeToGeometry() throws Exception {
        Geometry geometry = (Geometry)this.factory.createConverter(Envelope.class, Geometry.class, null).convert((Object)new Envelope(new Coordinate(0.0, 0.0), new Coordinate(1.0, 1.0)), Geometry.class);
        GeometryConverterFactoryTest.assertNotNull((Object)geometry);
        GeometryConverterFactoryTest.assertTrue((boolean)new GeometryFactory().createPolygon(new GeometryFactory().createLinearRing(new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(1.0, 0.0), new Coordinate(1.0, 1.0), new Coordinate(0.0, 1.0), new Coordinate(0.0, 0.0)}), null).equals(geometry));
    }

    public void testGeometryToEnvelope() throws Exception {
        Envelope envelope = (Envelope)this.factory.createConverter(Geometry.class, Envelope.class, null).convert((Object)new GeometryFactory().createPolygon(new GeometryFactory().createLinearRing(new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(1.0, 0.0), new Coordinate(1.0, 1.0), new Coordinate(0.0, 1.0), new Coordinate(0.0, 0.0)}), null), Envelope.class);
        GeometryConverterFactoryTest.assertEquals((Object)new Envelope(new Coordinate(0.0, 0.0), new Coordinate(1.0, 1.0)), (Object)envelope);
    }

    public void testStringToGeometry() throws Exception {
        Geometry geometry = (Geometry)this.factory.createConverter(String.class, Geometry.class, null).convert((Object)"POLYGON((0 0, 1 0, 1 1, 0 1, 0 0))", Geometry.class);
        GeometryConverterFactoryTest.assertNotNull((Object)geometry);
        GeometryConverterFactoryTest.assertTrue((boolean)new GeometryFactory().createPolygon(new GeometryFactory().createLinearRing(new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(1.0, 0.0), new Coordinate(1.0, 1.0), new Coordinate(0.0, 1.0), new Coordinate(0.0, 0.0)}), null).equals(geometry));
    }

    public void testGeometryToString() throws Exception {
        String wkt = (String)this.factory.createConverter(Geometry.class, String.class, null).convert((Object)new GeometryFactory().createPolygon(new GeometryFactory().createLinearRing(new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(1.0, 0.0), new Coordinate(1.0, 1.0), new Coordinate(0.0, 1.0), new Coordinate(0.0, 0.0)}), null), String.class);
        GeometryConverterFactoryTest.assertEquals((String)"POLYGON ((0 0, 1 0, 1 1, 0 1, 0 0))", (String)wkt);
    }
}

