/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.visitor;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.geotools.styling.AnchorPoint;
import org.geotools.styling.ChannelSelection;
import org.geotools.styling.ColorMap;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.ContrastEnhancement;
import org.geotools.styling.Description;
import org.geotools.styling.DescriptionImpl;
import org.geotools.styling.Displacement;
import org.geotools.styling.Extent;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.FeatureTypeStyleImpl;
import org.geotools.styling.Fill;
import org.geotools.styling.Font;
import org.geotools.styling.Graphic;
import org.geotools.styling.Halo;
import org.geotools.styling.ImageOutline;
import org.geotools.styling.LabelPlacement;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.OverlapBehavior;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SelectedChannelType;
import org.geotools.styling.ShadedRelief;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyleFactoryImpl;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.Symbol;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.UserLayer;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DuplicatingStyleVisitor
implements StyleVisitor {
    protected final StyleFactory sf;
    protected final FilterFactory2 ff;
    protected boolean STRICT;
    protected final DuplicatingFilterVisitor copyFilter;
    protected Stack<Object> pages = new Stack();

    public DuplicatingStyleVisitor() {
        this(CommonFactoryFinder.getStyleFactory(null));
    }

    public DuplicatingStyleVisitor(StyleFactory styleFactory) {
        this(styleFactory, CommonFactoryFinder.getFilterFactory2(null));
    }

    public DuplicatingStyleVisitor(StyleFactory styleFactory, FilterFactory2 filterFactory) {
        this.copyFilter = new DuplicatingFilterVisitor(filterFactory);
        this.sf = styleFactory;
        this.ff = filterFactory;
        this.STRICT = false;
    }

    public void setStrict(boolean strict) {
        this.STRICT = strict;
    }

    public Object getCopy() {
        return this.pages.peek();
    }

    public void visit(StyledLayerDescriptor sld) {
        StyledLayerDescriptor copy = null;
        StyledLayer[] layers = sld.getStyledLayers();
        StyledLayer[] layersCopy = new StyledLayer[layers.length];
        int length = layers.length;
        for (int i = 0; i < length; ++i) {
            if (layers[i] instanceof UserLayer) {
                ((UserLayer)layers[i]).accept((StyleVisitor)this);
                layersCopy[i] = (UserLayer)this.pages.pop();
                continue;
            }
            if (!(layers[i] instanceof NamedLayer)) continue;
            ((NamedLayer)layers[i]).accept((StyleVisitor)this);
            layersCopy[i] = (NamedLayer)this.pages.pop();
        }
        copy = this.sf.createStyledLayerDescriptor();
        copy.setAbstract(sld.getAbstract());
        copy.setName(sld.getName());
        copy.setTitle(sld.getTitle());
        copy.setStyledLayers(layersCopy);
        if (this.STRICT && !copy.equals(sld)) {
            throw new IllegalStateException("Was unable to duplicate provided SLD:" + sld);
        }
        this.pages.push(copy);
    }

    public void visit(NamedLayer layer) {
        int i;
        NamedLayer copy = null;
        Style[] style = layer.getStyles();
        Style[] styleCopy = new Style[style.length];
        int length = style.length;
        for (int i2 = 0; i2 < length; ++i2) {
            if (style[i2] == null) continue;
            style[i2].accept((StyleVisitor)this);
            styleCopy[i2] = (Style)this.pages.pop();
        }
        FeatureTypeConstraint[] lfc = layer.getLayerFeatureConstraints();
        FeatureTypeConstraint[] lfcCopy = new FeatureTypeConstraint[lfc.length];
        length = lfc.length;
        for (i = 0; i < length; ++i) {
            if (lfc[i] == null) continue;
            lfc[i].accept((StyleVisitor)this);
            lfcCopy[i] = (FeatureTypeConstraint)this.pages.pop();
        }
        copy = this.sf.createNamedLayer();
        copy.setName(layer.getName());
        length = styleCopy.length;
        for (i = 0; i < length; ++i) {
            copy.addStyle(styleCopy[i]);
        }
        copy.setLayerFeatureConstraints(lfcCopy);
        this.pages.push(copy);
    }

    public void visit(UserLayer layer) {
        UserLayer copy = null;
        Style[] style = layer.getUserStyles();
        int length = style.length;
        Style[] styleCopy = new Style[length];
        for (int i = 0; i < length; ++i) {
            if (style[i] == null) continue;
            style[i].accept((StyleVisitor)this);
            styleCopy[i] = (Style)this.pages.pop();
        }
        FeatureTypeConstraint[] lfc = layer.getLayerFeatureConstraints();
        FeatureTypeConstraint[] lfcCopy = new FeatureTypeConstraint[lfc.length];
        length = lfc.length;
        for (int i = 0; i < length; ++i) {
            if (lfc[i] == null) continue;
            lfc[i].accept((StyleVisitor)this);
            lfcCopy[i] = (FeatureTypeConstraint)this.pages.pop();
        }
        copy = this.sf.createUserLayer();
        copy.setName(layer.getName());
        copy.setUserStyles(styleCopy);
        copy.setLayerFeatureConstraints(lfcCopy);
        if (this.STRICT && !copy.equals(layer)) {
            throw new IllegalStateException("Was unable to duplicate provided UserLayer:" + layer);
        }
        this.pages.push(copy);
    }

    public void visit(Style style) {
        Style copy = null;
        FeatureTypeStyle[] fts = style.getFeatureTypeStyles();
        int length = fts.length;
        FeatureTypeStyle[] ftsCopy = new FeatureTypeStyle[length];
        for (int i = 0; i < length; ++i) {
            if (fts[i] == null) continue;
            fts[i].accept((StyleVisitor)this);
            ftsCopy[i] = (FeatureTypeStyle)this.pages.pop();
        }
        copy = this.sf.createStyle();
        copy.setAbstract(style.getAbstract());
        copy.setName(style.getName());
        copy.setTitle(style.getTitle());
        copy.setFeatureTypeStyles(ftsCopy);
        if (this.STRICT && !copy.equals(style)) {
            throw new IllegalStateException("Was unable to duplicate provided Style:" + style);
        }
        this.pages.push(copy);
    }

    public void visit(Rule rule) {
        Rule copy = null;
        Filter filterCopy = null;
        if (rule.getFilter() != null) {
            Filter filter = rule.getFilter();
            filterCopy = this.copy(filter);
        }
        Symbolizer[] symsCopy = rule.getSymbolizers();
        for (int i = 0; i < symsCopy.length; ++i) {
            symsCopy[i] = this.copy(symsCopy[i]);
        }
        Graphic[] legendCopy = rule.getLegendGraphic();
        for (int i = 0; i < legendCopy.length; ++i) {
            legendCopy[i] = this.copy(legendCopy[i]);
        }
        Description descCopy = rule.getDescription();
        descCopy = this.copy((org.opengis.style.Description)descCopy);
        copy = new StyleFactoryImpl().createRule(symsCopy, (org.opengis.style.Description)descCopy, legendCopy, rule.getName(), filterCopy, rule.isElseFilter(), rule.getMaxScaleDenominator(), rule.getMinScaleDenominator());
        if (this.STRICT && !copy.equals(rule)) {
            throw new IllegalStateException("Was unable to duplicate provided Rule:" + rule);
        }
        this.pages.push(copy);
    }

    public void visit(FeatureTypeStyle fts) {
        FeatureTypeStyleImpl copy = new FeatureTypeStyleImpl((org.opengis.style.FeatureTypeStyle)((FeatureTypeStyleImpl)fts));
        Rule[] rules = fts.getRules();
        int length = rules.length;
        Rule[] rulesCopy = new Rule[length];
        for (int i = 0; i < length; ++i) {
            if (rules[i] == null) continue;
            rules[i].accept((StyleVisitor)this);
            rulesCopy[i] = (Rule)this.pages.pop();
        }
        copy.setRules(rulesCopy);
        if (this.STRICT && !((Object)copy).equals(fts)) {
            throw new IllegalStateException("Was unable to duplicate provided FeatureTypeStyle:" + fts);
        }
        this.pages.push(copy);
    }

    protected Expression copy(Expression expression) {
        if (expression == null) {
            return null;
        }
        return (Expression)expression.accept((ExpressionVisitor)this.copyFilter, (Object)this.ff);
    }

    protected Filter copy(Filter filter) {
        if (filter == null) {
            return null;
        }
        return (Filter)filter.accept((FilterVisitor)this.copyFilter, (Object)this.ff);
    }

    protected Graphic copy(Graphic graphic) {
        if (graphic == null) {
            return null;
        }
        graphic.accept((StyleVisitor)this);
        return (Graphic)this.pages.pop();
    }

    protected Fill copy(Fill fill) {
        if (fill == null) {
            return null;
        }
        fill.accept((StyleVisitor)this);
        return (Fill)this.pages.pop();
    }

    protected float[] copy(float[] array) {
        if (array == null) {
            return null;
        }
        float[] copy = new float[array.length];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    protected <K, V> Map<K, V> copy(Map<K, V> customProperties) {
        if (customProperties == null) {
            return null;
        }
        return new HashMap<K, V>(customProperties);
    }

    protected Stroke copy(Stroke stroke) {
        if (stroke == null) {
            return null;
        }
        stroke.accept((StyleVisitor)this);
        return (Stroke)this.pages.pop();
    }

    protected ShadedRelief copy(ShadedRelief shaded) {
        if (shaded == null) {
            return null;
        }
        Expression reliefFactor = this.copy(shaded.getReliefFactor());
        ShadedRelief copy = this.sf.createShadedRelief(reliefFactor);
        copy.setBrightnessOnly(shaded.isBrightnessOnly());
        return copy;
    }

    protected org.opengis.style.Description copy(org.opengis.style.Description desc) {
        if (desc == null) {
            return null;
        }
        DescriptionImpl copy = new DescriptionImpl(desc.getTitle(), desc.getAbstract());
        return copy;
    }

    protected ExternalGraphic copy(ExternalGraphic externalGraphic) {
        if (externalGraphic == null) {
            return null;
        }
        externalGraphic.accept((StyleVisitor)this);
        return (ExternalGraphic)this.pages.pop();
    }

    protected Mark copy(Mark mark) {
        if (mark == null) {
            return null;
        }
        mark.accept((StyleVisitor)this);
        return (Mark)this.pages.pop();
    }

    protected ColorMapEntry copy(ColorMapEntry entry) {
        if (entry == null) {
            return null;
        }
        entry.accept((StyleVisitor)this);
        return (ColorMapEntry)this.pages.pop();
    }

    protected Symbolizer copy(Symbolizer symbolizer) {
        if (symbolizer == null) {
            return null;
        }
        symbolizer.accept((StyleVisitor)this);
        return (Symbolizer)this.pages.pop();
    }

    protected OverlapBehavior copy(OverlapBehavior ob) {
        if (ob == null) {
            return null;
        }
        ob.accept((StyleVisitor)this);
        return (OverlapBehavior)this.pages.pop();
    }

    protected ContrastEnhancement copy(ContrastEnhancement contrast) {
        if (contrast == null) {
            return null;
        }
        ContrastEnhancement copy = this.sf.createContrastEnhancement();
        copy.setGammaValue(this.copy(contrast.getGammaValue()));
        return copy;
    }

    protected ColorMap copy(ColorMap colorMap) {
        if (colorMap == null) {
            return null;
        }
        colorMap.accept((StyleVisitor)this);
        return (ColorMap)this.pages.pop();
    }

    protected SelectedChannelType[] copy(SelectedChannelType[] channels) {
        if (channels == null) {
            return null;
        }
        SelectedChannelType[] copy = new SelectedChannelType[channels.length];
        for (int i = 0; i < channels.length; ++i) {
            copy[i] = this.copy(channels[i]);
        }
        return copy;
    }

    protected SelectedChannelType copy(SelectedChannelType selectedChannelType) {
        if (selectedChannelType == null) {
            return null;
        }
        ContrastEnhancement enhancement = this.copy(selectedChannelType.getContrastEnhancement());
        String name = selectedChannelType.getChannelName();
        SelectedChannelType copy = this.sf.createSelectedChannelType(name, enhancement);
        return copy;
    }

    protected ChannelSelection copy(ChannelSelection channelSelection) {
        if (channelSelection == null) {
            return null;
        }
        SelectedChannelType[] channels = this.copy(channelSelection.getSelectedChannels());
        ChannelSelection copy = this.sf.createChannelSelection(channels);
        copy.setGrayChannel(this.copy(channelSelection.getGrayChannel()));
        copy.setRGBChannels(this.copy(channelSelection.getRGBChannels()));
        return copy;
    }

    protected Font[] copy(Font[] fonts) {
        if (fonts == null) {
            return null;
        }
        Font[] copy = new Font[fonts.length];
        for (int i = 0; i < fonts.length; ++i) {
            copy[i] = this.copy(fonts[i]);
        }
        return copy;
    }

    protected Font copy(Font font) {
        if (font == null) {
            return font;
        }
        Expression fontFamily = this.copy(font.getFontFamily());
        Expression fontStyle = this.copy(font.getFontStyle());
        Expression fontWeight = this.copy(font.getFontWeight());
        Expression fontSize = this.copy(font.getFontSize());
        Font copy = this.sf.createFont(fontFamily, fontStyle, fontWeight, fontSize);
        return copy;
    }

    protected Halo copy(Halo halo) {
        if (halo == null) {
            return null;
        }
        halo.accept((StyleVisitor)this);
        return (Halo)this.pages.pop();
    }

    protected Displacement copy(Displacement displacement) {
        if (displacement == null) {
            return null;
        }
        displacement.accept((StyleVisitor)this);
        return (Displacement)this.pages.pop();
    }

    protected LabelPlacement copy(LabelPlacement placement) {
        if (placement == null) {
            return null;
        }
        placement.accept((StyleVisitor)this);
        return (LabelPlacement)this.pages.pop();
    }

    protected Symbol copy(Symbol symbol) {
        if (symbol == null) {
            return null;
        }
        symbol.accept((StyleVisitor)this);
        return (Symbol)this.pages.pop();
    }

    protected AnchorPoint copy(AnchorPoint anchorPoint) {
        if (anchorPoint == null) {
            return null;
        }
        anchorPoint.accept((StyleVisitor)this);
        return (AnchorPoint)this.pages.pop();
    }

    public void visit(Fill fill) {
        Fill copy = this.sf.getDefaultFill();
        copy.setBackgroundColor(this.copy(fill.getBackgroundColor()));
        copy.setColor(this.copy(fill.getColor()));
        copy.setGraphicFill((org.opengis.style.Graphic)this.copy(fill.getGraphicFill()));
        copy.setOpacity(this.copy(fill.getOpacity()));
        if (this.STRICT && !copy.equals(fill)) {
            throw new IllegalStateException("Was unable to duplicate provided Fill:" + fill);
        }
        this.pages.push(copy);
    }

    public void visit(Stroke stroke) {
        Stroke copy = this.sf.getDefaultStroke();
        copy.setColor(this.copy(stroke.getColor()));
        copy.setDashArray(this.copy(stroke.getDashArray()));
        copy.setDashOffset(this.copy(stroke.getDashOffset()));
        copy.setGraphicFill((org.opengis.style.Graphic)this.copy(stroke.getGraphicFill()));
        copy.setGraphicStroke((org.opengis.style.Graphic)this.copy(stroke.getGraphicStroke()));
        copy.setLineCap(this.copy(stroke.getLineCap()));
        copy.setLineJoin(this.copy(stroke.getLineJoin()));
        copy.setOpacity(this.copy(stroke.getOpacity()));
        copy.setWidth(this.copy(stroke.getWidth()));
        if (this.STRICT && !copy.equals(stroke)) {
            throw new IllegalStateException("Was unable to duplicate provided Stroke:" + stroke);
        }
        this.pages.push(copy);
    }

    public void visit(Symbolizer sym) {
        if (sym instanceof RasterSymbolizer) {
            this.visit((RasterSymbolizer)sym);
        } else if (sym instanceof LineSymbolizer) {
            this.visit((LineSymbolizer)sym);
        } else if (sym instanceof PolygonSymbolizer) {
            this.visit((PolygonSymbolizer)sym);
        } else if (sym instanceof PointSymbolizer) {
            this.visit((PointSymbolizer)sym);
        } else if (sym instanceof TextSymbolizer) {
            this.visit((TextSymbolizer)sym);
        } else {
            throw new RuntimeException("visit(Symbolizer) unsupported");
        }
    }

    public void visit(PointSymbolizer ps) {
        PointSymbolizer copy = this.sf.getDefaultPointSymbolizer();
        copy.setGeometryPropertyName(ps.getGeometryPropertyName());
        copy.setUnitOfMeasure(ps.getUnitOfMeasure());
        copy.setGraphic((org.opengis.style.Graphic)this.copy(ps.getGraphic()));
        if (this.STRICT && !copy.equals(ps)) {
            throw new IllegalStateException("Was unable to duplicate provided Graphic:" + ps);
        }
        this.pages.push(copy);
    }

    public void visit(LineSymbolizer line) {
        LineSymbolizer copy = this.sf.getDefaultLineSymbolizer();
        copy.setGeometryPropertyName(line.getGeometryPropertyName());
        copy.setUnitOfMeasure(line.getUnitOfMeasure());
        copy.setStroke((org.opengis.style.Stroke)this.copy(line.getStroke()));
        if (this.STRICT && !copy.equals(line)) {
            throw new IllegalStateException("Was unable to duplicate provided LineSymbolizer:" + line);
        }
        this.pages.push(copy);
    }

    public void visit(PolygonSymbolizer poly) {
        PolygonSymbolizer copy = this.sf.createPolygonSymbolizer();
        copy.setFill((org.opengis.style.Fill)this.copy(poly.getFill()));
        copy.setGeometryPropertyName(poly.getGeometryPropertyName());
        copy.setUnitOfMeasure(poly.getUnitOfMeasure());
        copy.setStroke((org.opengis.style.Stroke)this.copy(poly.getStroke()));
        if (this.STRICT && !copy.equals(poly)) {
            throw new IllegalStateException("Was unable to duplicate provided PolygonSymbolizer:" + poly);
        }
        this.pages.push(copy);
    }

    public void visit(TextSymbolizer text) {
        TextSymbolizer copy = this.sf.createTextSymbolizer();
        copy.setFill((org.opengis.style.Fill)this.copy(text.getFill()));
        copy.setFont((org.opengis.style.Font)this.copy(text.getFont()));
        copy.setGeometryPropertyName(text.getGeometryPropertyName());
        copy.setUnitOfMeasure(text.getUnitOfMeasure());
        copy.setHalo((org.opengis.style.Halo)this.copy(text.getHalo()));
        copy.setLabel(this.copy(text.getLabel()));
        copy.setLabelPlacement((org.opengis.style.LabelPlacement)this.copy(text.getLabelPlacement()));
        copy.setPriority(this.copy(text.getPriority()));
        copy.getOptions().putAll(text.getOptions());
        if (this.STRICT && !copy.equals(text)) {
            throw new IllegalStateException("Was unable to duplicate provided TextSymbolizer:" + text);
        }
        this.pages.push(copy);
    }

    public void visit(RasterSymbolizer raster) {
        RasterSymbolizer copy = this.sf.createRasterSymbolizer();
        copy.setChannelSelection((org.opengis.style.ChannelSelection)this.copy(raster.getChannelSelection()));
        copy.setColorMap((org.opengis.style.ColorMap)this.copy(raster.getColorMap()));
        copy.setContrastEnhancement((org.opengis.style.ContrastEnhancement)this.copy(raster.getContrastEnhancement()));
        copy.setGeometryPropertyName(raster.getGeometryPropertyName());
        copy.setUnitOfMeasure(raster.getUnitOfMeasure());
        copy.setImageOutline((org.opengis.style.Symbolizer)this.copy(raster.getImageOutline()));
        copy.setOpacity(this.copy(raster.getOpacity()));
        copy.setOverlap(this.copy(raster.getOverlap()));
        copy.setShadedRelief((org.opengis.style.ShadedRelief)this.copy(raster.getShadedRelief()));
        if (this.STRICT && !copy.equals(raster)) {
            throw new IllegalStateException("Was unable to duplicate provided raster:" + raster);
        }
        this.pages.push(copy);
    }

    public void visit(Graphic gr) {
        Graphic copy = null;
        Displacement displacementCopy = this.copy(gr.getDisplacement());
        ExternalGraphic[] externalGraphicsCopy = this.copy(gr.getExternalGraphics());
        Mark[] marksCopy = this.copy(gr.getMarks());
        Expression opacityCopy = this.copy(gr.getOpacity());
        Expression rotationCopy = this.copy(gr.getRotation());
        Expression sizeCopy = this.copy(gr.getSize());
        copy = this.sf.createDefaultGraphic();
        copy.setGeometryPropertyName(gr.getGeometryPropertyName());
        copy.setDisplacement((org.opengis.style.Displacement)displacementCopy);
        copy.setExternalGraphics(externalGraphicsCopy);
        copy.setMarks(marksCopy);
        copy.setOpacity(opacityCopy);
        copy.setRotation(rotationCopy);
        copy.setSize(sizeCopy);
        if (this.STRICT && !copy.equals(gr)) {
            throw new IllegalStateException("Was unable to duplicate provided Graphic:" + gr);
        }
        this.pages.push(copy);
    }

    private Mark[] copy(Mark[] marks) {
        if (marks == null) {
            return null;
        }
        Mark[] copy = new Mark[marks.length];
        for (int i = 0; i < marks.length; ++i) {
            copy[i] = this.copy(marks[i]);
        }
        return copy;
    }

    private Symbol[] copy(Symbol[] symbols) {
        if (symbols == null) {
            return null;
        }
        Symbol[] copy = new Symbol[symbols.length];
        for (int i = 0; i < symbols.length; ++i) {
            copy[i] = this.copy(symbols[i]);
        }
        return copy;
    }

    private ExternalGraphic[] copy(ExternalGraphic[] externalGraphics) {
        if (externalGraphics == null) {
            return null;
        }
        ExternalGraphic[] copy = new ExternalGraphic[externalGraphics.length];
        for (int i = 0; i < externalGraphics.length; ++i) {
            copy[i] = this.copy(externalGraphics[i]);
        }
        return copy;
    }

    public void visit(Mark mark) {
        Mark copy = null;
        copy = this.sf.createMark();
        copy.setFill((org.opengis.style.Fill)this.copy(mark.getFill()));
        copy.setRotation(this.copy(mark.getRotation()));
        copy.setSize(this.copy(mark.getSize()));
        copy.setStroke((org.opengis.style.Stroke)this.copy(mark.getStroke()));
        copy.setWellKnownName(this.copy(mark.getWellKnownName()));
        if (this.STRICT && !copy.equals(mark)) {
            throw new IllegalStateException("Was unable to duplicate provided Mark:" + mark);
        }
        this.pages.push(copy);
    }

    public void visit(ExternalGraphic exgr) {
        URL uri = null;
        try {
            uri = exgr.getLocation();
        }
        catch (MalformedURLException huh) {
            // empty catch block
        }
        String format = exgr.getFormat();
        ExternalGraphic copy = this.sf.createExternalGraphic(uri, format);
        copy.setCustomProperties(this.copy(exgr.getCustomProperties()));
        if (this.STRICT && !copy.equals(exgr)) {
            throw new IllegalStateException("Was unable to duplicate provided ExternalGraphic:" + exgr);
        }
        this.pages.push(copy);
    }

    public void visit(PointPlacement pp) {
        PointPlacement copy = this.sf.getDefaultPointPlacement();
        copy.setAnchorPoint((org.opengis.style.AnchorPoint)this.copy(pp.getAnchorPoint()));
        copy.setDisplacement((org.opengis.style.Displacement)this.copy(pp.getDisplacement()));
        copy.setRotation(this.copy(pp.getRotation()));
        if (this.STRICT && !copy.equals(pp)) {
            throw new IllegalStateException("Was unable to duplicate provided PointPlacement:" + pp);
        }
        this.pages.push(copy);
    }

    public void visit(AnchorPoint ap) {
        Expression x = this.copy(ap.getAnchorPointX());
        Expression y = this.copy(ap.getAnchorPointY());
        AnchorPoint copy = this.sf.createAnchorPoint(x, y);
        if (this.STRICT && !copy.equals(ap)) {
            throw new IllegalStateException("Was unable to duplicate provided AnchorPoint:" + ap);
        }
        this.pages.push(copy);
    }

    public void visit(Displacement dis) {
        Expression x = this.copy(dis.getDisplacementX());
        Expression y = this.copy(dis.getDisplacementY());
        Displacement copy = this.sf.createDisplacement(x, y);
        if (this.STRICT && !copy.equals(dis)) {
            throw new IllegalStateException("Was unable to duplicate provided Displacement:" + dis);
        }
        this.pages.push(copy);
    }

    public void visit(LinePlacement lp) {
        Expression offset = this.copy(lp.getPerpendicularOffset());
        LinePlacement copy = this.sf.createLinePlacement(offset);
        copy.setAligned(lp.isAligned());
        copy.setGap(this.copy(lp.getGap()));
        copy.setGeneralized(lp.isGeneralizeLine());
        copy.setInitialGap(this.copy(lp.getInitialGap()));
        copy.setRepeated(lp.isRepeated());
        if (this.STRICT && !copy.equals(lp)) {
            throw new IllegalStateException("Was unable to duplicate provided LinePlacement:" + lp);
        }
        this.pages.push(copy);
    }

    public void visit(Halo halo) {
        Fill fill = this.copy(halo.getFill());
        Expression radius = this.copy(halo.getRadius());
        Halo copy = this.sf.createHalo(fill, radius);
        if (this.STRICT && !copy.equals(halo)) {
            throw new IllegalStateException("Was unable to duplicate provided raster:" + halo);
        }
        this.pages.push(copy);
    }

    public void visit(FeatureTypeConstraint ftc) {
        String typeName = ftc.getFeatureTypeName();
        Filter filter = this.copy(ftc.getFilter());
        Extent[] extents = this.copy(ftc.getExtents());
        FeatureTypeConstraint copy = this.sf.createFeatureTypeConstraint(typeName, filter, extents);
        if (this.STRICT && !copy.equals(ftc)) {
            throw new IllegalStateException("Was unable to duplicate provided FeatureTypeConstraint:" + ftc);
        }
        this.pages.push(copy);
    }

    protected Extent[] copy(Extent[] extents) {
        if (extents == null) {
            return null;
        }
        Extent[] copy = new Extent[extents.length];
        for (int i = 0; i < extents.length; ++i) {
            copy[i] = this.copy(extents[i]);
        }
        return copy;
    }

    protected Extent copy(Extent extent) {
        String name = extent.getName();
        String value = extent.getValue();
        Extent copy = this.sf.createExtent(name, value);
        return copy;
    }

    public void visit(ColorMap colorMap) {
        ColorMap copy = this.sf.createColorMap();
        copy.setType(colorMap.getType());
        ColorMapEntry[] entries = colorMap.getColorMapEntries();
        if (entries != null) {
            for (int i = 0; i < entries.length; ++i) {
                ColorMapEntry entry = entries[i];
                copy.addColorMapEntry(this.copy(entry));
            }
        }
        if (this.STRICT && !copy.equals(colorMap)) {
            throw new IllegalStateException("Was unable to duplicate provided ColorMap:" + colorMap);
        }
        this.pages.push(copy);
    }

    public void visit(ColorMapEntry colorMapEntry) {
        ColorMapEntry copy = this.sf.createColorMapEntry();
        copy.setColor(this.copy(colorMapEntry.getColor()));
        copy.setLabel(colorMapEntry.getLabel());
        copy.setOpacity(this.copy(colorMapEntry.getOpacity()));
        copy.setQuantity(colorMapEntry.getQuantity());
        if (this.STRICT && !copy.equals(colorMapEntry)) {
            throw new IllegalStateException("Was unable to duplicate provided ColorMapEntry:" + colorMapEntry);
        }
        this.pages.push(copy);
    }

    public void visit(ContrastEnhancement contrastEnhancement) {
        ContrastEnhancement copy = this.sf.createContrastEnhancement();
        copy.setType(contrastEnhancement.getType());
        copy.setGammaValue(contrastEnhancement.getGammaValue());
        if (this.STRICT && !copy.equals(contrastEnhancement)) {
            throw new IllegalStateException("Was unable to duplicate provided contrastEnhancement:" + contrastEnhancement);
        }
        this.pages.push(copy);
    }

    public void visit(ImageOutline outline) {
        Symbolizer symb = outline.getSymbolizer();
        Symbolizer copySymb = this.copy(symb);
        ImageOutline copy = this.sf.createImageOutline(copySymb);
        copy.setSymbolizer(copySymb);
        if (this.STRICT && !copy.equals(outline)) {
            throw new IllegalStateException("Was unable to duplicate provided ImageOutline:" + outline);
        }
        this.pages.push(copy);
    }

    public void visit(ChannelSelection cs) {
        SelectedChannelType[] sct = this.copy(cs.getSelectedChannels());
        ChannelSelection copy = this.sf.createChannelSelection(sct);
        if (this.STRICT && !copy.equals(cs)) {
            throw new IllegalStateException("Was unable to duplicate provided ChannelSelection:" + cs);
        }
        this.pages.push(copy);
    }

    public void visit(OverlapBehavior ob) {
        String behavior = (String)ob.getValue();
        if (behavior.equalsIgnoreCase("AVERAGE")) {
            this.pages.push("AVERAGE");
        } else if (behavior.equalsIgnoreCase("EARLIEST_ON_TOP")) {
            this.pages.push("EARLIEST_ON_TOP");
        } else if (behavior.equalsIgnoreCase("LATEST_ON_TOP")) {
            this.pages.push("LATEST_ON_TOP");
        } else if (behavior.equalsIgnoreCase("RANDOM")) {
            this.pages.push("RANDOM");
        } else {
            throw new IllegalStateException("Was unable to duplicate provided OverlapBehavior:" + ob);
        }
    }

    public void visit(SelectedChannelType sct) {
        SelectedChannelType copy = this.sf.createSelectedChannelType(sct.getChannelName(), this.copy(sct.getContrastEnhancement()));
        if (this.STRICT && !copy.equals(sct)) {
            throw new IllegalStateException("Was unable to duplicate provided SelectedChannelType:" + sct);
        }
        this.pages.push(copy);
    }

    public void visit(ShadedRelief sr) {
        ShadedRelief copy = this.sf.createShadedRelief(this.copy(sr.getReliefFactor()));
        copy.setBrightnessOnly(sr.isBrightnessOnly());
        if (this.STRICT && !copy.equals(sr)) {
            throw new IllegalStateException("Was unable to duplicate provided ShadedRelief:" + sr);
        }
        this.pages.push(copy);
    }
}

