/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.view;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.io.IOException;
import junit.framework.TestCase;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.Query;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.filter.IllegalFilterException;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.expression.Expression;

public class DefaultViewTest
extends TestCase {
    String typeName = "type1";
    private MemoryDataStore ds;

    protected void setUp() throws Exception {
        super.setUp();
        SimpleFeatureType ft = DataUtilities.createType((String)this.typeName, (String)"geom:Point,name:String,id:int");
        this.ds = new MemoryDataStore();
        this.ds.addFeature(this.createFeatures(ft, 1));
        this.ds.addFeature(this.createFeatures(ft, 2));
        this.ds.addFeature(this.createFeatures(ft, 3));
        this.ds.addFeature(this.createFeatures(ft, 4));
    }

    private SimpleFeature createFeatures(SimpleFeatureType ft, int i) throws IllegalAttributeException {
        GeometryFactory fac = new GeometryFactory();
        return SimpleFeatureBuilder.build((SimpleFeatureType)ft, (Object[])new Object[]{fac.createPoint(new Coordinate((double)i, (double)i)), "name" + i, new Integer(i)}, null);
    }

    public void testGetFeatures() throws Exception {
        SimpleFeatureSource view = this.getView();
        SimpleFeatureIterator features = view.getFeatures().features();
        int count = 0;
        while (features.hasNext()) {
            ++count;
            features.next();
        }
        DefaultViewTest.assertEquals((int)2, (int)count);
    }

    public void testGetFeaturesQuery() throws Exception {
        SimpleFeatureSource view = this.getView();
        SimpleFeatureIterator features = view.getFeatures(this.getQuery()).features();
        int count = 0;
        while (features.hasNext()) {
            ++count;
            features.next();
        }
        DefaultViewTest.assertEquals((int)1, (int)count);
    }

    public void testGetFeaturesFilter() throws Exception {
        SimpleFeatureSource view = this.getView();
        Filter f = this.getFilter();
        SimpleFeatureIterator features = view.getFeatures(f).features();
        int count = 0;
        while (features.hasNext()) {
            ++count;
            features.next();
        }
        DefaultViewTest.assertEquals((int)1, (int)count);
    }

    public void testGetCount() throws Exception {
        SimpleFeatureSource view = this.getView();
        Query query = this.getQuery();
        int count = view.getCount(query);
        DefaultViewTest.assertEquals((int)1, (int)count);
    }

    private Query getQuery() throws IllegalFilterException {
        Filter f = this.getFilter();
        Query query = new Query(this.typeName, f, new String[0]);
        return query;
    }

    private Filter getFilter() throws IllegalFilterException {
        FilterFactory fac = CommonFactoryFinder.getFilterFactory(null);
        PropertyIsEqualTo f = fac.equals((Expression)fac.property("name"), (Expression)fac.literal((Object)"name2"));
        return f;
    }

    private SimpleFeatureSource getView() throws IllegalFilterException, IOException, SchemaException {
        FilterFactory fac = CommonFactoryFinder.getFilterFactory(null);
        PropertyIsLessThan f = fac.less((Expression)fac.property("id"), (Expression)fac.literal(3));
        SimpleFeatureSource view = DataUtilities.createView((DataStore)this.ds, (Query)new Query(this.typeName, (Filter)f));
        return view;
    }
}

