/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.lang.reflect.Array;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.geotools.data.DataTestCase;
import org.geotools.data.DataUtilities;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.type.BasicFeatureTypes;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;

public class FeatureTypeTest
extends DataTestCase {
    static Set immutable = new HashSet();

    static {
        immutable.add(String.class);
        immutable.add(Integer.class);
        immutable.add(Double.class);
        immutable.add(Float.class);
    }

    public FeatureTypeTest(String testName) {
        super(testName);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)FeatureTypeTest.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(FeatureTypeTest.class);
        return suite;
    }

    public void testAbstractType() throws Exception {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName("AbstractThing");
        tb.setAbstract(true);
        tb.setNamespaceURI(new URI("http://www.nowhereinparticular.net"));
        SimpleFeatureType abstractType = tb.buildFeatureType();
        tb.setName("AbstractType2");
        tb.setSuperType(abstractType);
        tb.add("X", String.class);
        SimpleFeatureType abstractType2 = tb.buildFeatureType();
        FeatureTypeTest.assertTrue((boolean)abstractType.isAbstract());
        FeatureTypeTest.assertTrue((boolean)abstractType2.isAbstract());
        FeatureTypeTest.assertTrue((String)"abstractType2 --|> abstractType", (boolean)FeatureTypes.isDecendedFrom((FeatureType)abstractType2, (FeatureType)abstractType));
        FeatureTypeTest.assertFalse((String)"abstractType2 !--|> abstractType", (boolean)FeatureTypes.isDecendedFrom((FeatureType)abstractType, (FeatureType)abstractType2));
        try {
            SimpleFeatureBuilder.build((SimpleFeatureType)abstractType, (Object[])new Object[0], null);
            FeatureTypeTest.fail((String)"abstract type allowed create");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            SimpleFeatureBuilder.build((SimpleFeatureType)abstractType2, (Object[])new Object[0], null);
            FeatureTypeTest.fail((String)"abstract type allowed create");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testEquals() throws Exception {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName("Thing");
        tb.setNamespaceURI("http://www.nowhereinparticular.net");
        tb.add("X", String.class);
        SimpleFeatureType ft = tb.buildFeatureType();
        tb = new SimpleFeatureTypeBuilder();
        tb.setName("Thing");
        tb.setNamespaceURI("http://www.nowhereinparticular.net");
        tb.add("X", String.class);
        SimpleFeatureType ft2 = tb.buildFeatureType();
        FeatureTypeTest.assertEquals((Object)ft, (Object)ft2);
        tb.setName("Thingee");
        FeatureTypeTest.assertTrue((!ft.equals((Object)tb.buildFeatureType()) ? 1 : 0) != 0);
        tb.init(ft);
        tb.setNamespaceURI("http://www.somewhereelse.net");
        FeatureTypeTest.assertTrue((!ft.equals((Object)tb.buildFeatureType()) ? 1 : 0) != 0);
        FeatureTypeTest.assertTrue((!ft.equals(null) ? 1 : 0) != 0);
    }

    public void testCopyFeature() throws Exception {
        SimpleFeature feature = this.lakeFeatures[0];
        this.assertDuplicate("feature", feature, SimpleFeatureBuilder.copy((SimpleFeature)feature));
    }

    public void testAncestors() throws Exception {
        URI uri = new URI("http://www.geotools.org/example");
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName("A");
        tb.setNamespaceURI(uri);
        SimpleFeatureType typeA = tb.buildFeatureType();
        tb = new SimpleFeatureTypeBuilder();
        tb.setName("B");
        tb.setNamespaceURI(uri);
        tb.setSuperType(typeA);
        tb.add("b", String.class);
        SimpleFeatureType typeB = tb.buildFeatureType();
        tb = new SimpleFeatureTypeBuilder();
        tb.setName("C");
        tb.setNamespaceURI(uri);
        tb.setSuperType(typeB);
        tb.add("c", Integer.class);
        SimpleFeatureType typeC = tb.buildFeatureType();
        FeatureTypeTest.assertEquals((String)"Ancestors of Feature, nearest first", Collections.emptyList(), (Object)FeatureTypes.getAncestors((FeatureType)BasicFeatureTypes.FEATURE));
        FeatureTypeTest.assertEquals((String)"Ancestors of A, nearest first", (Object)new ArrayList<FeatureType>(){
            {
                this.add(BasicFeatureTypes.FEATURE);
            }
        }, (Object)FeatureTypes.getAncestors((FeatureType)typeA));
        FeatureTypeTest.assertEquals((String)"Ancestors of B, nearest first", (Object)new ArrayList<FeatureType>(typeA){
            {
                this.add(simpleFeatureType);
                this.add(BasicFeatureTypes.FEATURE);
            }
        }, (Object)FeatureTypes.getAncestors((FeatureType)typeB));
        FeatureTypeTest.assertEquals((String)"Ancestors of C, nearest first", (Object)new ArrayList<FeatureType>(typeB, typeA){
            {
                this.add(simpleFeatureType);
                this.add(simpleFeatureType2);
                this.add(BasicFeatureTypes.FEATURE);
            }
        }, (Object)FeatureTypes.getAncestors((FeatureType)typeC));
    }

    public void testDeepCopy() throws Exception {
        String str = "FooBar";
        Integer i = new Integer(3);
        Float f = new Float(3.14);
        Double d = new Double(3.14159);
        AttributeTypeBuilder ab = new AttributeTypeBuilder();
        AttributeDescriptor testType = ab.binding(Object.class).buildDescriptor("test");
        FeatureTypeTest.assertSame((String)"String", (Object)str, (Object)DataUtilities.duplicate((Object)str));
        FeatureTypeTest.assertSame((String)"Integer", (Object)i, (Object)DataUtilities.duplicate((Object)i));
        FeatureTypeTest.assertSame((String)"Float", (Object)f, (Object)DataUtilities.duplicate((Object)f));
        FeatureTypeTest.assertSame((String)"Double", (Object)d, (Object)DataUtilities.duplicate((Object)d));
        Object[] objs = new Object[]{str, i, f, d};
        int[] ints = new int[]{1, 2, 3, 4};
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(str);
        list.add(i);
        list.add(f);
        list.add(d);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("a", str);
        map.put("b", i);
        map.put("c", f);
        map.put("d", d);
        this.assertDuplicate("objs", objs, DataUtilities.duplicate((Object)objs));
        this.assertDuplicate("ints", ints, DataUtilities.duplicate((Object)ints));
        this.assertDuplicate("list", list, DataUtilities.duplicate(list));
        this.assertDuplicate("map", map, DataUtilities.duplicate(map));
        SimpleFeature feature = this.lakeFeatures[0];
        Coordinate coords = new Coordinate(1.0, 3.0);
        Coordinate coords2 = new Coordinate(1.0, 3.0);
        GeometryFactory gf = new GeometryFactory();
        Point point = gf.createPoint(coords);
        Point point2 = gf.createPoint(coords2);
        FeatureTypeTest.assertTrue((String)"jts identity", (point != point2 ? 1 : 0) != 0);
        FeatureTypeTest.assertTrue((String)"jts equals1", (boolean)point.equals((Geometry)point2));
        FeatureTypeTest.assertTrue((String)"jts equals", (!point.equals(point2) ? 1 : 0) != 0);
        this.assertDuplicate("jts duplicate", point, point2);
        this.assertDuplicate("feature", feature, DataUtilities.duplicate((Object)feature));
        this.assertDuplicate("point", point, DataUtilities.duplicate((Object)point));
    }

    protected void assertDuplicate(String message, Object expected, Object value) {
        if (expected.getClass().isArray()) {
            int length1 = Array.getLength(expected);
            int length2 = Array.getLength(value);
            FeatureTypeTest.assertEquals((String)message, (int)length1, (int)length2);
            int i = 0;
            while (i < length1) {
                this.assertDuplicate(String.valueOf(message) + "[" + i + "]", Array.get(expected, i), Array.get(value, i));
                ++i;
            }
        } else if (expected instanceof Geometry) {
            FeatureTypeTest.assertTrue((String)message, (boolean)(value instanceof Geometry));
            FeatureTypeTest.assertTrue((String)message, (boolean)(expected instanceof Geometry));
            Geometry expectedGeom = (Geometry)expected;
            Geometry actualGeom = (Geometry)value;
            FeatureTypeTest.assertTrue((String)message, (boolean)expectedGeom.equals(actualGeom));
        } else if (expected instanceof SimpleFeature) {
            this.assertDuplicate(message, ((SimpleFeature)expected).getAttributes(), ((SimpleFeature)value).getAttributes());
        } else {
            FeatureTypeTest.assertEquals((String)message, (Object)expected, (Object)value);
        }
        immutable.contains(expected.getClass());
    }
}

