/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import java.io.File;
import java.io.FileFilter;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.Assert;
import junit.framework.Protectable;
import junit.framework.Test;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.FilterDOMParser;
import org.geotools.test.TestData;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMParserTestSuite
extends TestSuite {
    protected static final Logger LOGGER = Logging.getLogger((String)"org.geotools.filter");
    protected static SimpleFeatureType testSchema = null;
    protected static SimpleFeature testFeature = null;
    protected boolean setup = false;

    public DOMParserTestSuite() {
        super("DOM Parser Test Suite");
    }

    static void prepareFeatures() throws SchemaException, IllegalAttributeException {
        LOGGER.finer("creating flat feature...");
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        ftb.add("testGeometry", LineString.class);
        ftb.add("testBoolean", Boolean.class);
        ftb.add("testCharacter", Character.class);
        ftb.add("testByte", Byte.class);
        ftb.add("testShort", Short.class);
        ftb.add("testInteger", Integer.class);
        ftb.add("testLong", Long.class);
        ftb.add("testFloat", Float.class);
        ftb.add("testDouble", Double.class);
        ftb.add("testString", String.class);
        ftb.add("testZeroDouble", Double.class);
        ftb.setName("testSchema");
        testSchema = ftb.buildFeatureType();
        GeometryFactory geomFac = new GeometryFactory();
        Coordinate[] coords = new Coordinate[]{new Coordinate(1.0, 2.0), new Coordinate(3.0, 4.0), new Coordinate(5.0, 6.0)};
        Object[] attributes = new Object[]{geomFac.createLineString(coords), new Boolean(true), new Character('t'), new Byte("10"), new Short("101"), new Integer(1002), new Long(10003L), new Float(10000.4), new Double(100000.5), "test string data", new Double(0.0)};
        testFeature = SimpleFeatureBuilder.build((SimpleFeatureType)testSchema, (Object[])attributes, null);
        LOGGER.finer("...flat feature created");
    }

    public static Test suite() {
        DOMParserTestSuite suite = new DOMParserTestSuite();
        try {
            DOMParserTestSuite.prepareFeatures();
            File dir = TestData.file(DOMParserTestSuite.class, (String)"test9.xml").getParentFile();
            File[] tests = dir.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.toString().endsWith("test20.xml");
                }
            });
            int i = 0;
            while (i < tests.length) {
                File test = tests[i];
                DOMParserTestSuite dOMParserTestSuite = suite;
                ((Object)((Object)dOMParserTestSuite)).getClass();
                suite.addTest(dOMParserTestSuite.new DomTestXml(test.getName()));
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(String.valueOf(suite.countTestCases()) + " xml filter tests found");
        return suite;
    }

    class DomTestXml
    extends Assert
    implements Test {
        String document;

        public DomTestXml(String document) {
            this.document = document;
        }

        public String toString() {
            return this.document;
        }

        public int countTestCases() {
            return 1;
        }

        public void run(TestResult result) {
            System.out.println(this.document);
            result.startTest((Test)this);
            Protectable p = new Protectable(){

                public void protect() throws Throwable {
                    DomTestXml.this.runBare();
                }
            };
            result.runProtected((Test)this, p);
            result.endTest((Test)this);
        }

        public void runBare() throws Throwable {
            Throwable exception = null;
            try {
                this.runTest();
            }
            catch (Throwable running) {
                exception = running;
            }
            if (exception != null) {
                throw exception;
            }
        }

        public void runTest() throws Throwable {
            Filter filter = this.parseDocument(this.document);
            DomTestXml.assertNotNull((Object)filter);
            LOGGER.fine("Parsed filter is " + filter);
        }

        public Filter parseDocument(String uri) throws Exception {
            Filter filter = null;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document dom = db.parse(TestData.getResource((Object)((Object)this), (String)uri).toExternalForm());
            LOGGER.fine("parsing " + uri);
            NodeList nodes = dom.getElementsByTagName("Filter");
            int j = 0;
            while (j < nodes.getLength()) {
                Element filterNode = (Element)nodes.item(j);
                NodeList list = filterNode.getChildNodes();
                Node child = null;
                int i = 0;
                while (i < list.getLength()) {
                    child = list.item(i);
                    if (child != null && child.getNodeType() == 1) {
                        filter = FilterDOMParser.parseFilter((Node)child);
                        DomTestXml.assertNotNull((String)"Null filter returned", (Object)filter);
                        LOGGER.finer("filter: " + filter.getClass().toString());
                        LOGGER.fine("parsed: " + filter.toString());
                        LOGGER.finer("result " + filter.evaluate((Object)testFeature));
                    }
                    ++i;
                }
                ++j;
            }
            return filter;
        }
    }
}

