/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import junit.framework.TestCase;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.filter.Expression;
import org.geotools.filter.FunctionExpression;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.LiteralExpressionImpl;
import org.geotools.util.logging.Logging;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.NilExpression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;

public class FunctionExpressionImplTest
extends TestCase {
    private static final Logger LOGGER = Logging.getLogger((String)FunctionExpressionImplTest.class.getPackage().getName());
    FunctionExpressionImpl function;
    TestExpressionVisitor testVisitor;

    public void setUp() throws Exception {
        super.setUp();
        this.function = new FunctionExpressionImpl("testFunction"){

            public int getArgCount() {
                return 1;
            }
        };
        this.testVisitor = new TestExpressionVisitor();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.function = null;
        this.testVisitor = null;
    }

    public void testAcceptExpressionVisitor() {
        Object extraData = new Object();
        this.function.accept((ExpressionVisitor)this.testVisitor, extraData);
        Object[] expected = new Object[]{Boolean.TRUE, extraData};
        Object[] actual = this.testVisitor.functionVisited;
        FunctionExpressionImplTest.assertEquals((Object)expected[0], (Object)actual[0]);
        FunctionExpressionImplTest.assertEquals((Object)expected[1], (Object)actual[1]);
    }

    public void testGetType() {
        FunctionExpressionImplTest.assertEquals((short)114, (short)this.function.getType());
    }

    public void testGetName() {
        this.function.setName("testFunction");
        FunctionExpressionImplTest.assertEquals((String)"testFunction", (String)this.function.getName());
    }

    public void testSetName() {
        this.function.setName("testFunction");
        FunctionExpressionImplTest.assertEquals((String)"testFunction", (String)this.function.name);
    }

    public void testGetParameters() {
        List<LiteralExpressionImpl> expected;
        this.function.params = expected = Collections.singletonList(new LiteralExpressionImpl(10.0));
        FunctionExpressionImplTest.assertEquals(expected, (Object)this.function.getParameters());
    }

    public void testSetParameters() {
        List<LiteralExpressionImpl> expected = Collections.singletonList(new LiteralExpressionImpl(10.0));
        this.function.setParameters(expected);
        FunctionExpressionImplTest.assertEquals(expected, (Object)this.function.params);
    }

    public void testGetArgs() {
        List<LiteralExpressionImpl> expected = Collections.singletonList(new LiteralExpressionImpl(10.0));
        this.function.setParameters(expected);
        Expression[] args = this.function.getArgs();
        List<Expression> actual = Arrays.asList(args);
        FunctionExpressionImplTest.assertEquals(expected, actual);
    }

    public void testSetArgs() {
        List<LiteralExpressionImpl> expected = Collections.singletonList(new LiteralExpressionImpl(10.0));
        Expression[] args = expected.toArray(new Expression[1]);
        this.function.setArgs(args);
        FunctionExpressionImplTest.assertEquals(expected, (Object)this.function.params);
    }

    public void testGetArgCount() {
        List<LiteralExpressionImpl> expected = Collections.singletonList(new LiteralExpressionImpl(10.0));
        this.function.setParameters(expected);
        FunctionExpressionImplTest.assertEquals((int)1, (int)this.function.getArgCount());
    }

    public void testGetImplementationHints() {
        FunctionExpressionImplTest.assertNotNull((Object)this.function.getImplementationHints());
        FunctionExpressionImplTest.assertTrue((boolean)this.function.getImplementationHints().isEmpty());
    }

    public void testImplementations() throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        List functionClasses = this.loadFunctionClasses();
        LinkedList errors = new LinkedList();
        for (Class functionClass : functionClasses) {
            Function function = (Function)functionClass.newInstance();
            this.testFunction(function, errors);
        }
        if (errors.size() > 0) {
            String errorsMessage = this.buildErrosMessage(errors);
            LOGGER.info(errorsMessage);
            FunctionExpressionImplTest.fail((String)errorsMessage);
        }
    }

    private String buildErrosMessage(List errors) {
        StringBuffer sb = new StringBuffer("Some function expression implementations violates contract:\n");
        int errorCount = 1;
        for (String error : errors) {
            sb.append(String.valueOf(errorCount++) + " - ");
            sb.append(error);
            sb.append("\n");
        }
        return sb.toString();
    }

    private void testFunction(Function function, List errors) throws InstantiationException, IllegalAccessException {
        List parameters;
        String functionClass = function.getClass().getName();
        if (function.getName() == null) {
            errors.add(String.valueOf(functionClass) + ": getName() == null");
        }
        this.testVisitor = new TestExpressionVisitor();
        String extraData = "[extraData correctly returned]";
        function.accept((ExpressionVisitor)this.testVisitor, (Object)extraData);
        Object[] functionVisited = this.testVisitor.functionVisited;
        if (Boolean.TRUE != functionVisited[0] || extraData != functionVisited[1]) {
            errors.add(String.valueOf(functionClass) + ": accept didn't called visitor.visit(Function, extraData): " + " visited: " + functionVisited[0] + ", extraData: " + functionVisited[1]);
        }
        try {
            String toString = function.toString();
        }
        catch (Exception e) {
            this.addExceptionError(errors, functionClass, "toString", e);
        }
        if (function instanceof FunctionExpression) {
            this.testDeprecatedMethods((FunctionExpression)function, errors);
        }
        if ((parameters = function.getParameters()) == null) {
            errors.add(String.valueOf(functionClass) + ".getParameters() returns null");
        }
    }

    private void addExceptionError(List errors, String functionClass, String method, Exception e) {
        errors.add(String.valueOf(functionClass) + "." + method + "() throwed an exception: " + e.getMessage());
    }

    private void testDeprecatedMethods(FunctionExpression function, List errors) throws InstantiationException, IllegalAccessException {
        String functionClass = function.getClass().getName();
        int argCount = function.getArgCount();
        Expression[] expected = new Expression[argCount];
        int i = 0;
        while (i < argCount) {
            AttributeExpressionImpl ex = new AttributeExpressionImpl("attName");
            expected[i] = ex;
            ++i;
        }
        List<Expression> expectedList = Arrays.asList(expected);
        try {
            function.setArgs(expected);
        }
        catch (Exception e) {
            this.addExceptionError(errors, functionClass, "setArgs", e);
        }
        List<Expression> returnedParams = function.getParameters();
        if (returnedParams == null) {
            errors.add(String.valueOf(functionClass) + ".getParameters() returned null when parameters were set through setArgs(Expression[])");
        } else if (!expectedList.equals(returnedParams)) {
            errors.add(String.valueOf(functionClass) + ".getParameters() returned a wrong result when parameters were set through setArgs(Expression[])");
        }
        function = (FunctionExpression)function.getClass().newInstance();
        function.setParameters(expectedList);
        Expression[] returnedArgs = function.getArgs();
        if (returnedArgs == null) {
            errors.add(String.valueOf(functionClass) + ".getArgs() returns null then arguments set through setParameters()");
        } else {
            returnedParams = Arrays.asList(expected);
            if (!expectedList.equals(returnedParams)) {
                errors.add(String.valueOf(functionClass) + ".getArgs() incompatible with getParameters()");
            }
        }
        if (114 != function.getType()) {
            errors.add(String.valueOf(functionClass) + ".getType != " + 114);
        }
    }

    private List loadFunctionClasses() throws IOException, ClassNotFoundException {
        String className;
        String spiDefinitionResource = "/META-INF/services/org.opengis.filter.expression.Function";
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("/META-INF/services/org.opengis.filter.expression.Function");
        if (in == null) {
            throw new FileNotFoundException("/META-INF/services/org.opengis.filter.expression.Function");
        }
        LinkedList functionClasses = new LinkedList();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        while ((className = reader.readLine()) != null) {
            Class<?> functionClazz = Class.forName(className);
            functionClasses.add(functionClazz);
        }
        return functionClasses;
    }

    private static class TestExpressionVisitor
    implements ExpressionVisitor {
        public Object[] functionVisited;

        private TestExpressionVisitor() {
            Object[] objectArray = new Object[2];
            objectArray[0] = Boolean.FALSE;
            this.functionVisited = objectArray;
        }

        public Object visit(Function expression, Object extraData) {
            this.functionVisited[0] = Boolean.TRUE;
            this.functionVisited[1] = extraData;
            return null;
        }

        public Object visit(Add expression, Object extraData) {
            return null;
        }

        public Object visit(Divide expression, Object extraData) {
            return null;
        }

        public Object visit(Literal expression, Object extraData) {
            return null;
        }

        public Object visit(Multiply expression, Object extraData) {
            return null;
        }

        public Object visit(PropertyName expression, Object extraData) {
            return null;
        }

        public Object visit(Subtract expression, Object extraData) {
            return null;
        }

        public Object visit(NilExpression arg0, Object arg1) {
            return null;
        }
    }
}

