/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.geotools.data.DataUtilities;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.filter.function.Classifier;
import org.geotools.filter.function.FunctionTestSupport;
import org.geotools.filter.function.QuantileFunction;
import org.geotools.filter.function.RangedClassifier;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;

public class QuantileFunctionTest
extends FunctionTestSupport {
    public QuantileFunctionTest(String testName) {
        super(testName);
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(QuantileFunctionTest.class);
        return suite;
    }

    public void testInstance() {
        Function equInt = this.ff.function("Quantile", new Expression[]{this.ff.literal((Object)FeatureCollections.newCollection())});
        QuantileFunctionTest.assertNotNull((Object)equInt);
    }

    public void testGetName() {
        Function qInt = this.ff.function("Quantile", new Expression[]{this.ff.literal((Object)FeatureCollections.newCollection())});
        QuantileFunctionTest.assertEquals((String)"Quantile", (String)qInt.getName());
    }

    public void testSetParameters() throws Exception {
        Literal classes = this.ff.literal(3);
        PropertyName expr = this.ff.property("foo");
        QuantileFunction func = (QuantileFunction)this.ff.function("Quantile", new Expression[]{expr, classes});
        QuantileFunctionTest.assertEquals((int)3, (int)func.getClasses());
        classes = this.ff.literal(12);
        func = (QuantileFunction)this.ff.function("Quantile", new Expression[]{expr, classes});
        QuantileFunctionTest.assertEquals((int)12, (int)func.getClasses());
        classes = this.ff.literal(5);
        func = (QuantileFunction)this.ff.function("Quantile", new Expression[]{expr, classes});
        QuantileFunctionTest.assertEquals((int)5, (int)func.getClasses());
    }

    public void testEvaluateWithExpressions() throws Exception {
        Literal classes = this.ff.literal(2);
        PropertyName exp = this.ff.property("foo");
        Function func = this.ff.function("Quantile", new Expression[]{exp, classes});
        Object value = func.evaluate((Object)this.featureCollection);
        QuantileFunctionTest.assertTrue((boolean)(value instanceof RangedClassifier));
        RangedClassifier ranged = (RangedClassifier)value;
        QuantileFunctionTest.assertEquals((int)2, (int)ranged.getSize());
        QuantileFunctionTest.assertEquals((String)"4..29", (String)ranged.getTitle(0));
        QuantileFunctionTest.assertEquals((String)"29..90", (String)ranged.getTitle(1));
    }

    public void testSingleBin() throws Exception {
        SimpleFeatureType dataType = DataUtilities.createType((String)"classification.test1", (String)"id:0,value:int");
        int[] iVal = new int[]{1, 2, 3, 4, 5};
        SimpleFeature[] myfeatures = new SimpleFeature[iVal.length];
        int i = 0;
        while (i < iVal.length) {
            myfeatures[i] = SimpleFeatureBuilder.build((SimpleFeatureType)dataType, (Object[])new Object[]{new Integer(i + 1), new Integer(iVal[i])}, (String)("classification.test1" + (i + 1)));
            ++i;
        }
        MemoryDataStore store = new MemoryDataStore();
        store.createSchema(dataType);
        store.addFeatures(myfeatures);
        SimpleFeatureCollection myFeatureCollection = store.getFeatureSource("test1").getFeatures();
        Function function = this.ff.function("Quantile", new Expression[]{this.ff.property("value"), this.ff.literal(5)});
        Classifier classifier = (Classifier)function.evaluate((Object)myFeatureCollection);
        QuantileFunctionTest.assertNotNull((Object)classifier);
        QuantileFunctionTest.assertEquals(classifier.getClass(), RangedClassifier.class);
        RangedClassifier range = (RangedClassifier)classifier;
        QuantileFunctionTest.assertEquals((int)5, (int)range.getSize());
        int i2 = 0;
        while (i2 < 5) {
            QuantileFunctionTest.assertTrue(((double)(i2 + 1) == ((Number)range.getMin(i2)).doubleValue() ? 1 : 0) != 0);
            if (i2 != 4) {
                QuantileFunctionTest.assertTrue(((double)(i2 + 2) == ((Number)range.getMax(i2)).doubleValue() ? 1 : 0) != 0);
                QuantileFunctionTest.assertEquals((String)(String.valueOf(i2 + 1) + ".." + (i2 + 2)), (String)range.getTitle(i2));
            } else {
                QuantileFunctionTest.assertTrue(((double)(i2 + 1) == ((Number)range.getMax(i2)).doubleValue() ? 1 : 0) != 0);
                QuantileFunctionTest.assertEquals((String)(String.valueOf(i2 + 1) + ".." + (i2 + 1)), (String)range.getTitle(i2));
            }
            ++i2;
        }
    }

    public void test2() throws Exception {
        SimpleFeatureType dataType = DataUtilities.createType((String)"classification.test1", (String)"id:0,value:int");
        int[] iVal = new int[]{1, 2, 3, 4, 5, 6};
        SimpleFeature[] myfeatures = new SimpleFeature[iVal.length];
        int i = 0;
        while (i < iVal.length) {
            myfeatures[i] = SimpleFeatureBuilder.build((SimpleFeatureType)dataType, (Object[])new Object[]{new Integer(i + 1), new Integer(iVal[i])}, (String)("classification.t" + (i + 1)));
            ++i;
        }
        MemoryDataStore store = new MemoryDataStore();
        store.createSchema(dataType);
        store.addFeatures(myfeatures);
        SimpleFeatureCollection myFeatureCollection = store.getFeatureSource("test1").getFeatures();
        Function function = this.ff.function("Quantile", new Expression[]{this.ff.property("value"), this.ff.literal(5)});
        Classifier classifier = (Classifier)function.evaluate((Object)myFeatureCollection);
        RangedClassifier range = (RangedClassifier)classifier;
    }

    public void testEvaluateWithStrings() throws Exception {
        Function function = this.ff.function("Quantile", new Expression[]{this.ff.property("group"), this.ff.literal(2)});
        Classifier classifier = (Classifier)function.evaluate((Object)this.featureCollection);
        QuantileFunctionTest.assertNotNull((Object)classifier);
        Classifier classifier2 = (Classifier)function.evaluate((Object)this.featureCollection, Classifier.class);
        QuantileFunctionTest.assertNotNull((Object)classifier2);
        Integer number = (Integer)function.evaluate((Object)this.featureCollection, Integer.class);
        QuantileFunctionTest.assertNull((Object)number);
    }

    public void xtestNullNaNHandling() throws Exception {
        SimpleFeatureType ft = DataUtilities.createType((String)"classification.nullnan", (String)"id:0,foo:int,bar:double");
        Integer[] integerArray = new Integer[9];
        integerArray[0] = new Integer(0);
        integerArray[1] = new Integer(0);
        integerArray[2] = new Integer(0);
        integerArray[3] = new Integer(13);
        integerArray[4] = new Integer(13);
        integerArray[5] = new Integer(13);
        Integer[] iVal = integerArray;
        Double[] doubleArray = new Double[9];
        doubleArray[0] = new Double(0.0);
        doubleArray[1] = new Double(50.01);
        doubleArray[3] = new Double(0.0);
        doubleArray[4] = new Double(50.01);
        doubleArray[6] = new Double(0.0);
        doubleArray[7] = new Double(50.01);
        Double[] dVal = doubleArray;
        SimpleFeature[] testFeatures = new SimpleFeature[iVal.length];
        int i = 0;
        while (i < iVal.length) {
            testFeatures[i] = SimpleFeatureBuilder.build((SimpleFeatureType)ft, (Object[])new Object[]{new Integer(i + 1), iVal[i], dVal[i]}, (String)("nantest.t" + (i + 1)));
            ++i;
        }
        MemoryDataStore store = new MemoryDataStore();
        store.createSchema(ft);
        store.addFeatures(testFeatures);
        SimpleFeatureCollection thisFC = store.getFeatureSource("nullnan").getFeatures();
        Divide divide = this.ff.divide((Expression)this.ff.property("foo"), (Expression)this.ff.property("bar"));
        QuantileFunction qf = (QuantileFunction)this.ff.function("Quantile", new Expression[]{divide, this.ff.literal(3)});
        RangedClassifier range = (RangedClassifier)qf.evaluate((Object)thisFC);
        QuantileFunctionTest.assertEquals((int)2, (int)range.getSize());
        QuantileFunctionTest.assertEquals((String)"0..0", (String)range.getTitle(0));
        QuantileFunctionTest.assertEquals((String)"0..0.25995", (String)range.getTitle(1));
    }
}

