/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import org.geotools.geometry.jts.WKTReader2;
import org.junit.Assert;
import org.junit.Test;

public class WKTReader2Test {
    @Test
    public void verifyWKT() throws Exception {
        String WKT = "LINESTRING (60 380, 60 20, 200 400, 280 20, 360 400, 420 20, 500 400, 580 20, 620 400)";
        WKTReader2 reader = new WKTReader2();
        Geometry geometry = reader.read(WKT);
        Assert.assertNotNull((Object)geometry);
    }

    @Test
    public void circularString() throws Exception {
        String WKT = "CIRCULARSTRING(220268.439465645 150415.359530563,220227.333322076 150505.561285879,220227.353105332 150406.434743975)";
        WKTReader2 reader = new WKTReader2();
        Geometry geometry = reader.read(WKT);
        Assert.assertNotNull((String)"parsed circularstring", (Object)geometry);
        Assert.assertEquals((String)"segmentized as expected", (long)112L, (long)geometry.getNumPoints());
        WKT = "CIRCULARSTRING(143.62025166838282 -30.037497356076827, 142.92857147299705 -32.75101196874403, 145.96132309891922 -34.985671061528784, 149.57565307617188 -33.41153335571289, 149.41972407584802 -29.824672680573517, 146.1209416055467 -30.19711586270431, 143.62025166838282 -30.037497356076827)";
        geometry = reader.read(WKT);
        Assert.assertNotNull((String)"parsed circularstring ring", (Object)geometry);
        Coordinate[] array = geometry.getCoordinates();
        Assert.assertEquals((String)"forms a ring", (Object)array[0], (Object)array[array.length - 1]);
        WKT = "CIRCULARSTRING(143.62025166838282 -30.037497356076827, 142.92857147299705 -32.75101196874403, 143.62025166838282 -30.037497356076827)";
        geometry = reader.read(WKT);
        Assert.assertNotNull((String)"parsed perfect circle", (Object)geometry);
        Assert.assertEquals((long)129L, (long)geometry.getNumPoints());
        WKT = "CIRCULARSTRING EMPTY";
        geometry = reader.read(WKT);
        Assert.assertNotNull((Object)geometry);
        Assert.assertTrue((boolean)geometry.isEmpty());
    }

    @Test
    public void compoundCurve() throws Exception {
        String WKT = "COMPOUNDCURVE((153.72942375 -27.21757040, 152.29285719 -29.23940482, 154.74034096 -30.51635287),CIRCULARSTRING(154.74034096 -30.51635287, 154.74034096 -30.51635287, 152.39926953 -32.16574411, 155.11278414 -34.08116619, 151.86720784 -35.62414508))";
        WKTReader2 reader = new WKTReader2();
        Geometry geometry = reader.read(WKT);
        Assert.assertNotNull((Object)geometry);
        WKT = "COMPOUNDCURVE((153.72942375 -27.21757040, 152.29285719 -29.23940482, 154.74034096 -30.51635287))";
        geometry = reader.read(WKT);
        Assert.assertNotNull((Object)geometry);
        WKT = "COMPOUNDCURVE(CIRCULARSTRING(154.74034096 -30.51635287, 154.74034096 -30.51635287, 152.39926953 -32.16574411, 155.11278414 -34.08116619, 151.86720784 -35.62414508))";
        geometry = reader.read(WKT);
        Assert.assertNotNull((Object)geometry);
        WKT = "COMPOUNDCURVE EMPTY";
        geometry = reader.read(WKT);
        Assert.assertNotNull((Object)geometry);
        Assert.assertTrue((boolean)geometry.isEmpty());
    }

    @Test
    public void curvePolygon() throws Exception {
        WKTReader2 reader = new WKTReader2();
        String WKT = "CURVEPOLYGON(CIRCULARSTRING(143.62025166838282 -30.037497356076827, 142.92857147299705 -32.75101196874403, 143.62025166838282 -30.037497356076827))";
        Geometry geometry = reader.read(WKT);
        Assert.assertNotNull((String)"read curvepolygon", (Object)geometry);
        Assert.assertTrue((boolean)(geometry instanceof Polygon));
        Polygon polygon = (Polygon)geometry;
        Assert.assertTrue((String)"ring", (boolean)polygon.getExteriorRing().isClosed());
        Assert.assertEquals((String)"segmented ring", (long)129L, (long)polygon.getExteriorRing().getNumPoints());
        Assert.assertEquals((String)"no holes", (long)0L, (long)polygon.getNumInteriorRing());
        WKT = "CURVEPOLYGON((144.84399355252685 -31.26123924022086, 144.20551952601693 -32.27215644886158, 145.55230712890625 -33.49203872680664, 147.97080993652344 -32.03618621826172, 146.38697244992585 -31.47406391572417, 144.84399355252685 -31.26123924022086))";
        polygon = (Polygon)reader.read(WKT);
        Assert.assertTrue((String)"ring", (boolean)polygon.getExteriorRing().isClosed());
        Assert.assertEquals((String)"no holes", (long)0L, (long)polygon.getNumInteriorRing());
        WKT = "CURVEPOLYGON(CIRCULARSTRING(143.62025166838282 -30.037497356076827, 142.92857147299705 -32.75101196874403, 145.96132309891922 -34.985671061528784, 149.57565307617188 -33.41153335571289, 149.41972407584802 -29.824672680573517, 146.1209416055467 -30.19711586270431, 143.62025166838282 -30.037497356076827),(144.84399355252685 -31.26123924022086, 144.20551952601693 -32.27215644886158, 145.55230712890625 -33.49203872680664, 147.97080993652344 -32.03618621826172, 146.38697244992585 -31.47406391572417, 144.84399355252685 -31.26123924022086))";
        polygon = (Polygon)reader.read(WKT);
        Assert.assertTrue((String)"ring", (boolean)polygon.getExteriorRing().isClosed());
        Assert.assertEquals((String)"one holes", (long)1L, (long)polygon.getNumInteriorRing());
    }
}

