/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.geotools.util.CollectionConverterFactory;

public class CollectionConverterFactoryTest
extends TestCase {
    public void testCollectionToCollection() throws Exception {
        ArrayList<Integer> source = new ArrayList<Integer>();
        source.add(1);
        source.add(2);
        Object converted = CollectionConverterFactory.CollectionToCollection.convert(source, Set.class);
        CollectionConverterFactoryTest.assertTrue((boolean)(converted instanceof Set));
        Set target = (Set)converted;
        CollectionConverterFactoryTest.assertTrue((boolean)target.contains(1));
        CollectionConverterFactoryTest.assertTrue((boolean)target.contains(2));
    }

    public void testCollectionToArray() throws Exception {
        ArrayList<Integer> source = new ArrayList<Integer>();
        source.add(1);
        source.add(2);
        Object converted = CollectionConverterFactory.CollectionToArray.convert(source, Integer[].class);
        CollectionConverterFactoryTest.assertTrue((boolean)(converted instanceof Integer[]));
        Integer[] target = (Integer[])converted;
        CollectionConverterFactoryTest.assertEquals((Object)new Integer(1), (Object)target[0]);
        CollectionConverterFactoryTest.assertEquals((Object)new Integer(2), (Object)target[1]);
    }

    public void testArrayToCollection() throws Exception {
        Integer[] source = new Integer[]{1, 2};
        Object converted = CollectionConverterFactory.ArrayToCollection.convert((Object)source, List.class);
        CollectionConverterFactoryTest.assertTrue((boolean)(converted instanceof List));
        List target = (List)converted;
        CollectionConverterFactoryTest.assertEquals((Object)new Integer(1), target.get(0));
        CollectionConverterFactoryTest.assertEquals((Object)new Integer(2), target.get(1));
    }

    public void testArrayToArray() throws Exception {
        Integer[] source = new Integer[]{1, 2};
        Object converted = CollectionConverterFactory.ArrayToArray.convert((Object)source, Number[].class);
        CollectionConverterFactoryTest.assertTrue((boolean)(converted instanceof Number[]));
        Number[] target = (Number[])converted;
        CollectionConverterFactoryTest.assertEquals((int)1, (int)target[0].intValue());
        CollectionConverterFactoryTest.assertEquals((int)2, (int)target[1].intValue());
    }
}

